/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import cpw.mods.fml.common.registry.LanguageRegistry;
import gregtech.api.GregTech_API;
import gregtech.api.util.GT_Utility;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class GT_LanguageManager {
    public static final HashMap<String, String> TEMPMAP = new HashMap();
    public static final HashMap<String, String> BUFFERMAP = new HashMap();
    public static final HashMap<String, String> LANGMAP = new HashMap();
    public static Configuration sEnglishFile;
    public static String sLanguage;
    public static boolean sUseEnglishFile;
    public static boolean i18nPlaceholder;

    public static String addStringLocalization(String aKey, String aEnglish) {
        return GT_LanguageManager.addStringLocalization(aKey, aEnglish, true);
    }

    public static synchronized String addStringLocalization(String aKey, String aEnglish, boolean aWriteIntoLangFile) {
        if (aKey == null) {
            return "";
        }
        if (aWriteIntoLangFile) {
            aEnglish = GT_LanguageManager.writeToLangFile(aKey, aEnglish);
            if (!LANGMAP.containsKey(aKey)) {
                LANGMAP.put(aKey, aEnglish);
            }
        }
        TEMPMAP.put(aKey.trim(), aEnglish);
        LanguageRegistry.instance().injectLanguage(sLanguage, TEMPMAP);
        TEMPMAP.clear();
        if (sUseEnglishFile && !aWriteIntoLangFile) {
            if (!LANGMAP.containsKey(aKey)) {
                Property tProperty = sEnglishFile.get("LanguageFile", aKey, aEnglish);
                aEnglish = tProperty.getString();
                LANGMAP.put(aKey, aEnglish);
            } else {
                aEnglish = LANGMAP.get(aKey);
            }
        }
        return aEnglish;
    }

    private static synchronized String writeToLangFile(String aKey, String aEnglish) {
        if (aKey == null) {
            return "";
        }
        if (sEnglishFile == null) {
            BUFFERMAP.put(aKey.trim(), aEnglish);
        } else {
            Property tProperty;
            if (!BUFFERMAP.isEmpty()) {
                for (Map.Entry<String, String> tEntry : BUFFERMAP.entrySet()) {
                    Property tProperty2 = sEnglishFile.get("LanguageFile", tEntry.getKey(), tEntry.getValue());
                    if (tProperty2.wasRead() || !GregTech_API.sPostloadFinished) continue;
                    sEnglishFile.save();
                }
                BUFFERMAP.clear();
            }
            if (!(tProperty = sEnglishFile.get("LanguageFile", aKey.trim(), aEnglish)).wasRead() && GregTech_API.sPostloadFinished) {
                sEnglishFile.save();
            }
            if (sEnglishFile.get("EnableLangFile", "UseThisFileAsLanguageFile", false).getBoolean(false)) {
                aEnglish = tProperty.getString();
                sUseEnglishFile = true;
            }
        }
        return aEnglish;
    }

    public static String getTranslation(String aKey) {
        if (aKey == null) {
            return "";
        }
        String tTrimmedKey = aKey.trim();
        String rTranslation = sUseEnglishFile ? LanguageRegistry.instance().getStringLocalization(tTrimmedKey) : StatCollector.func_74838_a((String)tTrimmedKey);
        if (GT_Utility.isStringInvalid(rTranslation) && (GT_Utility.isStringInvalid(rTranslation = StatCollector.func_74838_a((String)tTrimmedKey)) || tTrimmedKey.equals(rTranslation)) && (aKey.endsWith(".name") ? GT_Utility.isStringInvalid(rTranslation = StatCollector.func_74838_a((String)tTrimmedKey.substring(0, tTrimmedKey.length() - 5))) || tTrimmedKey.substring(0, tTrimmedKey.length() - 5).equals(rTranslation) : GT_Utility.isStringInvalid(rTranslation = StatCollector.func_74838_a((String)(tTrimmedKey + ".name"))) || (tTrimmedKey + ".name").equals(rTranslation))) {
            return aKey;
        }
        return rTranslation;
    }

    public static String getTranslation(String aKey, String aSeperator) {
        if (aKey == null) {
            return "";
        }
        String rTranslation = "";
        StringBuilder rTranslationSB = new StringBuilder(rTranslation);
        for (String tString : aKey.split(aSeperator)) {
            rTranslationSB.append(GT_LanguageManager.getTranslation(tString));
        }
        rTranslation = String.valueOf(rTranslationSB);
        return rTranslation;
    }

    public static String getTranslateableItemStackName(ItemStack aStack) {
        String tName;
        if (GT_Utility.isStackInvalid(aStack)) {
            return "null";
        }
        NBTTagCompound tNBT = aStack.func_77978_p();
        if (tNBT != null && tNBT.func_74764_b("display") && GT_Utility.isStringValid(tName = tNBT.func_74775_l("display").func_74779_i("Name"))) {
            return tName;
        }
        return aStack.func_77977_a() + ".name";
    }

    public static void writePlaceholderStrings() {
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_001", "Puts out into adjacent Slot #");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_002", "Grabs in for own Slot #");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_003", "Normal");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_004", "Inverted");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_005", "No Work at all");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_006", "Export");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_007", "Import");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_008", "Export (conditional)");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_009", "Import (conditional)");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_010", "Export (invert cond)");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_011", "Import (invert cond)");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_012", "Export allow Input");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_013", "Import allow Output");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_014", "Export allow Input (conditional)");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_015", "Import allow Output (conditional)");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_016", "Export allow Input (invert cond)");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_017", "Import allow Output (invert cond)");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_018", "Normal");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_019", "Inverted");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_020", "Ready to work");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_021", "Not ready to work");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_022", "Import");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_023", "Import (conditional)");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_024", "Import (invert cond)");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_025", "Keep Liquids Away");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_026", "Keep Liquids Away (conditional)");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_027", "Keep Liquids Away (invert cond)");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_028", "Allow");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_029", "Allow (conditional)");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_030", "Disallow (conditional)");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_031", "Normal Universal Storage");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_032", "Inverted Universal Storage");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_033", "Normal Electricity Storage");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_034", "Inverted Electricity Storage");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_035", "Normal Steam Storage");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_036", "Inverted Steam Storage");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_037", "Normal Average Electric Input");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_038", "Inverted Average Electric Input");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_039", "Normal Average Electric Output");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_040", "Inverted Average Electric Output");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_041", "Normal Electricity Storage(Including Batteries)");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_042", "Inverted Electricity Storage(Including Batteries)");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_043", "Allow input, no output");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_044", "Deny input, no output");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_045", "Allow input, permit any output");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_046", "Deny input, permit any output");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_047", "Filter Fluid: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_048", "Pump speed: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_049", "L/tick ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_050", "L/sec");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_051", "Normal");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_052", "Inverted");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_053", "Slot: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_054", "Inverted");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_055", "Normal");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_056", "Emit if 1 Maintenance Needed");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_057", "Emit if 1 Maintenance Needed(inverted)");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_058", "Emit if 2 Maintenance Needed");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_059", "Emit if 2 Maintenance Needed(inverted)");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_060", "Emit if 3 Maintenance Needed");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_061", "Emit if 3 Maintenance Needed(inverted)");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_062", "Emit if 4 Maintenance Needed");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_063", "Emit if 4 Maintenance Needed(inverted)");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_064", "Emit if 5 Maintenance Needed");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_065", "Emit if 5 Maintenance Needed(inverted)");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_066", "Emit if rotor needs maintenance");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_067", "Emit if rotor needs maintenance(inverted)");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_068", "Emit if any Player is close");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_069", "Emit if other player is close");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_070", "Emit if you are close");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_071", "Conducts strongest Input");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_072", "Conducts from bottom Input");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_073", "Conducts from top Input");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_074", "Conducts from north Input");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_075", "Conducts from south Input");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_076", "Conducts from west Input");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_077", "Conducts from east Input");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_078", "Signal = ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_079", "Conditional Signal = ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_080", "Inverted Conditional Signal = ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_081", "Frequency: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_082", "Open if work enabled");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_083", "Open if work disabled");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_084", "Only Output allowed");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_085", "Only Input allowed");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_086", "Auto-Input: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_087", "Disabled");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_088", "Enabled");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_089", "  Auto-Output: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_090", "Machine Processing: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_091", "Redstone Output at Side ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_092", " set to: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_093", "Strong");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_094", "Weak");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_095", "Input from Output Side allowed");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_096", "Input from Output Side forbidden");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_097", "It's dangerous to go alone! Take this.");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_098", "Do not regulate Item Stack Size");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_099", "Regulate Item Stack Size to: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_100", "This is ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_101", " Ore.");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_102", "There is Lava behind this Rock.");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_103", "There is a Liquid behind this Rock.");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_104", "There is an Air Pocket behind this Rock.");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_105", "Material is changing behind this Rock.");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_106", "Found traces of ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_107", "No Ores found.");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_108", "Outputs Liquids, Steam and Items");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_109", "Outputs Steam and Items");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_110", "Outputs Steam and Liquids");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_111", "Outputs Steam");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_112", "Outputs Liquids and Items");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_113", "Outputs only Items");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_114", "Outputs only Liquids");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_115", "Outputs nothing");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_116", "Emit Energy to Outputside");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_117", "Don't emit Energy");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_118", "Emit Redstone if no Slot is free");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_119", "Don't emit Redstone");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_120", "Invert Redstone");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_121", "Don't invert Redstone");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_122", "Emit Redstone if slots contain something");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_123", "Don't emit Redstone");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_124", "Invert Filter");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_125", "Don't invert Filter");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_126", "Ignore NBT");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_127", "NBT has to match");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_128", "Redstone ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_129", "Energy ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_130", "Fluids ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_131", "Items ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_132", "Pipe is loose.");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_133", "Screws are loose.");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_134", "Something is stuck.");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_135", "Platings are dented.");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_136", "Circuitry burned out.");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_137", "That doesn't belong there.");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_138", "Incomplete Structure.");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_139", "Hit with Soft Hammer");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_140", "to (re-)start the Machine");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_141", "if it doesn't start.");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_142", "Running perfectly.");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_143", "Missing Mining Pipe");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_144", "Missing Turbine Rotor");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_145", "Step Down, In: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_146", "Step Up, In: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_147", "Amp, Out: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_148", " V at ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_149", " Amp");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_150", "Chance: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_151", "Does not get consumed in the process");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_152", "Total: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_153", "Usage: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_154", "Voltage: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_155", "Amperage: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_156", "Voltage: unspecified");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_157", "Amperage: unspecified");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_158", "Time: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_159", "Needs Low Gravity");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_160", "Needs Cleanroom");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_161", " secs");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_162", "Name: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_163", "  MetaData: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_164", "Hardness: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_165", "  Blast Resistance: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_166", "Is valid Beacon Pyramid Material");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_167", "Tank ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_168", "Heat: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_169", "  HEM: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_170", "  Base EU Output: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_171", "Facing: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_172", " / Chance: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_173", "You can remove this with a Wrench");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_174", "You can NOT remove this with a Wrench");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_175", "Conduction Loss: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_176", "Contained Energy: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_177", "Has Muffler Upgrade");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_178", "Progress: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_179", "Max IN: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_180", " EU");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_181", "Max OUT: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_182", " EU at ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_183", " Amperes");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_184", "Energy: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_185", "EU");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_186", "Owned by: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_187", "Type -- Crop-Name: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_188", "  Growth: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_189", "  Gain: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_190", "  Resistance: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_191", "Plant -- Fertilizer: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_192", "  Water: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_193", "  Weed-Ex: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_194", "  Scan-Level: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_195", "Environment -- Nutrients: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_196", "  Humidity: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_197", "  Air-Quality: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_198", "Attributes:");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_199", "Discovered by: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_200", " L");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_201", "Nothing");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_202", "Pollution in Chunk: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_203", " gibbl");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_204", "No Pollution in Chunk! HAYO!");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_205", " of ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_206", "Scan for Assembly Line");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_211", "Items per side: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_212", "Input enabled");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_213", "Input disabled");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_214", "Connected");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_215", "Disconnected");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_216", "Deprecated Recipe");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_217", "Stocking mode. Keeps this many items in destination input slots. This mode can be server unfriendly.");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_218", "Transfer size mode. Add exactly this many items in destination input slots as long as there is room.");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_219", "Single recipe locking enabled. Will lock to next recipe.");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_220", "Single recipe locking disabled.");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_221", "Item threshold");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_222", "Fluid threshold");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_500", "Fitting: Loose - More Flow");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_501", "Fitting: Tight - More Efficiency");
        GT_LanguageManager.addStringLocalization("Item_DESCRIPTION_Index_000", "Stored Heat: %s");
        GT_LanguageManager.addStringLocalization("Item_DESCRIPTION_Index_001", "Durability: %s/%s");
        GT_LanguageManager.addStringLocalization("Item_DESCRIPTION_Index_002", "%s lvl %s");
        GT_LanguageManager.addStringLocalization("Item_DESCRIPTION_Index_003", "Attack Damage: %s");
        GT_LanguageManager.addStringLocalization("Item_DESCRIPTION_Index_004", "Mining Speed: %s");
        GT_LanguageManager.addStringLocalization("Item_DESCRIPTION_Index_005", "Turbine Efficiency: %s");
        GT_LanguageManager.addStringLocalization("Item_DESCRIPTION_Index_006", "Optimal Steam flow: %sL/sec");
        GT_LanguageManager.addStringLocalization("Item_DESCRIPTION_Index_007", "Optimal Gas flow(EU burnvalue per tick): %sEU/t");
        GT_LanguageManager.addStringLocalization("Item_DESCRIPTION_Index_008", "Optimal Plasma flow(Plasma energyvalue per tick): %sEU/t");
        GT_LanguageManager.addStringLocalization("Item_DESCRIPTION_Index_009", "Contains %s EU   Tier: %s");
        GT_LanguageManager.addStringLocalization("Item_DESCRIPTION_Index_010", "Empty. You should recycle it properly.");
        GT_LanguageManager.addStringLocalization("Item_DESCRIPTION_Index_011", "%s / %s EU - Voltage: %s");
        GT_LanguageManager.addStringLocalization("Item_DESCRIPTION_Index_012", "No Fluids Contained");
        GT_LanguageManager.addStringLocalization("Item_DESCRIPTION_Index_013", "%sL / %sL");
        GT_LanguageManager.addStringLocalization("Item_DESCRIPTION_Index_014", "Missing Coodinates!");
        GT_LanguageManager.addStringLocalization("Item_DESCRIPTION_Index_015", "Device at:");
        GT_LanguageManager.addStringLocalization("Item_DESCRIPTION_Index_016", "Amount: %s L");
        GT_LanguageManager.addStringLocalization("Item_DESCRIPTION_Index_017", "Temperature: %s K");
        GT_LanguageManager.addStringLocalization("Item_DESCRIPTION_Index_018", "State: %s");
        GT_LanguageManager.addStringLocalization("Item_DESCRIPTION_Index_500", "Turbine Efficiency (Loose): %s");
        GT_LanguageManager.addStringLocalization("Item_DESCRIPTION_Index_501", "Optimal Steam flow (Loose): %s L/t");
    }

    static {
        sLanguage = "en_US";
        sUseEnglishFile = false;
        i18nPlaceholder = true;
    }
}

