/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.items.GT_Generic_Item;
import gregtech.api.util.GT_Utility;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class GT_FluidDisplayItem
extends GT_Generic_Item {
    private static final Map<Fluid, String> sFluidTooltips = new HashMap<Fluid, String>();

    public GT_FluidDisplayItem() {
        super("GregTech_FluidDisplay", "Fluid Display", null);
        ItemList.Display_Fluid.set(this);
    }

    @Override
    protected void addAdditionalToolTips(List aList, ItemStack aStack, EntityPlayer aPlayer) {
        Fluid tFluid;
        String tChemicalFormula;
        if (FluidRegistry.getFluid((int)aStack.func_77960_j()) != null && !(tChemicalFormula = this.getChemicalFormula(new FluidStack(FluidRegistry.getFluid((int)aStack.func_77960_j()), 1))).isEmpty()) {
            aList.add(EnumChatFormatting.YELLOW + tChemicalFormula + EnumChatFormatting.RESET);
        }
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (GT_Values.D1 && (tFluid = FluidRegistry.getFluid((int)aStack.func_77960_j())) != null) {
            aList.add("Registry: " + tFluid.getName());
        }
        if (aNBT != null) {
            long tToolTipAmount = aNBT.func_74763_f("mFluidDisplayAmount");
            if (tToolTipAmount > 0L) {
                aList.add(EnumChatFormatting.BLUE + String.format(this.trans("016", "Amount: %s L"), "" + tToolTipAmount) + EnumChatFormatting.GRAY);
            }
            aList.add(EnumChatFormatting.RED + String.format(this.trans("017", "Temperature: %s K"), "" + aNBT.func_74763_f("mFluidDisplayHeat")) + EnumChatFormatting.GRAY);
            aList.add(EnumChatFormatting.GREEN + String.format(this.trans("018", "State: %s"), aNBT.func_74767_n("mFluidState") ? "Gas" : "Liquid") + EnumChatFormatting.GRAY);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister aIconRegister) {
    }

    @Override
    public IIcon func_77617_a(int aMeta) {
        return Stream.of(FluidRegistry.getFluid((int)aMeta), FluidRegistry.WATER).filter(Objects::nonNull).map(Fluid::getStillIcon).filter(Objects::nonNull).findFirst().orElseThrow(IllegalStateException::new);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack aStack, int aRenderPass) {
        Fluid tFluid = FluidRegistry.getFluid((int)aStack.func_77960_j());
        return tFluid == null ? 0xFFFFFF : tFluid.getColor();
    }

    public int func_94901_k() {
        return 0;
    }

    @Override
    public String func_77667_c(ItemStack aStack) {
        if (aStack != null) {
            return GT_Utility.getFluidName(FluidRegistry.getFluid((int)aStack.func_77960_j()), false);
        }
        return "";
    }

    public String func_77653_i(ItemStack aStack) {
        if (aStack != null) {
            return GT_Utility.getFluidName(FluidRegistry.getFluid((int)aStack.func_77960_j()), true);
        }
        return "";
    }

    @SideOnly(value=Side.CLIENT)
    public String getChemicalFormula(FluidStack aRealFluid) {
        return sFluidTooltips.computeIfAbsent(aRealFluid.getFluid(), fluid -> {
            for (ItemStack tContainer : GT_Utility.getContainersFromFluid(aRealFluid)) {
                if (!GT_FluidDisplayItem.isCell(tContainer)) continue;
                Materials tMaterial = GT_FluidDisplayItem.getMaterialFromCell(tContainer);
                if (!tMaterial.equals(Materials._NULL)) {
                    if (tMaterial.mChemicalFormula.equals("?")) {
                        return "";
                    }
                    return tMaterial.mChemicalFormula;
                }
                List tTooltip = tContainer.func_82840_a(null, true);
                for (Object tInfo : tTooltip) {
                    if (((String)tInfo).contains(" ") || ((String)tInfo).contains(":") || tTooltip.indexOf(tInfo) == 0) continue;
                    return (String)tInfo;
                }
            }
            return "";
        });
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item aItem, CreativeTabs aTab, List aList) {
        if (GT_Values.D1) {
            int j = FluidRegistry.getMaxID();
            for (int i = 0; i < j; ++i) {
                ItemStack tStack = GT_Utility.getFluidDisplayStack(FluidRegistry.getFluid((int)i));
                if (tStack == null) continue;
                aList.add(tStack);
            }
        }
    }

    public static boolean isCell(ItemStack tItemStack) {
        for (int tOreDict : OreDictionary.getOreIDs((ItemStack)tItemStack)) {
            String tOreDictName = OreDictionary.getOreName((int)tOreDict);
            if (!tOreDictName.startsWith("cell")) continue;
            return true;
        }
        return false;
    }

    public static Materials getMaterialFromCell(ItemStack tItemStack) {
        for (int tOreDict : OreDictionary.getOreIDs((ItemStack)tItemStack)) {
            String tOreDictName = OreDictionary.getOreName((int)tOreDict);
            if (!tOreDictName.startsWith("cell")) continue;
            return Materials.getRealMaterial(tOreDictName.replace("cell", "").replace("Molten", "").replace("Plasma", ""));
        }
        return Materials._NULL;
    }
}

