/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.behaviors;

import gregtech.api.GregTech_API;
import gregtech.api.interfaces.IItemBehaviour;
import gregtech.api.items.GT_MetaBase_Item;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_Utility;
import gregtech.common.items.behaviors.Behaviour_None;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class Behaviour_Scanner
extends Behaviour_None {
    public static final IItemBehaviour<GT_MetaBase_Item> INSTANCE = new Behaviour_Scanner();
    private final String mTooltip = GT_LanguageManager.addStringLocalization("gt.behaviour.scanning", "Can scan Blocks in World");

    @Override
    public boolean onItemUseFirst(GT_MetaBase_Item aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, int aSide, float hitX, float hitY, float hitZ) {
        NBTTagCompound tNBT = aStack.func_77978_p();
        if (aPlayer instanceof EntityPlayerMP && aItem.canUse(aStack, 20000.0)) {
            ArrayList<String> tList = new ArrayList<String>();
            if (aItem.use(aStack, GT_Utility.getCoordinateScan(tList, aPlayer, aWorld, 1, aX, aY, aZ, aSide, hitX, hitY, hitZ), (EntityLivingBase)aPlayer)) {
                int tList_sS = tList.size();
                tNBT.func_74768_a("dataLinesCount", tList_sS);
                for (int i = 0; i < tList_sS; ++i) {
                    tNBT.func_74778_a("dataLines" + Integer.toString(i), tList.get(i));
                    GT_Utility.sendChatToPlayer(aPlayer, tList.get(i));
                }
            }
            return true;
        }
        GT_Utility.doSoundAtClient(GregTech_API.sSoundList.get(108), 1, 1.0f, aX, aY, aZ);
        return aPlayer instanceof EntityPlayerMP;
    }

    @Override
    public List<String> getAdditionalToolTips(GT_MetaBase_Item aItem, List<String> aList, ItemStack aStack) {
        try {
            NBTTagCompound tNBT = aStack.func_77978_p();
            int lines = tNBT.func_74762_e("dataLinesCount");
            if (lines < 1) {
                throw new Exception();
            }
            aList.add(EnumChatFormatting.BLUE + "Block scan data result:");
            for (int i = 0; i < lines; ++i) {
                aList.add(EnumChatFormatting.RESET + tNBT.func_74779_i("dataLines" + Integer.toString(i)));
            }
        }
        catch (Exception e) {
            aList.add(this.mTooltip);
        }
        return aList;
    }
}

