/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.basic;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Utility;
import gregtech.common.blocks.GT_Block_Ores_Abstract;
import gregtech.common.blocks.GT_TileEntity_Ores;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.ChunkPosition;
import net.minecraftforge.common.util.FakePlayer;

public class GT_MetaTileEntity_Miner
extends GT_MetaTileEntity_BasicMachine {
    private static final ItemStack MINING_PIPE = GT_ModHandler.getIC2Item("miningPipe", 0L);
    private static final Block MINING_PIPE_BLOCK = GT_Utility.getBlockFromStack(MINING_PIPE);
    private static final Block MINING_PIPE_TIP_BLOCK = GT_Utility.getBlockFromStack(GT_ModHandler.getIC2Item("miningPipeTip", 0L));
    int drillY = 0;
    boolean isPickingPipes;
    boolean waitMiningPipe;
    static final int[] RADIUS = new int[]{8, 8, 16, 24, 32};
    static final int[] SPEED = new int[]{160, 160, 80, 40, 20};
    static final int[] ENERGY = new int[]{8, 8, 32, 128, 512};
    private int radiusConfig;
    private final ArrayList<ChunkPosition> oreBlockPositions = new ArrayList();
    private FakePlayer mFakePlayer = null;

    public GT_MetaTileEntity_Miner(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 1, new String[]{"Digging ore instead of you", "Use Screwdriver to regulate work area", ENERGY[aTier] + " EU/t, " + SPEED[aTier] / 20 + " sec per block, no stuttering", "Maximum work area " + (RADIUS[aTier] * 2 + 1) + "x" + (RADIUS[aTier] * 2 + 1), "Fortune bonus of " + aTier}, 2, 2, "Miner.png", "", TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/miner/OVERLAY_SIDE_ACTIVE")), TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/miner/OVERLAY_SIDE")), TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/miner/OVERLAY_FRONT_ACTIVE")), TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/miner/OVERLAY_FRONT")), TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/miner/OVERLAY_TOP_ACTIVE")), TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/miner/OVERLAY_TOP")), TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/miner/OVERLAY_BOTTOM_ACTIVE")), TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/miner/OVERLAY_BOTTOM")));
        this.radiusConfig = RADIUS[this.mTier];
    }

    public GT_MetaTileEntity_Miner(String aName, int aTier, String aDescription, ITexture[][][] aTextures, String aGUIName, String aNEIName) {
        super(aName, aTier, 1, aDescription, aTextures, 1, 1, aGUIName, aNEIName);
        this.radiusConfig = RADIUS[this.mTier];
    }

    public GT_MetaTileEntity_Miner(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures, String aGUIName, String aNEIName) {
        super(aName, aTier, 1, aDescription, aTextures, 2, 2, aGUIName, aNEIName);
        this.radiusConfig = RADIUS[this.mTier];
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Miner(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures, this.mGUIName, this.mNEIName);
    }

    @Override
    protected boolean allowPutStackValidated(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return super.allowPutStackValidated(aBaseMetaTileEntity, aIndex, aSide, aStack) && aStack.func_77973_b() == MINING_PIPE.func_77973_b();
    }

    public boolean hasFreeSpace() {
        for (int i = this.getOutputSlot(); i < this.getOutputSlot() + 2; ++i) {
            if (this.mInventory[i] == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        super.onScrewdriverRightClick(aSide, aPlayer, aX, aY, aZ);
        if (aSide != this.getBaseMetaTileEntity().getFrontFacing() && aSide != this.mMainFacing) {
            if (aPlayer.func_70093_af()) {
                if (this.radiusConfig >= 0) {
                    --this.radiusConfig;
                }
                if (this.radiusConfig < 0) {
                    this.radiusConfig = RADIUS[this.mTier];
                }
            } else {
                if (this.radiusConfig <= RADIUS[this.mTier]) {
                    ++this.radiusConfig;
                }
                if (this.radiusConfig > RADIUS[this.mTier]) {
                    this.radiusConfig = 0;
                }
            }
            GT_Utility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"GT5U.machines.workareaset") + " " + (this.radiusConfig * 2 + 1) + "x" + (this.radiusConfig * 2 + 1));
            this.oreBlockPositions.clear();
            this.fillOreList(this.getBaseMetaTileEntity());
        }
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        this.fillOreList(aBaseMetaTileEntity);
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide()) {
            block20: {
                if (aBaseMetaTileEntity.isAllowedToWork() && aBaseMetaTileEntity.isUniversalEnergyStored(ENERGY[this.mTier] * (SPEED[this.mTier] - this.mProgresstime)) && this.hasFreeSpace()) {
                    if (this.waitMiningPipe) {
                        this.mMaxProgresstime = 0;
                        for (int i = 0; i < this.mInputSlotCount; ++i) {
                            ItemStack s = this.getInputAt(i);
                            if (s == null || s.func_77973_b() != MINING_PIPE.func_77973_b() || s.field_77994_a <= 0) continue;
                            this.waitMiningPipe = false;
                            break block20;
                        }
                        if (GT_Values.debugBlockMiner) {
                            GT_Log.out.println("MINER: Pipe found in input");
                        }
                        return;
                    }
                } else {
                    this.mMaxProgresstime = 0;
                    if (GT_Values.debugBlockMiner) {
                        if (!aBaseMetaTileEntity.isAllowedToWork()) {
                            GT_Log.out.println("MINER: Disabled");
                        }
                        if (!aBaseMetaTileEntity.isUniversalEnergyStored(ENERGY[this.mTier] * (SPEED[this.mTier] - this.mProgresstime))) {
                            GT_Log.out.println("MINER: Not enough energy yet, want " + ENERGY[this.mTier] * SPEED[this.mTier] + " have " + aBaseMetaTileEntity.getUniversalEnergyStored());
                        }
                        if (!this.hasFreeSpace()) {
                            GT_Log.out.println("MINER: No free space");
                        }
                    }
                    return;
                }
            }
            aBaseMetaTileEntity.decreaseStoredEnergyUnits(ENERGY[this.mTier], true);
            this.mMaxProgresstime = SPEED[this.mTier];
            if (this.mProgresstime == SPEED[this.mTier] - 1) {
                if (this.isPickingPipes) {
                    if (this.drillY == 0) {
                        aBaseMetaTileEntity.disableWorking();
                        this.isPickingPipes = false;
                        if (GT_Values.debugBlockMiner) {
                            GT_Log.out.println("MINER: Completed picking pipes");
                        }
                    } else if (aBaseMetaTileEntity.getBlockOffset(0, this.drillY, 0) == MINING_PIPE_TIP_BLOCK || aBaseMetaTileEntity.getBlockOffset(0, this.drillY, 0) == MINING_PIPE_BLOCK) {
                        this.mOutputItems[0] = MINING_PIPE.func_77946_l();
                        this.mOutputItems[0].field_77994_a = 1;
                        aBaseMetaTileEntity.getWorld().func_147468_f(aBaseMetaTileEntity.getXCoord(), aBaseMetaTileEntity.getYCoord() + this.drillY, aBaseMetaTileEntity.getZCoord());
                        ++this.drillY;
                    }
                    return;
                }
                if (this.drillY == 0 || this.oreBlockPositions.isEmpty()) {
                    this.moveOneDown(aBaseMetaTileEntity);
                } else {
                    Block oreBlock;
                    int x = 0;
                    int y = 0;
                    int z = 0;
                    int oreBlockMetadata = 0;
                    do {
                        ChunkPosition oreBlockPos = this.oreBlockPositions.remove(0);
                        oreBlock = aBaseMetaTileEntity.getBlockOffset(oreBlockPos.field_151329_a, oreBlockPos.field_151327_b, oreBlockPos.field_151328_c);
                        x = aBaseMetaTileEntity.getXCoord() + oreBlockPos.field_151329_a;
                        y = aBaseMetaTileEntity.getYCoord() + oreBlockPos.field_151327_b;
                        z = aBaseMetaTileEntity.getZCoord() + oreBlockPos.field_151328_c;
                    } while (!GT_Utility.isOre(oreBlock, oreBlockMetadata = this.getBaseMetaTileEntity().getWorld().func_72805_g(x, y, z)) && !this.oreBlockPositions.isEmpty());
                    if (GT_Utility.isOre(oreBlock, oreBlockMetadata)) {
                        this.mineBlock(aBaseMetaTileEntity, oreBlock, x, y, z);
                    }
                }
            }
        }
    }

    private void fillOreList(IGregTechTileEntity aBaseMetaTileEntity) {
        if (this.drillY == 0) {
            return;
        }
        for (int z = -this.radiusConfig; z <= this.radiusConfig; ++z) {
            for (int x = -this.radiusConfig; x <= this.radiusConfig; ++x) {
                Block block = aBaseMetaTileEntity.getBlockOffset(x, this.drillY, z);
                byte blockMeta = aBaseMetaTileEntity.getMetaIDOffset(x, this.drillY, z);
                if (block instanceof GT_Block_Ores_Abstract) {
                    TileEntity tTileEntity = this.getBaseMetaTileEntity().getTileEntityOffset(x, this.drillY, z);
                    if (!(tTileEntity instanceof GT_TileEntity_Ores) || !((GT_TileEntity_Ores)tTileEntity).mNatural) continue;
                    this.oreBlockPositions.add(new ChunkPosition(x, this.drillY, z));
                    continue;
                }
                if (!GT_Utility.isOre(block, blockMeta)) continue;
                this.oreBlockPositions.add(new ChunkPosition(x, this.drillY, z));
            }
        }
    }

    @Override
    public long maxEUStore() {
        return this.mTier == 1 ? 4096L : GT_Values.V[this.mTier] * 64L;
    }

    public boolean moveOneDown(IGregTechTileEntity aBaseMetaTileEntity) {
        short yCoord;
        int zCoord;
        int xCoord;
        block6: {
            xCoord = aBaseMetaTileEntity.getXCoord();
            zCoord = aBaseMetaTileEntity.getZCoord();
            yCoord = aBaseMetaTileEntity.getYCoord();
            if (yCoord + this.drillY - 1 < 0 || GT_Utility.getBlockHardnessAt(aBaseMetaTileEntity.getWorld(), xCoord, yCoord + this.drillY - 1, zCoord) < 0.0f || !GT_Utility.setBlockByFakePlayer(this.getFakePlayer(aBaseMetaTileEntity), xCoord, yCoord + this.drillY - 1, zCoord, MINING_PIPE_TIP_BLOCK, 0, true)) {
                this.isPickingPipes = true;
                if (GT_Values.debugBlockMiner) {
                    GT_Log.out.println("MINER: Hit bottom? Hit block with -1 hardness? Unable to set mining pipe tip?");
                }
                return false;
            }
            if (aBaseMetaTileEntity.getBlockOffset(0, this.drillY, 0) == MINING_PIPE_TIP_BLOCK) {
                aBaseMetaTileEntity.getWorld().func_147449_b(xCoord, yCoord + this.drillY, zCoord, MINING_PIPE_BLOCK);
            }
            for (int i = 0; i < this.mInputSlotCount; ++i) {
                ItemStack s = this.getInputAt(i);
                if (s == null || s.func_77973_b() != MINING_PIPE.func_77973_b() || s.field_77994_a <= 0) continue;
                --s.field_77994_a;
                if (s.field_77994_a == 0) {
                    this.mInventory[this.getInputSlot() + i] = null;
                }
                break block6;
            }
            this.waitMiningPipe = true;
            return false;
        }
        Block block = aBaseMetaTileEntity.getBlockOffset(0, this.drillY - 1, 0);
        if (block != Blocks.field_150350_a) {
            this.mineBlock(aBaseMetaTileEntity, block, xCoord, yCoord + this.drillY - 1, zCoord);
        }
        aBaseMetaTileEntity.getWorld().func_147449_b(xCoord, yCoord + this.drillY - 1, zCoord, MINING_PIPE_TIP_BLOCK);
        --this.drillY;
        this.fillOreList(aBaseMetaTileEntity);
        return true;
    }

    public void mineBlock(IGregTechTileEntity aBaseMetaTileEntity, Block block, int x, int y, int z) {
        if (!GT_Utility.eraseBlockByFakePlayer(this.getFakePlayer(aBaseMetaTileEntity), x, y, z, true)) {
            if (GT_Values.debugBlockMiner) {
                GT_Log.out.println("MINER: FakePlayer cannot mine block at " + x + ", " + y + ", " + z);
            }
        } else {
            ArrayList<ItemStack> drops = this.getBlockDrops(block, x, y, z);
            if (drops.size() > 0) {
                this.mOutputItems[0] = drops.get(0);
            }
            if (drops.size() > 1) {
                this.mOutputItems[1] = drops.get(1);
            }
            short metaData = 0;
            TileEntity tTileEntity = this.getBaseMetaTileEntity().getTileEntity(x, y, z);
            if (tTileEntity instanceof GT_TileEntity_Ores) {
                metaData = ((GT_TileEntity_Ores)tTileEntity).mMetaData;
            }
            ItemStack cobble = GT_Utility.getCobbleForOre(block, metaData);
            aBaseMetaTileEntity.getWorld().func_147465_d(x, y, z, Block.func_149634_a((Item)cobble.func_77973_b()), cobble.func_77960_j(), 3);
            if (GT_Values.debugBlockMiner) {
                GT_Log.out.println("MINER: Mining GT ore block at " + x + " " + y + " " + z);
            }
        }
    }

    private ArrayList<ItemStack> getBlockDrops(Block oreBlock, int posX, int posY, int posZ) {
        byte blockMeta = this.getBaseMetaTileEntity().getMetaID(posX, posY, posZ);
        return oreBlock.getDrops(this.getBaseMetaTileEntity().getWorld(), posX, posY, posZ, (int)blockMeta, (int)this.mTier);
    }

    @Override
    public void setItemNBT(NBTTagCompound aNBT) {
        super.setItemNBT(aNBT);
        aNBT.func_74774_a("mTier", this.mTier);
        aNBT.func_74768_a("radiusConfig", this.radiusConfig);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("isPickingPipe", this.isPickingPipes);
        aNBT.func_74768_a("drillY", this.drillY);
        aNBT.func_74768_a("radiusConfig", this.radiusConfig);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.isPickingPipes = aNBT.func_74767_n("isPickingPipe");
        this.drillY = aNBT.func_74762_e("drillY");
        if (aNBT.func_74764_b("radiusConfig")) {
            this.radiusConfig = aNBT.func_74762_e("radiusConfig");
        }
    }

    protected FakePlayer getFakePlayer(IGregTechTileEntity aBaseTile) {
        if (this.mFakePlayer == null) {
            this.mFakePlayer = GT_Utility.getFakePlayer(aBaseTile);
        }
        if (this.mFakePlayer != null) {
            this.mFakePlayer.func_70029_a(aBaseTile.getWorld());
            this.mFakePlayer.func_70107_b((double)aBaseTile.getXCoord(), (double)aBaseTile.getYCoord(), (double)aBaseTile.getZCoord());
        }
        return this.mFakePlayer;
    }

    @Override
    public String[] getInfoData() {
        return new String[]{EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"GT5U.machines.miner") + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.machines.workarea") + ": " + EnumChatFormatting.GREEN + (this.radiusConfig * 2 + 1) + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"GT5U.machines.blocks")};
    }
}

