/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.GT_Mod;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_Container_MultiMachine;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_EnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gregtech.common.gui.GT_GUIContainer_FusionReactor;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;

public abstract class GT_MetaTileEntity_FusionComputer
extends GT_MetaTileEntity_EnhancedMultiBlockBase<GT_MetaTileEntity_FusionComputer> {
    public static final String STRUCTURE_PIECE_MAIN = "main";
    private static final ClassValue<IStructureDefinition<GT_MetaTileEntity_FusionComputer>> STRUCTURE_DEFINITION = new ClassValue<IStructureDefinition<GT_MetaTileEntity_FusionComputer>>(){

        @Override
        protected IStructureDefinition<GT_MetaTileEntity_FusionComputer> computeValue(Class<?> type) {
            return StructureDefinition.builder().addShape(GT_MetaTileEntity_FusionComputer.STRUCTURE_PIECE_MAIN, StructureUtility.transpose((String[][])new String[][]{{"               ", "      ihi      ", "    hh   hh    ", "   h       h   ", "  h         h  ", "  h         h  ", " i           i ", " h           h ", " i           i ", "  h         h  ", "  h         h  ", "   h       h   ", "    hh   hh    ", "      ihi      ", "               "}, {"      xhx      ", "    hhccchh    ", "   eccxhxcce   ", "  eceh   hece  ", " hce       ech ", " hch       hch ", "xcx         xcx", "hch         hch", "xcx         xcx", " hch       hch ", " hce       ech ", "  eceh   hece  ", "   eccx~xcce   ", "    hhccchh    ", "      xhx      "}, {"               ", "      ihi      ", "    hh   hh    ", "   h       h   ", "  h         h  ", "  h         h  ", " i           i ", " h           h ", " i           i ", "  h         h  ", "  h         h  ", "   h       h   ", "    hh   hh    ", "      ihi      ", "               "}})).addElement(Character.valueOf('c'), (IStructureElement)StructureUtility.lazy(t -> StructureUtility.ofBlock((Block)t.getFusionCoil(), (int)t.getFusionCoilMeta()))).addElement(Character.valueOf('h'), (IStructureElement)StructureUtility.lazy(t -> StructureUtility.ofBlock((Block)t.getCasing(), (int)t.getCasingMeta()))).addElement(Character.valueOf('i'), (IStructureElement)StructureUtility.lazy(t -> GT_StructureUtility.ofHatchAdderOptional((rec$, x$0, x$1) -> ((GT_MetaTileEntity_FusionComputer)rec$).addInjector(x$0, x$1), 53, 1, t.getCasing(), t.getCasingMeta()))).addElement(Character.valueOf('e'), (IStructureElement)StructureUtility.lazy(t -> GT_StructureUtility.ofHatchAdderOptional((rec$, x$0, x$1) -> ((GT_MetaTileEntity_FusionComputer)rec$).addEnergyInjector(x$0, x$1), 53, 2, t.getCasing(), t.getCasingMeta()))).addElement(Character.valueOf('x'), (IStructureElement)StructureUtility.lazy(t -> GT_StructureUtility.ofHatchAdderOptional((rec$, x$0, x$1) -> ((GT_MetaTileEntity_FusionComputer)rec$).addExtractor(x$0, x$1), 53, 3, t.getCasing(), t.getCasingMeta()))).build();
        }
    };
    public GT_Recipe mLastRecipe;
    public int mEUStore;

    public GT_MetaTileEntity_FusionComputer(int aID, String aName, String aNameRegional, int tier) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_FusionComputer(String aName) {
        super(aName);
    }

    public abstract int tier();

    @Override
    public abstract long maxEUStore();

    @Override
    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_Container_MultiMachine(aPlayerInventory, aBaseMetaTileEntity);
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_FusionReactor(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "FusionComputer.png", GT_Recipe.GT_Recipe_Map.sFusionRecipes.mNEIName);
    }

    @Override
    public abstract MetaTileEntity newMetaEntity(IGregTechTileEntity var1);

    @Override
    public boolean allowCoverOnSide(byte aSide, GT_ItemStack aStack) {
        return aSide != this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
    }

    @Override
    public IStructureDefinition<GT_MetaTileEntity_FusionComputer> getStructureDefinition() {
        return STRUCTURE_DEFINITION.get(this.getClass());
    }

    @Override
    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addController("Fusion Reactor").addInfo("Some kind of fusion reactor, maybe").addSeparator().addInfo("Some kind of fusion reactor, maybe").addStructureInfo("Should probably be built similar to other fusions").addStructureInfo("See controller tooltip for details").toolTipFinisher("Gregtech");
        return tt;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        if (this.checkPiece(STRUCTURE_PIECE_MAIN, 7, 1, 12) && this.mInputHatches.size() > 1 && !this.mOutputHatches.isEmpty() && !this.mEnergyHatches.isEmpty()) {
            this.mWrench = true;
            this.mScrewdriver = true;
            this.mSoftHammer = true;
            this.mHardHammer = true;
            this.mSolderingTool = true;
            this.mCrowbar = true;
            return true;
        }
        return false;
    }

    private boolean addEnergyInjector(IGregTechTileEntity aBaseMetaTileEntity, int aBaseCasingIndex) {
        IMetaTileEntity aMetaTileEntity = aBaseMetaTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (!(aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Energy)) {
            return false;
        }
        GT_MetaTileEntity_Hatch_Energy tHatch = (GT_MetaTileEntity_Hatch_Energy)aMetaTileEntity;
        if (tHatch.mTier < this.tier()) {
            return false;
        }
        tHatch.updateTexture(aBaseCasingIndex);
        return this.mEnergyHatches.add(tHatch);
    }

    private boolean addInjector(IGregTechTileEntity aBaseMetaTileEntity, int aBaseCasingIndex) {
        IMetaTileEntity aMetaTileEntity = aBaseMetaTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (!(aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input)) {
            return false;
        }
        GT_MetaTileEntity_Hatch_Input tHatch = (GT_MetaTileEntity_Hatch_Input)aMetaTileEntity;
        if (tHatch.mTier < this.tier()) {
            return false;
        }
        tHatch.updateTexture(aBaseCasingIndex);
        tHatch.mRecipeMap = this.getRecipeMap();
        return this.mInputHatches.add(tHatch);
    }

    private boolean addExtractor(IGregTechTileEntity aBaseMetaTileEntity, int aBaseCasingIndex) {
        if (aBaseMetaTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aBaseMetaTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (!(aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Output)) {
            return false;
        }
        GT_MetaTileEntity_Hatch_Output tHatch = (GT_MetaTileEntity_Hatch_Output)aMetaTileEntity;
        if (tHatch.mTier < this.tier()) {
            return false;
        }
        tHatch.updateTexture(aBaseCasingIndex);
        return this.mOutputHatches.add(tHatch);
    }

    public abstract Block getCasing();

    public abstract int getCasingMeta();

    public abstract Block getFusionCoil();

    public abstract int getFusionCoilMeta();

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{TextureFactory.builder().addIcon(Textures.BlockIcons.MACHINE_CASING_FUSION_GLASS).extFacing().build(), this.getTextureOverlay()};
        }
        if (aActive) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(52)};
        }
        return new ITexture[]{TextureFactory.builder().addIcon(Textures.BlockIcons.MACHINE_CASING_FUSION_GLASS).extFacing().build()};
    }

    public abstract ITexture getTextureOverlay();

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    public int overclock(int mStartEnergy) {
        if (this.tierOverclock() == 1) {
            return 1;
        }
        if (this.tierOverclock() == 2) {
            return mStartEnergy < 160000000 ? 2 : 1;
        }
        if (this.tierOverclock() == 4) {
            return mStartEnergy < 160000000 ? 4 : (mStartEnergy < 320000000 ? 2 : 1);
        }
        return mStartEnergy < 160000000 ? 8 : (mStartEnergy < 320000000 ? 4 : (mStartEnergy < 640000000 ? 2 : 1));
    }

    @Override
    public boolean checkRecipe(ItemStack aStack) {
        ArrayList<FluidStack> tFluidList = this.getStoredFluids();
        int tFluidList_sS = tFluidList.size();
        block0: for (int i = 0; i < tFluidList_sS - 1; ++i) {
            for (int j = i + 1; j < tFluidList_sS; ++j) {
                if (!GT_Utility.areFluidsEqual(tFluidList.get(i), tFluidList.get(j))) continue;
                if (tFluidList.get((int)i).amount >= tFluidList.get((int)j).amount) {
                    tFluidList.remove(j--);
                    tFluidList_sS = tFluidList.size();
                    continue;
                }
                tFluidList.remove(i--);
                tFluidList_sS = tFluidList.size();
                continue block0;
            }
        }
        if (tFluidList.size() > 1) {
            FluidStack[] tFluids = tFluidList.toArray(new FluidStack[tFluidList.size()]);
            GT_Recipe tRecipe = GT_Recipe.GT_Recipe_Map.sFusionRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), this.mLastRecipe, false, GT_Values.V[8], tFluids, new ItemStack[0]);
            if (tRecipe == null && !this.mRunningOnLoad || this.maxEUStore() < (long)tRecipe.mSpecialValue) {
                this.turnCasingActive(false);
                this.mLastRecipe = null;
                return false;
            }
            if (this.mRunningOnLoad || tRecipe.isRecipeInputEqual(true, tFluids, new ItemStack[0])) {
                this.mLastRecipe = tRecipe;
                this.mEUt = this.mLastRecipe.mEUt * this.overclock(this.mLastRecipe.mSpecialValue);
                this.mMaxProgresstime = this.mLastRecipe.mDuration / this.overclock(this.mLastRecipe.mSpecialValue);
                this.mEfficiencyIncrease = 10000;
                this.mOutputFluids = this.mLastRecipe.mFluidOutputs;
                this.turnCasingActive(true);
                this.mRunningOnLoad = false;
                return true;
            }
        }
        return false;
    }

    public abstract int tierOverclock();

    public boolean turnCasingActive(boolean status) {
        if (this.mEnergyHatches != null) {
            for (GT_MetaTileEntity_Hatch hatch : this.mEnergyHatches) {
                hatch.updateTexture(status ? 52 : 53);
            }
        }
        if (this.mOutputHatches != null) {
            for (GT_MetaTileEntity_Hatch hatch : this.mOutputHatches) {
                hatch.updateTexture(status ? 52 : 53);
            }
        }
        if (this.mInputHatches != null) {
            for (GT_MetaTileEntity_Hatch hatch : this.mInputHatches) {
                hatch.updateTexture(status ? 52 : 53);
            }
        }
        return true;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            if (this.mEfficiency < 0) {
                this.mEfficiency = 0;
            }
            if (this.mRunningOnLoad && this.checkMachine(aBaseMetaTileEntity, this.mInventory[1])) {
                this.mEUStore = (int)aBaseMetaTileEntity.getStoredEU();
                this.checkRecipe(this.mInventory[1]);
            }
            if (--this.mUpdate == 0 || --this.mStartUpCheck == 0) {
                this.mInputHatches.clear();
                this.mInputBusses.clear();
                this.mOutputHatches.clear();
                this.mOutputBusses.clear();
                this.mDynamoHatches.clear();
                this.mEnergyHatches.clear();
                this.mMufflerHatches.clear();
                this.mMaintenanceHatches.clear();
                this.mMachine = this.checkMachine(aBaseMetaTileEntity, this.mInventory[1]);
            }
            if (this.mStartUpCheck < 0) {
                if (this.mMachine) {
                    if (this.mEnergyHatches != null) {
                        for (GT_MetaTileEntity_Hatch_Energy tHatch : this.mEnergyHatches) {
                            if (!GT_MetaTileEntity_FusionComputer.isValidMetaTileEntity(tHatch) || aBaseMetaTileEntity.getStoredEU() + (long)(2048 * this.tierOverclock()) >= this.maxEUStore() || !tHatch.getBaseMetaTileEntity().decreaseStoredEnergyUnits(2048 * this.tierOverclock(), false)) continue;
                            aBaseMetaTileEntity.increaseStoredEnergyUnits(2048 * this.tierOverclock(), true);
                        }
                    }
                    if (this.mEUStore <= 0 && this.mMaxProgresstime > 0) {
                        this.stopMachine();
                    }
                    if (this.mMaxProgresstime > 0) {
                        this.getBaseMetaTileEntity().decreaseStoredEnergyUnits(this.mEUt, true);
                        if (this.mMaxProgresstime > 0 && ++this.mProgresstime >= this.mMaxProgresstime) {
                            if (this.mOutputItems != null) {
                                for (ItemStack itemStack : this.mOutputItems) {
                                    if (itemStack == null) continue;
                                    this.addOutput(itemStack);
                                }
                            }
                            if (this.mOutputFluids != null) {
                                for (ItemStack itemStack : this.mOutputFluids) {
                                    if (itemStack == null) continue;
                                    this.addOutput((FluidStack)itemStack);
                                }
                            }
                            this.mEfficiency = Math.max(0, Math.min(this.mEfficiency + this.mEfficiencyIncrease, this.getMaxEfficiency(this.mInventory[1])));
                            this.mOutputItems = null;
                            this.mProgresstime = 0;
                            this.mMaxProgresstime = 0;
                            this.mEfficiencyIncrease = 0;
                            if (this.mOutputFluids != null && this.mOutputFluids.length > 0) {
                                try {
                                    GT_Mod.achievements.issueAchivementHatchFluid(aBaseMetaTileEntity.getWorld().func_72924_a(aBaseMetaTileEntity.getOwnerName()), this.mOutputFluids[0]);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            this.mEUStore = (int)aBaseMetaTileEntity.getStoredEU();
                            if (aBaseMetaTileEntity.isAllowedToWork()) {
                                this.checkRecipe(this.mInventory[1]);
                            }
                        }
                    } else if (aTick % 100L == 0L || aBaseMetaTileEntity.hasWorkJustBeenEnabled() || aBaseMetaTileEntity.hasInventoryBeenModified()) {
                        this.turnCasingActive(this.mMaxProgresstime > 0);
                        if (aBaseMetaTileEntity.isAllowedToWork()) {
                            this.mEUStore = (int)aBaseMetaTileEntity.getStoredEU();
                            if (this.checkRecipe(this.mInventory[1])) {
                                if (this.mEUStore < this.mLastRecipe.mSpecialValue - this.mEUt) {
                                    this.mMaxProgresstime = 0;
                                    this.turnCasingActive(false);
                                }
                                aBaseMetaTileEntity.decreaseStoredEnergyUnits(this.mLastRecipe.mSpecialValue - this.mEUt, true);
                            }
                        }
                        if (this.mMaxProgresstime <= 0) {
                            this.mEfficiency = Math.max(0, this.mEfficiency - 1000);
                        }
                    }
                } else {
                    this.turnCasingActive(false);
                    this.mLastRecipe = null;
                    this.stopMachine();
                }
            }
            aBaseMetaTileEntity.setErrorDisplayID(aBaseMetaTileEntity.getErrorDisplayID() & 0xFFFFFF80 | (this.mMachine ? 0 : 64));
            aBaseMetaTileEntity.setActive(this.mMaxProgresstime > 0);
        }
    }

    @Override
    public boolean onRunningTick(ItemStack aStack) {
        if (this.mEUt < 0 && !this.drainEnergyInput((long)(-this.mEUt) * 10000L / (long)Math.max(1000, this.mEfficiency))) {
            this.mLastRecipe = null;
            this.stopMachine();
            return false;
        }
        if (this.mEUStore <= 0) {
            this.mLastRecipe = null;
            this.stopMachine();
            return false;
        }
        return true;
    }

    @Override
    public boolean drainEnergyInput(long aEU) {
        return false;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public String[] getInfoData() {
        String tier = this.tier() == 6 ? EnumChatFormatting.RED + "I" + EnumChatFormatting.RESET : (this.tier() == 7 ? EnumChatFormatting.YELLOW + "II" + EnumChatFormatting.RESET : (this.tier() == 8 ? EnumChatFormatting.GRAY + "III" + EnumChatFormatting.RESET : "IV"));
        float plasmaOut = 0.0f;
        int powerRequired = 0;
        if (this.mLastRecipe != null) {
            powerRequired = this.mLastRecipe.mEUt;
            if (this.mLastRecipe.getFluidOutput(0) != null) {
                plasmaOut = (float)this.mLastRecipe.getFluidOutput((int)0).amount / (float)this.mLastRecipe.mDuration;
            }
        }
        return new String[]{EnumChatFormatting.BLUE + "Fusion Reactor MK " + EnumChatFormatting.RESET + tier, StatCollector.func_74838_a((String)"GT5U.fusion.req") + ": " + EnumChatFormatting.RED + GT_Utility.formatNumbers(powerRequired) + EnumChatFormatting.RESET + "EU/t", StatCollector.func_74838_a((String)"GT5U.multiblock.energy") + ": " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers(this.mEUStore) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(this.maxEUStore()) + EnumChatFormatting.RESET + " EU", StatCollector.func_74838_a((String)"GT5U.fusion.plasma") + ": " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(plasmaOut) + EnumChatFormatting.RESET + "L/t"};
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 7, 1, 12);
    }

    static {
        Textures.BlockIcons.setCasingTextureForId(52, TextureFactory.of(TextureFactory.builder().addIcon(Textures.BlockIcons.MACHINE_CASING_FUSION_GLASS_YELLOW).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.MACHINE_CASING_FUSION_GLASS_YELLOW_GLOW).extFacing().glow().build()));
    }
}

