/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import codechicken.translocator.TileLiquidTranslocator;
import cpw.mods.fml.common.Optional;
import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.BaseMetaPipeEntity;
import gregtech.api.metatileentity.MetaPipeEntity;
import gregtech.api.objects.XSTR;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_CoverBehavior;
import gregtech.api.util.GT_CoverBehaviorBase;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.ISerializableObject;
import gregtech.api.util.WorldSpawnedEventBuilder;
import gregtech.common.GT_Client;
import gregtech.common.covers.GT_Cover_Drain;
import gregtech.common.covers.GT_Cover_FluidRegulator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import org.apache.commons.lang3.tuple.MutableTriple;
import tconstruct.smeltery.logic.FaucetLogic;

public class GT_MetaPipeEntity_Fluid
extends MetaPipeEntity {
    public final float mThickNess;
    public final Materials mMaterial;
    public final int mCapacity;
    public final int mHeatResistance;
    public final int mPipeAmount;
    public final boolean mGasProof;
    public final FluidStack[] mFluids;
    public byte mLastReceivedFrom = 0;
    public byte oLastReceivedFrom = 0;
    public byte mDisableInput = 0;

    public GT_MetaPipeEntity_Fluid(int aID, String aName, String aNameRegional, float aThickNess, Materials aMaterial, int aCapacity, int aHeatResistance, boolean aGasProof) {
        this(aID, aName, aNameRegional, aThickNess, aMaterial, aCapacity, aHeatResistance, aGasProof, 1);
    }

    public GT_MetaPipeEntity_Fluid(int aID, String aName, String aNameRegional, float aThickNess, Materials aMaterial, int aCapacity, int aHeatResistance, boolean aGasProof, int aFluidTypes) {
        super(aID, aName, aNameRegional, 0, false);
        this.mThickNess = aThickNess;
        this.mMaterial = aMaterial;
        this.mCapacity = aCapacity;
        this.mGasProof = aGasProof;
        this.mHeatResistance = aHeatResistance;
        this.mPipeAmount = aFluidTypes;
        this.mFluids = new FluidStack[this.mPipeAmount];
        this.addInfo(aID);
    }

    @Deprecated
    public GT_MetaPipeEntity_Fluid(String aName, float aThickNess, Materials aMaterial, int aCapacity, int aHeatResistance, boolean aGasProof) {
        this(aName, aThickNess, aMaterial, aCapacity, aHeatResistance, aGasProof, 1);
    }

    public GT_MetaPipeEntity_Fluid(String aName, float aThickNess, Materials aMaterial, int aCapacity, int aHeatResistance, boolean aGasProof, int aFluidTypes) {
        super(aName, 0);
        this.mThickNess = aThickNess;
        this.mMaterial = aMaterial;
        this.mCapacity = aCapacity;
        this.mGasProof = aGasProof;
        this.mHeatResistance = aHeatResistance;
        this.mPipeAmount = aFluidTypes;
        this.mFluids = new FluidStack[this.mPipeAmount];
    }

    @Override
    public byte getTileEntityBaseType() {
        return (byte)(this.mMaterial == null ? 4 : 4 + Math.max(0, Math.min(3, this.mMaterial.mToolQuality)));
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaPipeEntity_Fluid(this.mName, this.mThickNess, this.mMaterial, this.mCapacity, this.mHeatResistance, this.mGasProof, this.mPipeAmount);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aConnections, byte aColorIndex, boolean aConnected, boolean aRedstone) {
        float tThickNess = this.getThickNess();
        if (this.mDisableInput == 0) {
            return new ITexture[]{aConnected ? GT_MetaPipeEntity_Fluid.getBaseTexture(tThickNess, this.mPipeAmount, this.mMaterial, aColorIndex) : TextureFactory.of(this.mMaterial.mIconSet.mTextures[OrePrefixes.pipe.mTextureIndex], Dyes.getModulation(aColorIndex, this.mMaterial.mRGBa))};
        }
        byte tMask = 0;
        byte[][] sRestrictionArray = new byte[][]{{2, 3, 5, 4}, {2, 3, 4, 5}, {1, 0, 4, 5}, {1, 0, 4, 5}, {1, 0, 2, 3}, {1, 0, 2, 3}};
        if (aSide >= 0 && aSide < 6) {
            for (int i = 0; i < 4; i = (int)((byte)(i + 1))) {
                if (!this.isInputDisabledAtSide(sRestrictionArray[aSide][i])) continue;
                tMask = (byte)(tMask | 1 << i);
            }
            if ((aSide == 5 || aSide == 2) && tMask > 3 && tMask < 12) {
                tMask = (byte)(tMask ^ 0xC);
            }
        }
        return new ITexture[]{aConnected ? GT_MetaPipeEntity_Fluid.getBaseTexture(tThickNess, this.mPipeAmount, this.mMaterial, aColorIndex) : TextureFactory.of(this.mMaterial.mIconSet.mTextures[OrePrefixes.pipe.mTextureIndex], Dyes.getModulation(aColorIndex, this.mMaterial.mRGBa)), GT_MetaPipeEntity_Fluid.getRestrictorTexture(tMask)};
    }

    protected static ITexture getBaseTexture(float aThickNess, int aPipeAmount, Materials aMaterial, byte aColorIndex) {
        if (aPipeAmount >= 9) {
            return TextureFactory.of(aMaterial.mIconSet.mTextures[OrePrefixes.pipeNonuple.mTextureIndex], Dyes.getModulation(aColorIndex, aMaterial.mRGBa));
        }
        if (aPipeAmount >= 4) {
            return TextureFactory.of(aMaterial.mIconSet.mTextures[OrePrefixes.pipeQuadruple.mTextureIndex], Dyes.getModulation(aColorIndex, aMaterial.mRGBa));
        }
        if (aThickNess < 0.124f) {
            return TextureFactory.of(aMaterial.mIconSet.mTextures[OrePrefixes.pipe.mTextureIndex], Dyes.getModulation(aColorIndex, aMaterial.mRGBa));
        }
        if (aThickNess < 0.374f) {
            return TextureFactory.of(aMaterial.mIconSet.mTextures[OrePrefixes.pipeTiny.mTextureIndex], Dyes.getModulation(aColorIndex, aMaterial.mRGBa));
        }
        if (aThickNess < 0.499f) {
            return TextureFactory.of(aMaterial.mIconSet.mTextures[OrePrefixes.pipeSmall.mTextureIndex], Dyes.getModulation(aColorIndex, aMaterial.mRGBa));
        }
        if (aThickNess < 0.749f) {
            return TextureFactory.of(aMaterial.mIconSet.mTextures[OrePrefixes.pipeMedium.mTextureIndex], Dyes.getModulation(aColorIndex, aMaterial.mRGBa));
        }
        if (aThickNess < 0.874f) {
            return TextureFactory.of(aMaterial.mIconSet.mTextures[OrePrefixes.pipeLarge.mTextureIndex], Dyes.getModulation(aColorIndex, aMaterial.mRGBa));
        }
        return TextureFactory.of(aMaterial.mIconSet.mTextures[OrePrefixes.pipeHuge.mTextureIndex], Dyes.getModulation(aColorIndex, aMaterial.mRGBa));
    }

    protected static final ITexture getRestrictorTexture(byte aMask) {
        switch (aMask) {
            case 1: {
                return TextureFactory.of(Textures.BlockIcons.PIPE_RESTRICTOR_UP);
            }
            case 2: {
                return TextureFactory.of(Textures.BlockIcons.PIPE_RESTRICTOR_DOWN);
            }
            case 3: {
                return TextureFactory.of(Textures.BlockIcons.PIPE_RESTRICTOR_UD);
            }
            case 4: {
                return TextureFactory.of(Textures.BlockIcons.PIPE_RESTRICTOR_LEFT);
            }
            case 5: {
                return TextureFactory.of(Textures.BlockIcons.PIPE_RESTRICTOR_UL);
            }
            case 6: {
                return TextureFactory.of(Textures.BlockIcons.PIPE_RESTRICTOR_DL);
            }
            case 7: {
                return TextureFactory.of(Textures.BlockIcons.PIPE_RESTRICTOR_NR);
            }
            case 8: {
                return TextureFactory.of(Textures.BlockIcons.PIPE_RESTRICTOR_RIGHT);
            }
            case 9: {
                return TextureFactory.of(Textures.BlockIcons.PIPE_RESTRICTOR_UR);
            }
            case 10: {
                return TextureFactory.of(Textures.BlockIcons.PIPE_RESTRICTOR_DR);
            }
            case 11: {
                return TextureFactory.of(Textures.BlockIcons.PIPE_RESTRICTOR_NL);
            }
            case 12: {
                return TextureFactory.of(Textures.BlockIcons.PIPE_RESTRICTOR_LR);
            }
            case 13: {
                return TextureFactory.of(Textures.BlockIcons.PIPE_RESTRICTOR_ND);
            }
            case 14: {
                return TextureFactory.of(Textures.BlockIcons.PIPE_RESTRICTOR_NU);
            }
            case 15: {
                return TextureFactory.of(Textures.BlockIcons.PIPE_RESTRICTOR);
            }
        }
        return null;
    }

    @Override
    public void onValueUpdate(byte aValue) {
        this.mDisableInput = aValue;
    }

    @Override
    public byte getUpdateData() {
        return this.mDisableInput;
    }

    @Override
    public boolean isSimpleMachine() {
        return true;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return false;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return false;
    }

    @Override
    public final boolean renderInside(byte aSide) {
        return false;
    }

    @Override
    public int getProgresstime() {
        return this.getFluidAmount();
    }

    @Override
    public int maxProgresstime() {
        return this.getCapacity();
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        for (int i = 0; i < this.mPipeAmount; ++i) {
            if (this.mFluids[i] == null) continue;
            aNBT.func_74782_a("mFluid" + (i == 0 ? "" : Integer.valueOf(i)), (NBTBase)this.mFluids[i].writeToNBT(new NBTTagCompound()));
        }
        aNBT.func_74774_a("mLastReceivedFrom", this.mLastReceivedFrom);
        if (GT_Mod.gregtechproxy.gt6Pipe) {
            aNBT.func_74774_a("mConnections", this.mConnections);
            aNBT.func_74774_a("mDisableInput", this.mDisableInput);
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        for (int i = 0; i < this.mPipeAmount; ++i) {
            this.mFluids[i] = FluidStack.loadFluidStackFromNBT((NBTTagCompound)aNBT.func_74775_l("mFluid" + (i == 0 ? "" : Integer.valueOf(i))));
        }
        this.mLastReceivedFrom = aNBT.func_74771_c("mLastReceivedFrom");
        if (GT_Mod.gregtechproxy.gt6Pipe) {
            this.mConnections = aNBT.func_74771_c("mConnections");
            this.mDisableInput = aNBT.func_74771_c("mDisableInput");
        }
    }

    @Override
    public void onEntityCollidedWithBlock(World aWorld, int aX, int aY, int aZ, Entity aEntity) {
        if ((((BaseMetaPipeEntity)this.getBaseMetaTileEntity()).mConnections & 0xFFFFFF80) == 0 && aEntity instanceof EntityLivingBase) {
            for (FluidStack tFluid : this.mFluids) {
                if (tFluid == null) continue;
                int tTemperature = tFluid.getFluid().getTemperature(tFluid);
                if (tTemperature > 320 && !this.isCoverOnSide((BaseMetaPipeEntity)this.getBaseMetaTileEntity(), (EntityLivingBase)aEntity)) {
                    GT_Utility.applyHeatDamage((EntityLivingBase)aEntity, (float)(tTemperature - 300) / 50.0f);
                    break;
                }
                if (tTemperature >= 260 || this.isCoverOnSide((BaseMetaPipeEntity)this.getBaseMetaTileEntity(), (EntityLivingBase)aEntity)) continue;
                GT_Utility.applyFrostDamage((EntityLivingBase)aEntity, (float)(270 - tTemperature) / 25.0f);
                break;
            }
        }
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide() && aTick % 5L == 0L) {
            this.mLastReceivedFrom = (byte)(this.mLastReceivedFrom & 0x3F);
            if (this.mLastReceivedFrom == 63) {
                this.mLastReceivedFrom = 0;
            }
            if (!GT_Mod.gregtechproxy.gt6Pipe || this.mCheckConnections) {
                this.checkConnections();
            }
            boolean shouldDistribute = this.oLastReceivedFrom == this.mLastReceivedFrom;
            int j = aBaseMetaTileEntity.getRandomNumber(this.mPipeAmount);
            for (int i = 0; i < this.mPipeAmount; ++i) {
                int index = (i + j) % this.mPipeAmount;
                if (this.mFluids[index] != null && this.mFluids[index].amount <= 0) {
                    this.mFluids[index] = null;
                }
                if (this.mFluids[index] == null) continue;
                if (this.checkEnvironment(index, aBaseMetaTileEntity)) {
                    return;
                }
                if (!shouldDistribute) continue;
                this.distributeFluid(index, aBaseMetaTileEntity);
                this.mLastReceivedFrom = 0;
            }
            this.oLastReceivedFrom = this.mLastReceivedFrom;
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean checkEnvironment(int index, IGregTechTileEntity aBaseMetaTileEntity) {
        tFluid = this.mFluids[index];
        if (tFluid != null && tFluid.amount > 0) {
            block14: {
                tTemperature = tFluid.getFluid().getTemperature(tFluid);
                if (tTemperature > this.mHeatResistance) {
                    if (aBaseMetaTileEntity.getRandomNumber(100) == 0) {
                        GT_Log.exp.println("Set Pipe to Fire due to to low heat resistance at " + aBaseMetaTileEntity.getXCoord() + " | " + aBaseMetaTileEntity.getYCoord() + " | " + aBaseMetaTileEntity.getZCoord() + " DIMID: " + aBaseMetaTileEntity.getWorld().field_73011_w.field_76574_g);
                        aBaseMetaTileEntity.setToFire();
                        return true;
                    }
                    aBaseMetaTileEntity.setOnFire();
                    GT_Log.exp.println("Set Blocks around Pipe to Fire due to to low heat resistance at " + aBaseMetaTileEntity.getXCoord() + " | " + aBaseMetaTileEntity.getYCoord() + " | " + aBaseMetaTileEntity.getZCoord() + " DIMID: " + aBaseMetaTileEntity.getWorld().field_73011_w.field_76574_g);
                }
                if (!this.mGasProof && tFluid.getFluid().isGaseous(tFluid)) {
                    tFluid.amount -= 5;
                    this.sendSound((byte)9);
                    if (tTemperature > 320) {
                        try {
                            for (EntityLivingBase tLiving : (ArrayList)this.getBaseMetaTileEntity().getWorld().func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)(this.getBaseMetaTileEntity().getXCoord() - 2), (double)(this.getBaseMetaTileEntity().getYCoord() - 2), (double)(this.getBaseMetaTileEntity().getZCoord() - 2), (double)(this.getBaseMetaTileEntity().getXCoord() + 3), (double)(this.getBaseMetaTileEntity().getYCoord() + 3), (double)(this.getBaseMetaTileEntity().getZCoord() + 3)))) {
                                GT_Utility.applyHeatDamage(tLiving, (float)(tTemperature - 300) / 25.0f);
                            }
                        }
                        catch (Throwable e) {
                            if (!GT_Values.D1) ** GOTO lbl35
                            e.printStackTrace(GT_Log.err);
                        }
                    } else if (tTemperature < 260) {
                        try {
                            for (EntityLivingBase tLiving : (ArrayList)this.getBaseMetaTileEntity().getWorld().func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)(this.getBaseMetaTileEntity().getXCoord() - 2), (double)(this.getBaseMetaTileEntity().getYCoord() - 2), (double)(this.getBaseMetaTileEntity().getZCoord() - 2), (double)(this.getBaseMetaTileEntity().getXCoord() + 3), (double)(this.getBaseMetaTileEntity().getYCoord() + 3), (double)(this.getBaseMetaTileEntity().getZCoord() + 3)))) {
                                GT_Utility.applyFrostDamage(tLiving, (float)(270 - tTemperature) / 12.5f);
                            }
                        }
                        catch (Throwable e) {
                            if (!GT_Values.D1) break block14;
                            e.printStackTrace(GT_Log.err);
                        }
                    }
                }
            }
            if (tFluid.amount <= 0) {
                this.mFluids[index] = null;
            }
        }
        return false;
    }

    private void distributeFluid(int index, IGregTechTileEntity aBaseMetaTileEntity) {
        FluidStack tFluid = this.mFluids[index];
        if (tFluid == null) {
            return;
        }
        ArrayList<MutableTriple> tTanks = new ArrayList<MutableTriple>();
        int amount = tFluid.amount;
        byte j = (byte)aBaseMetaTileEntity.getRandomNumber(6);
        for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
            IGregTechTileEntity gTank;
            byte aSide = (byte)((i + j) % 6);
            byte tSide = GT_Utility.getOppositeSide(aSide);
            IFluidHandler tTank = aBaseMetaTileEntity.getITankContainerAtSide(aSide);
            IGregTechTileEntity iGregTechTileEntity = gTank = tTank instanceof IGregTechTileEntity ? (IGregTechTileEntity)tTank : null;
            if (!this.isConnectedAtSide(aSide) || tTank == null || (this.mLastReceivedFrom & 1 << aSide) != 0 || !this.getBaseMetaTileEntity().getCoverBehaviorAtSideNew(aSide).letsFluidOut(aSide, this.getBaseMetaTileEntity().getCoverIDAtSide(aSide), this.getBaseMetaTileEntity().getComplexCoverDataAtSide(aSide), tFluid.getFluid(), this.getBaseMetaTileEntity()) || gTank != null && !gTank.getCoverBehaviorAtSideNew(tSide).letsFluidIn(tSide, gTank.getCoverIDAtSide(tSide), gTank.getComplexCoverDataAtSide(tSide), tFluid.getFluid(), gTank)) continue;
            if (tTank.fill(ForgeDirection.getOrientation((int)tSide), tFluid, false) > 0) {
                tTanks.add(new MutableTriple((Object)tTank, (Object)ForgeDirection.getOrientation((int)tSide), (Object)0));
            }
            tFluid.amount = amount;
        }
        double tAmount = Math.max(1, Math.min(this.mCapacity * 10, tFluid.amount));
        double tNumTanks = tTanks.size();
        FluidStack maxFluid = tFluid.copy();
        maxFluid.amount = Integer.MAX_VALUE;
        double availableCapacity = 0.0;
        for (MutableTriple tEntry : tTanks) {
            tEntry.right = ((IFluidHandler)tEntry.left).fill((ForgeDirection)tEntry.middle, maxFluid, false);
            availableCapacity += (double)((Integer)tEntry.right).intValue();
        }
        for (MutableTriple tEntry : tTanks) {
            int tFilledAmount;
            if (availableCapacity > tAmount) {
                tEntry.right = (int)Math.floor((double)((Integer)tEntry.right).intValue() * tAmount / availableCapacity);
            }
            if ((Integer)tEntry.right == 0) {
                tEntry.right = (int)Math.min(1.0, tAmount);
            }
            if ((Integer)tEntry.right <= 0 || (tFilledAmount = ((IFluidHandler)tEntry.left).fill((ForgeDirection)tEntry.middle, this.drainFromIndex((Integer)tEntry.right, false, index), false)) <= 0) continue;
            ((IFluidHandler)tEntry.left).fill((ForgeDirection)tEntry.middle, this.drainFromIndex(tFilledAmount, true, index), true);
        }
    }

    @Override
    public boolean onWrenchRightClick(byte aSide, byte aWrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (GT_Mod.gregtechproxy.gt6Pipe) {
            byte tSide = GT_Utility.determineWrenchingSide(aSide, aX, aY, aZ);
            byte tMask = (byte)(1 << tSide);
            if (aPlayer.func_70093_af()) {
                if (this.isInputDisabledAtSide(tSide)) {
                    this.mDisableInput = (byte)(this.mDisableInput & ~tMask);
                    GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("212", "Input enabled"));
                    if (!this.isConnectedAtSide(tSide)) {
                        this.connect(tSide);
                    }
                } else {
                    this.mDisableInput = (byte)(this.mDisableInput | tMask);
                    GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("213", "Input disabled"));
                }
            } else if (!this.isConnectedAtSide(tSide)) {
                if (this.connect(tSide) > 0) {
                    GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("214", "Connected"));
                }
            } else {
                this.disconnect(tSide);
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("215", "Disconnected"));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean letsIn(GT_CoverBehavior coverBehavior, byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return coverBehavior.letsFluidIn(aSide, aCoverID, aCoverVariable, null, aTileEntity);
    }

    @Override
    public boolean letsOut(GT_CoverBehavior coverBehavior, byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return coverBehavior.letsFluidOut(aSide, aCoverID, aCoverVariable, null, aTileEntity);
    }

    @Override
    public boolean letsIn(GT_CoverBehaviorBase<?> coverBehavior, byte aSide, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return coverBehavior.letsFluidIn(aSide, aCoverID, aCoverVariable, null, aTileEntity);
    }

    @Override
    public boolean letsOut(GT_CoverBehaviorBase<?> coverBehavior, byte aSide, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return coverBehavior.letsFluidOut(aSide, aCoverID, aCoverVariable, null, aTileEntity);
    }

    @Override
    public boolean canConnect(byte aSide, TileEntity tTileEntity) {
        FluidTankInfo[] tInfo;
        IFluidHandler fTileEntity;
        IGregTechTileEntity gTileEntity;
        if (tTileEntity == null) {
            return false;
        }
        byte tSide = (byte)ForgeDirection.getOrientation((int)aSide).getOpposite().ordinal();
        IGregTechTileEntity baseMetaTile = this.getBaseMetaTileEntity();
        if (baseMetaTile == null) {
            return false;
        }
        GT_CoverBehaviorBase<?> coverBehavior = baseMetaTile.getCoverBehaviorAtSideNew(aSide);
        IGregTechTileEntity iGregTechTileEntity = gTileEntity = tTileEntity instanceof IGregTechTileEntity ? (IGregTechTileEntity)tTileEntity : null;
        if (coverBehavior instanceof GT_Cover_Drain || GregTech_API.mTConstruct && this.isTConstructFaucet(tTileEntity)) {
            return true;
        }
        IFluidHandler iFluidHandler = fTileEntity = tTileEntity instanceof IFluidHandler ? (IFluidHandler)tTileEntity : null;
        if (fTileEntity != null && (tInfo = fTileEntity.getTankInfo(ForgeDirection.getOrientation((int)tSide))) != null) {
            return tInfo.length > 0 || GregTech_API.mTranslocator && this.isTranslocator(tTileEntity) || gTileEntity != null && gTileEntity.getCoverBehaviorAtSideNew(tSide) instanceof GT_Cover_FluidRegulator;
        }
        return false;
    }

    @Optional.Method(modid="TConstruct")
    private boolean isTConstructFaucet(TileEntity tTileEntity) {
        return tTileEntity instanceof FaucetLogic;
    }

    @Optional.Method(modid="Translocator")
    private boolean isTranslocator(TileEntity tTileEntity) {
        return tTileEntity instanceof TileLiquidTranslocator;
    }

    @Override
    public boolean getGT6StyleConnection() {
        return GT_Mod.gregtechproxy.gt6Pipe;
    }

    @Override
    public void doSound(byte aIndex, double aX, double aY, double aZ) {
        super.doSound(aIndex, aX, aY, aZ);
        if (aIndex == 9) {
            GT_Utility.doSoundAtClient(GregTech_API.sSoundList.get(4), 5, 1.0f, aX, aY, aZ);
            new WorldSpawnedEventBuilder.ParticleEventBuilder().setIdentifier("largesmoke").setWorld(this.getBaseMetaTileEntity().getWorld()).times(6, (x, i) -> x.setMotion((double)ForgeDirection.getOrientation((int)i.intValue()).offsetX / 5.0, (double)ForgeDirection.getOrientation((int)i.intValue()).offsetY / 5.0, (double)ForgeDirection.getOrientation((int)i.intValue()).offsetZ / 5.0).setPosition(aX - 0.5 + (double)XSTR.XSTR_INSTANCE.nextFloat(), aY - 0.5 + (double)XSTR.XSTR_INSTANCE.nextFloat(), aZ - 0.5 + (double)XSTR.XSTR_INSTANCE.nextFloat()).run());
        }
    }

    @Override
    public final int getCapacity() {
        return this.mCapacity * 20 * this.mPipeAmount;
    }

    @Override
    public FluidTankInfo getInfo() {
        for (FluidStack tFluid : this.mFluids) {
            if (tFluid == null) continue;
            return new FluidTankInfo(tFluid, this.mCapacity * 20);
        }
        return new FluidTankInfo(null, this.mCapacity * 20);
    }

    @Override
    public FluidTankInfo[] getTankInfo(ForgeDirection aSide) {
        if (this.getCapacity() <= 0 && !this.getBaseMetaTileEntity().hasSteamEngineUpgrade()) {
            return new FluidTankInfo[0];
        }
        ArrayList<FluidTankInfo> tList = new ArrayList<FluidTankInfo>();
        for (FluidStack tFluid : this.mFluids) {
            tList.add(new FluidTankInfo(tFluid, this.mCapacity * 20));
        }
        return tList.toArray(new FluidTankInfo[this.mPipeAmount]);
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    @Override
    public final FluidStack getFluid() {
        for (FluidStack tFluid : this.mFluids) {
            if (tFluid == null) continue;
            return tFluid;
        }
        return null;
    }

    @Override
    public final int getFluidAmount() {
        int rAmount = 0;
        for (FluidStack tFluid : this.mFluids) {
            if (tFluid == null) continue;
            rAmount += tFluid.amount;
        }
        return rAmount;
    }

    @Override
    public final int fill_default(ForgeDirection aSide, FluidStack aFluid, boolean doFill) {
        if (aFluid == null || aFluid.getFluid().getID() <= 0) {
            return 0;
        }
        int index = -1;
        for (int i = 0; i < this.mPipeAmount; ++i) {
            if (this.mFluids[i] != null && this.mFluids[i].isFluidEqual(aFluid)) {
                index = i;
                break;
            }
            if (this.mFluids[i] != null && this.mFluids[i].getFluid().getID() > 0 || index >= 0) continue;
            index = i;
        }
        return this.fill_default_intoIndex(aSide, aFluid, doFill, index);
    }

    private final int fill_default_intoIndex(ForgeDirection aSide, FluidStack aFluid, boolean doFill, int index) {
        if (index < 0 || index >= this.mPipeAmount) {
            return 0;
        }
        if (aFluid == null || aFluid.getFluid().getID() <= 0) {
            return 0;
        }
        if (this.mFluids[index] == null || this.mFluids[index].getFluid().getID() <= 0) {
            if (aFluid.amount * this.mPipeAmount <= this.getCapacity()) {
                if (doFill) {
                    this.mFluids[index] = aFluid.copy();
                    this.mLastReceivedFrom = (byte)(this.mLastReceivedFrom | 1 << aSide.ordinal());
                }
                return aFluid.amount;
            }
            if (doFill) {
                this.mFluids[index] = aFluid.copy();
                this.mLastReceivedFrom = (byte)(this.mLastReceivedFrom | 1 << aSide.ordinal());
                this.mFluids[index].amount = this.getCapacity() / this.mPipeAmount;
            }
            return this.getCapacity() / this.mPipeAmount;
        }
        if (!this.mFluids[index].isFluidEqual(aFluid)) {
            return 0;
        }
        int space = this.getCapacity() / this.mPipeAmount - this.mFluids[index].amount;
        if (aFluid.amount <= space) {
            if (doFill) {
                this.mFluids[index].amount += aFluid.amount;
                this.mLastReceivedFrom = (byte)(this.mLastReceivedFrom | 1 << aSide.ordinal());
            }
            return aFluid.amount;
        }
        if (doFill) {
            this.mFluids[index].amount = this.getCapacity() / this.mPipeAmount;
            this.mLastReceivedFrom = (byte)(this.mLastReceivedFrom | 1 << aSide.ordinal());
        }
        return space;
    }

    @Override
    public final FluidStack drain(int maxDrain, boolean doDrain) {
        FluidStack drained = null;
        for (int i = 0; i < this.mPipeAmount; ++i) {
            drained = this.drainFromIndex(maxDrain, doDrain, i);
            if (drained == null) continue;
            return drained;
        }
        return null;
    }

    private final FluidStack drainFromIndex(int maxDrain, boolean doDrain, int index) {
        if (index < 0 || index >= this.mPipeAmount) {
            return null;
        }
        if (this.mFluids[index] == null) {
            return null;
        }
        if (this.mFluids[index].amount <= 0) {
            this.mFluids[index] = null;
            return null;
        }
        int used = maxDrain;
        if (this.mFluids[index].amount < used) {
            used = this.mFluids[index].amount;
        }
        if (doDrain) {
            this.mFluids[index].amount -= used;
        }
        FluidStack drained = this.mFluids[index].copy();
        drained.amount = used;
        if (this.mFluids[index].amount <= 0) {
            this.mFluids[index] = null;
        }
        return drained;
    }

    @Override
    public int getTankPressure() {
        return this.getFluidAmount() - this.getCapacity() / 2;
    }

    @Override
    public String[] getDescription() {
        if (this.mPipeAmount == 1) {
            return new String[]{EnumChatFormatting.BLUE + "Fluid Capacity: %%%" + GT_Utility.formatNumbers(this.mCapacity * 20) + "%%% L/sec" + EnumChatFormatting.GRAY, EnumChatFormatting.RED + "Heat Limit: %%%" + GT_Utility.formatNumbers(this.mHeatResistance) + "%%% K" + EnumChatFormatting.GRAY};
        }
        return new String[]{EnumChatFormatting.BLUE + "Fluid Capacity: %%%" + GT_Utility.formatNumbers(this.mCapacity * 20) + "%%% L/sec" + EnumChatFormatting.GRAY, EnumChatFormatting.RED + "Heat Limit: %%%" + GT_Utility.formatNumbers(this.mHeatResistance) + "%%% K" + EnumChatFormatting.GRAY, EnumChatFormatting.AQUA + "Pipe Amount: %%%" + this.mPipeAmount + EnumChatFormatting.GRAY};
    }

    @Override
    public float getThickNess() {
        if (GT_Mod.instance.isClientSide() && (GT_Client.hideValue & 1) != 0) {
            return 0.0625f;
        }
        return this.mThickNess;
    }

    @Override
    public boolean isLiquidInput(byte aSide) {
        return !this.isInputDisabledAtSide(aSide);
    }

    @Override
    public boolean isLiquidOutput(byte aSide) {
        return true;
    }

    public boolean isInputDisabledAtSide(int aSide) {
        return (this.mDisableInput & 1 << aSide) != 0;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World aWorld, int aX, int aY, int aZ) {
        if (GT_Mod.instance.isClientSide() && (GT_Client.hideValue & 2) != 0) {
            return AxisAlignedBB.func_72330_a((double)aX, (double)aY, (double)aZ, (double)(aX + 1), (double)(aY + 1), (double)(aZ + 1));
        }
        return this.getActualCollisionBoundingBoxFromPool(aWorld, aX, aY, aZ);
    }

    private AxisAlignedBB getActualCollisionBoundingBoxFromPool(World aWorld, int aX, int aY, int aZ) {
        byte tConn;
        float tSpace;
        float tSide0 = tSpace = (1.0f - this.mThickNess) / 2.0f;
        float tSide1 = 1.0f - tSpace;
        float tSide2 = tSpace;
        float tSide3 = 1.0f - tSpace;
        float tSide4 = tSpace;
        float tSide5 = 1.0f - tSpace;
        if (this.getBaseMetaTileEntity().getCoverIDAtSide((byte)0) != 0) {
            tSide4 = 0.0f;
            tSide2 = 0.0f;
            tSide0 = 0.0f;
            tSide5 = 1.0f;
            tSide3 = 1.0f;
        }
        if (this.getBaseMetaTileEntity().getCoverIDAtSide((byte)1) != 0) {
            tSide4 = 0.0f;
            tSide2 = 0.0f;
            tSide5 = 1.0f;
            tSide3 = 1.0f;
            tSide1 = 1.0f;
        }
        if (this.getBaseMetaTileEntity().getCoverIDAtSide((byte)2) != 0) {
            tSide4 = 0.0f;
            tSide2 = 0.0f;
            tSide0 = 0.0f;
            tSide5 = 1.0f;
            tSide1 = 1.0f;
        }
        if (this.getBaseMetaTileEntity().getCoverIDAtSide((byte)3) != 0) {
            tSide4 = 0.0f;
            tSide0 = 0.0f;
            tSide5 = 1.0f;
            tSide3 = 1.0f;
            tSide1 = 1.0f;
        }
        if (this.getBaseMetaTileEntity().getCoverIDAtSide((byte)4) != 0) {
            tSide4 = 0.0f;
            tSide2 = 0.0f;
            tSide0 = 0.0f;
            tSide3 = 1.0f;
            tSide1 = 1.0f;
        }
        if (this.getBaseMetaTileEntity().getCoverIDAtSide((byte)5) != 0) {
            tSide2 = 0.0f;
            tSide0 = 0.0f;
            tSide5 = 1.0f;
            tSide3 = 1.0f;
            tSide1 = 1.0f;
        }
        if (((tConn = ((BaseMetaPipeEntity)this.getBaseMetaTileEntity()).mConnections) & 1 << ForgeDirection.DOWN.ordinal()) != 0) {
            tSide0 = 0.0f;
        }
        if ((tConn & 1 << ForgeDirection.UP.ordinal()) != 0) {
            tSide1 = 1.0f;
        }
        if ((tConn & 1 << ForgeDirection.NORTH.ordinal()) != 0) {
            tSide2 = 0.0f;
        }
        if ((tConn & 1 << ForgeDirection.SOUTH.ordinal()) != 0) {
            tSide3 = 1.0f;
        }
        if ((tConn & 1 << ForgeDirection.WEST.ordinal()) != 0) {
            tSide4 = 0.0f;
        }
        if ((tConn & 1 << ForgeDirection.EAST.ordinal()) != 0) {
            tSide5 = 1.0f;
        }
        return AxisAlignedBB.func_72330_a((double)((float)aX + tSide4), (double)((float)aY + tSide0), (double)((float)aZ + tSide2), (double)((float)aX + tSide5), (double)((float)aY + tSide1), (double)((float)aZ + tSide3));
    }

    @Override
    public void addCollisionBoxesToList(World aWorld, int aX, int aY, int aZ, AxisAlignedBB inputAABB, List<AxisAlignedBB> outputAABB, Entity collider) {
        AxisAlignedBB aabb;
        super.addCollisionBoxesToList(aWorld, aX, aY, aZ, inputAABB, outputAABB, collider);
        if (GT_Mod.instance.isClientSide() && (GT_Client.hideValue & 2) != 0 && inputAABB.func_72326_a(aabb = this.getActualCollisionBoundingBoxFromPool(aWorld, aX, aY, aZ))) {
            outputAABB.add(aabb);
        }
    }

    @Override
    public FluidStack drain(ForgeDirection aSide, FluidStack aFluid, boolean doDrain) {
        if (aFluid == null) {
            return null;
        }
        for (int i = 0; i < this.mFluids.length; ++i) {
            FluidStack f = this.mFluids[i];
            if (f == null || !f.isFluidEqual(aFluid)) continue;
            return this.drainFromIndex(aFluid.amount, doDrain, i);
        }
        return null;
    }
}

