/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import gregtech.GT_Mod;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_Container_1by1;
import gregtech.api.gui.GT_Container_2by2;
import gregtech.api.gui.GT_Container_3by3;
import gregtech.api.gui.GT_Container_4by4;
import gregtech.api.gui.GT_GUIContainer_1by1;
import gregtech.api.gui.GT_GUIContainer_2by2;
import gregtech.api.gui.GT_GUIContainer_3by3;
import gregtech.api.gui.GT_GUIContainer_4by4;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_ClientPreference;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.extensions.ArrayExt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;

public class GT_MetaTileEntity_Hatch_InputBus
extends GT_MetaTileEntity_Hatch {
    public GT_Recipe.GT_Recipe_Map mRecipeMap = null;
    public boolean disableSort;
    public boolean disableFilter = false;
    public boolean disableLimited = true;

    public GT_MetaTileEntity_Hatch_InputBus(int id, String name, String nameRegional, int tier) {
        this(id, name, nameRegional, tier, GT_MetaTileEntity_Hatch_InputBus.getSlots(tier));
    }

    public GT_MetaTileEntity_Hatch_InputBus(int id, String name, String nameRegional, int tier, int slots) {
        super(id, name, nameRegional, tier, slots, ArrayExt.of("Item Input for Multiblocks", "Shift + right click with screwdriver to turn Sort mode on/off", "Capacity: " + slots + " stack" + (slots >= 2 ? "s" : "")), new ITexture[0]);
    }

    @Deprecated
    public GT_MetaTileEntity_Hatch_InputBus(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        this(aName, aTier, ArrayExt.of(aDescription), aTextures);
    }

    public GT_MetaTileEntity_Hatch_InputBus(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        this(aName, aTier, GT_MetaTileEntity_Hatch_InputBus.getSlots(aTier), aDescription, aTextures);
    }

    public GT_MetaTileEntity_Hatch_InputBus(String aName, int aTier, int aSlots, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aSlots, aDescription, aTextures);
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        ITexture[] iTextureArray;
        if (GT_Mod.gregtechproxy.mRenderIndicatorsOnHatch) {
            ITexture[] iTextureArray2 = new ITexture[3];
            iTextureArray2[0] = aBaseTexture;
            iTextureArray2[1] = TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_IN);
            iTextureArray = iTextureArray2;
            iTextureArray2[2] = TextureFactory.of(Textures.BlockIcons.ITEM_IN_SIGN);
        } else {
            ITexture[] iTextureArray3 = new ITexture[2];
            iTextureArray3[0] = aBaseTexture;
            iTextureArray = iTextureArray3;
            iTextureArray3[1] = TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_IN);
        }
        return iTextureArray;
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        ITexture[] iTextureArray;
        if (GT_Mod.gregtechproxy.mRenderIndicatorsOnHatch) {
            ITexture[] iTextureArray2 = new ITexture[3];
            iTextureArray2[0] = aBaseTexture;
            iTextureArray2[1] = TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_IN);
            iTextureArray = iTextureArray2;
            iTextureArray2[2] = TextureFactory.of(Textures.BlockIcons.ITEM_IN_SIGN);
        } else {
            ITexture[] iTextureArray3 = new ITexture[2];
            iTextureArray3[0] = aBaseTexture;
            iTextureArray = iTextureArray3;
            iTextureArray3[1] = TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_IN);
        }
        return iTextureArray;
    }

    @Override
    public boolean isSimpleMachine() {
        return true;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return true;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return true;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Hatch_InputBus(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        aBaseMetaTileEntity.openGUI(aPlayer);
        return true;
    }

    @Override
    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        switch (this.mTier) {
            case 0: {
                return new GT_Container_1by1(aPlayerInventory, aBaseMetaTileEntity);
            }
            case 1: {
                return new GT_Container_2by2(aPlayerInventory, aBaseMetaTileEntity);
            }
            case 2: {
                return new GT_Container_3by3(aPlayerInventory, aBaseMetaTileEntity);
            }
        }
        return new GT_Container_4by4(aPlayerInventory, aBaseMetaTileEntity);
    }

    @Override
    public void initDefaultModes(NBTTagCompound aNBT) {
        GT_ClientPreference tPreference;
        if (!this.getBaseMetaTileEntity().getWorld().field_72995_K && (tPreference = GT_Mod.gregtechproxy.getClientPreference(this.getBaseMetaTileEntity().getOwnerUuid())) != null) {
            this.disableFilter = !tPreference.isInputBusInitialFilterEnabled();
        }
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        switch (this.mInventory.length) {
            case 1: {
                return new GT_GUIContainer_1by1(aPlayerInventory, aBaseMetaTileEntity, "Input Bus");
            }
            case 4: {
                return new GT_GUIContainer_2by2(aPlayerInventory, aBaseMetaTileEntity, "Input Bus");
            }
            case 9: {
                return new GT_GUIContainer_3by3(aPlayerInventory, aBaseMetaTileEntity, "Input Bus");
            }
            case 16: {
                return new GT_GUIContainer_4by4(aPlayerInventory, aBaseMetaTileEntity, "Input Bus");
            }
        }
        return new GT_GUIContainer_4by4(aPlayerInventory, aBaseMetaTileEntity, "Input Bus");
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTimer) {
        if (aBaseMetaTileEntity.isServerSide() && aBaseMetaTileEntity.hasInventoryBeenModified()) {
            this.fillStacksIntoFirstSlots();
        }
    }

    public void updateSlots() {
        for (int i = 0; i < this.mInventory.length; ++i) {
            if (this.mInventory[i] == null || this.mInventory[i].field_77994_a > 0) continue;
            this.mInventory[i] = null;
        }
        this.fillStacksIntoFirstSlots();
    }

    protected void fillStacksIntoFirstSlots() {
        if (this.disableSort) {
            for (int i = 0; i < this.mInventory.length; ++i) {
                for (int j = i + 1; j < this.mInventory.length; ++j) {
                    if (this.mInventory[j] == null || this.mInventory[j].field_77994_a > 0 || this.mInventory[i] != null && !GT_Utility.areStacksEqual(this.mInventory[i], this.mInventory[j])) continue;
                    GT_Utility.moveStackFromSlotAToSlotB((IInventory)this.getBaseMetaTileEntity(), (IInventory)this.getBaseMetaTileEntity(), j, i, (byte)64, (byte)1, (byte)64, (byte)1);
                }
            }
        } else {
            for (int i = 0; i < this.mInventory.length; ++i) {
                for (int j = i + 1; j < this.mInventory.length; ++j) {
                    if (this.mInventory[j] == null || this.mInventory[i] != null && !GT_Utility.areStacksEqual(this.mInventory[i], this.mInventory[j])) continue;
                    GT_Utility.moveStackFromSlotAToSlotB((IInventory)this.getBaseMetaTileEntity(), (IInventory)this.getBaseMetaTileEntity(), j, i, (byte)64, (byte)1, (byte)64, (byte)1);
                }
            }
        }
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("disableSort", this.disableSort);
        aNBT.func_74757_a("disableFilter", this.disableFilter);
        aNBT.func_74757_a("disableLimited", this.disableLimited);
        if (this.mRecipeMap != null) {
            aNBT.func_74778_a("recipeMap", this.mRecipeMap.mUniqueIdentifier);
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.disableSort = aNBT.func_74767_n("disableSort");
        this.disableFilter = aNBT.func_74767_n("disableFilter");
        if (aNBT.func_74764_b("disableLimited")) {
            this.disableLimited = aNBT.func_74767_n("disableLimited");
        }
        this.mRecipeMap = GT_Recipe.GT_Recipe_Map.sIndexedMappings.getOrDefault(aNBT.func_74779_i("recipeMap"), null);
    }

    @Override
    public void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (!this.getBaseMetaTileEntity().getCoverBehaviorAtSideNew(aSide).isGUIClickable(aSide, this.getBaseMetaTileEntity().getCoverIDAtSide(aSide), this.getBaseMetaTileEntity().getComplexCoverDataAtSide(aSide), this.getBaseMetaTileEntity())) {
            return;
        }
        if (aPlayer.func_70093_af()) {
            if (this.disableSort) {
                this.disableSort = false;
            } else if (this.disableLimited) {
                this.disableLimited = false;
            } else {
                this.disableSort = true;
                this.disableLimited = true;
            }
            GT_Utility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)("GT5U.hatch.disableSort." + this.disableSort)) + "   " + StatCollector.func_74838_a((String)("GT5U.hatch.disableLimited." + this.disableLimited)));
        } else {
            this.disableFilter = !this.disableFilter;
            GT_Utility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)("GT5U.hatch.disableFilter." + this.disableFilter)));
        }
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return aSide == this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return !(aSide != this.getBaseMetaTileEntity().getFrontFacing() || this.mRecipeMap != null && !this.disableFilter && !this.mRecipeMap.containsInput(aStack) || !this.disableLimited && !this.limitedAllowPutStack(aIndex, aStack));
    }

    protected boolean limitedAllowPutStack(int aIndex, ItemStack aStack) {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (!GT_Utility.areStacksEqual(GT_OreDictUnificator.get_nocopy(aStack), this.mInventory[i])) continue;
            return i == aIndex;
        }
        return this.mInventory[aIndex] == null;
    }
}

