/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.util.AutoValue_GT_Single_Recipe_Check_ItemId;
import gregtech.api.util.GT_Recipe;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class GT_Single_Recipe_Check {
    protected final GT_MetaTileEntity_MultiBlockBase multiBlockBase;
    protected final GT_Recipe recipe;
    protected final ImmutableMap<ItemId, Integer> itemCost;
    protected final ImmutableMap<Fluid, Integer> fluidCost;
    protected final int totalItemCost;
    protected final int totalFluidCost;

    protected GT_Single_Recipe_Check(GT_MetaTileEntity_MultiBlockBase multiBlockBase, GT_Recipe recipe, ImmutableMap<ItemId, Integer> itemCost, ImmutableMap<Fluid, Integer> fluidCost) {
        this.multiBlockBase = multiBlockBase;
        this.recipe = recipe;
        this.itemCost = itemCost;
        this.fluidCost = fluidCost;
        this.totalItemCost = itemCost.values().stream().mapToInt(Integer::intValue).sum();
        this.totalFluidCost = fluidCost.values().stream().mapToInt(Integer::intValue).sum();
    }

    public GT_Recipe getRecipe() {
        return this.recipe;
    }

    public boolean checkRecipeInputsSingleStack(boolean consumeInputs) {
        HashMap<ItemId, ItemStack> itemMap = null;
        if (this.totalItemCost > 0) {
            itemMap = new HashMap<ItemId, ItemStack>();
            for (ItemStack itemStack : this.multiBlockBase.getStoredInputs()) {
                itemMap.merge(ItemId.createNoCopy(itemStack), itemStack, (a, b) -> a.field_77994_a >= b.field_77994_a ? a : b);
            }
            for (Map.Entry entry : this.itemCost.entrySet()) {
                ItemStack itemStack = (ItemStack)itemMap.get(entry.getKey());
                if (itemStack != null && itemStack.field_77994_a >= (Integer)entry.getValue()) continue;
                return false;
            }
        }
        HashMap<Fluid, FluidStack> fluidMap = null;
        if (this.totalFluidCost > 0) {
            fluidMap = new HashMap<Fluid, FluidStack>();
            for (FluidStack fluidStack : this.multiBlockBase.getStoredFluids()) {
                fluidMap.merge(fluidStack.getFluid(), fluidStack, (a, b) -> a.amount >= b.amount ? a : b);
            }
            for (Map.Entry entry : this.fluidCost.entrySet()) {
                FluidStack fluidStack = (FluidStack)fluidMap.get(entry.getKey());
                if (fluidStack != null && fluidStack.amount >= (Integer)entry.getValue()) continue;
                return false;
            }
        }
        if (consumeInputs) {
            if (this.totalItemCost > 0) {
                for (Map.Entry entry : this.itemCost.entrySet()) {
                    ((ItemStack)itemMap.get(entry.getKey())).field_77994_a -= ((Integer)entry.getValue()).intValue();
                }
            }
            if (this.totalFluidCost > 0) {
                for (Map.Entry entry : this.fluidCost.entrySet()) {
                    ((FluidStack)fluidMap.get(entry.getKey())).amount -= ((Integer)entry.getValue()).intValue();
                }
            }
        }
        return true;
    }

    public boolean checkRecipeInputs(boolean consumeInputs) {
        ArrayList<ItemStack> items = null;
        if (this.totalItemCost > 0) {
            items = this.multiBlockBase.getStoredInputs();
            HashMap<ItemId, Integer> itemMap = new HashMap<ItemId, Integer>();
            for (ItemStack itemStack : items) {
                itemMap.merge(ItemId.createNoCopy(itemStack), itemStack.field_77994_a, Integer::sum);
            }
            for (Object entry : this.itemCost.entrySet()) {
                if (itemMap.getOrDefault(entry.getKey(), 0) >= (Integer)entry.getValue()) continue;
                return false;
            }
        }
        ArrayList<FluidStack> fluids = null;
        if (this.totalFluidCost > 0) {
            fluids = this.multiBlockBase.getStoredFluids();
            HashMap<Fluid, Integer> fluidMap = new HashMap<Fluid, Integer>();
            for (FluidStack fluidStack : fluids) {
                fluidMap.merge(fluidStack.getFluid(), fluidStack.amount, Integer::sum);
            }
            for (Map.Entry entry : this.fluidCost.entrySet()) {
                if (fluidMap.getOrDefault(entry.getKey(), 0) >= (Integer)entry.getValue()) continue;
                return false;
            }
        }
        if (consumeInputs) {
            int paid;
            int runningCost;
            ItemId key;
            if (this.totalItemCost > 0) {
                int remainingItemCost = this.totalItemCost;
                HashMap runningItemCost = Maps.newHashMap(this.itemCost);
                for (ItemStack itemStack : items) {
                    key = ItemId.createNoCopy(itemStack);
                    runningCost = runningItemCost.getOrDefault(key, 0);
                    paid = Math.min(itemStack.field_77994_a, runningCost);
                    itemStack.field_77994_a -= paid;
                    runningItemCost.put(key, runningCost - paid);
                    if ((remainingItemCost -= paid) > 0) continue;
                    break;
                }
            }
            if (this.totalFluidCost > 0) {
                int remainingFluidCost = this.totalFluidCost;
                HashMap runningFluidCost = Maps.newHashMap(this.fluidCost);
                for (FluidStack fluidStack : fluids) {
                    key = fluidStack.getFluid();
                    runningCost = runningFluidCost.getOrDefault(key, 0);
                    paid = Math.min(fluidStack.amount, runningCost);
                    fluidStack.amount -= paid;
                    runningFluidCost.put(key, runningCost - paid);
                    if ((remainingFluidCost -= paid) > 0) continue;
                    break;
                }
            }
        }
        return true;
    }

    protected static Map<ItemId, Integer> buildItemMap(GT_MetaTileEntity_MultiBlockBase multiBlockBase) {
        HashMap<ItemId, Integer> itemMap = new HashMap<ItemId, Integer>();
        for (ItemStack itemStack : multiBlockBase.getStoredInputs()) {
            itemMap.merge(ItemId.create(itemStack), itemStack.field_77994_a, Integer::sum);
        }
        return itemMap;
    }

    protected static Map<Fluid, Integer> buildFluidMap(GT_MetaTileEntity_MultiBlockBase multiBlockBase) {
        HashMap<Fluid, Integer> fluidMap = new HashMap<Fluid, Integer>();
        for (FluidStack fluidStack : multiBlockBase.getStoredFluids()) {
            fluidMap.merge(fluidStack.getFluid(), fluidStack.amount, Integer::sum);
        }
        return fluidMap;
    }

    public static Builder builder(GT_MetaTileEntity_MultiBlockBase multiBlockBase) {
        return new Builder(multiBlockBase);
    }

    @AutoValue
    protected static abstract class ItemId {
        protected ItemId() {
        }

        protected static ItemId create(ItemStack itemStack) {
            NBTTagCompound nbt = itemStack.func_77978_p();
            if (nbt != null) {
                nbt = (NBTTagCompound)nbt.func_74737_b();
            }
            return new AutoValue_GT_Single_Recipe_Check_ItemId(itemStack.func_77973_b(), itemStack.func_77960_j(), nbt);
        }

        protected static ItemId createNoCopy(ItemStack itemStack) {
            return new AutoValue_GT_Single_Recipe_Check_ItemId(itemStack.func_77973_b(), itemStack.func_77960_j(), itemStack.func_77978_p());
        }

        protected abstract Item item();

        protected abstract int metaData();

        @Nullable
        protected abstract NBTTagCompound nbt();
    }

    public static final class Builder {
        private final GT_MetaTileEntity_MultiBlockBase multiBlockBase;
        private Map<ItemId, Integer> beforeItems;
        private Map<Fluid, Integer> beforeFluids;
        private Map<ItemId, Integer> afterItems;
        private Map<Fluid, Integer> afterFluids;
        private GT_Recipe recipe;

        private Builder(GT_MetaTileEntity_MultiBlockBase multiBlockBase) {
            this.multiBlockBase = multiBlockBase;
        }

        public Builder setBefore() {
            this.beforeItems = GT_Single_Recipe_Check.buildItemMap(this.multiBlockBase);
            this.beforeFluids = GT_Single_Recipe_Check.buildFluidMap(this.multiBlockBase);
            return this;
        }

        public Builder setAfter() {
            this.afterItems = GT_Single_Recipe_Check.buildItemMap(this.multiBlockBase);
            this.afterFluids = GT_Single_Recipe_Check.buildFluidMap(this.multiBlockBase);
            return this;
        }

        public Builder setRecipe(GT_Recipe recipe) {
            this.recipe = recipe;
            return this;
        }

        public GT_Single_Recipe_Check build() {
            ImmutableMap.Builder itemCostBuilder = ImmutableMap.builder();
            for (Map.Entry<ItemId, Integer> entry : this.beforeItems.entrySet()) {
                int cost = entry.getValue() - this.afterItems.getOrDefault(entry.getKey(), 0);
                if (cost <= 0) continue;
                itemCostBuilder.put((Object)entry.getKey(), (Object)cost);
            }
            ImmutableMap.Builder fluidCostBuilder = ImmutableMap.builder();
            for (Map.Entry<Fluid, Integer> entry : this.beforeFluids.entrySet()) {
                int cost = entry.getValue() - this.afterFluids.getOrDefault(entry.getKey(), 0);
                if (cost <= 0) continue;
                fluidCostBuilder.put((Object)entry.getKey(), (Object)cost);
            }
            return new GT_Single_Recipe_Check(this.multiBlockBase, this.recipe, (ImmutableMap<ItemId, Integer>)itemCostBuilder.build(), (ImmutableMap<Fluid, Integer>)fluidCostBuilder.build());
        }
    }
}

