/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import gregtech.api.enums.GT_Values;
import gregtech.api.gui.GT_GUICover;
import gregtech.api.gui.widgets.GT_GuiIcon;
import gregtech.api.gui.widgets.GT_GuiIconButton;
import gregtech.api.gui.widgets.GT_GuiIconCheckButton;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IMachineProgress;
import gregtech.api.net.GT_Packet_TileEntityCover;
import gregtech.api.util.GT_CoverBehavior;
import gregtech.api.util.GT_Utility;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fluids.Fluid;

public class GT_Cover_DoesWork
extends GT_CoverBehavior {
    @Override
    public boolean isRedstoneSensitive(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity, long aTimer) {
        return false;
    }

    @Override
    public int doCoverThings(byte aSide, byte aInputRedstone, int aCoverID, int aCoverVariable, ICoverable aTileEntity, long aTimer) {
        if (aTileEntity instanceof IMachineProgress) {
            if (aCoverVariable < 2) {
                int tScale = ((IMachineProgress)((Object)aTileEntity)).getMaxProgress() / 15;
                if (tScale > 0 && ((IMachineProgress)((Object)aTileEntity)).hasThingsToDo()) {
                    aTileEntity.setOutputRedstoneSignal(aSide, aCoverVariable % 2 == 0 ? (byte)(((IMachineProgress)((Object)aTileEntity)).getProgress() / tScale) : (byte)(15 - ((IMachineProgress)((Object)aTileEntity)).getProgress() / tScale));
                } else {
                    aTileEntity.setOutputRedstoneSignal(aSide, (byte)(aCoverVariable % 2 == 0 ? 0 : 15));
                }
            } else {
                aTileEntity.setOutputRedstoneSignal(aSide, (byte)(aCoverVariable % 2 == 0 != (((IMachineProgress)((Object)aTileEntity)).getMaxProgress() == 0) ? 0 : 15));
            }
        } else {
            aTileEntity.setOutputRedstoneSignal(aSide, (byte)0);
        }
        return aCoverVariable;
    }

    @Override
    public int onCoverScrewdriverclick(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if ((aCoverVariable = (aCoverVariable + (aPlayer.func_70093_af() ? -1 : 1)) % 4) < 0) {
            aCoverVariable = 3;
        }
        switch (aCoverVariable) {
            case 0: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("018", "Normal"));
                break;
            }
            case 1: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("019", "Inverted"));
                break;
            }
            case 2: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("020", "Ready to work"));
                break;
            }
            case 3: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("021", "Not ready to work"));
            }
        }
        return aCoverVariable;
    }

    @Override
    public boolean letsEnergyIn(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsEnergyOut(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsFluidIn(byte aSide, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsFluidOut(byte aSide, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsIn(byte aSide, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsOut(byte aSide, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean manipulatesSidedRedstoneOutput(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public int getTickRate(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return 5;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public Object getClientGUI(byte aSide, int aCoverID, int coverData, ICoverable aTileEntity) {
        return new GUI(aSide, aCoverID, coverData, aTileEntity);
    }

    private class GUI
    extends GT_GUICover {
        private final byte side;
        private final int coverID;
        private int coverVariable;
        private static final int startX = 10;
        private static final int startY = 25;
        private static final int spaceX = 18;
        private static final int spaceY = 18;

        public GUI(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
            super(aTileEntity, 176, 107, GT_Utility.intToStack(aCoverID));
            this.side = aSide;
            this.coverID = aCoverID;
            this.coverVariable = aCoverVariable;
            GT_GuiIconButton b = new GT_GuiIconButton(this, 0, 10, 25, GT_GuiIcon.PROGRESS);
            b = new GT_GuiIconButton(this, 1, 28, 25, GT_GuiIcon.CHECKMARK);
            b = new GT_GuiIconCheckButton(this, 2, 10, 43, GT_GuiIcon.REDSTONE_ON, GT_GuiIcon.REDSTONE_OFF);
        }

        @Override
        public void drawExtras(int mouseX, int mouseY, float parTicks) {
            super.drawExtras(mouseX, mouseY, parTicks);
            String s1 = (this.coverVariable & 2) > 0 ? GT_Utility.trans("242", "Machine idle") : GT_Utility.trans("241", "Recipe progress");
            String s2 = (this.coverVariable & 1) > 0 ? GT_Utility.trans("INVERTED", "Inverted") : GT_Utility.trans("NORMAL", "Normal");
            this.field_146289_q.func_78276_b(s1, 64, 29, -11184811);
            this.field_146289_q.func_78276_b(s2, 64, 47, -11184811);
        }

        @Override
        protected void onInitGui(int guiLeft, int guiTop, int gui_width, int gui_height) {
            this.updateButtons();
        }

        @Override
        public void buttonClicked(GuiButton btn) {
            if (this.getClickable(btn.field_146127_k)) {
                boolean state = false;
                if (btn.field_146127_k == 2) {
                    state = ((GT_GuiIconCheckButton)btn).isChecked();
                }
                this.coverVariable = this.getNewCoverVariable(btn.field_146127_k, state);
                GT_Values.NW.sendToServer(new GT_Packet_TileEntityCover(this.side, this.coverID, this.coverVariable, this.tile));
            }
            this.updateButtons();
        }

        private void updateButtons() {
            for (Object o : this.field_146292_n) {
                GuiButton b = (GuiButton)o;
                if (b.field_146127_k == 2) {
                    ((GT_GuiIconCheckButton)b).setChecked((this.coverVariable & 1) > 0);
                    continue;
                }
                b.field_146124_l = this.getClickable(b.field_146127_k);
            }
        }

        private int getNewCoverVariable(int id, boolean buttonState) {
            switch (id) {
                case 0: {
                    return this.coverVariable & 0xFFFFFFFD;
                }
                case 1: {
                    return this.coverVariable | 2;
                }
                case 2: {
                    if (buttonState) {
                        return this.coverVariable & 0xFFFFFFFE;
                    }
                    return this.coverVariable | 1;
                }
            }
            return this.coverVariable;
        }

        private boolean getClickable(int id) {
            switch (id) {
                case 0: {
                    return (this.coverVariable & 2) > 0;
                }
                case 1: {
                    return (this.coverVariable & 2) == 0;
                }
                case 2: {
                    return true;
                }
            }
            return false;
        }
    }
}

