/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.boilers;

import gregtech.GT_Mod;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.common.gui.GT_Container_Boiler;
import gregtech.common.gui.GT_GUIContainer_Boiler;
import gregtech.common.tileentities.boilers.GT_MetaTileEntity_Boiler;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_Boiler_Lava
extends GT_MetaTileEntity_Boiler {
    public static final int COOLDOWN_INTERVAL = 20;
    public static final int ENERGY_PER_LAVA = 1;
    public static final int CONSUMPTION_PER_HEATUP = 3;
    public static final int PRODUCTION_PER_SECOND = 600;

    public GT_MetaTileEntity_Boiler_Lava(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, new String[]{"A Boiler running off Lava", "Produces 600L of Steam per second", "Causes " + Integer.toString(GT_Mod.gregtechproxy.mPollutionHighPressureLavaBoilerPerSecond) + " Pollution per second", "Consumes 3.0L of Lava every 20 ticks when fully heat up"}, new ITexture[0]);
    }

    public GT_MetaTileEntity_Boiler_Lava(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
    }

    public GT_MetaTileEntity_Boiler_Lava(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[5][17][];
        ITexture[] texBottom = new ITexture[]{TextureFactory.of(Textures.BlockIcons.MACHINE_STEELBRICKS_BOTTOM)};
        ITexture[] texTop = new ITexture[]{TextureFactory.of(Textures.BlockIcons.MACHINE_STEELBRICKS_TOP), TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE)};
        ITexture[] texSide = new ITexture[]{TextureFactory.of(Textures.BlockIcons.MACHINE_STEELBRICKS_SIDE), TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE)};
        ITexture[] texFront = new ITexture[]{TextureFactory.of(Textures.BlockIcons.MACHINE_STEELBRICKS_SIDE), TextureFactory.of(Textures.BlockIcons.BOILER_LAVA_FRONT), TextureFactory.of(Textures.BlockIcons.BOILER_LAVA_FRONT_GLOW)};
        ITexture[] texFrontActive = new ITexture[]{TextureFactory.of(Textures.BlockIcons.MACHINE_STEELBRICKS_SIDE), TextureFactory.of(Textures.BlockIcons.BOILER_LAVA_FRONT_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.BOILER_LAVA_FRONT_ACTIVE_GLOW).glow().build()};
        for (int i = 0; i < 17; i = (int)((byte)(i + 1))) {
            rTextures[0][i] = texBottom;
            rTextures[1][i] = texTop;
            rTextures[2][i] = texSide;
            rTextures[3][i] = texFront;
            rTextures[4][i] = texFrontActive;
        }
        return rTextures;
    }

    @Override
    public int maxProgresstime() {
        return 1000;
    }

    @Override
    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_Container_Boiler(aPlayerInventory, aBaseMetaTileEntity);
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_Boiler(aPlayerInventory, aBaseMetaTileEntity, "SteelBoiler.png");
    }

    @Override
    public int getCapacity() {
        return 32000;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Boiler_Lava(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    protected int getPollution() {
        return GT_Mod.gregtechproxy.mPollutionHighPressureLavaBoilerPerSecond;
    }

    @Override
    protected int getProductionPerSecond() {
        return 600;
    }

    @Override
    protected int getMaxTemperature() {
        return 1000;
    }

    @Override
    protected int getEnergyConsumption() {
        return 3;
    }

    @Override
    protected int getCooldownInterval() {
        return 20;
    }

    @Override
    protected void updateFuel(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (GT_OreDictUnificator.isItemStackInstanceOf(this.mInventory[2], OrePrefixes.bucket.get(Materials.Lava))) {
            this.mProcessingEnergy += 1000;
            aBaseMetaTileEntity.func_70298_a(2, 1);
            aBaseMetaTileEntity.addStackToSlot(3, GT_OreDictUnificator.get(OrePrefixes.bucket, Materials.Empty, 1L));
        } else if (GT_OreDictUnificator.isItemStackInstanceOf(this.mInventory[2], OrePrefixes.bucketClay.get(Materials.Lava))) {
            this.mProcessingEnergy += 1000;
            aBaseMetaTileEntity.func_70298_a(2, 1);
        }
    }

    @Override
    public final int fill(FluidStack aFluid, boolean doFill) {
        if (GT_ModHandler.isLava(aFluid) && this.mProcessingEnergy < 50) {
            int tFilledAmount = Math.min(50, aFluid.amount);
            if (doFill) {
                this.mProcessingEnergy += tFilledAmount * 1;
            }
            return tFilledAmount;
        }
        return super.fill(aFluid, doFill);
    }
}

