/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTech_API;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IChunkLoader;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_EnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_DataAccess;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.objects.GT_ChunkManager;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class GT_MetaTileEntity_DrillerBase
extends GT_MetaTileEntity_EnhancedMultiBlockBase<GT_MetaTileEntity_DrillerBase>
implements IChunkLoader {
    private static final ItemStack miningPipe = GT_ModHandler.getIC2Item("miningPipe", 0L);
    private static final ItemStack miningPipeTip = GT_ModHandler.getIC2Item("miningPipeTip", 0L);
    private static final Block miningPipeBlock = GT_Utility.getBlockFromStack(miningPipe);
    private static final Block miningPipeTipBlock = GT_Utility.getBlockFromStack(miningPipeTip);
    protected static final String STRUCTURE_PIECE_MAIN = "main";
    protected static final ClassValue<IStructureDefinition<GT_MetaTileEntity_DrillerBase>> STRUCTURE_DEFINITION = new ClassValue<IStructureDefinition<GT_MetaTileEntity_DrillerBase>>(){

        @Override
        protected IStructureDefinition<GT_MetaTileEntity_DrillerBase> computeValue(Class<?> type) {
            return StructureDefinition.builder().addShape(GT_MetaTileEntity_DrillerBase.STRUCTURE_PIECE_MAIN, StructureUtility.transpose((String[][])new String[][]{{"   ", " f ", "   "}, {"   ", " f ", "   "}, {"   ", " f ", "   "}, {" f ", "fcf", " f "}, {" f ", "fcf", " f "}, {" f ", "fcf", " f "}, {"b~b", "bbb", "bbb"}})).addElement(Character.valueOf('f'), (IStructureElement)StructureUtility.lazy(t -> GT_StructureUtility.ofFrame(t.getFrameMaterial()))).addElement(Character.valueOf('c'), (IStructureElement)StructureUtility.lazy(t -> StructureUtility.ofBlock((Block)t.getCasingBlockItem().getBlock(), (int)t.getCasingBlockItem().get(0L, new Object[0]).func_77960_j()))).addElement(Character.valueOf('b'), (IStructureElement)StructureUtility.lazy(t -> StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.ofBlock((Block)t.getCasingBlockItem().getBlock(), (int)t.getCasingBlockItem().get(0L, new Object[0]).func_77960_j()), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addMaintenanceToMachineList, t.casingTextureIndex, 1), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addInputToMachineList, t.casingTextureIndex, 1), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addOutputToMachineList, t.casingTextureIndex, 1), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addEnergyInputToMachineList, t.casingTextureIndex, 1), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_DrillerBase::addDataAccessToMachineList, t.casingTextureIndex, 1)}))).build();
        }
    };
    private Block casingBlock;
    private int casingMeta;
    private int frameMeta;
    protected int casingTextureIndex;
    protected boolean isPickingPipes;
    private ForgeDirection back;
    private int xDrill;
    private int yDrill;
    private int zDrill;
    private int xPipe;
    private int zPipe;
    private int yHead;
    protected int workState;
    protected static final int STATE_DOWNWARD = 0;
    protected static final int STATE_AT_BOTTOM = 1;
    protected static final int STATE_UPWARD = 2;
    protected boolean mChunkLoadingEnabled = true;
    protected ChunkCoordIntPair mCurrentChunk = null;
    protected boolean mWorkChunkNeedsReload = true;
    private FakePlayer mFakePlayer = null;
    public ArrayList<GT_MetaTileEntity_Hatch_DataAccess> mDataAccessHatches = new ArrayList();

    protected int getXDrill() {
        return this.xDrill;
    }

    protected int getZDrill() {
        return this.zDrill;
    }

    public GT_MetaTileEntity_DrillerBase(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
        this.initFields();
    }

    public GT_MetaTileEntity_DrillerBase(String aName) {
        super(aName);
        this.initFields();
    }

    private void initFields() {
        this.casingBlock = this.getCasingBlockItem().getBlock();
        this.casingMeta = this.getCasingBlockItem().get(0L, new Object[0]).func_77960_j();
        int frameId = 4096 + this.getFrameMaterial().mMetaItemSubID;
        this.frameMeta = GregTech_API.METATILEENTITIES[frameId] != null ? (int)GregTech_API.METATILEENTITIES[frameId].getTileEntityBaseType() : Short.MAX_VALUE;
        this.casingTextureIndex = this.getCasingTextureIndex();
        this.workState = 0;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(this.casingTextureIndex), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_ORE_DRILL_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_ORE_DRILL_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(this.casingTextureIndex), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_ORE_DRILL).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_ORE_DRILL_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(this.casingTextureIndex)};
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("workState", this.workState);
        aNBT.func_74757_a("chunkLoadingEnabled", this.mChunkLoadingEnabled);
        aNBT.func_74757_a("isChunkloading", this.mCurrentChunk != null);
        if (this.mCurrentChunk != null) {
            aNBT.func_74768_a("loadedChunkXPos", this.mCurrentChunk.field_77276_a);
            aNBT.func_74768_a("loadedChunkZPos", this.mCurrentChunk.field_77275_b);
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.workState = aNBT.func_74762_e("workState");
        if (aNBT.func_74764_b("isPickingPipes")) {
            int n = this.workState = aNBT.func_74767_n("isPickingPipes") ? 2 : 0;
        }
        if (aNBT.func_74764_b("chunkLoadingEnabled")) {
            this.mChunkLoadingEnabled = aNBT.func_74767_n("chunkLoadingEnabled");
        }
        if (aNBT.func_74767_n("isChunkloading")) {
            this.mCurrentChunk = new ChunkCoordIntPair(aNBT.func_74762_e("loadedChunkXPos"), aNBT.func_74762_e("loadedChunkZPos"));
        }
    }

    @Override
    public boolean onSolderingToolRightClick(byte aSide, byte aWrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aSide == this.getBaseMetaTileEntity().getFrontFacing()) {
            this.mChunkLoadingEnabled = !this.mChunkLoadingEnabled;
            GT_Utility.sendChatToPlayer(aPlayer, this.mChunkLoadingEnabled ? GT_Utility.trans("502", "Mining chunk loading enabled") : GT_Utility.trans("503", "Mining chunk loading disabled"));
            return true;
        }
        return super.onSolderingToolRightClick(aSide, aWrenchingSide, aPlayer, aX, aY, aZ);
    }

    @Override
    public void onRemoval() {
        if (this.mChunkLoadingEnabled) {
            GT_ChunkManager.releaseTicket((TileEntity)this.getBaseMetaTileEntity());
        }
        super.onRemoval();
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide() && this.mCurrentChunk != null && !this.mWorkChunkNeedsReload && !aBaseMetaTileEntity.isAllowedToWork()) {
            GT_ChunkManager.releaseTicket((TileEntity)aBaseMetaTileEntity);
            this.mWorkChunkNeedsReload = true;
        }
    }

    protected boolean tryPickPipe() {
        if (this.yHead == this.yDrill) {
            this.isPickingPipes = false;
            return false;
        }
        if (this.tryOutputPipe()) {
            if (this.checkBlockAndMeta(this.xPipe, this.yHead + 1, this.zPipe, miningPipeBlock, Short.MAX_VALUE)) {
                this.getBaseMetaTileEntity().getWorld().func_147449_b(this.xPipe, this.yHead + 1, this.zPipe, miningPipeTipBlock);
            }
            this.getBaseMetaTileEntity().getWorld().func_147468_f(this.xPipe, this.yHead, this.zPipe);
            this.isPickingPipes = true;
            return true;
        }
        this.isPickingPipes = false;
        return false;
    }

    @Deprecated
    protected boolean tryLowerPipe() {
        return this.tryLowerPipeState(false) == 0;
    }

    protected int tryLowerPipeState() {
        return this.tryLowerPipeState(false);
    }

    protected int tryLowerPipeState(boolean isSimulating) {
        if (!this.isHasMiningPipes()) {
            return 2;
        }
        switch (this.canLowerPipe()) {
            case 1: {
                return 1;
            }
            case 2: {
                return 3;
            }
        }
        Block b = this.getBaseMetaTileEntity().getBlock(this.xPipe, this.yHead - 1, this.zPipe);
        if (b != miningPipeTipBlock && !GT_Utility.setBlockByFakePlayer(this.getFakePlayer(this.getBaseMetaTileEntity()), this.xPipe, this.yHead - 1, this.zPipe, miningPipeTipBlock, 0, isSimulating)) {
            return 3;
        }
        if (!isSimulating) {
            if (this.yHead != this.yDrill) {
                this.getBaseMetaTileEntity().getWorld().func_147449_b(this.xPipe, this.yHead, this.zPipe, miningPipeBlock);
            }
            if (b != miningPipeBlock && b != miningPipeTipBlock) {
                this.getBaseMetaTileEntity().func_70298_a(1, 1);
            }
        }
        return 0;
    }

    private void putMiningPipesFromInputsInController() {
        int maxPipes = miningPipe.func_77976_d();
        if (this.isHasMiningPipes(maxPipes)) {
            return;
        }
        ItemStack pipes = this.func_70301_a(1);
        if (pipes != null && !pipes.func_77969_a(miningPipe)) {
            return;
        }
        for (ItemStack storedItem : this.getStoredInputs()) {
            if (!storedItem.func_77969_a(miningPipe)) continue;
            if (pipes == null) {
                this.func_70299_a(1, GT_Utility.copyOrNull(miningPipe));
                pipes = this.func_70301_a(1);
            }
            if (pipes.field_77994_a == maxPipes) break;
            int needPipes = maxPipes - pipes.field_77994_a;
            int transferPipes = Math.min(storedItem.field_77994_a, needPipes);
            pipes.field_77994_a += transferPipes;
            storedItem.field_77994_a -= transferPipes;
        }
        this.updateSlots();
    }

    private boolean tryOutputPipe() {
        if (!this.getBaseMetaTileEntity().addStackToSlot(1, GT_Utility.copyAmount(1L, miningPipe))) {
            this.mOutputItems = new ItemStack[]{GT_Utility.copyAmount(1L, miningPipe)};
        }
        return true;
    }

    protected int canLowerPipe() {
        IGregTechTileEntity aBaseTile = this.getBaseMetaTileEntity();
        if (this.yHead > 0 && GT_Utility.getBlockHardnessAt(aBaseTile.getWorld(), this.xPipe, this.yHead - 1, this.zPipe) >= 0.0f) {
            return GT_Utility.eraseBlockByFakePlayer(this.getFakePlayer(aBaseTile), this.xPipe, this.yHead - 1, this.zPipe, true) ? 0 : 2;
        }
        return 1;
    }

    protected boolean reachingVoidOrBedrock() {
        return this.yHead <= 0 || this.checkBlockAndMeta(this.xPipe, this.yHead - 1, this.zPipe, Blocks.field_150357_h, Short.MAX_VALUE);
    }

    private boolean isHasMiningPipes() {
        return this.isHasMiningPipes(1);
    }

    private boolean isHasMiningPipes(int minCount) {
        ItemStack pipe = this.func_70301_a(1);
        return pipe != null && pipe.field_77994_a > minCount - 1 && pipe.func_77969_a(miningPipe);
    }

    @Deprecated
    protected boolean waitForPipes() {
        return !this.isHasMiningPipes();
    }

    private boolean isEnergyEnough() {
        long requiredEnergy = 512L + this.getMaxInputVoltage() * 4L;
        for (GT_MetaTileEntity_Hatch_Energy energyHatch : this.mEnergyHatches) {
            if ((requiredEnergy -= energyHatch.getEUVar()) > 0L) continue;
            return true;
        }
        return false;
    }

    protected boolean workingDownward(ItemStack aStack, int xDrill, int yDrill, int zDrill, int xPipe, int zPipe, int yHead, int oldYHead) {
        switch (this.tryLowerPipeState()) {
            case 2: {
                this.mMaxProgresstime = 0;
                return false;
            }
            case 3: {
                this.workState = 2;
                return true;
            }
            case 1: {
                this.workState = 1;
                return true;
            }
        }
        return true;
    }

    protected boolean workingAtBottom(ItemStack aStack, int xDrill, int yDrill, int zDrill, int xPipe, int zPipe, int yHead, int oldYHead) {
        switch (this.tryLowerPipeState(true)) {
            case 0: {
                this.workState = 0;
                return true;
            }
        }
        this.workState = 2;
        return true;
    }

    protected boolean workingUpward(ItemStack aStack, int xDrill, int yDrill, int zDrill, int xPipe, int zPipe, int yHead, int oldYHead) {
        if (this.tryPickPipe()) {
            return true;
        }
        this.workState = 0;
        this.stopMachine();
        return false;
    }

    @Override
    public boolean checkRecipe(ItemStack aStack) {
        this.setElectricityStats();
        int oldYHead = this.yHead;
        if (!this.checkPipesAndSetYHead() || !this.isEnergyEnough()) {
            this.stopMachine();
            return false;
        }
        this.putMiningPipesFromInputsInController();
        switch (this.workState) {
            case 0: {
                return this.workingDownward(aStack, this.xDrill, this.yDrill, this.zDrill, this.xPipe, this.zPipe, this.yHead, oldYHead);
            }
            case 1: {
                return this.workingAtBottom(aStack, this.xDrill, this.yDrill, this.zDrill, this.xPipe, this.zPipe, this.yHead, oldYHead);
            }
            case 2: {
                return this.workingUpward(aStack, this.xDrill, this.yDrill, this.zDrill, this.xPipe, this.zPipe, this.yHead, oldYHead);
            }
        }
        return false;
    }

    @Override
    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> d.offsetY == 0 && r.isNotRotated() && !f.isVerticallyFliped();
    }

    @Override
    public final IStructureDefinition<GT_MetaTileEntity_DrillerBase> getStructureDefinition() {
        return STRUCTURE_DEFINITION.get(this.getClass());
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.updateCoordinates();
        return this.checkPiece(STRUCTURE_PIECE_MAIN, 1, 6, 0) && this.checkHatches() && GT_Utility.getTier(this.getMaxInputVoltage()) >= this.getMinTier() && this.mMaintenanceHatches.size() == 1;
    }

    private void updateCoordinates() {
        this.xDrill = this.getBaseMetaTileEntity().getXCoord();
        this.yDrill = this.getBaseMetaTileEntity().getYCoord();
        this.zDrill = this.getBaseMetaTileEntity().getZCoord();
        this.back = ForgeDirection.getOrientation((int)this.getBaseMetaTileEntity().getBackFacing());
        this.xPipe = this.xDrill + this.back.offsetX;
        this.zPipe = this.zDrill + this.back.offsetZ;
    }

    private boolean checkPipesAndSetYHead() {
        this.yHead = this.yDrill - 1;
        while (this.checkBlockAndMeta(this.xPipe, this.yHead, this.zPipe, miningPipeBlock, Short.MAX_VALUE)) {
            --this.yHead;
        }
        if (this.checkBlockAndMeta(this.xPipe, this.yHead, this.zPipe, miningPipeTipBlock, Short.MAX_VALUE) || ++this.yHead == this.yDrill) {
            return true;
        }
        this.getBaseMetaTileEntity().getWorld().func_147449_b(this.xPipe, this.yHead, this.zPipe, miningPipeTipBlock);
        return true;
    }

    @Deprecated
    protected boolean checkCasingBlock(int xOff, int yOff, int zOff) {
        return this.checkBlockAndMetaOffset(xOff, yOff, zOff, this.casingBlock, this.casingMeta);
    }

    @Deprecated
    protected boolean checkFrameBlock(int xOff, int yOff, int zOff) {
        return this.checkBlockAndMetaOffset(xOff, yOff, zOff, GregTech_API.sBlockMachines, this.frameMeta);
    }

    @Deprecated
    protected boolean checkBlockAndMetaOffset(int xOff, int yOff, int zOff, Block block, int meta) {
        return this.checkBlockAndMeta(this.xDrill + xOff, this.yDrill + yOff, this.zDrill + zOff, block, meta);
    }

    private boolean checkBlockAndMeta(int x, int y, int z, Block block, int meta) {
        return (meta == Short.MAX_VALUE || this.getBaseMetaTileEntity().getMetaID(x, y, z) == meta) && this.getBaseMetaTileEntity().getBlock(x, y, z) == block;
    }

    protected FakePlayer getFakePlayer(IGregTechTileEntity aBaseTile) {
        if (this.mFakePlayer == null) {
            this.mFakePlayer = GT_Utility.getFakePlayer(aBaseTile);
        }
        this.mFakePlayer.func_70029_a(aBaseTile.getWorld());
        this.mFakePlayer.func_70107_b((double)aBaseTile.getXCoord(), (double)aBaseTile.getYCoord(), (double)aBaseTile.getZCoord());
        return this.mFakePlayer;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    protected abstract ItemList getCasingBlockItem();

    protected abstract Materials getFrameMaterial();

    protected abstract int getCasingTextureIndex();

    protected abstract int getMinTier();

    protected abstract boolean checkHatches();

    protected abstract void setElectricityStats();

    public int getTotalConfigValue() {
        int config = 0;
        ArrayList<ItemStack> tCircuitList = this.getDataItems(1);
        for (ItemStack tCircuit : tCircuitList) {
            config += tCircuit.func_77960_j();
        }
        return config;
    }

    private boolean isCorrectDataItem(ItemStack aStack, int state) {
        if ((state & 1) != 0 && ItemList.Circuit_Integrated.isStackEqual(aStack, true, true)) {
            return true;
        }
        if ((state & 2) != 0 && ItemList.Tool_DataStick.isStackEqual(aStack, false, true)) {
            return true;
        }
        return (state & 4) != 0 && ItemList.Tool_DataOrb.isStackEqual(aStack, false, true);
    }

    public ArrayList<ItemStack> getDataItems(int state) {
        ArrayList<ItemStack> rList = new ArrayList<ItemStack>();
        if (GT_Utility.isStackValid(this.mInventory[1]) && this.isCorrectDataItem(this.mInventory[1], state)) {
            rList.add(this.mInventory[1]);
        }
        for (GT_MetaTileEntity_Hatch_DataAccess tHatch : this.mDataAccessHatches) {
            if (!GT_MetaTileEntity_DrillerBase.isValidMetaTileEntity(tHatch)) continue;
            for (int i = 0; i < tHatch.getBaseMetaTileEntity().func_70302_i_(); ++i) {
                if (tHatch.getBaseMetaTileEntity().func_70301_a(i) == null || !this.isCorrectDataItem(tHatch.getBaseMetaTileEntity().func_70301_a(i), state)) continue;
                rList.add(tHatch.getBaseMetaTileEntity().func_70301_a(i));
            }
        }
        return rList;
    }

    public boolean addDataAccessToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_DataAccess) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture((byte)aBaseCasingIndex);
            return this.mDataAccessHatches.add((GT_MetaTileEntity_Hatch_DataAccess)aMetaTileEntity);
        }
        return false;
    }

    @Override
    public ChunkCoordIntPair getActiveChunk() {
        return this.mCurrentChunk;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 1, 6, 0);
    }
}

