/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_EnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Single_Recipe_Check;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_LargeChemicalReactor
extends GT_MetaTileEntity_EnhancedMultiBlockBase<GT_MetaTileEntity_LargeChemicalReactor> {
    private static final int CASING_INDEX = 176;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<GT_MetaTileEntity_LargeChemicalReactor> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"ccc", "cxc", "ccc"}, {"c~c", "xPx", "cxc"}, {"ccc", "cxc", "ccc"}})).addElement(Character.valueOf('P'), StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings8, (int)1)).addElement(Character.valueOf('c'), (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addInputToMachineList, 176, 1), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addOutputToMachineList, 176, 1), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addMaintenanceToMachineList, 176, 1), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addEnergyInputToMachineList, 176, 1), StructureUtility.onElementPass(GT_MetaTileEntity_LargeChemicalReactor::onCasingAdded, (IStructureElement)StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings8, (int)0))})).addElement(Character.valueOf('x'), (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addInputToMachineList, 176, 2), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addOutputToMachineList, 176, 2), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addMaintenanceToMachineList, 176, 2), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addEnergyInputToMachineList, 176, 2), StructureUtility.onElementPass(GT_MetaTileEntity_LargeChemicalReactor::onCoilAdded, (IStructureElement)StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings5, (int)0)), StructureUtility.onElementPass(GT_MetaTileEntity_LargeChemicalReactor::onCasingAdded, (IStructureElement)StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings8, (int)0))})).build();
    private int mCasingAmount;
    private int mCoilAmount;

    public GT_MetaTileEntity_LargeChemicalReactor(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_LargeChemicalReactor(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_LargeChemicalReactor(this.mName);
    }

    @Override
    public GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Chemical Reactor").addInfo("Controller block for the Large Chemical Reactor").addInfo("Does not lose efficiency when overclocked").addInfo("Accepts fluids instead of fluid cells").addSeparator().beginStructureBlock(3, 3, 3, false).addController("Front center").addCasingInfo("Chemically Inert Machine Casing", 8).addOtherStructurePart("PTFE Pipe Machine Casing", "Center").addOtherStructurePart("Cupronickel Coil Block", "Adjacent to the PTFE Pipe Machine Casing", 1).addEnergyHatch("Any casing", 1, 2).addMaintenanceHatch("Any casing", 1, 2).addInputBus("Any casing", 1, 2).addInputHatch("Any casing", 1, 2).addOutputBus("Any casing", 1, 2).addOutputHatch("Any casing", 1, 2).addStructureInfo("You can have multiple hatches/busses").toolTipFinisher("Gregtech");
        return tt;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[1][48], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[1][48], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[1][48]};
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "LargeChemicalReactor.png");
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public boolean supportsSingleRecipeLocking() {
        return true;
    }

    @Override
    public boolean checkRecipe(ItemStack aStack) {
        GT_Recipe tRecipe;
        long tVoltage = this.getMaxInputVoltage();
        byte tier = (byte)Math.max(1, GT_Utility.getTier(tVoltage));
        if (this.mLockedToSingleRecipe && this.mSingleRecipeCheck != null) {
            if (!this.mSingleRecipeCheck.checkRecipeInputsSingleStack(true)) {
                return false;
            }
            tRecipe = this.mSingleRecipeCheck.getRecipe();
        } else {
            ArrayList<ItemStack> tInputList = this.getStoredInputs();
            int tInputList_sS = tInputList.size();
            block0: for (int i = 0; i < tInputList_sS - 1; ++i) {
                for (int j = i + 1; j < tInputList_sS; ++j) {
                    if (!GT_Utility.areStacksEqual(tInputList.get(i), tInputList.get(j))) continue;
                    if (tInputList.get((int)i).field_77994_a >= tInputList.get((int)j).field_77994_a) {
                        tInputList.remove(j--);
                        tInputList_sS = tInputList.size();
                        continue;
                    }
                    tInputList.remove(i--);
                    tInputList_sS = tInputList.size();
                    continue block0;
                }
            }
            ItemStack[] inputs = tInputList.toArray(new ItemStack[0]);
            ArrayList<FluidStack> tFluidList = this.getStoredFluids();
            int tFluidList_sS = tFluidList.size();
            block2: for (int i = 0; i < tFluidList_sS - 1; ++i) {
                for (int j = i + 1; j < tFluidList_sS; ++j) {
                    if (!GT_Utility.areFluidsEqual(tFluidList.get(i), tFluidList.get(j))) continue;
                    if (tFluidList.get((int)i).amount >= tFluidList.get((int)j).amount) {
                        tFluidList.remove(j--);
                        tFluidList_sS = tFluidList.size();
                        continue;
                    }
                    tFluidList.remove(i--);
                    tFluidList_sS = tFluidList.size();
                    continue block2;
                }
            }
            FluidStack[] fluids = tFluidList.toArray(new FluidStack[0]);
            if (inputs.length == 0 && fluids.length == 0) {
                return false;
            }
            GT_Single_Recipe_Check.Builder tSingleRecipeCheckBuilder = null;
            if (this.mLockedToSingleRecipe) {
                tSingleRecipeCheckBuilder = GT_Single_Recipe_Check.builder(this).setBefore();
            }
            if ((tRecipe = GT_Recipe.GT_Recipe_Map.sMultiblockChemicalRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, false, GT_Values.V[tier], fluids, inputs)) == null || !tRecipe.isRecipeInputEqual(true, fluids, inputs)) {
                return false;
            }
            if (this.mLockedToSingleRecipe) {
                this.mSingleRecipeCheck = tSingleRecipeCheckBuilder.setAfter().setRecipe(tRecipe).build();
            }
        }
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        this.calculatePerfectOverclockedNessMulti(tRecipe.mEUt, tRecipe.mDuration, 1, tVoltage);
        if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
            return false;
        }
        if (this.mEUt > 0) {
            this.mEUt = -this.mEUt;
        }
        this.mOutputItems = tRecipe.mOutputs;
        this.mOutputFluids = tRecipe.mFluidOutputs;
        this.updateSlots();
        return true;
    }

    @Override
    public IStructureDefinition<GT_MetaTileEntity_LargeChemicalReactor> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    private void onCasingAdded() {
        ++this.mCasingAmount;
    }

    private void onCoilAdded() {
        ++this.mCoilAmount;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasingAmount = 0;
        this.mCoilAmount = 0;
        return this.checkPiece(STRUCTURE_PIECE_MAIN, 1, 1, 0) && this.mCasingAmount >= 8 && this.mCoilAmount == 1 && !this.mEnergyHatches.isEmpty() && this.mMaintenanceHatches.size() == 1;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 1, 1, 0);
    }
}

