/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.fluid;

import com.google.common.primitives.Ints;
import gregtech.api.util.GT_Utility;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;

public class FluidTankGT
implements IFluidTank {
    public final FluidTankGT[] AS_ARRAY = new FluidTankGT[]{this};
    private FluidStack mFluid;
    private long mCapacity = 0L;
    private long mAmount = 0L;
    private boolean mPreventDraining = false;
    private boolean mVoidExcess = false;
    private boolean mChangedFluids = false;
    private Map<String, Long> mAdjustableCapacity = null;
    private long mAdjustableMultiplier = 1L;
    public int mIndex = 0;

    public FluidTankGT() {
        this.mCapacity = Long.MAX_VALUE;
    }

    public FluidTankGT(long aCapacity) {
        this.mCapacity = aCapacity;
    }

    public FluidTankGT(FluidStack aFluid) {
        this.mFluid = aFluid;
        if (aFluid != null) {
            this.mCapacity = aFluid.amount;
            this.mAmount = aFluid.amount;
        }
    }

    public FluidTankGT(FluidStack aFluid, long aCapacity) {
        this.mFluid = aFluid;
        this.mCapacity = aCapacity;
        this.mAmount = aFluid == null ? 0 : aFluid.amount;
    }

    public FluidTankGT(FluidStack aFluid, long aAmount, long aCapacity) {
        this.mFluid = aFluid;
        this.mCapacity = aCapacity;
        this.mAmount = aFluid == null ? 0L : aAmount;
    }

    public FluidTankGT(Fluid aFluid, long aAmount) {
        this(new FluidStack(aFluid, Ints.saturatedCast((long)aAmount)));
        this.mAmount = aAmount;
    }

    public FluidTankGT(Fluid aFluid, long aAmount, long aCapacity) {
        this(new FluidStack(aFluid, Ints.saturatedCast((long)aAmount)), aCapacity);
        this.mAmount = aAmount;
    }

    public FluidTankGT(NBTTagCompound aNBT, String aKey, long aCapacity) {
        this(aNBT.func_74764_b(aKey) ? aNBT.func_74775_l(aKey) : null, aCapacity);
    }

    public FluidTankGT(NBTTagCompound aNBT, long aCapacity) {
        this.mCapacity = aCapacity;
        if (aNBT != null && !aNBT.func_82582_d()) {
            this.mFluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)aNBT);
            this.mAmount = this.isEmpty() ? 0L : (aNBT.func_74764_b("LAmount") ? aNBT.func_74763_f("LAmount") : (long)this.mFluid.amount);
        }
    }

    public FluidTankGT readFromNBT(NBTTagCompound aNBT, String aKey) {
        if (aNBT.func_74764_b(aKey) && (aNBT = aNBT.func_74775_l(aKey)) != null && !aNBT.func_82582_d()) {
            this.mFluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)aNBT);
            this.mAmount = this.isEmpty() ? 0L : (aNBT.func_74764_b("LAmount") ? aNBT.func_74763_f("LAmount") : (long)this.mFluid.amount);
        }
        return this;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound aNBT, String aKey) {
        if (this.mFluid != null && (this.mPreventDraining || this.mAmount > 0L)) {
            NBTTagCompound tNBT = new NBTTagCompound();
            this.mFluid.amount = (int)this.mAmount;
            aNBT.func_74782_a(aKey, (NBTBase)this.mFluid.writeToNBT(tNBT));
            if (this.mAmount > Integer.MAX_VALUE) {
                tNBT.func_74772_a("LAmount", this.mAmount);
            }
        } else {
            aNBT.func_82580_o(aKey);
        }
        return aNBT;
    }

    public FluidStack drain(int aDrained) {
        return this.drain(aDrained, true);
    }

    public FluidStack drain(int aDrained, boolean aDoDrain) {
        if (this.isEmpty() || aDrained <= 0) {
            return null;
        }
        if (this.mAmount < (long)aDrained) {
            aDrained = (int)this.mAmount;
        }
        FluidStack rFluid = new FluidStack(this.mFluid, aDrained);
        if (aDoDrain) {
            this.mAmount -= (long)aDrained;
            if (this.mAmount <= 0L) {
                if (this.mPreventDraining) {
                    this.mAmount = 0L;
                } else {
                    this.setEmpty();
                }
            }
        }
        return rFluid;
    }

    public boolean drainAll(long aDrained) {
        if (this.isEmpty() || this.mAmount < aDrained) {
            return false;
        }
        this.mAmount -= aDrained;
        if (this.mAmount <= 0L) {
            if (this.mPreventDraining) {
                this.mAmount = 0L;
            } else {
                this.setEmpty();
            }
        }
        return true;
    }

    public long remove(long aDrained) {
        if (this.isEmpty() || this.mAmount <= 0L || aDrained <= 0L) {
            return 0L;
        }
        if (this.mAmount < aDrained) {
            aDrained = this.mAmount;
        }
        this.mAmount -= aDrained;
        if (this.mAmount <= 0L) {
            if (this.mPreventDraining) {
                this.mAmount = 0L;
            } else {
                this.setEmpty();
            }
        }
        return aDrained;
    }

    public long add(long aFilled) {
        if (this.isEmpty() || aFilled <= 0L) {
            return 0L;
        }
        long tCapacity = this.capacity();
        if (this.mAmount + aFilled > tCapacity) {
            if (!this.mVoidExcess) {
                aFilled = tCapacity - this.mAmount;
            }
            this.mAmount = tCapacity;
            return aFilled;
        }
        this.mAmount += aFilled;
        return aFilled;
    }

    public long add(long aFilled, FluidStack aFluid) {
        if (aFluid == null || aFilled <= 0L) {
            return 0L;
        }
        if (this.isEmpty()) {
            this.mFluid = aFluid.copy();
            this.mChangedFluids = true;
            this.mAmount = Math.min(this.capacity(aFluid), aFilled);
            return this.mVoidExcess ? aFilled : this.mAmount;
        }
        return this.contains(aFluid) ? this.add(aFilled) : 0L;
    }

    public int fill(FluidStack aFluid) {
        return this.fill(aFluid, true);
    }

    public int fill(FluidStack aFluid, boolean aDoFill) {
        if (aFluid == null) {
            return 0;
        }
        if (aDoFill) {
            if (this.isEmpty()) {
                this.mFluid = aFluid.copy();
                this.mChangedFluids = true;
                this.mAmount = Math.min(this.capacity(aFluid), (long)aFluid.amount);
                return this.mVoidExcess ? aFluid.amount : (int)this.mAmount;
            }
            if (!this.contains(aFluid)) {
                return 0;
            }
            long tCapacity = this.capacity(aFluid);
            long tFilled = tCapacity - this.mAmount;
            if ((long)aFluid.amount < tFilled) {
                this.mAmount += (long)aFluid.amount;
                tFilled = aFluid.amount;
            } else {
                this.mAmount = tCapacity;
            }
            return this.mVoidExcess ? aFluid.amount : (int)tFilled;
        }
        return Ints.saturatedCast((long)(this.isEmpty() ? (this.mVoidExcess ? (long)aFluid.amount : Math.min(this.capacity(aFluid), (long)aFluid.amount)) : (this.contains(aFluid) ? (this.mVoidExcess ? (long)aFluid.amount : Math.min(this.capacity(aFluid) - this.mAmount, (long)aFluid.amount)) : 0L)));
    }

    public boolean canFillAll(FluidStack aFluid) {
        return aFluid == null || aFluid.amount <= 0 || (this.isEmpty() ? this.mVoidExcess || (long)aFluid.amount <= this.capacity(aFluid) : this.contains(aFluid) && (this.mVoidExcess || this.mAmount + (long)aFluid.amount <= this.capacity(aFluid)));
    }

    public boolean canFillAll(long aAmount) {
        return aAmount <= 0L || this.mVoidExcess || this.mAmount + aAmount <= this.capacity();
    }

    public boolean fillAll(FluidStack aFluid) {
        if (aFluid == null || aFluid.amount <= 0) {
            return true;
        }
        if (this.isEmpty()) {
            long tCapacity = this.capacity(aFluid);
            if ((long)aFluid.amount <= tCapacity || this.mVoidExcess) {
                this.mFluid = aFluid.copy();
                this.mChangedFluids = true;
                this.mAmount = aFluid.amount;
                if (this.mAmount > tCapacity) {
                    this.mAmount = tCapacity;
                }
                return true;
            }
            return false;
        }
        if (this.contains(aFluid)) {
            if (this.mAmount + (long)aFluid.amount <= this.capacity()) {
                this.mAmount += (long)aFluid.amount;
                return true;
            }
            if (this.mVoidExcess) {
                this.mAmount = this.capacity();
                return true;
            }
        }
        return false;
    }

    public boolean fillAll(FluidStack aFluid, long aMultiplier) {
        if (aMultiplier <= 0L) {
            return true;
        }
        if (aMultiplier == 1L) {
            return this.fillAll(aFluid);
        }
        if (aFluid == null || aFluid.amount <= 0) {
            return true;
        }
        if (this.isEmpty()) {
            long tCapacity = this.capacity(aFluid);
            if ((long)aFluid.amount * aMultiplier <= tCapacity || this.mVoidExcess) {
                this.mFluid = aFluid.copy();
                this.mChangedFluids = true;
                this.mAmount = (long)aFluid.amount * aMultiplier;
                if (this.mAmount > tCapacity) {
                    this.mAmount = tCapacity;
                }
                return true;
            }
            return false;
        }
        if (this.contains(aFluid)) {
            if (this.mAmount + (long)aFluid.amount * aMultiplier <= this.capacity()) {
                this.mAmount += (long)aFluid.amount * aMultiplier;
                return true;
            }
            if (this.mVoidExcess) {
                this.mAmount = this.capacity();
                return true;
            }
        }
        return false;
    }

    public FluidTankGT setEmpty() {
        this.mFluid = null;
        this.mChangedFluids = true;
        this.mAmount = 0L;
        return this;
    }

    public FluidTankGT setFluid(FluidStack aFluid) {
        this.mFluid = aFluid;
        this.mChangedFluids = true;
        this.mAmount = aFluid == null ? 0 : aFluid.amount;
        return this;
    }

    public FluidTankGT setFluid(FluidStack aFluid, long aAmount) {
        this.mFluid = aFluid;
        this.mChangedFluids = true;
        this.mAmount = aFluid == null ? 0L : aAmount;
        return this;
    }

    public FluidTankGT setFluid(FluidTankGT aTank) {
        this.mFluid = new FluidStack(aTank.mFluid, Ints.saturatedCast((long)aTank.mAmount));
        this.mChangedFluids = true;
        this.mAmount = aTank.mAmount;
        return this;
    }

    public FluidTankGT setIndex(int aIndex) {
        this.mIndex = aIndex;
        return this;
    }

    public FluidTankGT setCapacity(long aCapacity) {
        if (aCapacity >= 0L) {
            this.mCapacity = aCapacity;
        }
        return this;
    }

    public FluidTankGT setCapacityMultiplier(long aCapacityMultiplier) {
        if (aCapacityMultiplier >= 0L) {
            this.mAdjustableMultiplier = aCapacityMultiplier;
        }
        return this;
    }

    public FluidTankGT setCapacity(Map<String, Long> aMap, long aCapacityMultiplier) {
        this.mAdjustableCapacity = aMap;
        this.mAdjustableMultiplier = aCapacityMultiplier;
        return this;
    }

    public FluidTankGT setPreventDraining() {
        return this.setPreventDraining(true);
    }

    public FluidTankGT setPreventDraining(boolean aPrevent) {
        this.mPreventDraining = aPrevent;
        return this;
    }

    public FluidTankGT setVoidExcess() {
        return this.setVoidExcess(true);
    }

    public FluidTankGT setVoidExcess(boolean aVoidExcess) {
        this.mVoidExcess = aVoidExcess;
        return this;
    }

    public boolean isFull() {
        return this.mFluid != null && this.mAmount >= this.capacity();
    }

    public long capacity() {
        return this.capacity(this.mFluid);
    }

    public long capacity(FluidStack aFluid) {
        if (this.mAdjustableCapacity == null || aFluid == null) {
            return this.mCapacity;
        }
        return this.capacity(aFluid.getFluid());
    }

    public long capacity(Fluid aFluid) {
        if (this.mAdjustableCapacity == null || aFluid == null) {
            return this.mCapacity;
        }
        return this.capacity(aFluid.getName());
    }

    public long capacity(String aFluid) {
        if (this.mAdjustableCapacity == null || aFluid == null) {
            return this.mCapacity;
        }
        Long tSize = this.mAdjustableCapacity.get(aFluid);
        return tSize == null ? Math.max(this.mAmount, this.mCapacity) : Math.max(tSize * this.mAdjustableMultiplier, Math.max(this.mAmount, this.mCapacity));
    }

    public boolean isHalf() {
        return this.mFluid != null && this.mAmount * 2L >= this.capacity();
    }

    public boolean contains(Fluid aFluid) {
        return this.mFluid != null && this.mFluid.getFluid() == aFluid;
    }

    public boolean contains(FluidStack aFluid) {
        return GT_Utility.areFluidsEqual(this.mFluid, aFluid);
    }

    public boolean has(long aAmount) {
        return this.mAmount >= aAmount;
    }

    public boolean has() {
        return this.mAmount > 0L;
    }

    public boolean check() {
        if (this.mChangedFluids) {
            this.mChangedFluids = false;
            return true;
        }
        return false;
    }

    public boolean update() {
        this.mChangedFluids = true;
        return true;
    }

    public boolean changed() {
        return this.mChangedFluids;
    }

    public long amount() {
        return this.isEmpty() ? 0L : this.mAmount;
    }

    public boolean isEmpty() {
        return this.mFluid == null;
    }

    public long amount(long aMax) {
        return this.isEmpty() || aMax <= 0L ? 0L : Math.min(this.mAmount, aMax);
    }

    public String name() {
        return this.mFluid == null ? null : this.mFluid.getFluid().getName();
    }

    public FluidStack get() {
        return this.mFluid;
    }

    public FluidStack get(long aMax) {
        return this.isEmpty() || aMax <= 0L ? null : new FluidStack(this.mFluid, Ints.saturatedCast((long)Math.min(this.mAmount, aMax)));
    }

    public FluidStack getFluid() {
        if (this.mFluid != null) {
            this.mFluid.amount = Ints.saturatedCast((long)this.mAmount);
        }
        return this.mFluid;
    }

    public int getFluidAmount() {
        return Ints.saturatedCast((long)this.mAmount);
    }

    public int getCapacity() {
        return Ints.saturatedCast((long)this.capacity());
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo(this.isEmpty() ? null : this.mFluid.copy(), Ints.saturatedCast((long)this.capacity()));
    }
}

