/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.gui.GT_Container_BasicTank;
import gregtech.api.gui.GT_Slot_Holo;
import gregtech.api.gui.GT_Slot_Output;
import gregtech.api.gui.GT_Slot_Render;
import gregtech.api.interfaces.IFluidAccess;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicTank;
import gregtech.api.util.GT_Utility;
import gregtech.common.tileentities.storage.GT_MetaTileEntity_DigitalTankBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class GT_Container_DigitalTank
extends GT_Container_BasicTank {
    public boolean outputFluid = false;
    public boolean mLockFluid = false;
    public boolean mVoidFluidPart = false;
    public boolean mVoidFluidFull = false;
    public boolean mAllowInputFromOutputSide = false;
    public Slot slotAutoOutput;
    public Slot slotLockFLuid;
    public Slot slotVoidOverFlow;
    public Slot slotVoidFull;
    public Slot slotInputFromOutput;

    public GT_Container_DigitalTank(InventoryPlayer aInventoryPlayer, IGregTechTileEntity aTileEntity) {
        super(aInventoryPlayer, aTileEntity);
    }

    @Override
    public void addSlots(InventoryPlayer aInventoryPlayer) {
        this.func_75146_a(new Slot((IInventory)this.mTileEntity, 0, 81, 17));
        this.func_75146_a(new GT_Slot_Output((IInventory)this.mTileEntity, 1, 81, 44));
        this.func_75146_a(new GT_Slot_Render((IInventory)this.mTileEntity, 2, 59, 42));
        this.slotAutoOutput = new GT_Slot_Holo((IInventory)this.mTileEntity, 3, 8, 64, false, true, 1);
        this.func_75146_a(this.slotAutoOutput);
        this.slotLockFLuid = new GT_Slot_Holo((IInventory)this.mTileEntity, 4, 26, 64, false, true, 1);
        this.func_75146_a(this.slotLockFLuid);
        this.slotVoidOverFlow = new GT_Slot_Holo((IInventory)this.mTileEntity, 5, 152, 8, false, true, 1);
        this.func_75146_a(this.slotVoidOverFlow);
        this.slotVoidFull = new GT_Slot_Holo((IInventory)this.mTileEntity, 6, 152, 26, false, true, 1);
        this.func_75146_a(this.slotVoidFull);
        this.slotInputFromOutput = new GT_Slot_Holo((IInventory)this.mTileEntity, 7, 44, 64, false, true, 1);
        this.func_75146_a(this.slotInputFromOutput);
    }

    @Override
    public ItemStack func_75144_a(int aSlotIndex, int aMouseclick, int aShifthold, EntityPlayer aPlayer) {
        GT_MetaTileEntity_DigitalTankBase mte = (GT_MetaTileEntity_DigitalTankBase)this.mTileEntity.getMetaTileEntity();
        if (aSlotIndex == 3) {
            boolean bl = mte.mOutputFluid = !mte.mOutputFluid;
            if (!mte.mOutputFluid) {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("262", "Fluid Auto Output Disabled"));
            } else {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("263", "Fluid Auto Output Enabled"));
            }
            return null;
        }
        if (aSlotIndex == 4) {
            boolean bl = mte.mLockFluid = !mte.mLockFluid;
            if (mte.mLockFluid) {
                String inBrackets;
                if (mte.mFluid == null) {
                    mte.setLockedFluidName(null);
                    inBrackets = GT_Utility.trans("264", "currently none, will be locked to the next that is put in");
                } else {
                    mte.setLockedFluidName(mte.getDrainableStack().getFluid().getName());
                    inBrackets = mte.getDrainableStack().getLocalizedName();
                }
                GT_Utility.sendChatToPlayer(aPlayer, String.format("%s (%s)", GT_Utility.trans("265", "1 specific Fluid"), inBrackets));
            } else {
                mte.setLockedFluidName(null);
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("266", "Lock Fluid Mode Disabled"));
            }
            return null;
        }
        if (aSlotIndex == 5) {
            boolean bl = mte.mVoidFluidPart = !mte.mVoidFluidPart;
            if (!mte.mVoidFluidPart) {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("267", "Overflow Voiding Mode Disabled"));
            } else {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("268", "Overflow Voiding Mode Enabled"));
            }
            return null;
        }
        if (aSlotIndex == 6) {
            boolean bl = mte.mVoidFluidFull = !mte.mVoidFluidFull;
            if (!mte.mVoidFluidFull) {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("269", "Void Full Mode Disabled"));
            } else {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("270", "Void Full Mode Enabled"));
                return null;
            }
        }
        if (aSlotIndex == 7) {
            boolean bl = mte.mAllowInputFromOutputSide = !mte.mAllowInputFromOutputSide;
            if (!mte.mAllowInputFromOutputSide) {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.getTrans("096"));
            } else {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.getTrans("095"));
            }
            return null;
        }
        return super.func_75144_a(aSlotIndex, aMouseclick, aShifthold, aPlayer);
    }

    @Override
    public void sendProgressBar() {
        GT_MetaTileEntity_DigitalTankBase mte = (GT_MetaTileEntity_DigitalTankBase)this.mTileEntity.getMetaTileEntity();
        for (Object crafter : this.field_75149_d) {
            ICrafting player = (ICrafting)crafter;
            if (this.mContent != this.oContent) {
                player.func_71112_a((Container)this, 100, this.mContent & 0xFFFF);
                player.func_71112_a((Container)this, 101, this.mContent >>> 16);
            }
            if (this.outputFluid != mte.mOutputFluid) {
                player.func_71112_a((Container)this, 103, mte.mOutputFluid ? 1 : 0);
            }
            if (this.mLockFluid != mte.mLockFluid) {
                player.func_71112_a((Container)this, 104, mte.mLockFluid ? 1 : 0);
            }
            if (this.mVoidFluidPart != mte.mVoidFluidPart) {
                player.func_71112_a((Container)this, 105, mte.mVoidFluidPart ? 1 : 0);
            }
            if (this.mVoidFluidFull != mte.mVoidFluidFull) {
                player.func_71112_a((Container)this, 106, mte.mVoidFluidFull ? 1 : 0);
            }
            if (this.mAllowInputFromOutputSide == mte.mAllowInputFromOutputSide) continue;
            player.func_71112_a((Container)this, 107, mte.mAllowInputFromOutputSide ? 1 : 0);
        }
        this.outputFluid = mte.mOutputFluid;
        this.mLockFluid = mte.mLockFluid;
        this.mVoidFluidPart = mte.mVoidFluidPart;
        this.mVoidFluidFull = mte.mVoidFluidFull;
        this.mAllowInputFromOutputSide = mte.mAllowInputFromOutputSide;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int value) {
        super.func_75137_b(id, value);
        switch (id) {
            case 103: {
                this.outputFluid = value != 0;
                break;
            }
            case 104: {
                this.mLockFluid = value != 0;
                break;
            }
            case 105: {
                this.mVoidFluidPart = value != 0;
                break;
            }
            case 106: {
                this.mVoidFluidFull = value != 0;
                break;
            }
            case 107: {
                this.mAllowInputFromOutputSide = value != 0;
            }
        }
    }

    @Override
    protected IFluidAccess constructFluidAccess(GT_MetaTileEntity_BasicTank aTank, boolean aIsFillableStack) {
        return new DigitalTankFluidAccess(aTank, aIsFillableStack);
    }

    static class DigitalTankFluidAccess
    extends GT_Container_BasicTank.BasicTankFluidAccess {
        public DigitalTankFluidAccess(GT_MetaTileEntity_BasicTank aTank, boolean aIsFillableStack) {
            super(aTank, aIsFillableStack);
        }

        @Override
        public int getRealCapacity() {
            return ((GT_MetaTileEntity_DigitalTankBase)this.mTank).getRealCapacity();
        }

        @Override
        public void verifyFluidStack() {
        }
    }
}

