/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import gregtech.api.util.GT_TooltipDataCache;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.lwjgl.input.Keyboard;

public class GT_GuiTooltip {
    protected Rectangle bounds;
    protected GT_TooltipDataCache.TooltipData data;
    private List<String> displayedText;
    public boolean enabled = true;

    public GT_GuiTooltip(Rectangle bounds, String ... text) {
        this.bounds = bounds;
        this.setToolTipText(text);
    }

    public GT_GuiTooltip(Rectangle bounds, GT_TooltipDataCache.TooltipData data) {
        this.bounds = bounds;
        this.data = this.sanitizeTooltipData(data);
    }

    private GT_TooltipDataCache.TooltipData sanitizeTooltipData(GT_TooltipDataCache.TooltipData data) {
        if (data.text == null) {
            data.text = Arrays.asList(new String[0]);
        }
        if (data.shiftText == null) {
            data.shiftText = Arrays.asList(new String[0]);
        }
        return data;
    }

    protected void onTick() {
        this.displayedText = Keyboard.isKeyDown((int)42) ? this.data.shiftText : this.data.text;
        this.enabled = this.displayedText.size() != 0;
    }

    protected void updateText() {
    }

    public void setToolTipText(String ... text) {
        this.data = this.formatTooltip(text);
        this.displayedText = this.data.text;
    }

    public void setToolTipText(GT_TooltipDataCache.TooltipData data) {
        this.data = this.sanitizeTooltipData(data);
    }

    protected GT_TooltipDataCache.TooltipData formatTooltip(String[] text) {
        List<String> list;
        if (text != null) {
            list = new ArrayList(text.length);
            for (int i = 0; i < text.length; ++i) {
                if (text[i] == null) continue;
                if (list.isEmpty()) {
                    list.add("\u00a7f" + text[i]);
                    continue;
                }
                list.add("\u00a77" + text[i]);
            }
        } else {
            list = Collections.emptyList();
        }
        return new GT_TooltipDataCache.TooltipData(list, list);
    }

    public List<String> getToolTipText() {
        return this.displayedText;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public boolean isDelayed() {
        return true;
    }
}

