/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.items;

import gregtech.api.GregTech_API;
import gregtech.api.items.GT_Generic_Item;
import gregtech.api.util.GT_Utility;
import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorComponent;
import ic2.core.IC2Potion;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class GT_BreederCell_Item
extends GT_Generic_Item
implements IReactorComponent {
    protected final int mHeatBonusStep;
    protected final int mHeatBonusMultiplier;
    protected ItemStack mProduct;

    public GT_BreederCell_Item(String aUnlocalized, String aEnglish, String aEnglishTooltip, int aHeatBonusStep, int aHeatBonusMultiplier, int aRequiredPulse, Supplier<ItemStack> aProduct) {
        super(aUnlocalized, aEnglish, aEnglishTooltip);
        this.mHeatBonusStep = aHeatBonusStep;
        this.mHeatBonusMultiplier = aHeatBonusMultiplier;
        this.func_77656_e(aRequiredPulse);
        this.setNoRepair();
        GregTech_API.sAfterGTServerstart.add(() -> {
            this.mProduct = (ItemStack)aProduct.get();
        });
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slotIndex, boolean isCurrentItem) {
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase entityLiving = (EntityLivingBase)entity;
            if (!GregTech_API.mIC2Classic && !GT_Utility.isWearingFullRadioHazmat(entityLiving)) {
                IC2Potion.radiation.applyTo(entityLiving, 20, 1);
            }
        }
    }

    @Override
    public void addAdditionalToolTips(List aList, ItemStack aStack, EntityPlayer aPlayer) {
        EnumChatFormatting color2;
        aList.add(this.transItem("019", "Bath with neutron in a hot reactor"));
        int rDmg = aStack.func_77960_j() * 4 / this.func_77612_l();
        switch (rDmg) {
            case 0: {
                color2 = EnumChatFormatting.DARK_GRAY;
                break;
            }
            case 1: 
            case 2: {
                color2 = EnumChatFormatting.GRAY;
                break;
            }
            default: {
                color2 = EnumChatFormatting.WHITE;
            }
        }
        aList.add(String.format(this.transItem("020", "Progress: %s/%s"), "" + color2 + aStack.func_77960_j() + EnumChatFormatting.RESET, "" + this.func_77612_l()));
        if (aStack.func_77960_j() > 0) {
            aList.add(EnumChatFormatting.RED + this.transItem("021", "Radiation Hazard"));
        }
    }

    public int getItemStackLimit(ItemStack stack) {
        return stack.func_77960_j() == 0 ? this.field_77777_bU : 1;
    }

    public void processChamber(IReactor reactor, ItemStack yourStack, int x, int y, boolean heatrun) {
    }

    public boolean acceptUraniumPulse(IReactor reactor, ItemStack yourStack, ItemStack pulsingStack, int youX, int youY, int pulseX, int pulseY, boolean heatrun) {
        if (heatrun) {
            int myLevel = this.getNewDamage(reactor, yourStack);
            if (myLevel >= this.func_77612_l()) {
                reactor.setItemAt(youX, youY, this.mProduct.func_77946_l());
            } else {
                yourStack.func_77964_b(myLevel);
            }
        }
        return true;
    }

    protected int getNewDamage(IReactor reactor, ItemStack stack) {
        return stack.func_77960_j() + 1 + reactor.getHeat() / this.mHeatBonusStep * this.mHeatBonusMultiplier;
    }

    public boolean canStoreHeat(IReactor reactor, ItemStack yourStack, int x, int y) {
        return false;
    }

    public int getMaxHeat(IReactor reactor, ItemStack yourStack, int x, int y) {
        return 0;
    }

    public int getCurrentHeat(IReactor reactor, ItemStack yourStack, int x, int y) {
        return 0;
    }

    public int alterHeat(IReactor reactor, ItemStack yourStack, int x, int y, int heat) {
        return heat;
    }

    public float influenceExplosion(IReactor reactor, ItemStack yourStack) {
        return 0.0f;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)stack.func_77952_i() / (double)stack.func_77958_k();
    }
}

