/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity;

import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.CoverableTileEntity;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_Utility;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;

public abstract class CommonMetaTileEntity
extends CoverableTileEntity
implements IGregTechTileEntity {
    protected boolean mNeedsBlockUpdate = true;
    protected boolean mNeedsUpdate = true;
    protected boolean mSendClientData = false;
    protected boolean mInventoryChanged = false;

    protected boolean createNewMetatileEntity(short aID) {
        if (aID > 0 && aID < GregTech_API.METATILEENTITIES.length && GregTech_API.METATILEENTITIES[aID] != null) {
            if (this.hasValidMetaTileEntity()) {
                this.getMetaTileEntity().setBaseMetaTileEntity(null);
            }
            GregTech_API.METATILEENTITIES[aID].newMetaEntity(this).setBaseMetaTileEntity(this);
            this.mTickTimer = 0L;
            this.mID = aID;
            return true;
        }
        GT_Log.err.println("MetaID " + aID + " not loadable => locking TileEntity!");
        return false;
    }

    protected void saveMetaTileNBT(NBTTagCompound aNBT) {
        try {
            if (this.hasValidMetaTileEntity()) {
                NBTTagList tItemList = new NBTTagList();
                for (int i = 0; i < this.getMetaTileEntity().getRealInventory().length; ++i) {
                    ItemStack tStack = this.getMetaTileEntity().getRealInventory()[i];
                    if (tStack == null) continue;
                    NBTTagCompound tTag = new NBTTagCompound();
                    tTag.func_74768_a("IntSlot", i);
                    tStack.func_77955_b(tTag);
                    tItemList.func_74742_a((NBTBase)tTag);
                }
                aNBT.func_74782_a("Inventory", (NBTBase)tItemList);
                try {
                    this.getMetaTileEntity().saveNBTData(aNBT);
                }
                catch (Throwable e) {
                    GT_Mod.GT_FML_LOGGER.error("Encountered CRITICAL ERROR while saving MetaTileEntity.");
                    GT_Mod.logStackTrace(e);
                }
            }
        }
        catch (Throwable e) {
            GT_Mod.GT_FML_LOGGER.error("Encountered CRITICAL ERROR while saving MetaTileEntity.");
            GT_Mod.logStackTrace(e);
        }
    }

    protected void loadMetaTileNBT(NBTTagCompound aNBT) {
        int nbtVersion = aNBT.func_74762_e("nbtVersion");
        if (this.mID != 0 && this.createNewMetatileEntity(this.mID)) {
            NBTTagList tItemList = aNBT.func_150295_c("Inventory", 10);
            for (int i = 0; i < tItemList.func_74745_c(); ++i) {
                NBTTagCompound tTag = tItemList.func_150305_b(i);
                int tSlot = this.migrateInventoryIndex(tTag.func_74762_e("IntSlot"), nbtVersion);
                if (tSlot < 0 || tSlot >= this.getMetaTileEntity().getRealInventory().length) continue;
                this.getMetaTileEntity().getRealInventory()[tSlot] = GT_Utility.loadItem(tTag);
            }
            try {
                this.getMetaTileEntity().loadNBTData(aNBT);
            }
            catch (Throwable e) {
                GT_Mod.GT_FML_LOGGER.error("Encountered Exception while loading MetaTileEntity.");
                GT_Mod.logStackTrace(e);
            }
        }
    }

    protected int migrateInventoryIndex(int slotIndex, int nbtVersion) {
        return slotIndex;
    }

    @Override
    public void func_70296_d() {
        super.func_70296_d();
        this.mInventoryChanged = true;
    }

    @Override
    public boolean hasInventoryBeenModified() {
        return this.mInventoryChanged;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        if (this.canAccessData()) {
            return this.getMetaTileEntity().isValidSlot(aIndex);
        }
        return false;
    }

    public Packet func_145844_m() {
        this.issueClientUpdate();
        return null;
    }

    @Override
    public void issueTextureUpdate() {
        this.mNeedsUpdate = true;
    }

    @Override
    public void issueClientUpdate() {
        this.mSendClientData = true;
    }

    @Override
    public void issueBlockUpdate() {
        this.mNeedsBlockUpdate = true;
    }

    @Override
    public boolean isValidFacing(byte aSide) {
        if (this.canAccessData()) {
            return this.getMetaTileEntity().isFacingValid(aSide);
        }
        return false;
    }

    protected boolean canAccessData() {
        return !this.isDead && this.hasValidMetaTileEntity();
    }

    protected abstract boolean hasValidMetaTileEntity();

    @Override
    public String[] getDescription() {
        if (this.canAccessData()) {
            return this.getMetaTileEntity().getDescription();
        }
        return new String[0];
    }

    @Override
    public boolean isStillValid() {
        return this.hasValidMetaTileEntity();
    }

    @Override
    public boolean allowCoverOnSide(byte aSide, GT_ItemStack aCoverID) {
        return this.hasValidMetaTileEntity() && this.getMetaTileEntity().allowCoverOnSide(aSide, aCoverID);
    }

    @Override
    public void issueCoverUpdate(byte aSide) {
        super.issueCoverUpdate(aSide);
        this.issueClientUpdate();
    }

    @Override
    public boolean shouldJoinIc2Enet() {
        IMetaTileEntity meta = this.getMetaTileEntity();
        return meta != null && meta.shouldJoinIc2Enet();
    }
}

