/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity;

import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregtechWailaProvider;
import gregtech.api.metatileentity.BaseMetaPipeEntity;
import gregtech.api.metatileentity.BaseTileEntity;
import gregtech.api.net.GT_Packet_RequestCoverData;
import gregtech.api.net.GT_Packet_SendCoverData;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.util.GT_CoverBehavior;
import gregtech.api.util.GT_CoverBehaviorBase;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.ISerializableObject;
import gregtech.common.GT_Client;
import gregtech.common.covers.GT_Cover_Fluidfilter;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;

public abstract class CoverableTileEntity
extends BaseTileEntity
implements ICoverable,
IGregtechWailaProvider {
    public static final String[] COVER_DATA_NBT_KEYS = (String[])Arrays.stream(ForgeDirection.VALID_DIRECTIONS).mapToInt(Enum::ordinal).mapToObj(i -> "mCoverData" + i).toArray(String[]::new);
    protected final GT_CoverBehaviorBase<?>[] mCoverBehaviors = new GT_CoverBehaviorBase[]{GregTech_API.sNoBehavior, GregTech_API.sNoBehavior, GregTech_API.sNoBehavior, GregTech_API.sNoBehavior, GregTech_API.sNoBehavior, GregTech_API.sNoBehavior};
    protected byte[] mSidedRedstone = new byte[]{15, 15, 15, 15, 15, 15};
    protected boolean mRedstone = false;
    protected byte mStrongRedstone = 0;
    protected int[] mCoverSides = new int[]{0, 0, 0, 0, 0, 0};
    protected ISerializableObject[] mCoverData = new ISerializableObject[6];
    protected final boolean[] mCoverNeedUpdate = new boolean[]{false, false, false, false, false, false};
    protected short mID = 0;
    public long mTickTimer = 0L;

    protected void writeCoverNBT(NBTTagCompound aNBT, boolean isDrop) {
        boolean hasCover = false;
        for (int i = 0; i < this.mCoverData.length; ++i) {
            if (this.mCoverSides[i] == 0 || this.mCoverData[i] == null) continue;
            aNBT.func_74782_a(COVER_DATA_NBT_KEYS[i], this.mCoverData[i].saveDataToNBT());
            hasCover = true;
        }
        if (this.mStrongRedstone > 0) {
            aNBT.func_74774_a("mStrongRedstone", this.mStrongRedstone);
        }
        if (hasCover) {
            aNBT.func_74783_a("mCoverSides", this.mCoverSides);
        }
        if (!isDrop) {
            aNBT.func_74773_a("mRedstoneSided", this.mSidedRedstone);
            aNBT.func_74757_a("mRedstone", this.mRedstone);
        }
    }

    protected void readCoverNBT(NBTTagCompound aNBT) {
        byte i;
        byte[] byArray;
        int[] nArray;
        if (aNBT.func_74764_b("mCoverSides")) {
            nArray = aNBT.func_74759_k("mCoverSides");
        } else {
            int[] nArray2 = new int[6];
            nArray2[0] = 0;
            nArray2[1] = 0;
            nArray2[2] = 0;
            nArray2[3] = 0;
            nArray2[4] = 0;
            nArray = nArray2;
            nArray2[5] = 0;
        }
        this.mCoverSides = nArray;
        this.mRedstone = aNBT.func_74767_n("mRedstone");
        if (aNBT.func_74764_b("mRedstoneSided")) {
            byArray = aNBT.func_74770_j("mRedstoneSided");
        } else {
            byte[] byArray2 = new byte[6];
            byArray2[0] = 15;
            byArray2[1] = 15;
            byArray2[2] = 15;
            byArray2[3] = 15;
            byArray2[4] = 15;
            byArray = byArray2;
            byArray2[5] = 15;
        }
        this.mSidedRedstone = byArray;
        this.mStrongRedstone = aNBT.func_74771_c("mStrongRedstone");
        for (i = 0; i < 6; i = (byte)((byte)(i + 1))) {
            this.mCoverBehaviors[i] = GregTech_API.getCoverBehaviorNew(this.mCoverSides[i]);
        }
        this.mCoverData = new ISerializableObject[6];
        if (aNBT.func_150297_b("mCoverData", 11) && aNBT.func_74759_k("mCoverData").length == 6) {
            int[] tOldData = aNBT.func_74759_k("mCoverData");
            for (int i2 = 0; i2 < tOldData.length; ++i2) {
                if (this.mCoverBehaviors[i2] instanceof GT_Cover_Fluidfilter) {
                    String filterKey = String.format("fluidFilter%d", i2);
                    if (!aNBT.func_74764_b(filterKey)) continue;
                    this.mCoverData[i2] = this.mCoverBehaviors[i2].createDataObject(tOldData[i2] & 7 | FluidRegistry.getFluidID((String)aNBT.func_74779_i(filterKey)) << 3);
                    continue;
                }
                if (this.mCoverBehaviors[i2] == null || this.mCoverBehaviors[i2] == GregTech_API.sNoBehavior) continue;
                this.mCoverData[i2] = this.mCoverBehaviors[i2].createDataObject(tOldData[i2]);
            }
        } else {
            for (i = 0; i < 6; i = (byte)((byte)(i + 1))) {
                if (this.mCoverBehaviors[i] == null) continue;
                this.mCoverData[i] = aNBT.func_74764_b(COVER_DATA_NBT_KEYS[i]) ? this.mCoverBehaviors[i].createDataObject(aNBT.func_74781_a(COVER_DATA_NBT_KEYS[i])) : this.mCoverBehaviors[i].createDataObject();
                if (!this.mCoverBehaviors[i].isDataNeededOnClient(i, this.mCoverSides[i], this.mCoverData[i], this)) continue;
                this.issueCoverUpdate(i);
            }
        }
    }

    public abstract boolean isStillValid();

    protected boolean doCoverThings() {
        for (byte i : GT_Values.ALL_VALID_SIDES) {
            GT_CoverBehaviorBase<?> tCover;
            int tCoverTickRate;
            if (this.getCoverIDAtSide(i) == 0 || (tCoverTickRate = (tCover = this.getCoverBehaviorAtSideNew(i)).getTickRate(i, this.getCoverIDAtSide(i), this.mCoverData[i], this)) <= 0 || this.mTickTimer % (long)tCoverTickRate != 0L) continue;
            byte tRedstone = tCover.isRedstoneSensitive(i, this.getCoverIDAtSide(i), this.mCoverData[i], this, this.mTickTimer) ? this.getInputRedstoneSignal(i) : (byte)0;
            this.mCoverData[i] = tCover.doCoverThings(i, tRedstone, this.getCoverIDAtSide(i), this.mCoverData[i], this, this.mTickTimer);
            if (this.isStillValid()) continue;
            return false;
        }
        return true;
    }

    public abstract boolean allowCoverOnSide(byte var1, GT_ItemStack var2);

    protected void checkDropCover() {
        for (byte i : GT_Values.ALL_VALID_SIDES) {
            if (this.getCoverIDAtSide(i) == 0 || this.allowCoverOnSide(i, new GT_ItemStack(this.getCoverIDAtSide(i)))) continue;
            this.dropCover(i, i, true);
        }
    }

    protected void updateCoverBehavior() {
        for (byte i : GT_Values.ALL_VALID_SIDES) {
            this.mCoverBehaviors[i] = GregTech_API.getCoverBehaviorNew(this.mCoverSides[i]);
        }
    }

    @Override
    public void issueCoverUpdate(byte aSide) {
        if (this.field_145850_b == null || this.isServerSide() && this.getCoverBehaviorAtSideNew(aSide).isDataNeededOnClient(aSide, this.getCoverIDAtSide(aSide), this.getComplexCoverDataAtSide(aSide), this)) {
            this.mCoverNeedUpdate[aSide] = true;
        }
    }

    public final ITexture getCoverTexture(byte aSide) {
        if (this.getCoverIDAtSide(aSide) == 0) {
            return null;
        }
        if (GT_Mod.instance.isClientSide() && (GT_Client.hideValue & 1) != 0) {
            return Textures.BlockIcons.HIDDEN_TEXTURE[0];
        }
        GT_CoverBehaviorBase<?> coverBehavior = this.getCoverBehaviorAtSideNew(aSide);
        ITexture coverTexture = coverBehavior != null ? (!(this instanceof BaseMetaPipeEntity) ? coverBehavior.getSpecialCoverFGTexture(aSide, this.getCoverIDAtSide(aSide), this.getComplexCoverDataAtSide(aSide), this) : coverBehavior.getSpecialCoverTexture(aSide, this.getCoverIDAtSide(aSide), this.getComplexCoverDataAtSide(aSide), this)) : null;
        return coverTexture != null ? coverTexture : GregTech_API.sCovers.get(new GT_ItemStack(this.getCoverIDAtSide(aSide)));
    }

    protected void requestCoverDataIfNeeded() {
        if (this.field_145850_b == null || !this.field_145850_b.field_72995_K) {
            return;
        }
        for (byte i : GT_Values.ALL_VALID_SIDES) {
            if (!this.getCoverBehaviorAtSideNew(i).isDataNeededOnClient(i, this.getCoverIDAtSide(i), this.getComplexCoverDataAtSide(i), this)) continue;
            GT_Values.NW.sendToServer(new GT_Packet_RequestCoverData(i, this.getCoverIDAtSide(i), this));
        }
    }

    @Override
    public void setCoverIdAndDataAtSide(byte aSide, int aId, ISerializableObject aData) {
        if (this.setCoverIDAtSideNoUpdate(aSide, aId)) {
            this.setCoverDataAtSide(aSide, aData);
            this.issueCoverUpdate(aSide);
            this.issueBlockUpdate();
        }
    }

    @Override
    public void setCoverIDAtSide(byte aSide, int aID) {
        if (this.setCoverIDAtSideNoUpdate(aSide, aID)) {
            this.issueCoverUpdate(aSide);
            this.issueBlockUpdate();
        }
    }

    @Override
    public boolean setCoverIDAtSideNoUpdate(byte aSide, int aID) {
        if (aSide >= 0 && aSide < 6 && this.mCoverSides[aSide] != aID) {
            if (aID == 0 && this.isClientSide()) {
                this.mCoverBehaviors[aSide].onDropped(aSide, this.mCoverSides[aSide], this.mCoverData[aSide], this);
            }
            this.mCoverSides[aSide] = aID;
            this.mCoverBehaviors[aSide] = GregTech_API.getCoverBehaviorNew(aID);
            this.mCoverData[aSide] = this.mCoverBehaviors[aSide].createDataObject();
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public void setCoverDataAtSide(byte aSide, int aData) {
        if (aSide >= 0 && aSide < 6 && this.mCoverData[aSide] instanceof ISerializableObject.LegacyCoverData) {
            this.mCoverData[aSide] = new ISerializableObject.LegacyCoverData(aData);
        }
    }

    @Override
    public void setCoverDataAtSide(byte aSide, ISerializableObject aData) {
        if (aSide >= 0 && aSide < 6 && this.getCoverBehaviorAtSideNew(aSide) != null && this.getCoverBehaviorAtSideNew(aSide).cast(aData) != null) {
            this.mCoverData[aSide] = aData;
        }
    }

    @Override
    @Deprecated
    public GT_CoverBehavior getCoverBehaviorAtSide(byte aSide) {
        if (aSide >= 0 && aSide < this.mCoverBehaviors.length && this.mCoverBehaviors[aSide] instanceof GT_CoverBehavior) {
            return (GT_CoverBehavior)this.mCoverBehaviors[aSide];
        }
        return GregTech_API.sNoBehavior;
    }

    @Override
    public void setCoverItemAtSide(byte aSide, ItemStack aCover) {
        GregTech_API.getCoverBehaviorNew(aCover).placeCover(aSide, aCover, this);
    }

    @Override
    public int getCoverIDAtSide(byte aSide) {
        if (aSide >= 0 && aSide < 6) {
            return this.mCoverSides[aSide];
        }
        return 0;
    }

    @Override
    public ItemStack getCoverItemAtSide(byte aSide) {
        return this.getCoverBehaviorAtSideNew(aSide).getDisplayStack(this.getCoverIDAtSide(aSide), this.getComplexCoverDataAtSide(aSide));
    }

    @Override
    public boolean canPlaceCoverIDAtSide(byte aSide, int aID) {
        return this.getCoverIDAtSide(aSide) == 0;
    }

    @Override
    public boolean canPlaceCoverItemAtSide(byte aSide, ItemStack aCover) {
        return this.getCoverIDAtSide(aSide) == 0;
    }

    @Override
    @Deprecated
    public int getCoverDataAtSide(byte aSide) {
        if (aSide >= 0 && aSide < 6 && this.mCoverData[aSide] instanceof ISerializableObject.LegacyCoverData) {
            return ((ISerializableObject.LegacyCoverData)this.mCoverData[aSide]).get();
        }
        return 0;
    }

    @Override
    public ISerializableObject getComplexCoverDataAtSide(byte aSide) {
        if (aSide >= 0 && aSide < 6 && this.getCoverBehaviorAtSideNew(aSide) != null) {
            return this.mCoverData[aSide];
        }
        return GregTech_API.sNoBehavior.createDataObject();
    }

    @Override
    public GT_CoverBehaviorBase<?> getCoverBehaviorAtSideNew(byte aSide) {
        if (aSide >= 0 && aSide < 6) {
            return this.mCoverBehaviors[aSide];
        }
        return GregTech_API.sNoBehavior;
    }

    @Override
    public boolean dropCover(byte aSide, byte aDroppedSide, boolean aForced) {
        if (this.getCoverBehaviorAtSideNew(aSide).onCoverRemoval(aSide, this.getCoverIDAtSide(aSide), this.mCoverData[aSide], this, aForced) || aForced) {
            ItemStack tStack = this.getCoverBehaviorAtSideNew(aSide).getDrop(aSide, this.getCoverIDAtSide(aSide), this.getComplexCoverDataAtSide(aSide), this);
            if (tStack != null) {
                this.getCoverBehaviorAtSideNew(aSide).onDropped(aSide, this.getCoverIDAtSide(aSide), this.getComplexCoverDataAtSide(aSide), this);
                EntityItem tEntity = new EntityItem(this.field_145850_b, (double)this.getOffsetX(aDroppedSide, 1) + 0.5, (double)this.getOffsetY(aDroppedSide, 1) + 0.5, (double)this.getOffsetZ(aDroppedSide, 1) + 0.5, tStack);
                tEntity.field_70159_w = 0.0;
                tEntity.field_70181_x = 0.0;
                tEntity.field_70179_y = 0.0;
                this.field_145850_b.func_72838_d((Entity)tEntity);
            }
            this.setCoverIDAtSide(aSide, 0);
            this.updateOutputRedstoneSignal(aSide);
            return true;
        }
        return false;
    }

    @Override
    public void setOutputRedstoneSignal(byte aSide, byte aStrength) {
        aStrength = (byte)Math.min(Math.max(0, aStrength), 15);
        if (aSide >= 0 && aSide < 6 && this.mSidedRedstone[aSide] != aStrength) {
            this.mSidedRedstone[aSide] = aStrength;
            this.issueBlockUpdate();
        }
    }

    @Override
    public void setStrongOutputRedstoneSignal(byte aSide, byte aStrength) {
        this.mStrongRedstone = (byte)(this.mStrongRedstone | 1 << aSide);
        this.setOutputRedstoneSignal(aSide, aStrength);
    }

    @Override
    public void setInternalOutputRedstoneSignal(byte aSide, byte aStrength) {
        if (!this.getCoverBehaviorAtSideNew(aSide).manipulatesSidedRedstoneOutput(aSide, this.getCoverIDAtSide(aSide), this.getComplexCoverDataAtSide(aSide), this)) {
            this.setOutputRedstoneSignal(aSide, aStrength);
        }
    }

    @Override
    public boolean getRedstone() {
        return IntStream.range(1, 6).anyMatch(i -> this.getRedstone((byte)i));
    }

    @Override
    public boolean getRedstone(byte aSide) {
        return this.getInternalInputRedstoneSignal(aSide) > 0;
    }

    @Override
    public byte getStrongestRedstone() {
        return (byte)IntStream.range(1, 6).map(i -> this.getInternalInputRedstoneSignal((byte)i)).max().orElse(0);
    }

    @Override
    public byte getStrongOutputRedstoneSignal(byte aSide) {
        return aSide >= 0 && aSide < 6 && (this.mStrongRedstone & 1 << aSide) != 0 ? (byte)(this.mSidedRedstone[aSide] & 0xF) : (byte)0;
    }

    @Override
    public void setGenericRedstoneOutput(boolean aOnOff) {
        this.mRedstone = aOnOff;
    }

    @Override
    public byte getInternalInputRedstoneSignal(byte aSide) {
        return (byte)(this.getCoverBehaviorAtSideNew(aSide).getRedstoneInput(aSide, this.getInputRedstoneSignal(aSide), this.getCoverIDAtSide(aSide), this.getComplexCoverDataAtSide(aSide), this) & 0xF);
    }

    @Override
    public byte getInputRedstoneSignal(byte aSide) {
        return (byte)(this.field_145850_b.func_72878_l(this.getOffsetX(aSide, 1), (int)this.getOffsetY(aSide, 1), this.getOffsetZ(aSide, 1), (int)aSide) & 0xF);
    }

    @Override
    public byte getOutputRedstoneSignal(byte aSide) {
        return this.getCoverBehaviorAtSideNew(aSide).manipulatesSidedRedstoneOutput(aSide, this.getCoverIDAtSide(aSide), this.getComplexCoverDataAtSide(aSide), this) ? this.mSidedRedstone[aSide] : this.getGeneralRS(aSide);
    }

    protected void updateOutputRedstoneSignal(byte aSide) {
        this.setOutputRedstoneSignal(aSide, (byte)0);
    }

    @Override
    public void receiveCoverData(byte aCoverSide, int aCoverID, int aCoverData) {
        if (aCoverSide >= 0 && aCoverSide < 6) {
            this.setCoverIDAtSideNoUpdate(aCoverSide, aCoverID);
        }
        this.setCoverDataAtSide(aCoverSide, aCoverData);
    }

    @Override
    public void receiveCoverData(byte aCoverSide, int aCoverID, ISerializableObject aCoverData, EntityPlayerMP aPlayer) {
        if (aCoverSide >= 0 && aCoverSide < 6) {
            this.setCoverIDAtSideNoUpdate(aCoverSide, aCoverID);
            this.setCoverDataAtSide(aCoverSide, aCoverData);
            if (this.isClientSide()) {
                this.getCoverBehaviorAtSideNew(aCoverSide).onDataChanged(aCoverSide, aCoverID, aCoverData, this);
            }
        }
    }

    protected void sendCoverDataIfNeeded() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        byte mCoverNeedUpdateLength = this.mCoverNeedUpdate.length;
        for (byte i = 0; i < mCoverNeedUpdateLength; i = (byte)((byte)(i + 1))) {
            if (!this.mCoverNeedUpdate[i]) continue;
            GT_Values.NW.sendPacketToAllPlayersInRange(this.field_145850_b, new GT_Packet_SendCoverData(i, this.getCoverIDAtSide(i), this.getComplexCoverDataAtSide(i), this), this.field_145851_c, this.field_145849_e);
            this.mCoverNeedUpdate[i] = false;
        }
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        int coverId;
        GT_CoverBehaviorBase<?> behavior;
        NBTTagCompound tag = accessor.getNBTData();
        byte side = (byte)accessor.getSide().ordinal();
        int[] coverSides = tag.func_74759_k("mCoverSides");
        if (coverSides != null && coverSides.length == 6 && coverSides[side] != 0 && (behavior = GregTech_API.getCoverBehaviorNew(coverId = coverSides[side])) != null && behavior != GregTech_API.sNoBehavior && tag.func_74764_b(COVER_DATA_NBT_KEYS[side])) {
            String behaviorDesc;
            Object dataObject = behavior.createDataObject(tag.func_74781_a(COVER_DATA_NBT_KEYS[side]));
            ItemStack coverStack = behavior.getDisplayStack(coverId, (ISerializableObject)dataObject);
            if (coverStack != null) {
                currenttip.add(String.format("Cover: %s", coverStack.func_82833_r()));
            }
            if (!Objects.equals(behaviorDesc = behavior.getDescription(side, coverId, (ISerializableObject)dataObject, null), "")) {
                currenttip.add(behaviorDesc);
            }
        }
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        this.writeCoverNBT(tag, false);
    }

    public static void addInstalledCoversInformation(NBTTagCompound aNBT, List<String> aList) {
        int[] mCoverSides;
        if (aNBT.func_74764_b("mCoverSides") && (mCoverSides = aNBT.func_74759_k("mCoverSides")) != null && mCoverSides.length == 6) {
            for (byte tSide : GT_Values.ALL_VALID_SIDES) {
                Object dataObject;
                ItemStack coverStack;
                GT_CoverBehaviorBase<?> behavior;
                int coverId = mCoverSides[tSide];
                if (coverId == 0 || (behavior = GregTech_API.getCoverBehaviorNew(coverId)) == null || behavior == GregTech_API.sNoBehavior || !aNBT.func_74764_b(COVER_DATA_NBT_KEYS[tSide]) || (coverStack = behavior.getDisplayStack(coverId, (ISerializableObject)(dataObject = behavior.createDataObject(aNBT.func_74781_a(COVER_DATA_NBT_KEYS[tSide]))))) == null) continue;
                aList.add(String.format("Cover on %s side: %s", GT_LanguageManager.getTranslation(GT_LanguageManager.FACES[tSide]), coverStack.func_82833_r()));
            }
        }
    }
}

