/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import gregtech.api.enums.ItemList;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_Container_2by2_Fluid;
import gregtech.api.gui.GT_GUIContainer_2by2_Fluid;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Utility;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

public class GT_MetaTileEntity_Hatch_MultiInput
extends GT_MetaTileEntity_Hatch_Input {
    public FluidStack[] mStoredFluid;
    public int mCapacityPer;

    public GT_MetaTileEntity_Hatch_MultiInput(int aID, int aSlot, String aName, String aNameRegional, int aTier) {
        super(aID, aSlot, aName, aNameRegional, aTier);
        this.mStoredFluid = new FluidStack[aSlot];
        this.mCapacityPer = 8000 * (1 << aTier) / aSlot;
    }

    public GT_MetaTileEntity_Hatch_MultiInput(String aName, int aSlot, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aSlot, aTier, aDescription, aTextures);
        this.mStoredFluid = new FluidStack[aSlot];
        this.mCapacityPer = 8000 * (1 << aTier) / aSlot;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Hatch_MultiInput(this.mName, this.getMaxType(), (int)this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        if (this.mStoredFluid != null) {
            for (int i = 0; i < this.mStoredFluid.length; ++i) {
                if (this.mStoredFluid[i] == null) continue;
                aNBT.func_74782_a("mFluid" + i, (NBTBase)this.mStoredFluid[i].writeToNBT(new NBTTagCompound()));
            }
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (this.mStoredFluid != null) {
            for (int i = 0; i < this.mStoredFluid.length; ++i) {
                if (!aNBT.func_74764_b("mFluid" + i)) continue;
                this.mStoredFluid[i] = FluidStack.loadFluidStackFromNBT((NBTTagCompound)aNBT.func_74775_l("mFluid" + i));
            }
        }
    }

    public FluidStack[] getStoredFluid() {
        return this.mStoredFluid;
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(Textures.BlockIcons.OVERLAY_INPUT_HATCH_2x2)};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(Textures.BlockIcons.OVERLAY_INPUT_HATCH_2x2)};
    }

    public int getMaxType() {
        return this.mStoredFluid.length;
    }

    @Override
    public FluidStack getFluid() {
        for (FluidStack tFluid : this.mStoredFluid) {
            if (tFluid == null || tFluid.amount <= 0) continue;
            return tFluid;
        }
        return null;
    }

    public FluidStack getFluid(int aSlot) {
        if (this.mStoredFluid == null || aSlot < 0 || aSlot >= this.getMaxType()) {
            return null;
        }
        return this.mStoredFluid[aSlot];
    }

    @Override
    public int getFluidAmount() {
        if (this.getFluid() != null) {
            return this.getFluid().amount;
        }
        return 0;
    }

    @Override
    public int getCapacity() {
        return this.mCapacityPer;
    }

    public int getFirstEmptySlot() {
        for (int i = 0; i < this.mStoredFluid.length; ++i) {
            if (this.mStoredFluid[i] != null && this.mStoredFluid[i].amount > 0) continue;
            return i;
        }
        return -1;
    }

    public boolean hasFluid(FluidStack aFluid) {
        if (aFluid == null) {
            return false;
        }
        for (FluidStack tFluid : this.mStoredFluid) {
            if (!aFluid.isFluidEqual(tFluid)) continue;
            return true;
        }
        return false;
    }

    public int getFluidSlot(FluidStack tFluid) {
        if (tFluid == null) {
            return -1;
        }
        for (int i = 0; i < this.mStoredFluid.length; ++i) {
            if (!tFluid.equals((Object)this.mStoredFluid[i])) continue;
            return i;
        }
        return -1;
    }

    public int getFluidAmount(FluidStack tFluid) {
        int tSlot = this.getFluidSlot(tFluid);
        if (tSlot != -1) {
            return this.mStoredFluid[tSlot].amount;
        }
        return 0;
    }

    public void setFluid(FluidStack aFluid, int aSlot) {
        if (aSlot < 0 || aSlot >= this.getMaxType()) {
            return;
        }
        this.mStoredFluid[aSlot] = aFluid;
    }

    public void addFluid(FluidStack aFluid, int aSlot) {
        if (aSlot < 0 || aSlot >= this.getMaxType()) {
            return;
        }
        if (aFluid.equals((Object)this.mStoredFluid[aSlot])) {
            this.mStoredFluid[aSlot].amount += aFluid.amount;
        }
        if (this.mStoredFluid[aSlot] == null) {
            this.mStoredFluid[aSlot] = aFluid.copy();
        }
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            this.mFluid = this.getFluid();
        }
        super.onPreTick(aBaseMetaTileEntity, aTick);
    }

    @Override
    public int fill(FluidStack aFluid, boolean doFill) {
        if (aFluid == null || aFluid.getFluid().getID() <= 0 || aFluid.amount <= 0 || !this.canTankBeFilled() || !this.isFluidInputAllowed(aFluid)) {
            return 0;
        }
        if (!this.hasFluid(aFluid) && this.getFirstEmptySlot() != -1) {
            int tFilled = Math.min(aFluid.amount, this.mCapacityPer);
            if (doFill) {
                FluidStack tFluid = aFluid.copy();
                tFluid.amount = tFilled;
                this.addFluid(tFluid, this.getFirstEmptySlot());
                this.getBaseMetaTileEntity().func_70296_d();
            }
            return tFilled;
        }
        if (this.hasFluid(aFluid)) {
            int tLeft = this.mCapacityPer - this.getFluidAmount(aFluid);
            int tFilled = Math.min(tLeft, aFluid.amount);
            if (doFill) {
                FluidStack tFluid = aFluid.copy();
                tFluid.amount = tFilled;
                this.addFluid(tFluid, this.getFluidSlot(tFluid));
                this.getBaseMetaTileEntity().func_70296_d();
            }
            return tFilled;
        }
        return 0;
    }

    @Override
    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.getFluid() == null || !this.canTankBeEmptied()) {
            return null;
        }
        if (this.getFluid().amount <= 0 && this.isFluidChangingAllowed()) {
            this.setFluid(null, this.getFluidSlot(this.getFluid()));
            this.getBaseMetaTileEntity().func_70296_d();
            return null;
        }
        FluidStack tRemove = this.getFluid().copy();
        tRemove.amount = Math.min(maxDrain, tRemove.amount);
        if (doDrain) {
            this.getFluid().amount -= tRemove.amount;
            this.getBaseMetaTileEntity().func_70296_d();
        }
        if (this.getFluid() == null || this.getFluid().amount <= 0 && this.isFluidChangingAllowed()) {
            this.setFluid(null, this.getFluidSlot(this.getFluid()));
            this.getBaseMetaTileEntity().func_70296_d();
        }
        return tRemove;
    }

    @Override
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.fill(resource, doFill);
    }

    @Override
    public FluidStack drain(ForgeDirection from, FluidStack aFluid, boolean doDrain) {
        if (this.getFluid() != null && aFluid != null && this.getFluid().isFluidEqual(aFluid) && this.hasFluid(aFluid)) {
            FluidStack tStored = this.mStoredFluid[this.getFluidSlot(aFluid)];
            if (tStored.amount <= 0 && this.isFluidChangingAllowed()) {
                this.setFluid(null, this.getFluidSlot(tStored));
                this.getBaseMetaTileEntity().func_70296_d();
                return null;
            }
            FluidStack tRemove = tStored.copy();
            tRemove.amount = Math.min(aFluid.amount, tRemove.amount);
            if (doDrain) {
                tStored.amount -= tRemove.amount;
                this.getBaseMetaTileEntity().func_70296_d();
            }
            if (tStored.amount <= 0 && this.isFluidChangingAllowed()) {
                this.setFluid(null, this.getFluidSlot(tStored));
                this.getBaseMetaTileEntity().func_70296_d();
            }
            return tRemove;
        }
        return null;
    }

    @Override
    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidTankInfo[] FTI = new FluidTankInfo[this.getMaxType()];
        for (int i = 0; i < this.getMaxType(); ++i) {
            FTI[i] = new FluidTankInfo(this.mStoredFluid[i], this.mCapacityPer);
        }
        return FTI;
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_2by2_Fluid(aPlayerInventory, aBaseMetaTileEntity, "Quadruple Input Hatch");
    }

    @Override
    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_Container_2by2_Fluid(aPlayerInventory, aBaseMetaTileEntity);
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide() && this.mStoredFluid != null) {
            for (int i = 0; i < this.getMaxType(); ++i) {
                if (this.mStoredFluid[i] == null || this.mStoredFluid[i].amount > 0) continue;
                this.mStoredFluid[i] = null;
            }
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return aIndex >= 4;
    }

    @Override
    public void updateFluidDisplayItem() {
        for (int i = 0; i < 4; ++i) {
            if (this.getFluid(i) == null || this.getFluid((int)i).amount <= 0) {
                if (!ItemList.Display_Fluid.isStackEqual(this.mInventory[i], true, true)) continue;
                this.mInventory[i] = null;
                continue;
            }
            this.mInventory[i] = GT_Utility.getFluidDisplayStack(this.getFluid(i), true, !this.displaysStackSize());
        }
    }
}

