/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.multitileentity;

import com.cricketcraft.chisel.api.IFacade;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IDebugableBlock;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IDebugableTileEntity;
import gregtech.api.metatileentity.BaseTileEntity;
import gregtech.api.metatileentity.CoverableTileEntity;
import gregtech.api.multitileentity.MultiTileEntityRegistry;
import gregtech.api.multitileentity.interfaces.IMultiTileEntity;
import gregtech.api.objects.XSTR;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_Util;
import gregtech.api.util.GT_Utility;
import gregtech.common.render.GT_Renderer_Block;
import gregtech.common.render.IRenderedBlock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.ForgeEventFactory;

public class MultiTileEntityBlock
extends Block
implements IDebugableBlock,
ITileEntityProvider,
IRenderedBlock,
IFacade {
    protected static final Map<String, MultiTileEntityBlock> MULTI_BLOCK_MAP = new HashMap<String, MultiTileEntityBlock>();
    private static boolean LOCK = false;
    protected final String mNameInternal;
    protected final String mTool;
    protected final int mHarvestLevelOffset;
    protected final int mHarvestLevelMinimum;
    protected final int mHarvestLevelMaximum;
    protected final boolean mOpaque;
    protected final boolean mNormalCube;

    public static String getName(String aMaterialName, Block.SoundType aSoundType, String aTool, int aHarvestLevelOffset, int aHarvestLevelMinimum, int aHarvestLevelMaximum, boolean aOpaque, boolean aNormalCube) {
        return "gt.block.multiblock." + aMaterialName + "." + aSoundType.field_150501_a + "." + aTool + "." + aHarvestLevelOffset + "." + aHarvestLevelMinimum + "." + aHarvestLevelMaximum + "." + aOpaque + "." + aNormalCube;
    }

    public static MultiTileEntityBlock getOrCreate(String aModID, String aMaterialName, Material aMaterial, Block.SoundType aSoundType, String aTool, int aHarvestLevelOffset, int aHarvestLevelMinimum, int aHarvestLevelMaximum, boolean aOpaque, boolean aNormalCube) {
        aTool = aTool.toLowerCase();
        MultiTileEntityBlock rBlock = MULTI_BLOCK_MAP.get(aModID + ":" + MultiTileEntityBlock.getName(aMaterialName, aSoundType, aTool, aHarvestLevelOffset, aHarvestLevelMinimum, aHarvestLevelMaximum, aOpaque, aNormalCube));
        return rBlock == null ? new MultiTileEntityBlock(aModID, aMaterialName, aMaterial, aSoundType, aTool, aHarvestLevelOffset, aHarvestLevelMinimum, aHarvestLevelMaximum, aOpaque, aNormalCube) : rBlock;
    }

    protected MultiTileEntityBlock(String aModID, String aMaterialName, Material aMaterial, Block.SoundType aSoundType, String aTool, int aHarvestLevelOffset, int aHarvestLevelMinimum, int aHarvestLevelMaximum, boolean aOpaque, boolean aNormalCube) {
        super(aMaterial);
        if (GregTech_API.sPreloadFinished) {
            throw new IllegalStateException("Blocks can only be initialized within preInit!");
        }
        this.mNameInternal = MultiTileEntityBlock.getName(aMaterialName, aSoundType, aTool, aHarvestLevelOffset, aHarvestLevelMinimum, aHarvestLevelMaximum, aOpaque, aNormalCube);
        GameRegistry.registerBlock((Block)this, ItemBlock.class, (String)this.mNameInternal);
        MULTI_BLOCK_MAP.put(aModID + ":" + this.mNameInternal, this);
        this.func_149672_a(aSoundType);
        this.mOpaque = aOpaque;
        this.mNormalCube = aNormalCube;
        this.mTool = aTool.toLowerCase();
        this.mHarvestLevelOffset = aHarvestLevelOffset;
        this.mHarvestLevelMinimum = Math.max(0, aHarvestLevelMinimum);
        this.mHarvestLevelMaximum = Math.max(aHarvestLevelMinimum, aHarvestLevelMaximum);
        this.field_149787_q = this.func_149662_c();
        this.field_149786_r = this.func_149662_c() ? 255 : 0;
    }

    public final void func_149749_a(World aWorld, int aX, int aY, int aZ, Block aBlock, int aMetaData) {
        TileEntity aTileEntity = GT_Util.getTileEntity(aWorld, aX, aY, aZ, true);
        if (aTileEntity != null) {
            GT_Util.LAST_BROKEN_TILEENTITY.set(aTileEntity);
        }
        if (aTileEntity == null || !aTileEntity.shouldRefresh((Block)this, aBlock, aMetaData, aMetaData, aWorld, aX, aY, aZ)) {
            return;
        }
        if (aTileEntity instanceof IMultiTileEntity.IMTE_BreakBlock && ((IMultiTileEntity.IMTE_BreakBlock)aTileEntity).breakBlock()) {
            return;
        }
        if (aTileEntity instanceof IMultiTileEntity.IMTE_HasMultiBlockMachineRelevantData && ((IMultiTileEntity.IMTE_HasMultiBlockMachineRelevantData)aTileEntity).hasMultiBlockMachineRelevantData()) {
            GregTech_API.causeMachineUpdate(aWorld, aX, aY, aZ);
        }
        aWorld.func_147475_p(aX, aY, aZ);
    }

    @Override
    public ArrayList<String> getDebugInfo(EntityPlayer aPlayer, int aX, int aY, int aZ, int aLogLevel) {
        TileEntity aTileEntity = aPlayer.field_70170_p.func_147438_o(aX, aY, aZ);
        if (aTileEntity instanceof IDebugableTileEntity) {
            return ((IDebugableTileEntity)aTileEntity).getDebugInfo(aPlayer, aLogLevel);
        }
        return (ArrayList)Collections.emptyList();
    }

    public final boolean func_149730_j() {
        return this.mOpaque;
    }

    public final boolean func_149721_r() {
        return this.mNormalCube;
    }

    public final boolean func_149686_d() {
        return this.mOpaque || this.mNormalCube;
    }

    public int func_149645_b() {
        return GT_Renderer_Block.INSTANCE == null ? super.func_149645_b() : GT_Renderer_Block.INSTANCE.mRenderID;
    }

    public final float func_149712_f(World aWorld, int aX, int aY, int aZ) {
        TileEntity aTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_GetBlockHardness ? ((IMultiTileEntity.IMTE_GetBlockHardness)aTileEntity).getBlockHardness() : 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess aIBlockAccess, int aX, int aY, int aZ, int aSide) {
        return Textures.BlockIcons.MACHINE_LV_SIDE.getIcon();
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int aSide, int aMeta) {
        return Textures.BlockIcons.MACHINE_LV_SIDE.getIcon();
    }

    public final void func_149743_a(World aWorld, int aX, int aY, int aZ, AxisAlignedBB aAABB, List aList, Entity aEntity) {
        TileEntity aTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (aTileEntity instanceof IMultiTileEntity) {
            ((IMultiTileEntity)aTileEntity).addCollisionBoxesToList(aAABB, aList, aEntity);
        } else {
            super.func_149743_a(aWorld, aX, aY, aZ, aAABB, aList, aEntity);
        }
    }

    public final AxisAlignedBB func_149668_a(World aWorld, int aX, int aY, int aZ) {
        TileEntity aTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity ? ((IMultiTileEntity)aTileEntity).getCollisionBoundingBoxFromPool() : (aTileEntity == null ? null : super.func_149668_a(aWorld, aX, aY, aZ));
    }

    public final AxisAlignedBB func_149633_g(World aWorld, int aX, int aY, int aZ) {
        TileEntity aTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity ? ((IMultiTileEntity)aTileEntity).getSelectedBoundingBoxFromPool() : super.func_149633_g(aWorld, aX, aY, aZ);
    }

    public void func_149719_a(IBlockAccess blockAccess, int aX, int aY, int aZ) {
        TileEntity aTileEntity = blockAccess.func_147438_o(aX, aY, aZ);
        if (aTileEntity instanceof IMultiTileEntity) {
            ((IMultiTileEntity)aTileEntity).setBlockBoundsBasedOnState(this);
            return;
        }
        super.func_149719_a(blockAccess, aX, aY, aZ);
    }

    public final boolean func_149662_c() {
        return this.mOpaque;
    }

    public final void onNeighborChange(IBlockAccess aWorld, int aX, int aY, int aZ, int aTileX, int aTileY, int aTileZ) {
        TileEntity aTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (!LOCK) {
            LOCK = true;
            if (aTileEntity instanceof BaseTileEntity) {
                ((BaseTileEntity)aTileEntity).onAdjacentBlockChange(aTileX, aTileY, aTileZ);
            }
            LOCK = false;
        }
    }

    public void func_149695_a(World aWorld, int aX, int aY, int aZ, Block aBlock) {
        TileEntity aTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (!LOCK) {
            LOCK = true;
            if (aTileEntity instanceof BaseTileEntity) {
                ((BaseTileEntity)aTileEntity).onAdjacentBlockChange(aX, aY, aZ);
            }
            LOCK = false;
        }
        if (aTileEntity instanceof IMultiTileEntity.IMTE_OnNeighborBlockChange) {
            ((IMultiTileEntity.IMTE_OnNeighborBlockChange)aTileEntity).onNeighborBlockChange(aWorld, aBlock);
        }
        if (aTileEntity == null) {
            aWorld.func_147468_f(aX, aY, aZ);
        }
    }

    public final void func_149726_b(World aWorld, int aX, int aY, int aZ) {
        TileEntity aTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (aTileEntity instanceof IMultiTileEntity) {
            ((IMultiTileEntity)aTileEntity).onBlockAdded();
        }
    }

    public float func_149737_a(EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ) {
        TileEntity aTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity && ((IMultiTileEntity)aTileEntity).privateAccess() && !((IMultiTileEntity)aTileEntity).playerOwnsThis(aPlayer, true) ? -1.0f : super.func_149737_a(aPlayer, aWorld, aX, aY, aZ);
    }

    public final void func_149699_a(World aWorld, int aX, int aY, int aZ, EntityPlayer aPlayer) {
        TileEntity aTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (aTileEntity instanceof IMultiTileEntity) {
            ((IMultiTileEntity)aTileEntity).onLeftClick(aPlayer);
        } else {
            super.func_149699_a(aWorld, aX, aY, aZ, aPlayer);
        }
    }

    public boolean func_149727_a(World aWorld, int aX, int aY, int aZ, EntityPlayer aPlayer, int aSide, float aHitX, float aHitY, float aHitZ) {
        TileEntity aTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (aPlayer != null && ItemList.TC_Thaumometer.isStackEqual(aPlayer.func_70694_bm(), true, true)) {
            return false;
        }
        return aTileEntity instanceof IMultiTileEntity && ((IMultiTileEntity)aTileEntity).onBlockActivated(aPlayer, (byte)aSide, aHitX, aHitY, aHitZ);
    }

    public final int func_149709_b(IBlockAccess aWorld, int aX, int aY, int aZ, int aSide) {
        TileEntity aTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_IsProvidingWeakPower ? ((IMultiTileEntity.IMTE_IsProvidingWeakPower)aTileEntity).isProvidingWeakPower((byte)aSide) : super.func_149709_b(aWorld, aX, aY, aZ, aSide);
    }

    public final int func_149748_c(IBlockAccess aWorld, int aX, int aY, int aZ, int aSide) {
        TileEntity aTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_IsProvidingStrongPower ? ((IMultiTileEntity.IMTE_IsProvidingStrongPower)aTileEntity).isProvidingStrongPower((byte)aSide) : super.func_149748_c(aWorld, aX, aY, aZ, aSide);
    }

    public final boolean shouldCheckWeakPower(IBlockAccess aWorld, int aX, int aY, int aZ, int aSide) {
        TileEntity aTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_ShouldCheckWeakPower ? ((IMultiTileEntity.IMTE_ShouldCheckWeakPower)aTileEntity).shouldCheckWeakPower((byte)aSide) : this.isNormalCube(aWorld, aX, aY, aZ);
    }

    public final boolean getWeakChanges(IBlockAccess aWorld, int aX, int aY, int aZ) {
        TileEntity aTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_GetWeakChanges ? ((IMultiTileEntity.IMTE_GetWeakChanges)aTileEntity).getWeakChanges() : super.getWeakChanges(aWorld, aX, aY, aZ);
    }

    public final void func_149636_a(World aWorld, EntityPlayer aPlayer, int aX, int aY, int aZ, int aMeta) {
        if (aPlayer == null) {
            aPlayer = (EntityPlayer)this.harvesters.get();
        }
        aPlayer.func_71064_a(StatList.field_75934_C[MultiTileEntityBlock.func_149682_b((Block)this)], 1);
        aPlayer.func_71020_j(0.025f);
        boolean aSilkTouch = EnchantmentHelper.func_77502_d((EntityLivingBase)aPlayer);
        int aFortune = EnchantmentHelper.func_77517_e((EntityLivingBase)aPlayer);
        float aChance = 1.0f;
        TileEntity aTileEntity = GT_Util.getTileEntity(aWorld, aX, aY, aZ, true);
        if (aTileEntity instanceof IMultiTileEntity) {
            ArrayList<ItemStack> tList = ((IMultiTileEntity)aTileEntity).getDrops(aFortune, aSilkTouch);
            aChance = ForgeEventFactory.fireBlockHarvesting(tList, (World)aWorld, (Block)this, (int)aX, (int)aY, (int)aZ, (int)aMeta, (int)aFortune, (float)aChance, (boolean)aSilkTouch, (EntityPlayer)aPlayer);
            for (ItemStack tStack : tList) {
                if (!(XSTR.XSTR_INSTANCE.nextFloat() <= aChance)) continue;
                this.func_149642_a(aWorld, aX, aY, aZ, tStack);
            }
        }
    }

    @Override
    public ITexture[] getTexture(Block aBlock, byte aSide, int aRenderPass, boolean[] aShouldSideBeRendered) {
        return null;
    }

    @Override
    public ITexture[] getTexture(Block aBlock, byte aSide, boolean isActive, int aRenderPass) {
        return null;
    }

    @Override
    public int getRenderPasses(Block aBlock) {
        return 0;
    }

    @Override
    public boolean usesRenderPass(int aRenderPass) {
        return true;
    }

    @Override
    public boolean setBlockBounds(Block aBlock, int aRenderPass) {
        return false;
    }

    @Override
    public IRenderedBlock passRenderingToObject(ItemStack aStack) {
        return null;
    }

    @Override
    public IRenderedBlock passRenderingToObject(IBlockAccess aWorld, int aX, int aY, int aZ) {
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        return tTileEntity instanceof IRenderedBlock ? (IRenderedBlock)tTileEntity : null;
    }

    public final boolean func_149646_a(IBlockAccess aWorld, int aX, int aY, int aZ, int aSide) {
        TileEntity aTileEntity = aWorld.func_147438_o(aX - GT_Values.OFFX[aSide], aY - GT_Values.OFFY[aSide], aZ - GT_Values.OFFZ[aSide]);
        return aTileEntity instanceof IMultiTileEntity ? ((IMultiTileEntity)aTileEntity).shouldSideBeRendered((byte)aSide) : super.func_149646_a(aWorld, aX, aY, aZ, aSide);
    }

    public Block getFacade(IBlockAccess aWorld, int aX, int aY, int aZ, int side) {
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof CoverableTileEntity) {
            byte aSide = (byte)side;
            CoverableTileEntity tile = (CoverableTileEntity)tTileEntity;
            if (side != -1) {
                Block facadeBlock = tile.getCoverBehaviorAtSideNew(aSide).getFacadeBlock(aSide, tile.getCoverIDAtSide(aSide), tile.getComplexCoverDataAtSide(aSide), tile);
                if (facadeBlock != null) {
                    return facadeBlock;
                }
            } else {
                for (byte i = 0; i < 6; i = (byte)(i + 1)) {
                    Block facadeBlock = tile.getCoverBehaviorAtSideNew(i).getFacadeBlock(i, tile.getCoverIDAtSide(i), tile.getComplexCoverDataAtSide(i), tile);
                    if (facadeBlock == null) continue;
                    return facadeBlock;
                }
            }
        }
        return Blocks.field_150350_a;
    }

    public int getFacadeMetadata(IBlockAccess aWorld, int aX, int aY, int aZ, int side) {
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof CoverableTileEntity) {
            byte aSide = (byte)side;
            CoverableTileEntity tile = (CoverableTileEntity)tTileEntity;
            if (side != -1) {
                Block facadeBlock = tile.getCoverBehaviorAtSideNew(aSide).getFacadeBlock(aSide, tile.getCoverIDAtSide(aSide), tile.getComplexCoverDataAtSide(aSide), tile);
                if (facadeBlock != null) {
                    return tile.getCoverBehaviorAtSideNew(aSide).getFacadeMeta(aSide, tile.getCoverIDAtSide(aSide), tile.getComplexCoverDataAtSide(aSide), tile);
                }
            } else {
                for (byte i = 0; i < 6; i = (byte)(i + 1)) {
                    Block facadeBlock = tile.getCoverBehaviorAtSideNew(i).getFacadeBlock(i, tile.getCoverIDAtSide(i), tile.getComplexCoverDataAtSide(i), tile);
                    if (facadeBlock == null) continue;
                    return tile.getCoverBehaviorAtSideNew(i).getFacadeMeta(i, tile.getCoverIDAtSide(i), tile.getComplexCoverDataAtSide(i), tile);
                }
            }
        }
        return 0;
    }

    protected boolean func_149700_E() {
        return false;
    }

    public final boolean func_149744_f() {
        return !this.mNormalCube;
    }

    public final String func_149732_F() {
        return StatCollector.func_74838_a((String)(this.mNameInternal + ".name"));
    }

    public final String func_149739_a() {
        return this.mNameInternal;
    }

    public final boolean func_149696_a(World aWorld, int aX, int aY, int aZ, int aID, int aData) {
        TileEntity aTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        return aTileEntity == null || aTileEntity.func_145842_c(aID, aData);
    }

    public final void func_149666_a(Item aItem, CreativeTabs aCreativeTab, List aList) {
    }

    public boolean func_149740_M() {
        return true;
    }

    public final int func_149736_g(World aWorld, int aX, int aY, int aZ, int aSide) {
        TileEntity aTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_GetComparatorInputOverride ? ((IMultiTileEntity.IMTE_GetComparatorInputOverride)aTileEntity).getComparatorInputOverride((byte)aSide) : (aTileEntity instanceof IMultiTileEntity.IMTE_IsProvidingWeakPower ? ((IMultiTileEntity.IMTE_IsProvidingWeakPower)aTileEntity).isProvidingWeakPower(GT_Utility.getOppositeSide(aSide)) : super.func_149736_g(aWorld, aX, aY, aZ, aSide));
    }

    public final void func_149651_a(IIconRegister aIconRegister) {
    }

    public final boolean isNormalCube(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return this.mNormalCube;
    }

    public final boolean isSideSolid(IBlockAccess aWorld, int aX, int aY, int aZ, ForgeDirection aSide) {
        TileEntity aTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity ? ((IMultiTileEntity)aTileEntity).isSideSolid((byte)(aSide != null ? aSide.ordinal() : 6)) : this.mOpaque;
    }

    public boolean removedByPlayer(World aWorld, EntityPlayer aPlayer, int aX, int aY, int aZ, boolean aWillHarvest) {
        TileEntity aTileEntity = GT_Util.getTileEntity(aWorld, aX, aY, aZ, true);
        if (aTileEntity != null) {
            GT_Util.LAST_BROKEN_TILEENTITY.set(aTileEntity);
        }
        return super.removedByPlayer(aWorld, aPlayer, aX, aY, aZ, aWillHarvest);
    }

    public int getFlammability(IBlockAccess aWorld, int aX, int aY, int aZ, ForgeDirection face) {
        return 0;
    }

    public int getFireSpreadSpeed(IBlockAccess aWorld, int aX, int aY, int aZ, ForgeDirection face) {
        return GregTech_API.sMachineFlammable && aWorld.func_72805_g(aX, aY, aZ) == 0 ? 100 : 0;
    }

    public boolean hasTileEntity(int aMeta) {
        return true;
    }

    public final ArrayList<ItemStack> getDrops(World aWorld, int aX, int aY, int aZ, int aUnusableMetaData, int aFortune) {
        TileEntity aTileEntity = GT_Util.getTileEntity(aWorld, aX, aY, aZ, true);
        if (aTileEntity instanceof IMultiTileEntity) {
            return ((IMultiTileEntity)aTileEntity).getDrops(aFortune, false);
        }
        return new ArrayList<ItemStack>();
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess aWorld, int aX, int aY, int aZ) {
        return false;
    }

    public final float getExplosionResistance(Entity aExploder, World aWorld, int aX, int aY, int aZ, double aExplosionX, double aExplosionY, double aExplosionZ) {
        TileEntity aTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity ? ((IMultiTileEntity)aTileEntity).getExplosionResistance(aExploder, aExplosionX, aExplosionY, aExplosionZ) : 1.0f;
    }

    public final void onBlockExploded(World aWorld, int aX, int aY, int aZ, Explosion aExplosion) {
        if (aWorld.field_72995_K) {
            return;
        }
        TileEntity aTileEntity = GT_Util.getTileEntity(aWorld, aX, aY, aZ, true);
        if (aTileEntity != null) {
            GT_Util.LAST_BROKEN_TILEENTITY.set(aTileEntity);
        }
        if (aTileEntity instanceof IMultiTileEntity) {
            GT_Log.exp.printf("Explosion at : %d | %d | %d DIMID: %s due to near explosion!%n", aX, aY, aZ, aWorld.field_73011_w.field_76574_g);
            ((IMultiTileEntity)aTileEntity).onExploded(aExplosion);
        } else {
            aWorld.func_147468_f(aX, aY, aZ);
        }
    }

    public final boolean canConnectRedstone(IBlockAccess aWorld, int aX, int aY, int aZ, int aSide) {
        return true;
    }

    public final boolean recolourBlock(World aWorld, int aX, int aY, int aZ, ForgeDirection aSide, int aColor) {
        TileEntity aTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity && ((IMultiTileEntity)aTileEntity).recolourBlock((byte)aSide.ordinal(), (byte)aColor);
    }

    public final String getHarvestTool(int aMeta) {
        return this.mTool;
    }

    public final int getHarvestLevel(int aMeta) {
        return Math.max(this.mHarvestLevelMinimum, Math.min(this.mHarvestLevelMaximum, this.mHarvestLevelOffset + aMeta));
    }

    public final boolean isToolEffective(String aType, int aMeta) {
        return this.getHarvestTool(aMeta).equals(aType);
    }

    public final ItemStack getPickBlock(MovingObjectPosition aTarget, World aWorld, int aX, int aY, int aZ, EntityPlayer aPlayer) {
        TileEntity aTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity ? ((IMultiTileEntity)aTileEntity).getPickBlock(aTarget) : null;
    }

    public final ItemStack getPickBlock(MovingObjectPosition aTarget, World aWorld, int aX, int aY, int aZ) {
        TileEntity aTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity ? ((IMultiTileEntity)aTileEntity).getPickBlock(aTarget) : null;
    }

    public final void receiveMultiTileEntityData(IBlockAccess aWorld, int aX, short aY, int aZ, short aRID, short aID, int aCover0, int aCover1, int aCover2, int aCover3, int aCover4, int aCover5, byte aTextureData, byte aTexturePage, byte aUpdateData, byte aRedstoneData, byte aColorData) {
        if (!(aWorld instanceof World)) {
            return;
        }
        TileEntity aTileEntity = aWorld.func_147438_o(aX, (int)aY, aZ);
        if (!(aTileEntity instanceof IMultiTileEntity) || ((IMultiTileEntity)aTileEntity).getMultiTileEntityRegistryID() != aRID || ((IMultiTileEntity)aTileEntity).getMultiTileEntityID() != aID) {
            MultiTileEntityRegistry tRegistry = MultiTileEntityRegistry.getRegistry(aRID);
            if (tRegistry == null) {
                return;
            }
            aTileEntity = tRegistry.getNewTileEntity((World)aWorld, aX, (int)aY, aZ, aID);
            if (!(aTileEntity instanceof IMultiTileEntity)) {
                return;
            }
            GT_Util.setTileEntity((World)aWorld, aX, aY, aZ, aTileEntity, false);
        }
        IMultiTileEntity te = (IMultiTileEntity)aTileEntity;
        boolean updated = te.setCoverIDAtSideNoUpdate((byte)0, aCover0);
        updated |= te.setCoverIDAtSideNoUpdate((byte)1, aCover1);
        updated |= te.setCoverIDAtSideNoUpdate((byte)2, aCover2);
        updated |= te.setCoverIDAtSideNoUpdate((byte)3, aCover3);
        updated |= te.setCoverIDAtSideNoUpdate((byte)4, aCover4);
        if (updated |= te.setCoverIDAtSideNoUpdate((byte)5, aCover5)) {
            te.issueBlockUpdate();
        }
        te.receiveClientEvent(0, aTextureData);
        te.receiveClientEvent(1, aUpdateData & 0x7F);
        te.receiveClientEvent(1, aTexturePage | 0x80);
        te.receiveClientEvent(2, aColorData);
        te.receiveClientEvent(3, aRedstoneData);
    }

    public final TileEntity createTileEntity(World aWorld, int aMeta) {
        return null;
    }

    public TileEntity func_149915_a(World world, int i) {
        return null;
    }
}

