/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.multitileentity.multiblock.base;

import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.alignment.IAlignment;
import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.IAlignmentProvider;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.alignment.enumerable.ExtendedFacing;
import com.gtnewhorizon.structurelib.alignment.enumerable.Flip;
import com.gtnewhorizon.structurelib.alignment.enumerable.Rotation;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.util.Vec3Impl;
import cpw.mods.fml.common.network.NetworkRegistry;
import gnu.trove.list.array.TIntArrayList;
import gregtech.GT_Mod;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TextureSet;
import gregtech.api.interfaces.IDescribable;
import gregtech.api.interfaces.tileentity.IMachineProgress;
import gregtech.api.multitileentity.MultiTileEntityContainer;
import gregtech.api.multitileentity.MultiTileEntityRegistry;
import gregtech.api.multitileentity.interfaces.IMultiBlockController;
import gregtech.api.multitileentity.interfaces.IMultiBlockFluidHandler;
import gregtech.api.multitileentity.interfaces.IMultiBlockInventory;
import gregtech.api.multitileentity.interfaces.IMultiTileEntity;
import gregtech.api.multitileentity.machine.MultiTileBasicMachine;
import gregtech.api.multitileentity.multiblock.base.MultiBlockPart;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.input.Keyboard;

public abstract class MultiBlockController<T extends MultiBlockController<T>>
extends MultiTileBasicMachine
implements IAlignment,
IConstructable,
IMultiBlockController,
IDescribable,
IMachineProgress,
IMultiBlockFluidHandler,
IMultiBlockInventory,
IMultiTileEntity.IMTE_AddToolTips {
    private static final Map<Integer, GT_Multiblock_Tooltip_Builder> tooltip = new ConcurrentHashMap<Integer, GT_Multiblock_Tooltip_Builder>();
    protected BuildState buildState = new BuildState();
    protected List<ItemStack[]> multiBlockInventory = new ArrayList<ItemStack[]>();
    private int mMaxProgresstime = 0;
    private int mProgresstime = 0;
    private boolean mStructureOkay = false;
    private boolean mStructureChanged = false;
    private boolean mWorks = true;
    private boolean mWorkUpdate = false;
    private boolean mWasShutdown = false;
    private boolean mActive = false;
    private ExtendedFacing mExtendedFacing = ExtendedFacing.DEFAULT;
    private IAlignmentLimits mLimits = this.getInitialAlignmentLimits();

    public abstract short getCasingRegistryID();

    public abstract short getCasingMeta();

    protected abstract GT_Multiblock_Tooltip_Builder createTooltip();

    public abstract Vec3Impl getStartingStructureOffset();

    public abstract IStructureDefinition<T> getStructureDefinition();

    public abstract boolean checkMachine();

    public abstract boolean checkRecipe(ItemStack var1);

    @Override
    public void writeMultiTileNBT(NBTTagCompound aNBT) {
        super.writeMultiTileNBT(aNBT);
        aNBT.func_74757_a("gt.structure.ok", this.mStructureOkay);
        aNBT.func_74774_a("gt.eRotation", (byte)this.mExtendedFacing.getRotation().getIndex());
        aNBT.func_74774_a("gt.eFlip", (byte)this.mExtendedFacing.getFlip().getIndex());
    }

    @Override
    public void readMultiTileNBT(NBTTagCompound aNBT) {
        super.readMultiTileNBT(aNBT);
        if (this.mInventory != null) {
            this.multiBlockInventory.add(this.mInventory);
        }
        this.mStructureOkay = aNBT.func_74767_n("gt.structure.ok");
        this.mExtendedFacing = ExtendedFacing.of((ForgeDirection)ForgeDirection.getOrientation((int)this.getFrontFacing()), (Rotation)Rotation.byIndex((int)aNBT.func_74771_c("gt.eRotation")), (Flip)Flip.byIndex((int)aNBT.func_74771_c("gt.eFlip")));
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.addAll(Arrays.asList(this.getDescription()));
    }

    @Override
    public String[] getDescription() {
        if (Keyboard.isKeyDown((int)42)) {
            return this.getTooltip().getStructureInformation();
        }
        return this.getTooltip().getInformation();
    }

    @Override
    protected void addDebugInfo(EntityPlayer aPlayer, int aLogLevel, ArrayList<String> tList) {
        tList.add("Structure ok: " + this.checkStructure(false));
    }

    protected int getToolTipID() {
        return this.getMultiTileEntityRegistryID() << 16 + this.getMultiTileEntityID();
    }

    protected GT_Multiblock_Tooltip_Builder getTooltip() {
        return this.createTooltip();
    }

    @Override
    public boolean checkStructure(boolean aForceReset) {
        if (!this.isServerSide()) {
            return this.mStructureOkay;
        }
        if (this.mStructureChanged || aForceReset) {
            this.mStructureOkay = this.checkMachine();
        }
        this.mStructureChanged = false;
        return this.mStructureOkay;
    }

    @Override
    public void onStructureChange() {
        this.mStructureChanged = true;
    }

    public final boolean checkPiece(String piece, Vec3Impl offset) {
        return this.checkPiece(piece, offset.get0(), offset.get1(), offset.get2());
    }

    protected final boolean checkPiece(String piece, int horizontalOffset, int verticalOffset, int depthOffset) {
        return this.getCastedStructureDefinition().check((Object)this, piece, this.getWorld(), this.getExtendedFacing(), this.getXCoord(), (int)this.getYCoord(), this.getZCoord(), horizontalOffset, verticalOffset, depthOffset, !this.mStructureOkay);
    }

    public final boolean buildPiece(String piece, ItemStack trigger, boolean hintsOnly, Vec3Impl offset) {
        return this.buildPiece(piece, trigger, hintsOnly, offset.get0(), offset.get1(), offset.get2());
    }

    protected final boolean buildPiece(String piece, ItemStack trigger, boolean hintOnly, int horizontalOffset, int verticalOffset, int depthOffset) {
        return this.getCastedStructureDefinition().buildOrHints((Object)this, trigger, piece, this.getWorld(), this.getExtendedFacing(), this.getXCoord(), (int)this.getYCoord(), this.getZCoord(), horizontalOffset, verticalOffset, depthOffset, hintOnly);
    }

    private IStructureDefinition<MultiBlockController<T>> getCastedStructureDefinition() {
        return this.getStructureDefinition();
    }

    public ExtendedFacing getExtendedFacing() {
        return this.mExtendedFacing;
    }

    public void setExtendedFacing(ExtendedFacing newExtendedFacing) {
        if (this.mExtendedFacing != newExtendedFacing) {
            this.onStructureChange();
            if (this.mStructureOkay) {
                this.stopMachine();
            }
            this.mExtendedFacing = newExtendedFacing;
            this.mStructureOkay = false;
            if (this.isServerSide()) {
                StructureLibAPI.sendAlignment((IAlignmentProvider)this, (NetworkRegistry.TargetPoint)new NetworkRegistry.TargetPoint(this.getWorld().field_73011_w.field_76574_g, (double)this.getXCoord(), (double)this.getYCoord(), (double)this.getZCoord(), 512.0));
            } else {
                this.issueTextureUpdate();
            }
        }
    }

    @Override
    public boolean onWrenchRightClick(EntityPlayer aPlayer, ItemStack tCurrentItem, byte wrenchSide, float aX, float aY, float aZ) {
        if (wrenchSide != this.getFrontFacing()) {
            return super.onWrenchRightClick(aPlayer, tCurrentItem, wrenchSide, aX, aY, aZ);
        }
        if (aPlayer.func_70093_af()) {
            this.toolSetFlip(this.getFlip().isHorizontallyFlipped() ? Flip.NONE : Flip.HORIZONTAL);
        } else {
            this.toolSetRotation(null);
        }
        return true;
    }

    @Override
    public void onFirstTick(boolean aIsServerSide) {
        super.onFirstTick(aIsServerSide);
        if (aIsServerSide) {
            this.checkStructure(true);
        } else {
            StructureLibAPI.queryAlignment((IAlignmentProvider)this);
        }
    }

    @Override
    public void onPostTick(long aTick, boolean aIsServerSide) {
        if (aIsServerSide && aTick % 600L == 5L && !this.checkStructure(false)) {
            this.checkStructure(true);
        }
    }

    @Override
    public final boolean isFacingValid(byte aFacing) {
        return this.canSetToDirectionAny(ForgeDirection.getOrientation((int)aFacing));
    }

    @Override
    public void onFacingChange() {
        this.toolSetDirection(ForgeDirection.getOrientation((int)this.getFrontFacing()));
        this.onStructureChange();
    }

    @Override
    public boolean allowCoverOnSide(byte aSide, GT_ItemStack aCoverID) {
        return aSide != this.mFacing;
    }

    public String[] getStructureDescription(ItemStack stackSize) {
        return this.getTooltip().getStructureHint();
    }

    public IAlignmentLimits getAlignmentLimits() {
        return this.mLimits;
    }

    protected void setAlignmentLimits(IAlignmentLimits mLimits) {
        this.mLimits = mLimits;
    }

    @Override
    public int getProgress() {
        return this.mProgresstime;
    }

    @Override
    public int getMaxProgress() {
        return this.mMaxProgresstime;
    }

    @Override
    public boolean increaseProgress(int aProgressAmountInTicks) {
        return this.increaseProgressGetOverflow(aProgressAmountInTicks) != aProgressAmountInTicks;
    }

    @Override
    public FluidStack getDrainableFluid(byte aSide) {
        IFluidTank tank = this.getFluidTankDrainable(aSide, null);
        return tank == null ? null : tank.getFluid();
    }

    public int increaseProgressGetOverflow(int aProgress) {
        return 0;
    }

    @Override
    public boolean hasThingsToDo() {
        return this.getMaxProgress() > 0;
    }

    @Override
    public boolean hasWorkJustBeenEnabled() {
        return this.mWorkUpdate;
    }

    @Override
    public void enableWorking() {
        if (!this.mWorks) {
            this.mWorkUpdate = true;
        }
        this.mWorks = true;
        this.mWasShutdown = false;
    }

    @Override
    public void disableWorking() {
        this.mWorks = false;
    }

    @Override
    public boolean isAllowedToWork() {
        return this.mWorks;
    }

    @Override
    public boolean isActive() {
        return this.mActive;
    }

    @Override
    public void setActive(boolean aActive) {
        this.mActive = aActive;
    }

    @Override
    public boolean wasShutdown() {
        return this.mWasShutdown;
    }

    public void stopMachine() {
        this.disableWorking();
    }

    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> !f.isVerticallyFliped();
    }

    public <S> IStructureElement<S> addMultiTileCasing(final int aRegistryID, final int aBlockMeta, final int aModes) {
        return new IStructureElement<S>(){
            private final short[] DEFAULT = new short[]{255, 255, 255, 0};
            private IIcon[] mIcons = null;

            public boolean check(S t, World world, int x, int y, int z) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                if (!(tileEntity instanceof MultiBlockPart)) {
                    return false;
                }
                MultiBlockPart part = (MultiBlockPart)tileEntity;
                if (aRegistryID != part.getMultiTileEntityRegistryID() || aBlockMeta != part.getMultiTileEntityID()) {
                    return false;
                }
                IMultiBlockController tTarget = part.getTarget(false);
                if (tTarget != null && tTarget != MultiBlockController.this) {
                    return false;
                }
                part.setTarget(MultiBlockController.this, aModes);
                return true;
            }

            public boolean spawnHint(S t, World world, int x, int y, int z, ItemStack trigger) {
                if (this.mIcons == null) {
                    this.mIcons = new IIcon[6];
                    Arrays.fill(this.mIcons, TextureSet.SET_NONE.mTextures[OrePrefixes.block.mTextureIndex].getIcon());
                }
                short[] RGBA = this.DEFAULT;
                StructureLibAPI.hintParticleTinted((World)world, (int)x, (int)y, (int)z, (IIcon[])this.mIcons, (short[])RGBA);
                return true;
            }

            public boolean placeBlock(S t, World world, int x, int y, int z, ItemStack trigger) {
                MultiTileEntityRegistry tRegistry = MultiTileEntityRegistry.getRegistry(aRegistryID);
                MultiTileEntityContainer tContainer = tRegistry.getNewTileEntityContainer(world, x, y, z, aBlockMeta, null);
                if (tContainer == null) {
                    GT_Mod.GT_FML_LOGGER.error("NULL CONTAINER");
                    return false;
                }
                IMultiTileEntity te = (IMultiTileEntity)tContainer.mTileEntity;
                if (!(te instanceof MultiBlockPart)) {
                    GT_Mod.GT_FML_LOGGER.error("Not a multiblock part");
                    return false;
                }
                if (world.func_147465_d(x, y, z, (Block)tContainer.mBlock, 15 - tContainer.mBlockMetaData, 2)) {
                    tContainer.setMultiTile(world, x, y, z);
                    ((MultiBlockPart)te).setTarget(MultiBlockController.this, aModes);
                }
                return false;
            }

            public IIcon getTexture(OrePrefixes aBlock) {
                return TextureSet.SET_NONE.mTextures[OrePrefixes.block.mTextureIndex].getIcon();
            }
        };
    }

    protected IFluidTank getFluidTankFillable(MultiBlockPart aPart, byte aSide, FluidStack aFluidToFill) {
        return this.getFluidTankFillable(aSide, aFluidToFill);
    }

    protected IFluidTank getFluidTankDrainable(MultiBlockPart aPart, byte aSide, FluidStack aFluidToDrain) {
        return this.getFluidTankDrainable(aSide, aFluidToDrain);
    }

    protected IFluidTank[] getFluidTanks(MultiBlockPart aPart, byte aSide) {
        return this.getFluidTanks(aSide);
    }

    @Override
    public int fill(MultiBlockPart aPart, ForgeDirection aDirection, FluidStack aFluid, boolean aDoFill) {
        if (aFluid == null || aFluid.amount <= 0) {
            return 0;
        }
        IFluidTank tTank = this.getFluidTankFillable(aPart, (byte)aDirection.ordinal(), aFluid);
        if (tTank == null) {
            return 0;
        }
        int rFilledAmount = tTank.fill(aFluid, aDoFill);
        if (rFilledAmount > 0 && aDoFill) {
            this.mInventoryChanged = true;
        }
        return rFilledAmount;
    }

    @Override
    public FluidStack drain(MultiBlockPart aPart, ForgeDirection aDirection, FluidStack aFluid, boolean aDoDrain) {
        if (aFluid == null || aFluid.amount <= 0) {
            return null;
        }
        IFluidTank tTank = this.getFluidTankDrainable(aPart, (byte)aDirection.ordinal(), aFluid);
        if (tTank == null || tTank.getFluid() == null || tTank.getFluidAmount() == 0 || !tTank.getFluid().isFluidEqual(aFluid)) {
            return null;
        }
        FluidStack rDrained = tTank.drain(aFluid.amount, aDoDrain);
        if (rDrained != null && aDoDrain) {
            this.markInventoryBeenModified();
        }
        return rDrained;
    }

    @Override
    public FluidStack drain(MultiBlockPart aPart, ForgeDirection aDirection, int aAmountToDrain, boolean aDoDrain) {
        if (aAmountToDrain <= 0) {
            return null;
        }
        IFluidTank tTank = this.getFluidTankDrainable(aPart, (byte)aDirection.ordinal(), null);
        if (tTank == null || tTank.getFluid() == null || tTank.getFluidAmount() == 0) {
            return null;
        }
        FluidStack rDrained = tTank.drain(aAmountToDrain, aDoDrain);
        if (rDrained != null && aDoDrain) {
            this.markInventoryBeenModified();
        }
        return rDrained;
    }

    @Override
    public boolean canFill(MultiBlockPart aPart, ForgeDirection aDirection, Fluid aFluid) {
        if (aFluid == null) {
            return false;
        }
        IFluidTank tTank = this.getFluidTankFillable(aPart, (byte)aDirection.ordinal(), new FluidStack(aFluid, 0));
        return tTank != null && (tTank.getFluid() == null || tTank.getFluid().getFluid() == aFluid);
    }

    @Override
    public boolean canDrain(MultiBlockPart aPart, ForgeDirection aDirection, Fluid aFluid) {
        if (aFluid == null) {
            return false;
        }
        IFluidTank tTank = this.getFluidTankDrainable(aPart, (byte)aDirection.ordinal(), new FluidStack(aFluid, 0));
        return tTank != null && tTank.getFluid() != null && tTank.getFluid().getFluid() == aFluid;
    }

    @Override
    public FluidTankInfo[] getTankInfo(MultiBlockPart aPart, ForgeDirection aDirection) {
        IFluidTank[] tTanks = this.getFluidTanks(aPart, (byte)aDirection.ordinal());
        if (tTanks == null || tTanks.length <= 0) {
            return GT_Values.emptyFluidTankInfo;
        }
        FluidTankInfo[] rInfo = new FluidTankInfo[tTanks.length];
        for (int i = 0; i < tTanks.length; ++i) {
            rInfo[i] = new FluidTankInfo(tTanks[i]);
        }
        return rInfo;
    }

    @Override
    public boolean isUniversalEnergyStored(MultiBlockPart aPart, long aEnergyAmount) {
        return this.getUniversalEnergyStored(aPart) >= aEnergyAmount;
    }

    @Override
    public long getUniversalEnergyStored(MultiBlockPart aPart) {
        return Math.min(this.getUniversalEnergyStored(), this.getUniversalEnergyCapacity());
    }

    @Override
    public long getUniversalEnergyCapacity(MultiBlockPart aPart) {
        return this.getUniversalEnergyCapacity();
    }

    @Override
    public long getOutputAmperage(MultiBlockPart aPart) {
        return this.getOutputAmperage();
    }

    @Override
    public long getOutputVoltage(MultiBlockPart aPart) {
        return this.getOutputVoltage();
    }

    @Override
    public long getInputAmperage(MultiBlockPart aPart) {
        return this.getInputAmperage();
    }

    @Override
    public long getInputVoltage(MultiBlockPart aPart) {
        return this.getInputVoltage();
    }

    @Override
    public boolean decreaseStoredEnergyUnits(MultiBlockPart aPart, long aEnergy, boolean aIgnoreTooLittleEnergy) {
        return this.decreaseStoredEnergyUnits(aEnergy, aIgnoreTooLittleEnergy);
    }

    @Override
    public boolean increaseStoredEnergyUnits(MultiBlockPart aPart, long aEnergy, boolean aIgnoreTooMuchEnergy) {
        return this.increaseStoredEnergyUnits(aEnergy, aIgnoreTooMuchEnergy);
    }

    @Override
    public boolean drainEnergyUnits(MultiBlockPart aPart, byte aSide, long aVoltage, long aAmperage) {
        return this.drainEnergyUnits(aSide, aVoltage, aAmperage);
    }

    @Override
    public long injectEnergyUnits(MultiBlockPart aPart, byte aSide, long aVoltage, long aAmperage) {
        return this.injectEnergyUnits(aSide, aVoltage, aAmperage);
    }

    @Override
    public long getAverageElectricInput(MultiBlockPart aPart) {
        return this.getAverageElectricInput();
    }

    @Override
    public long getAverageElectricOutput(MultiBlockPart aPart) {
        return this.getAverageElectricOutput();
    }

    @Override
    public long getStoredEU(MultiBlockPart aPart) {
        return this.getStoredEU();
    }

    @Override
    public long getEUCapacity(MultiBlockPart aPart) {
        return this.getEUCapacity();
    }

    @Override
    public boolean inputEnergyFrom(MultiBlockPart aPart, byte aSide) {
        if (aSide == 6) {
            return true;
        }
        if (aSide >= 0 && aSide < 6) {
            if (this.func_145837_r()) {
                return false;
            }
            if (this.isEnetInput()) {
                return this.isEnergyInputSide(aSide);
            }
        }
        return false;
    }

    @Override
    public boolean outputsEnergyTo(MultiBlockPart aPart, byte aSide) {
        if (aSide == 6) {
            return true;
        }
        if (aSide >= 0 && aSide < 6) {
            if (this.func_145837_r()) {
                return false;
            }
            if (this.isEnetOutput()) {
                return this.isEnergyOutputSide(aSide);
            }
        }
        return false;
    }

    @Override
    public boolean hasInventoryBeenModified(MultiBlockPart aPart) {
        return this.hasInventoryBeenModified();
    }

    @Override
    public boolean isValidSlot(MultiBlockPart aPart, int aIndex) {
        return false;
    }

    @Override
    public boolean addStackToSlot(MultiBlockPart aPart, int aIndex, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean addStackToSlot(MultiBlockPart aPart, int aIndex, ItemStack aStack, int aAmount) {
        return false;
    }

    protected Pair<ItemStack[], Integer> getInventory(int lockedInventory, int aSlot) {
        if (lockedInventory != -1) {
            return new ImmutablePair((Object)this.multiBlockInventory.get(lockedInventory), (Object)aSlot);
        }
        int start = 0;
        for (ItemStack[] inv : this.multiBlockInventory) {
            if (aSlot > start && aSlot < start + inv.length) {
                return new ImmutablePair((Object)inv, (Object)(aSlot - start));
            }
            start += inv.length;
        }
        return null;
    }

    @Override
    public int[] getAccessibleSlotsFromSide(MultiBlockPart aPart, byte aSide) {
        TIntArrayList tList = new TIntArrayList();
        int lockedInventory = aPart.getLockedInventory();
        int start = 0;
        if (lockedInventory == -1) {
            for (ItemStack[] inv : this.multiBlockInventory) {
                for (int i = start; i < inv.length + start; ++i) {
                    tList.add(i);
                }
                start += inv.length;
            }
        } else {
            int len = this.multiBlockInventory.get(lockedInventory).length;
            for (int i = 0; i < len; ++i) {
                tList.add(i);
            }
        }
        return tList.toArray();
    }

    @Override
    public boolean canInsertItem(MultiBlockPart aPart, int aSlot, ItemStack aStack, byte aSide) {
        int tSlot;
        ItemStack[] inv;
        int lockedInventory = aPart.getLockedInventory();
        if (lockedInventory == -1) {
            Pair<ItemStack[], Integer> tInv = this.getInventory(lockedInventory, aSlot);
            if (tInv == null) {
                return false;
            }
            inv = (ItemStack[])tInv.getLeft();
            tSlot = (Integer)tInv.getRight();
        } else {
            inv = this.multiBlockInventory.get(lockedInventory);
            tSlot = aSlot;
        }
        return inv[tSlot] == null || GT_Utility.areStacksEqual(aStack, inv[tSlot]);
    }

    @Override
    public boolean canExtractItem(MultiBlockPart aPart, int aSlot, ItemStack aStack, byte aSide) {
        int tSlot;
        ItemStack[] inv;
        int lockedInventory = aPart.getLockedInventory();
        if (lockedInventory == -1) {
            Pair<ItemStack[], Integer> tInv = this.getInventory(lockedInventory, aSlot);
            if (tInv == null) {
                return false;
            }
            inv = (ItemStack[])tInv.getLeft();
            tSlot = (Integer)tInv.getRight();
        } else {
            inv = this.multiBlockInventory.get(lockedInventory);
            tSlot = aSlot;
        }
        return inv[tSlot] != null;
    }

    @Override
    public int getSizeInventory(MultiBlockPart aPart) {
        int lockedInventory = aPart.getLockedInventory();
        if (lockedInventory == -1) {
            int len = 0;
            for (ItemStack[] inv : this.multiBlockInventory) {
                len += inv.length;
            }
            return len;
        }
        return this.multiBlockInventory.get(lockedInventory).length;
    }

    @Override
    public ItemStack getStackInSlot(MultiBlockPart aPart, int aSlot) {
        int tSlot;
        ItemStack[] inv;
        int lockedInventory = aPart.getLockedInventory();
        if (lockedInventory == -1) {
            Pair<ItemStack[], Integer> tInv = this.getInventory(lockedInventory, aSlot);
            if (tInv == null) {
                return null;
            }
            inv = (ItemStack[])tInv.getLeft();
            tSlot = (Integer)tInv.getRight();
        } else {
            inv = this.multiBlockInventory.get(lockedInventory);
            tSlot = aSlot;
        }
        return inv[tSlot];
    }

    @Override
    public ItemStack decrStackSize(MultiBlockPart aPart, int aSlot, int aDecrement) {
        ItemStack tStack = this.getStackInSlot(aPart, aSlot);
        ItemStack rStack = GT_Utility.copyOrNull(tStack);
        if (tStack != null) {
            if (tStack.field_77994_a <= aDecrement) {
                this.func_70299_a(aSlot, null);
            } else {
                rStack = tStack.func_77979_a(aDecrement);
                if (tStack.field_77994_a == 0) {
                    this.func_70299_a(aSlot, null);
                }
            }
        }
        return rStack;
    }

    @Override
    public ItemStack getStackInSlotOnClosing(MultiBlockPart aPart, int aSlot) {
        Pair<ItemStack[], Integer> tInv = this.getInventory(aPart.getLockedInventory(), aSlot);
        if (tInv == null) {
            return null;
        }
        ItemStack[] inv = (ItemStack[])tInv.getLeft();
        int tSlot = (Integer)tInv.getRight();
        ItemStack rStack = inv[tSlot];
        inv[tSlot] = null;
        return rStack;
    }

    @Override
    public void setInventorySlotContents(MultiBlockPart aPart, int aSlot, ItemStack aStack) {
        Pair<ItemStack[], Integer> tInv = this.getInventory(aPart.getLockedInventory(), aSlot);
        if (tInv == null) {
            return;
        }
        ItemStack[] inv = (ItemStack[])tInv.getLeft();
        int tSlot = (Integer)tInv.getRight();
        inv[tSlot] = aStack;
    }

    @Override
    public String getInventoryName(MultiBlockPart aPart) {
        return this.func_145825_b();
    }

    @Override
    public boolean hasCustomInventoryName(MultiBlockPart aPart) {
        return this.func_145818_k_();
    }

    @Override
    public int getInventoryStackLimit(MultiBlockPart aPart) {
        return this.func_70297_j_();
    }

    @Override
    public void markDirty(MultiBlockPart aPart) {
        this.func_70296_d();
        this.markInventoryBeenModified();
    }

    @Override
    public boolean isUseableByPlayer(MultiBlockPart aPart, EntityPlayer aPlayer) {
        return this.func_70300_a(aPlayer);
    }

    @Override
    public void openInventory(MultiBlockPart aPart) {
        this.func_70295_k_();
    }

    @Override
    public void closeInventory(MultiBlockPart aPart) {
        this.func_70305_f();
    }

    @Override
    public boolean isItemValidForSlot(MultiBlockPart aPart, int aSlot, ItemStack aStack) {
        return this.func_94041_b(aSlot, aStack);
    }

    public static class BuildState {
        boolean building = false;
        Vec3Impl currentOffset;

        public void startBuilding(Vec3Impl structureOffset) {
            if (this.building) {
                throw new IllegalStateException("Already building!");
            }
            this.building = true;
            this.setCurrentOffset(structureOffset);
        }

        public Vec3Impl setCurrentOffset(Vec3Impl structureOffset) {
            this.verifyBuilding();
            this.currentOffset = structureOffset;
            return this.currentOffset;
        }

        private void verifyBuilding() {
            if (!this.building) {
                throw new IllegalStateException("Not building!");
            }
        }

        public boolean failBuilding() {
            this.building = false;
            this.currentOffset = null;
            return false;
        }

        public Vec3Impl stopBuilding() {
            Vec3Impl toReturn = this.getCurrentOffset();
            this.building = false;
            this.currentOffset = null;
            return toReturn;
        }

        public Vec3Impl getCurrentOffset() {
            this.verifyBuilding();
            return this.currentOffset;
        }

        public Vec3Impl addOffset(Vec3Impl offset) {
            this.verifyBuilding();
            return this.setCurrentOffset(this.currentOffset.add(offset));
        }
    }
}

