/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.net;

import com.google.common.io.ByteArrayDataInput;
import gregtech.api.GregTech_API;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.metatileentity.CoverableTileEntity;
import gregtech.api.net.GT_Packet_New;
import gregtech.api.util.ISerializableObject;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;

public class GT_Packet_SendCoverData
extends GT_Packet_New {
    protected int mX;
    protected short mY;
    protected int mZ;
    protected byte side;
    protected int coverID;
    protected ISerializableObject coverData;

    public GT_Packet_SendCoverData() {
        super(true);
    }

    public GT_Packet_SendCoverData(int mX, short mY, int mZ, byte coverSide, int coverID, ISerializableObject coverData) {
        super(false);
        this.mX = mX;
        this.mY = mY;
        this.mZ = mZ;
        this.side = coverSide;
        this.coverID = coverID;
        this.coverData = coverData;
    }

    public GT_Packet_SendCoverData(byte coverSide, int coverID, ISerializableObject coverData, ICoverable tile) {
        super(false);
        this.mX = tile.getXCoord();
        this.mY = tile.getYCoord();
        this.mZ = tile.getZCoord();
        this.side = coverSide;
        this.coverID = coverID;
        this.coverData = coverData;
    }

    @Override
    public byte getPacketID() {
        return 16;
    }

    @Override
    public void encode(ByteBuf aOut) {
        aOut.writeInt(this.mX);
        aOut.writeShort((int)this.mY);
        aOut.writeInt(this.mZ);
        aOut.writeByte((int)this.side);
        aOut.writeInt(this.coverID);
        this.coverData.writeToByteBuf(aOut);
    }

    @Override
    public GT_Packet_New decode(ByteArrayDataInput aData) {
        int coverId = aData.readInt();
        return new GT_Packet_SendCoverData(aData.readInt(), aData.readShort(), aData.readInt(), aData.readByte(), coverId, GregTech_API.getCoverBehaviorNew(coverId).createDataObject().readFromPacket(aData, null));
    }

    @Override
    public void process(IBlockAccess aWorld) {
        TileEntity tile;
        if (aWorld != null && (tile = aWorld.func_147438_o(this.mX, (int)this.mY, this.mZ)) instanceof CoverableTileEntity && !((CoverableTileEntity)tile).isDead()) {
            ((CoverableTileEntity)tile).receiveCoverData(this.side, this.coverID, this.coverData, null);
        }
    }
}

