/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.net;

import com.google.common.io.ByteArrayDataInput;
import gregtech.api.GregTech_API;
import gregtech.api.gui.GT_GUICover;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.net.GT_Packet_New;
import gregtech.api.util.GT_CoverBehaviorBase;
import gregtech.api.util.ISerializableObject;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class GT_Packet_TileEntityCoverGUI
extends GT_Packet_New {
    protected int mX;
    protected short mY;
    protected int mZ;
    protected byte side;
    protected int coverID;
    protected int dimID;
    protected int playerID;
    protected ISerializableObject coverData;
    protected int parentGuiId;

    public GT_Packet_TileEntityCoverGUI() {
        super(true);
    }

    public GT_Packet_TileEntityCoverGUI(int mX, short mY, int mZ, byte coverSide, int coverID, int coverData, int dimID, int playerID) {
        super(false);
        this.mX = mX;
        this.mY = mY;
        this.mZ = mZ;
        this.side = coverSide;
        this.coverID = coverID;
        this.coverData = new ISerializableObject.LegacyCoverData(coverData);
        this.dimID = dimID;
        this.playerID = playerID;
        this.parentGuiId = -1;
    }

    public GT_Packet_TileEntityCoverGUI(int mX, short mY, int mZ, byte coverSide, int coverID, ISerializableObject coverData, int dimID, int playerID) {
        super(false);
        this.mX = mX;
        this.mY = mY;
        this.mZ = mZ;
        this.side = coverSide;
        this.coverID = coverID;
        this.coverData = coverData;
        this.dimID = dimID;
        this.playerID = playerID;
        this.parentGuiId = -1;
    }

    public GT_Packet_TileEntityCoverGUI(int mX, short mY, int mZ, byte coverSide, int coverID, ISerializableObject coverData, int dimID, int playerID, int parentGuiId) {
        super(false);
        this.mX = mX;
        this.mY = mY;
        this.mZ = mZ;
        this.side = coverSide;
        this.coverID = coverID;
        this.coverData = coverData;
        this.dimID = dimID;
        this.playerID = playerID;
        this.parentGuiId = parentGuiId;
    }

    public GT_Packet_TileEntityCoverGUI(byte side, int coverID, int coverData, ICoverable tile, EntityPlayerMP aPlayer) {
        super(false);
        this.mX = tile.getXCoord();
        this.mY = tile.getYCoord();
        this.mZ = tile.getZCoord();
        this.side = side;
        this.coverID = coverID;
        this.coverData = new ISerializableObject.LegacyCoverData(coverData);
        this.dimID = tile.getWorld().field_73011_w.field_76574_g;
        this.playerID = aPlayer.func_145782_y();
        this.parentGuiId = -1;
    }

    public GT_Packet_TileEntityCoverGUI(byte coverSide, int coverID, int coverData, IGregTechTileEntity tile) {
        super(false);
        this.mX = tile.getXCoord();
        this.mY = tile.getYCoord();
        this.mZ = tile.getZCoord();
        this.side = coverSide;
        this.coverID = coverID;
        this.coverData = new ISerializableObject.LegacyCoverData(coverData);
        this.dimID = tile.getWorld().field_73011_w.field_76574_g;
        this.parentGuiId = -1;
    }

    public GT_Packet_TileEntityCoverGUI(byte side, int coverID, ISerializableObject coverData, ICoverable tile, EntityPlayerMP aPlayer) {
        super(false);
        this.mX = tile.getXCoord();
        this.mY = tile.getYCoord();
        this.mZ = tile.getZCoord();
        this.side = side;
        this.coverID = coverID;
        this.coverData = coverData.copy();
        this.dimID = tile.getWorld().field_73011_w.field_76574_g;
        this.playerID = aPlayer.func_145782_y();
        this.parentGuiId = -1;
    }

    @Override
    public byte getPacketID() {
        return 7;
    }

    @Override
    public void encode(ByteBuf aOut) {
        aOut.writeInt(this.mX);
        aOut.writeShort((int)this.mY);
        aOut.writeInt(this.mZ);
        aOut.writeByte((int)this.side);
        aOut.writeInt(this.coverID);
        this.coverData.writeToByteBuf(aOut);
        aOut.writeInt(this.dimID);
        aOut.writeInt(this.playerID);
        aOut.writeInt(this.parentGuiId);
    }

    @Override
    public GT_Packet_New decode(ByteArrayDataInput aData) {
        int coverID = aData.readInt();
        return new GT_Packet_TileEntityCoverGUI(aData.readInt(), aData.readShort(), aData.readInt(), aData.readByte(), coverID, GregTech_API.getCoverBehaviorNew(coverID).createDataObject().readFromPacket(aData, null), aData.readInt(), aData.readInt(), aData.readInt());
    }

    @Override
    public void process(IBlockAccess aWorld) {
        if (aWorld instanceof World) {
            EntityPlayer thePlayer = (EntityPlayer)((World)aWorld).func_73045_a(this.playerID);
            TileEntity tile = aWorld.func_147438_o(this.mX, (int)this.mY, this.mZ);
            if (tile instanceof IGregTechTileEntity && !((IGregTechTileEntity)tile).isDead()) {
                IGregTechTileEntity gtTile = (IGregTechTileEntity)tile;
                gtTile.setCoverDataAtSide(this.side, this.coverData);
                GuiScreen gui = (GuiScreen)this.getCoverGUI(this.side, thePlayer, thePlayer.field_70170_p, gtTile);
                if (gui instanceof GT_GUICover) {
                    ((GT_GUICover)gui).setParentGuiId(this.parentGuiId);
                }
                Minecraft.func_71410_x().func_147108_a(gui);
            }
        }
    }

    private Object getCoverGUI(byte aSide, EntityPlayer aPlayer, World aWorld, IGregTechTileEntity aGtTile) {
        GT_CoverBehaviorBase<?> cover = aGtTile.getCoverBehaviorAtSideNew(aSide);
        if (cover.hasCoverGUI()) {
            return cover.getClientGUI(aSide, aGtTile.getCoverIDAtSide(aSide), aGtTile.getComplexCoverDataAtSide(aSide), aGtTile, aPlayer, aWorld);
        }
        return null;
    }
}

