/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.net;

import com.google.common.io.ByteArrayDataInput;
import gregtech.api.GregTech_API;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.net.GT_Packet_New;
import gregtech.api.util.ISerializableObject;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class GT_Packet_TileEntityCoverNew
extends GT_Packet_New {
    protected int mX;
    protected short mY;
    protected int mZ;
    protected byte side;
    protected int coverID;
    protected int dimID;
    protected ISerializableObject coverData;
    protected EntityPlayerMP mPlayer;

    public GT_Packet_TileEntityCoverNew() {
        super(true);
    }

    public GT_Packet_TileEntityCoverNew(int mX, short mY, int mZ, byte coverSide, int coverID, ISerializableObject coverData, int dimID) {
        super(false);
        this.mX = mX;
        this.mY = mY;
        this.mZ = mZ;
        this.side = coverSide;
        this.coverID = coverID;
        this.coverData = coverData;
        this.dimID = dimID;
    }

    public GT_Packet_TileEntityCoverNew(byte coverSide, int coverID, ISerializableObject coverData, ICoverable tile) {
        super(false);
        this.mX = tile.getXCoord();
        this.mY = tile.getYCoord();
        this.mZ = tile.getZCoord();
        this.side = coverSide;
        this.coverID = coverID;
        this.coverData = coverData;
        this.dimID = tile.getWorld().field_73011_w.field_76574_g;
    }

    @Override
    public byte getPacketID() {
        return 11;
    }

    @Override
    public void setINetHandler(INetHandler aHandler) {
        if (aHandler instanceof NetHandlerPlayServer) {
            this.mPlayer = ((NetHandlerPlayServer)aHandler).field_147369_b;
        }
    }

    @Override
    public void encode(ByteBuf aOut) {
        aOut.writeInt(this.mX);
        aOut.writeShort((int)this.mY);
        aOut.writeInt(this.mZ);
        aOut.writeByte((int)this.side);
        aOut.writeInt(this.coverID);
        this.coverData.writeToByteBuf(aOut);
        aOut.writeInt(this.dimID);
    }

    @Override
    public GT_Packet_New decode(ByteArrayDataInput aData) {
        int coverId = aData.readInt();
        return new GT_Packet_TileEntityCoverNew(aData.readInt(), aData.readShort(), aData.readInt(), aData.readByte(), coverId, GregTech_API.getCoverBehaviorNew(coverId).createDataObject().readFromPacket(aData, this.mPlayer), aData.readInt());
    }

    @Override
    public void process(IBlockAccess aWorld) {
        TileEntity tile;
        if (this.mPlayer == null) {
            return;
        }
        WorldServer world = DimensionManager.getWorld((int)this.dimID);
        if (world != null && (tile = world.func_147438_o(this.mX, (int)this.mY, this.mZ)) instanceof IGregTechTileEntity && !((IGregTechTileEntity)tile).isDead()) {
            ((IGregTechTileEntity)tile).receiveCoverData(this.side, this.coverID, this.coverData, this.mPlayer);
        }
    }
}

