/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import cpw.mods.fml.common.ProgressManager;
import gregtech.GT_Mod;
import gregtech.api.enums.Materials;
import gregtech.common.GT_Proxy;
import gregtech.loaders.postload.GT_PostLoad;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;

public class GT_CLS_Compat {
    private static Class alexiilMinecraftDisplayer;
    private static Class alexiilProgressDisplayer;
    private static Class cpwProgressBar;
    private static Method getLastPercent;
    private static Method displayProgress;
    private static Field isReplacingVanillaMaterials;
    private static Field isRegisteringGTmaterials;
    private static Field progressBarStep;

    private GT_CLS_Compat() {
    }

    private static <T> void registerAndReportProgression(String materialsType, Collection<T> materials, ProgressManager.ProgressBar progressBar, Function<T, Object> getName, Consumer<T> action) {
        int sizeStep = materials.size();
        long progressionReportsEvery = 100L;
        long bakingMsgEvery = 1000L;
        long nextProgressionReportAt = 0L;
        long nextBakingMsgAt = 0L;
        int currentStep = 0;
        for (T m : materials) {
            long now = System.currentTimeMillis();
            if (nextProgressionReportAt < now) {
                nextProgressionReportAt = now + 100L;
                String materialName = getName.apply(m).toString();
                try {
                    displayProgress.invoke(null, materialName, Float.valueOf((float)currentStep / (float)sizeStep));
                }
                catch (IllegalAccessException | InvocationTargetException iae) {
                    GT_Mod.GT_FML_LOGGER.error("While updating progression", (Throwable)iae);
                }
                try {
                    progressBarStep.set(progressBar, currentStep);
                }
                catch (IllegalAccessException iae) {
                    GT_Mod.GT_FML_LOGGER.error("While updating intermediate progression steps number", (Throwable)iae);
                }
                progressBar.step(materialName);
            }
            if (nextBakingMsgAt < now) {
                nextBakingMsgAt = now + 1000L;
                GT_Mod.GT_FML_LOGGER.info(String.format("%s - Baking: %d%%", materialsType, currentStep * 100 / sizeStep));
            }
            action.accept(m);
            ++currentStep;
        }
        GT_Mod.GT_FML_LOGGER.info(String.format("%s - Baking: Done", materialsType));
        try {
            progressBarStep.set(progressBar, currentStep);
        }
        catch (IllegalAccessException iae) {
            GT_Mod.GT_FML_LOGGER.error("While updating final progression steps number", (Throwable)iae);
        }
    }

    public static void stepMaterialsCLS(Collection<GT_Proxy.OreDictEventContainer> mEvents, ProgressManager.ProgressBar progressBar) throws IllegalAccessException, InvocationTargetException {
        try {
            isRegisteringGTmaterials.set(null, true);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            GT_Mod.GT_FML_LOGGER.catching((Throwable)e);
        }
        GT_CLS_Compat.registerAndReportProgression("GregTech materials", mEvents, progressBar, m -> m.mMaterial, m -> GT_Proxy.registerRecipes(m));
        ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
        isRegisteringGTmaterials.set(null, false);
    }

    public static void doActualRegistrationCLS(ProgressManager.ProgressBar progressBar, Set<Materials> replacedVanillaItemsSet) throws InvocationTargetException, IllegalAccessException {
        try {
            isReplacingVanillaMaterials.set(null, true);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            GT_Mod.GT_FML_LOGGER.catching((Throwable)e);
        }
        GT_CLS_Compat.registerAndReportProgression("Vanilla materials", replacedVanillaItemsSet, progressBar, m -> m.mDefaultLocalName, m -> GT_PostLoad.doActualRegistration(m));
    }

    public static void pushToDisplayProgress() throws InvocationTargetException, IllegalAccessException {
        isReplacingVanillaMaterials.set(null, false);
        displayProgress.invoke(null, "Post Initialization: loading GregTech", getLastPercent.invoke(null, new Object[0]));
    }

    static {
        try {
            alexiilMinecraftDisplayer = Class.forName("alexiil.mods.load.MinecraftDisplayer");
            alexiilProgressDisplayer = Class.forName("alexiil.mods.load.ProgressDisplayer");
        }
        catch (ClassNotFoundException ex) {
            GT_Mod.GT_FML_LOGGER.catching((Throwable)ex);
        }
        try {
            cpwProgressBar = Class.forName("cpw.mods.fml.common.ProgressManager$ProgressBar");
        }
        catch (ClassNotFoundException ex) {
            GT_Mod.GT_FML_LOGGER.catching((Throwable)ex);
        }
        Optional.ofNullable(alexiilMinecraftDisplayer).ifPresent(e -> {
            try {
                getLastPercent = e.getMethod("getLastPercent", new Class[0]);
                isReplacingVanillaMaterials = e.getField("isReplacingVanillaMaterials");
                isRegisteringGTmaterials = e.getField("isRegisteringGTmaterials");
            }
            catch (NoSuchFieldException | NoSuchMethodException ex) {
                GT_Mod.GT_FML_LOGGER.catching((Throwable)ex);
            }
        });
        Optional.ofNullable(alexiilProgressDisplayer).ifPresent(e -> {
            try {
                displayProgress = e.getMethod("displayProgress", String.class, Float.TYPE);
            }
            catch (NoSuchMethodException ex) {
                GT_Mod.GT_FML_LOGGER.catching((Throwable)ex);
            }
        });
        try {
            progressBarStep = cpwProgressBar.getDeclaredField("step");
            progressBarStep.setAccessible(true);
        }
        catch (NoSuchFieldException ex) {
            GT_Mod.GT_FML_LOGGER.catching((Throwable)ex);
        }
    }
}

