/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.enums.GT_Values;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.net.GT_Packet_TileEntityCoverGUI;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.ISerializableObject;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;

public abstract class GT_CoverBehaviorBase<T extends ISerializableObject> {
    public EntityPlayer lastPlayer = null;
    private final Class<T> typeToken;
    private final ITexture coverFGTexture;

    protected GT_CoverBehaviorBase(Class<T> typeToken) {
        this(typeToken, null);
    }

    protected GT_CoverBehaviorBase(Class<T> typeToken, ITexture coverTexture) {
        this.typeToken = typeToken;
        this.coverFGTexture = coverTexture;
    }

    public abstract T createDataObject(int var1);

    public abstract T createDataObject();

    public final T createDataObject(NBTBase aNBT) {
        if (aNBT instanceof NBTTagInt) {
            return this.createDataObject(((NBTTagInt)aNBT).func_150287_d());
        }
        T ret = this.createDataObject();
        ret.loadDataFromNBT(aNBT);
        return ret;
    }

    public final T cast(ISerializableObject aData) {
        if (this.typeToken.isInstance(aData)) {
            return this.forceCast(aData);
        }
        return null;
    }

    private T forceCast(ISerializableObject aData) {
        try {
            return (T)((ISerializableObject)this.typeToken.cast(aData));
        }
        catch (Exception e) {
            throw new RuntimeException("Casting data in " + this.getClass() + ", data " + aData, e);
        }
    }

    public final Block getFacadeBlock(byte aSide, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.getFacadeBlockImpl(aSide, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final int getFacadeMeta(byte aSide, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.getFacadeMetaImpl(aSide, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final ItemStack getDisplayStack(int aCoverID, ISerializableObject aCoverVariable) {
        return this.getDisplayStackImpl(aCoverID, this.forceCast(aCoverVariable));
    }

    public final ITexture getSpecialCoverFGTexture(byte aSide, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.getSpecialCoverFGTextureImpl(aSide, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final ITexture getSpecialCoverTexture(byte aSide, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.getSpecialCoverTextureImpl(aSide, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final boolean isDataNeededOnClient(byte aSide, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.isDataNeededOnClientImpl(aSide, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final void onDataChanged(byte aSide, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        this.onDataChangedImpl(aSide, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final void onDropped(byte aSide, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        this.onDroppedImpl(aSide, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final boolean isRedstoneSensitive(byte aSide, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity, long aTimer) {
        return this.isRedstoneSensitiveImpl(aSide, aCoverID, this.forceCast(aCoverVariable), aTileEntity, aTimer);
    }

    public final T doCoverThings(byte aSide, byte aInputRedstone, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity, long aTimer) {
        return this.doCoverThingsImpl(aSide, aInputRedstone, aCoverID, this.forceCast(aCoverVariable), aTileEntity, aTimer);
    }

    public final boolean onCoverRightClick(byte aSide, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        return this.onCoverRightClickImpl(aSide, aCoverID, this.forceCast(aCoverVariable), aTileEntity, aPlayer, aX, aY, aZ);
    }

    public final T onCoverScrewdriverClick(byte aSide, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        return this.onCoverScrewdriverClickImpl(aSide, aCoverID, this.forceCast(aCoverVariable), aTileEntity, aPlayer, aX, aY, aZ);
    }

    public final boolean onCoverShiftRightClick(byte aSide, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer) {
        return this.onCoverShiftRightClickImpl(aSide, aCoverID, this.forceCast(aCoverVariable), aTileEntity, aPlayer);
    }

    public final Object getClientGUI(byte aSide, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, World aWorld) {
        return this.getClientGUIImpl(aSide, aCoverID, this.forceCast(aCoverVariable), aTileEntity, aPlayer, aWorld);
    }

    public final boolean onCoverRemoval(byte aSide, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity, boolean aForced) {
        return this.onCoverRemovalImpl(aSide, aCoverID, this.forceCast(aCoverVariable), aTileEntity, aForced);
    }

    public final String getDescription(byte aSide, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.getDescriptionImpl(aSide, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final float getBlastProofLevel(byte aSide, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.getBlastProofLevelImpl(aSide, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final boolean letsRedstoneGoIn(byte aSide, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.letsRedstoneGoInImpl(aSide, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final boolean letsRedstoneGoOut(byte aSide, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.letsRedstoneGoOutImpl(aSide, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final boolean letsFibreGoIn(byte aSide, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.letsFibreGoInImpl(aSide, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final boolean letsFibreGoOut(byte aSide, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.letsFibreGoOutImpl(aSide, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final boolean letsEnergyIn(byte aSide, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.letsEnergyInImpl(aSide, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final boolean letsEnergyOut(byte aSide, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.letsEnergyOutImpl(aSide, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final boolean letsFluidIn(byte aSide, int aCoverID, ISerializableObject aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return this.letsFluidInImpl(aSide, aCoverID, this.forceCast(aCoverVariable), aFluid, aTileEntity);
    }

    public final boolean letsFluidOut(byte aSide, int aCoverID, ISerializableObject aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return this.letsFluidOutImpl(aSide, aCoverID, this.forceCast(aCoverVariable), aFluid, aTileEntity);
    }

    public final boolean letsItemsIn(byte aSide, int aCoverID, ISerializableObject aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return this.letsItemsInImpl(aSide, aCoverID, this.forceCast(aCoverVariable), aSlot, aTileEntity);
    }

    public final boolean letsItemsOut(byte aSide, int aCoverID, ISerializableObject aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return this.letsItemsOutImpl(aSide, aCoverID, this.forceCast(aCoverVariable), aSlot, aTileEntity);
    }

    public final boolean isGUIClickable(byte aSide, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.isGUIClickableImpl(aSide, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final boolean manipulatesSidedRedstoneOutput(byte aSide, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.manipulatesSidedRedstoneOutputImpl(aSide, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final boolean alwaysLookConnected(byte aSide, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.alwaysLookConnectedImpl(aSide, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final byte getRedstoneInput(byte aSide, byte aInputRedstone, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.getRedstoneInputImpl(aSide, aInputRedstone, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final int getTickRate(byte aSide, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.getTickRateImpl(aSide, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final byte getLensColor(byte aSide, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.getLensColorImpl(aSide, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final ItemStack getDrop(byte aSide, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.getDropImpl(aSide, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    protected Block getFacadeBlockImpl(byte aSide, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return null;
    }

    protected int getFacadeMetaImpl(byte aSide, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return 0;
    }

    protected ItemStack getDisplayStackImpl(int aCoverID, T aCoverVariable) {
        return GT_Utility.intToStack(aCoverID);
    }

    protected ITexture getSpecialCoverFGTextureImpl(byte aSide, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return this.coverFGTexture;
    }

    protected ITexture getSpecialCoverTextureImpl(byte aSide, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return null;
    }

    protected boolean isDataNeededOnClientImpl(byte aSide, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return false;
    }

    protected void onDataChangedImpl(byte aSide, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
    }

    protected void onDroppedImpl(byte aSide, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
    }

    protected boolean isRedstoneSensitiveImpl(byte aSide, int aCoverID, T aCoverVariable, ICoverable aTileEntity, long aTimer) {
        return true;
    }

    protected T doCoverThingsImpl(byte aSide, byte aInputRedstone, int aCoverID, T aCoverVariable, ICoverable aTileEntity, long aTimer) {
        return aCoverVariable;
    }

    protected boolean onCoverRightClickImpl(byte aSide, int aCoverID, T aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        return false;
    }

    protected T onCoverScrewdriverClickImpl(byte aSide, int aCoverID, T aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        return aCoverVariable;
    }

    protected boolean onCoverShiftRightClickImpl(byte aSide, int aCoverID, T aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer) {
        if (this.hasCoverGUI() && aPlayer instanceof EntityPlayerMP) {
            this.lastPlayer = aPlayer;
            GT_Values.NW.sendToPlayer(new GT_Packet_TileEntityCoverGUI(aSide, aCoverID, (ISerializableObject)aCoverVariable, aTileEntity, (EntityPlayerMP)aPlayer), (EntityPlayerMP)aPlayer);
            return true;
        }
        return false;
    }

    protected Object getClientGUIImpl(byte aSide, int aCoverID, T aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, World aWorld) {
        return null;
    }

    protected boolean onCoverRemovalImpl(byte aSide, int aCoverID, T aCoverVariable, ICoverable aTileEntity, boolean aForced) {
        return true;
    }

    protected String getDescriptionImpl(byte aSide, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return "";
    }

    protected float getBlastProofLevelImpl(byte aSide, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return 10.0f;
    }

    protected boolean letsRedstoneGoInImpl(byte aSide, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return false;
    }

    protected boolean letsRedstoneGoOutImpl(byte aSide, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return false;
    }

    protected boolean letsFibreGoInImpl(byte aSide, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return false;
    }

    protected boolean letsFibreGoOutImpl(byte aSide, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return false;
    }

    protected boolean letsEnergyInImpl(byte aSide, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return false;
    }

    protected boolean letsEnergyOutImpl(byte aSide, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return false;
    }

    protected boolean letsFluidInImpl(byte aSide, int aCoverID, T aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return false;
    }

    protected boolean letsFluidOutImpl(byte aSide, int aCoverID, T aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return false;
    }

    protected boolean letsItemsInImpl(byte aSide, int aCoverID, T aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return false;
    }

    protected boolean letsItemsOutImpl(byte aSide, int aCoverID, T aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return false;
    }

    protected boolean isGUIClickableImpl(byte aSide, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return false;
    }

    protected boolean manipulatesSidedRedstoneOutputImpl(byte aSide, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return false;
    }

    protected boolean alwaysLookConnectedImpl(byte aSide, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return false;
    }

    protected byte getRedstoneInputImpl(byte aSide, byte aInputRedstone, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return this.letsRedstoneGoIn(aSide, aCoverID, (ISerializableObject)aCoverVariable, aTileEntity) ? aInputRedstone : (byte)0;
    }

    protected int getTickRateImpl(byte aSide, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return 0;
    }

    protected byte getLensColorImpl(byte aSide, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return -1;
    }

    protected ItemStack getDropImpl(byte aSide, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return GT_OreDictUnificator.get(true, aTileEntity.getCoverItemAtSide(aSide));
    }

    public boolean isCoverPlaceable(byte aSide, ItemStack aStack, ICoverable aTileEntity) {
        return this.isCoverPlaceable(aSide, new GT_ItemStack(aStack), aTileEntity);
    }

    @Deprecated
    public boolean isCoverPlaceable(byte aSide, GT_ItemStack aStack, ICoverable aTileEntity) {
        return true;
    }

    public boolean hasCoverGUI() {
        return false;
    }

    public boolean onCoverRightclickClient(byte aSide, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        return false;
    }

    public boolean isSimpleCover() {
        return false;
    }

    public void placeCover(byte aSide, ItemStack aCover, ICoverable aTileEntity) {
        aTileEntity.setCoverIDAtSide(aSide, GT_Utility.stackToInt(aCover));
    }

    @Deprecated
    public String trans(String aNr, String aEnglish) {
        return GT_Utility.trans(aNr, aEnglish);
    }
}

