/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.common.network.ByteBufUtils;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_GUICover;
import gregtech.api.gui.widgets.GT_GuiIcon;
import gregtech.api.gui.widgets.GT_GuiIconCheckButton;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.net.GT_Packet_TileEntityCoverNew;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_CoverBehaviorBase;
import gregtech.api.util.GT_RenderingWorld;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.ISerializableObject;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;

public abstract class GT_Cover_FacadeBase
extends GT_CoverBehaviorBase<FacadeData> {
    public GT_Cover_FacadeBase() {
        super(FacadeData.class);
    }

    @Override
    public boolean isSimpleCover() {
        return true;
    }

    @Override
    public FacadeData createDataObject(int aLegacyData) {
        return new FacadeData();
    }

    @Override
    public FacadeData createDataObject() {
        return new FacadeData();
    }

    @Override
    protected FacadeData onCoverScrewdriverClickImpl(byte aSide, int aCoverID, FacadeData aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        aCoverVariable.mFlags = aCoverVariable.mFlags + 1 & 0xF;
        GT_Utility.sendChatToPlayer(aPlayer, ((aCoverVariable.mFlags & 1) != 0 ? GT_Utility.trans("128", "Redstone ") : "") + ((aCoverVariable.mFlags & 2) != 0 ? GT_Utility.trans("129", "Energy ") : "") + ((aCoverVariable.mFlags & 4) != 0 ? GT_Utility.trans("130", "Fluids ") : "") + ((aCoverVariable.mFlags & 8) != 0 ? GT_Utility.trans("131", "Items ") : ""));
        return aCoverVariable;
    }

    @Override
    protected boolean letsRedstoneGoInImpl(byte aSide, int aCoverID, FacadeData aCoverVariable, ICoverable aTileEntity) {
        return (aCoverVariable.mFlags & 1) != 0;
    }

    @Override
    protected boolean letsRedstoneGoOutImpl(byte aSide, int aCoverID, FacadeData aCoverVariable, ICoverable aTileEntity) {
        return (aCoverVariable.mFlags & 1) != 0;
    }

    @Override
    protected boolean letsEnergyInImpl(byte aSide, int aCoverID, FacadeData aCoverVariable, ICoverable aTileEntity) {
        return (aCoverVariable.mFlags & 2) != 0;
    }

    @Override
    protected boolean letsEnergyOutImpl(byte aSide, int aCoverID, FacadeData aCoverVariable, ICoverable aTileEntity) {
        return (aCoverVariable.mFlags & 2) != 0;
    }

    @Override
    protected boolean letsFluidInImpl(byte aSide, int aCoverID, FacadeData aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return (aCoverVariable.mFlags & 4) != 0;
    }

    @Override
    protected boolean letsFluidOutImpl(byte aSide, int aCoverID, FacadeData aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return (aCoverVariable.mFlags & 4) != 0;
    }

    @Override
    protected boolean letsItemsInImpl(byte aSide, int aCoverID, FacadeData aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return (aCoverVariable.mFlags & 8) != 0;
    }

    @Override
    protected boolean letsItemsOutImpl(byte aSide, int aCoverID, FacadeData aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return (aCoverVariable.mFlags & 8) != 0;
    }

    @Override
    public void placeCover(byte aSide, ItemStack aCover, ICoverable aTileEntity) {
        aTileEntity.setCoverIdAndDataAtSide(aSide, GT_Utility.stackToInt(aCover), new FacadeData(GT_Utility.copyAmount(1L, aCover), 0));
        if (aTileEntity.isClientSide()) {
            GT_RenderingWorld.getInstance().register(aTileEntity.getXCoord(), aTileEntity.getYCoord(), aTileEntity.getZCoord(), this.getTargetBlock(aCover), this.getTargetMeta(aCover));
        }
    }

    @Override
    protected ItemStack getDropImpl(byte aSide, int aCoverID, FacadeData aCoverVariable, ICoverable aTileEntity) {
        return aCoverVariable.mStack;
    }

    @Override
    protected ITexture getSpecialCoverFGTextureImpl(byte aSide, int aCoverID, FacadeData aCoverVariable, ICoverable aTileEntity) {
        return this.getSpecialCoverTextureImpl(aSide, aCoverID, aCoverVariable, aTileEntity);
    }

    @Override
    protected ITexture getSpecialCoverTextureImpl(byte aSide, int aCoverID, FacadeData aCoverVariable, ICoverable aTileEntity) {
        if (GT_Utility.isStackInvalid(aCoverVariable.mStack)) {
            return Textures.BlockIcons.ERROR_RENDERING[0];
        }
        Block block = this.getTargetBlock(aCoverVariable.mStack);
        if (block == null) {
            return Textures.BlockIcons.ERROR_RENDERING[0];
        }
        if (block.func_149701_w() != 0) {
            return Textures.BlockIcons.ERROR_RENDERING[0];
        }
        return TextureFactory.builder().setFromBlock(block, this.getTargetMeta(aCoverVariable.mStack)).useWorldCoord().setFromSide(ForgeDirection.getOrientation((int)aSide)).build();
    }

    @Override
    protected Block getFacadeBlockImpl(byte aSide, int aCoverID, FacadeData aCoverVariable, ICoverable aTileEntity) {
        if (GT_Utility.isStackInvalid(aCoverVariable.mStack)) {
            return null;
        }
        return this.getTargetBlock(aCoverVariable.mStack);
    }

    @Override
    protected int getFacadeMetaImpl(byte aSide, int aCoverID, FacadeData aCoverVariable, ICoverable aTileEntity) {
        if (GT_Utility.isStackInvalid(aCoverVariable.mStack)) {
            return 0;
        }
        return this.getTargetMeta(aCoverVariable.mStack);
    }

    protected abstract Block getTargetBlock(ItemStack var1);

    protected abstract int getTargetMeta(ItemStack var1);

    @Override
    protected boolean isDataNeededOnClientImpl(byte aSide, int aCoverID, FacadeData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected void onDataChangedImpl(byte aSide, int aCoverID, FacadeData aCoverVariable, ICoverable aTileEntity) {
        if (aTileEntity.isClientSide()) {
            GT_RenderingWorld.getInstance().register(aTileEntity.getXCoord(), aTileEntity.getYCoord(), aTileEntity.getZCoord(), this.getTargetBlock(aCoverVariable.mStack), this.getTargetMeta(aCoverVariable.mStack));
        }
    }

    @Override
    protected void onDroppedImpl(byte aSide, int aCoverID, FacadeData aCoverVariable, ICoverable aTileEntity) {
        if (aTileEntity.isClientSide()) {
            for (byte i = 0; i < 6; i = (byte)(i + 1)) {
                if (i == aSide || !(aTileEntity.getCoverBehaviorAtSideNew(i) instanceof GT_Cover_FacadeBase)) continue;
                return;
            }
            if (aCoverVariable.mStack != null) {
                GT_RenderingWorld.getInstance().unregister(aTileEntity.getXCoord(), aTileEntity.getYCoord(), aTileEntity.getZCoord(), this.getTargetBlock(aCoverVariable.mStack), this.getTargetMeta(aCoverVariable.mStack));
            }
        }
    }

    @Override
    protected boolean onCoverRightClickImpl(byte aSide, int aCoverID, FacadeData aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        aTileEntity.issueCoverUpdate(aSide);
        return super.onCoverRightClickImpl(aSide, aCoverID, aCoverVariable, aTileEntity, aPlayer, aX, aY, aZ);
    }

    @Override
    public boolean isCoverPlaceable(byte aSide, ItemStack aStack, ICoverable aTileEntity) {
        if (!super.isCoverPlaceable(aSide, aStack, aTileEntity)) {
            return false;
        }
        Block targetBlock = this.getTargetBlock(aStack);
        if (targetBlock == null) {
            return false;
        }
        for (byte i = 0; i < 6; i = (byte)(i + 1)) {
            Block facadeBlock;
            GT_CoverBehaviorBase<?> behavior;
            if (i == aSide || (behavior = aTileEntity.getCoverBehaviorAtSideNew(i)) == null || (facadeBlock = behavior.getFacadeBlock(i, aTileEntity.getCoverIDAtSide(i), aTileEntity.getComplexCoverDataAtSide(i), aTileEntity)) == null) continue;
            if (facadeBlock != targetBlock) {
                return false;
            }
            if (behavior.getFacadeMeta(i, aTileEntity.getCoverIDAtSide(i), aTileEntity.getComplexCoverDataAtSide(i), aTileEntity) == this.getTargetMeta(aStack)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    protected Object getClientGUIImpl(byte aSide, int aCoverID, FacadeData coverData, ICoverable aTileEntity, EntityPlayer aPlayer, World aWorld) {
        return new GUI(aSide, aCoverID, coverData, aTileEntity);
    }

    private class GUI
    extends GT_GUICover {
        private final byte side;
        private final int coverID;
        private FacadeData coverVariable;
        private static final int startX = 10;
        private static final int startY = 25;
        private static final int spaceX = 18;
        private static final int spaceY = 18;
        private final int textColor;

        public GUI(byte aSide, int aCoverID, FacadeData aCoverVariable, ICoverable aTileEntity) {
            super(aTileEntity, 176, 107, aCoverVariable.mStack);
            this.textColor = this.getTextColorOrDefault("text", -11184811);
            this.side = aSide;
            this.coverID = aCoverID;
            this.coverVariable = aCoverVariable;
            new GT_GuiIconCheckButton(this, 0, 10, 25, GT_GuiIcon.CHECKMARK, GT_GuiIcon.CROSS).setChecked((this.coverVariable.mFlags & 1) == 0);
            new GT_GuiIconCheckButton(this, 1, 10, 43, GT_GuiIcon.CHECKMARK, GT_GuiIcon.CROSS).setChecked((this.coverVariable.mFlags & 2) == 0);
            new GT_GuiIconCheckButton(this, 2, 10, 61, GT_GuiIcon.CHECKMARK, GT_GuiIcon.CROSS).setChecked((this.coverVariable.mFlags & 4) == 0);
            new GT_GuiIconCheckButton(this, 3, 10, 79, GT_GuiIcon.CHECKMARK, GT_GuiIcon.CROSS).setChecked((this.coverVariable.mFlags & 8) == 0);
        }

        @Override
        public void drawExtras(int mouseX, int mouseY, float parTicks) {
            super.drawExtras(mouseX, mouseY, parTicks);
            this.field_146289_q.func_78276_b(GT_Utility.trans("128", "Redstone"), 31, 29, this.textColor);
            this.field_146289_q.func_78276_b(GT_Utility.trans("129", "Energy"), 31, 47, this.textColor);
            this.field_146289_q.func_78276_b(GT_Utility.trans("130", "Fluids"), 31, 65, this.textColor);
            this.field_146289_q.func_78276_b(GT_Utility.trans("131", "Items"), 31, 83, this.textColor);
        }

        @Override
        protected void onInitGui(int guiLeft, int guiTop, int gui_width, int gui_height) {
            this.updateButtons();
        }

        @Override
        public void buttonClicked(GuiButton btn) {
            if (this.getClickable(btn.field_146127_k)) {
                this.coverVariable.mFlags = this.getNewCoverVariable(btn.field_146127_k);
                GT_Values.NW.sendToServer(new GT_Packet_TileEntityCoverNew(this.side, this.coverID, this.coverVariable, this.tile));
            }
            this.updateButtons();
        }

        private void updateButtons() {
            for (Object o : this.field_146292_n) {
                GT_GuiIconCheckButton b = (GT_GuiIconCheckButton)o;
                b.field_146124_l = this.getClickable(b.field_146127_k);
                b.setChecked((this.coverVariable.mFlags & 1 << b.field_146127_k) != 0);
            }
        }

        private int getNewCoverVariable(int id) {
            switch (id) {
                case 0: {
                    return this.coverVariable.mFlags ^ 1;
                }
                case 1: {
                    return this.coverVariable.mFlags ^ 2;
                }
                case 2: {
                    return this.coverVariable.mFlags ^ 4;
                }
                case 3: {
                    return this.coverVariable.mFlags ^ 8;
                }
            }
            return this.coverVariable.mFlags;
        }

        private boolean getClickable(int id) {
            return this.coverVariable.mFlags >= 0 && this.coverVariable.mFlags <= 15;
        }
    }

    public static class FacadeData
    implements ISerializableObject {
        ItemStack mStack;
        int mFlags;

        public FacadeData() {
        }

        public FacadeData(ItemStack mStack, int mFlags) {
            this.mStack = mStack;
            this.mFlags = mFlags;
        }

        @Override
        @Nonnull
        public ISerializableObject copy() {
            return new FacadeData(this.mStack, this.mFlags);
        }

        @Override
        @Nonnull
        public NBTBase saveDataToNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            if (this.mStack != null) {
                tag.func_74782_a("mStack", (NBTBase)this.mStack.func_77955_b(new NBTTagCompound()));
            }
            tag.func_74774_a("mFlags", (byte)this.mFlags);
            return tag;
        }

        @Override
        public void writeToByteBuf(ByteBuf aBuf) {
            ByteBufUtils.writeItemStack((ByteBuf)aBuf, (ItemStack)this.mStack);
            aBuf.writeByte(this.mFlags);
        }

        @Override
        public void loadDataFromNBT(NBTBase aNBT) {
            NBTTagCompound tag = (NBTTagCompound)aNBT;
            this.mStack = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("mStack"));
            this.mFlags = tag.func_74771_c("mFlags");
        }

        @Override
        @Nonnull
        public ISerializableObject readFromPacket(ByteArrayDataInput aBuf, EntityPlayerMP aPlayer) {
            this.mStack = ISerializableObject.readItemStackFromGreggyByteBuf(aBuf);
            this.mFlags = aBuf.readByte();
            return this;
        }
    }
}

