/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.google.common.io.ByteArrayDataInput;
import gregtech.api.enums.GT_Values;
import gregtech.api.gui.GT_GUICover;
import gregtech.api.gui.widgets.GT_GuiIntegerTextBox;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.net.GT_Packet_TileEntityCoverNew;
import gregtech.api.util.GT_CoverBehaviorBase;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.ISerializableObject;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class GT_Cover_FluidLimiter
extends GT_CoverBehaviorBase<FluidLimiterData> {
    @Deprecated
    public GT_Cover_FluidLimiter() {
        this((ITexture)null);
    }

    public GT_Cover_FluidLimiter(ITexture coverTexture) {
        super(FluidLimiterData.class, coverTexture);
    }

    @Override
    protected FluidLimiterData onCoverScrewdriverClickImpl(byte aSide, int aCoverID, FluidLimiterData aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aTileEntity instanceof IFluidHandler) {
            this.adjustThreshold(aCoverVariable, !aPlayer.func_70093_af());
            GT_Utility.sendChatToPlayer(aPlayer, String.format("Threshold: %f", Float.valueOf(aCoverVariable.threshold)));
        }
        return aCoverVariable;
    }

    @Override
    protected boolean letsFluidInImpl(byte aSide, int aCoverID, FluidLimiterData aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return this.allowsFluidIn(aCoverVariable, aTileEntity);
    }

    @Override
    protected boolean alwaysLookConnectedImpl(byte aSide, int aCoverID, FluidLimiterData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    private boolean allowsFluidIn(FluidLimiterData aCoverVariable, ICoverable c) {
        if (c instanceof IFluidHandler) {
            return aCoverVariable.threshold > this.getFillLevelInputSlots((IFluidHandler)c);
        }
        return false;
    }

    private void adjustThreshold(FluidLimiterData coverVariable, boolean way) {
        if (way) {
            if (coverVariable.threshold + 0.05f > 1.0f) {
                coverVariable.threshold = 0.0f;
                return;
            }
            FluidLimiterData fluidLimiterData = coverVariable;
            fluidLimiterData.threshold = fluidLimiterData.threshold + 0.05f;
        } else {
            if (Math.abs(coverVariable.threshold) - 0.05f < 0.0f) {
                coverVariable.threshold = 1.0f;
                return;
            }
            FluidLimiterData fluidLimiterData = coverVariable;
            fluidLimiterData.threshold = fluidLimiterData.threshold - 0.05f;
        }
    }

    private float getFillLevelInputSlots(IFluidHandler fh) {
        FluidTankInfo[] tankInfo = fh.getTankInfo(ForgeDirection.UNKNOWN);
        if (tankInfo != null) {
            FluidTankInfo inputSlot = tankInfo[0];
            if (inputSlot.fluid != null) {
                long tMax = inputSlot.capacity;
                long tUsed = inputSlot.fluid.amount;
                return (float)tUsed / (float)tMax;
            }
        }
        return 0.0f;
    }

    @Override
    public FluidLimiterData createDataObject(int aLegacyData) {
        return this.createDataObject();
    }

    @Override
    public FluidLimiterData createDataObject() {
        return new FluidLimiterData(1.0f);
    }

    @Override
    protected Object getClientGUIImpl(byte aSide, int aCoverID, FluidLimiterData aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, World aWorld) {
        return new GUI(aSide, aCoverID, aCoverVariable, aTileEntity);
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    private static class GUI
    extends GT_GUICover {
        private static final int startX = 10;
        private static final int startY = 25;
        private static final int spaceX = 18;
        private static final int spaceY = 18;
        private final byte side;
        private final int coverID;
        private final FluidLimiterData coverVariable;
        private final GT_GuiIntegerTextBox thresholdBox;
        private final int textColor = this.getTextColorOrDefault("text", -11184811);

        public GUI(byte aSide, int aCoverID, FluidLimiterData aCoverVariable, ICoverable aTileEntity) {
            super(aTileEntity, 176, 107, GT_Utility.intToStack(aCoverID));
            this.side = aSide;
            this.coverID = aCoverID;
            this.coverVariable = aCoverVariable;
            this.thresholdBox = new GT_GuiIntegerTextBox(this, 2, 10, 37, 69, 12){

                @Override
                public boolean validChar(char c, int key) {
                    return super.validChar(c, key) || c == '-';
                }
            };
        }

        @Override
        public void drawExtras(int mouseX, int mouseY, float parTicks) {
            super.drawExtras(mouseX, mouseY, parTicks);
            this.getFontRenderer().func_78276_b("Percent threshold", 10, 26, this.textColor);
        }

        @Override
        protected void onInitGui(int guiLeft, int guiTop, int gui_width, int gui_height) {
            this.thresholdBox.func_146195_b(true);
            String text = this.coverVariable != null ? String.valueOf(Math.round(this.coverVariable.threshold * 100.0f)) : "";
            this.thresholdBox.func_146180_a(text);
        }

        @Override
        public void applyTextBox(GT_GuiIntegerTextBox box) {
            int percent;
            try {
                percent = Integer.parseInt(box.func_146179_b().trim());
            }
            catch (NumberFormatException ignored) {
                this.resetTextBox(this.thresholdBox);
                return;
            }
            if (percent > 100 || percent <= 0) {
                return;
            }
            this.coverVariable.threshold = (float)percent / 100.0f;
            box.func_146180_a(String.valueOf(percent));
            GT_Values.NW.sendToServer(new GT_Packet_TileEntityCoverNew(this.side, this.coverID, this.coverVariable, this.tile));
        }
    }

    public static class FluidLimiterData
    implements ISerializableObject {
        private float threshold;

        public FluidLimiterData(float threshold) {
            this.threshold = threshold;
        }

        @Override
        @Nonnull
        public ISerializableObject copy() {
            return new FluidLimiterData(this.threshold);
        }

        @Override
        @Nonnull
        public NBTBase saveDataToNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74776_a("threshold", this.threshold);
            return tag;
        }

        @Override
        public void writeToByteBuf(ByteBuf aBuf) {
            aBuf.writeFloat(this.threshold);
        }

        @Override
        public void loadDataFromNBT(NBTBase aNBT) {
            if (aNBT instanceof NBTTagCompound) {
                NBTTagCompound tag = (NBTTagCompound)aNBT;
                this.threshold = tag.func_74760_g("threshold");
            }
        }

        @Override
        @Nonnull
        public ISerializableObject readFromPacket(ByteArrayDataInput aBuf, @Nullable EntityPlayerMP aPlayer) {
            this.threshold = aBuf.readFloat();
            return this;
        }
    }
}

