/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.fluid;

import gregtech.api.enums.Dyes;
import gregtech.api.enums.FluidState;
import gregtech.api.interfaces.fluid.IGT_Fluid;
import gregtech.api.interfaces.fluid.IGT_FluidBuilder;
import gregtech.common.fluid.GT_Fluid;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;

public class GT_FluidBuilder
implements IGT_FluidBuilder {
    protected final String fluidName;
    protected String localizedName;
    protected ResourceLocation stillIconResourceLocation = null;
    protected ResourceLocation flowingIconResourceLocation = null;
    protected short[] colorRGBA = Dyes._NULL.getRGBA();
    protected Block fluidBlock = null;
    protected FluidState fluidState;
    protected int temperature;

    public GT_FluidBuilder(String fluidName) {
        this.fluidName = fluidName;
    }

    @Override
    public IGT_FluidBuilder withColorRGBA(short[] colorRGBA) {
        this.colorRGBA = colorRGBA;
        return this;
    }

    @Override
    public IGT_FluidBuilder withLocalizedName(String localizedName) {
        this.localizedName = localizedName;
        return this;
    }

    @Override
    public IGT_FluidBuilder withStateAndTemperature(FluidState fluidState, int temperature) {
        this.fluidState = fluidState;
        this.temperature = temperature;
        return this;
    }

    @Override
    public IGT_FluidBuilder withStillIconResourceLocation(ResourceLocation stillIconResourceLocation) {
        this.stillIconResourceLocation = stillIconResourceLocation;
        return this;
    }

    @Override
    public IGT_FluidBuilder withFlowingIconResourceLocation(ResourceLocation flowingIconResourceLocation) {
        this.flowingIconResourceLocation = flowingIconResourceLocation;
        return this;
    }

    @Override
    public IGT_FluidBuilder withTextureName(String textureName) {
        this.stillIconResourceLocation = new ResourceLocation("gregtech", "fluids/fluid." + textureName);
        this.flowingIconResourceLocation = null;
        return this;
    }

    @Override
    public IGT_FluidBuilder withTextureFrom(IGT_Fluid fromGTFluid) {
        this.stillIconResourceLocation = fromGTFluid.getStillIconResourceLocation();
        this.flowingIconResourceLocation = fromGTFluid.getFlowingIconResourceLocation();
        return this;
    }

    @Override
    public IGT_FluidBuilder withFluidBlock(Block fluidBlock) {
        this.fluidBlock = fluidBlock;
        return this;
    }

    @Override
    public IGT_FluidBuilder withTextures(ResourceLocation stillIconResourceLocation, ResourceLocation flowingIconResourceLocation) {
        this.stillIconResourceLocation = stillIconResourceLocation;
        this.flowingIconResourceLocation = flowingIconResourceLocation;
        return this;
    }

    @Override
    public IGT_Fluid build() {
        if (this.stillIconResourceLocation == null) {
            this.withTextureName(this.fluidName.toLowerCase(Locale.ENGLISH));
        }
        return new GT_Fluid(this);
    }

    @Override
    public IGT_Fluid buildAndRegister() {
        if (this.stillIconResourceLocation == null) {
            this.withTextureName(this.fluidName.toLowerCase(Locale.ENGLISH));
        }
        return this.build().addFluid();
    }
}

