/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.power;

import gregtech.api.util.GT_Utility;

public abstract class Power {
    protected final byte tier;
    protected int recipeEuPerTick;
    protected int recipeDuration;

    public Power(byte tier) {
        this.tier = tier;
    }

    public byte getTier() {
        return this.tier;
    }

    public abstract String getTierString();

    public abstract void computePowerUsageAndDuration(int var1, int var2);

    public int getEuPerTick() {
        return this.recipeEuPerTick;
    }

    public int getDurationTicks() {
        return this.recipeDuration;
    }

    public double getDurationSeconds() {
        return 0.05 * (double)this.getDurationTicks();
    }

    public String getDurationStringSeconds() {
        return GT_Utility.formatNumbers(this.getDurationSeconds()) + GT_Utility.trans("161", " secs");
    }

    public String getDurationStringTicks() {
        return GT_Utility.formatNumbers(this.getDurationTicks()) + GT_Utility.trans("224", " ticks");
    }

    public abstract String getTotalPowerString();

    public abstract String getPowerUsageString();

    public abstract String getVoltageString();

    public abstract String getAmperageString();
}

