/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render.items;

import gregtech.api.enums.ItemList;
import gregtech.api.enums.Textures;
import gregtech.api.items.GT_MetaGenerated_Item;
import gregtech.api.util.GT_Utility;
import gregtech.common.render.GT_RenderUtil;
import gregtech.loaders.ExtraIcons;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class GT_GeneratedItem_Renderer
implements IItemRenderer {
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON || type == IItemRenderer.ItemRenderType.INVENTORY || type == IItemRenderer.ItemRenderType.ENTITY;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type == IItemRenderer.ItemRenderType.ENTITY;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack aStack, Object ... data) {
        ItemList largeFluidCell;
        long tCharge;
        Long[] tStats;
        short aMetaData = (short)aStack.func_77960_j();
        GT_MetaGenerated_Item aItem = (GT_MetaGenerated_Item)aStack.func_77973_b();
        GL11.glEnable((int)3042);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        IIcon tIcon = aItem.mIconList[aMetaData - aItem.mOffset].length > 1 ? ((tStats = aItem.mElectricStats.get(aMetaData)) != null && tStats[3] < 0L ? ((tCharge = aItem.getRealCharge(aStack)) <= 0L ? aItem.mIconList[aMetaData - aItem.mOffset][1] : (tCharge >= tStats[0] ? aItem.mIconList[aMetaData - aItem.mOffset][8] : aItem.mIconList[aMetaData - aItem.mOffset][7 - (int)Math.max(0L, Math.min(5L, (tStats[0] - tCharge) * 6L / tStats[0]))])) : aItem.mIconList[aMetaData - aItem.mOffset][0]) : aItem.mIconList[aMetaData - aItem.mOffset][0];
        if (tIcon == null) {
            tIcon = Textures.ItemIcons.RENDERING_ERROR.getIcon();
        }
        if ((largeFluidCell = GT_GeneratedItem_Renderer.getLargeFluidCell(aStack)) != null) {
            GT_GeneratedItem_Renderer.renderLargeFluidCellExtraParts(type, largeFluidCell, aStack);
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110576_c);
        GL11.glBlendFunc((int)770, (int)771);
        if (type.equals((Object)IItemRenderer.ItemRenderType.INVENTORY)) {
            GT_RenderUtil.renderItemIcon(tIcon, 16.0, 0.001, 0.0f, 0.0f, -1.0f);
        } else {
            ItemRenderer.func_78439_a((Tessellator)Tessellator.field_78398_a, (float)tIcon.func_94212_f(), (float)tIcon.func_94206_g(), (float)tIcon.func_94209_e(), (float)tIcon.func_94210_h(), (int)tIcon.func_94211_a(), (int)tIcon.func_94216_b(), (float)0.0625f);
        }
        GL11.glDisable((int)3042);
    }

    @Nullable
    private static ItemList getLargeFluidCell(ItemStack stack) {
        if (GT_GeneratedItem_Renderer.isSame(ItemList.Large_Fluid_Cell_Steel, stack)) {
            return ItemList.Large_Fluid_Cell_Steel;
        }
        if (GT_GeneratedItem_Renderer.isSame(ItemList.Large_Fluid_Cell_Aluminium, stack)) {
            return ItemList.Large_Fluid_Cell_Aluminium;
        }
        if (GT_GeneratedItem_Renderer.isSame(ItemList.Large_Fluid_Cell_TungstenSteel, stack)) {
            return ItemList.Large_Fluid_Cell_TungstenSteel;
        }
        if (GT_GeneratedItem_Renderer.isSame(ItemList.Large_Fluid_Cell_StainlessSteel, stack)) {
            return ItemList.Large_Fluid_Cell_StainlessSteel;
        }
        if (GT_GeneratedItem_Renderer.isSame(ItemList.Large_Fluid_Cell_Titanium, stack)) {
            return ItemList.Large_Fluid_Cell_Titanium;
        }
        if (GT_GeneratedItem_Renderer.isSame(ItemList.Large_Fluid_Cell_Chrome, stack)) {
            return ItemList.Large_Fluid_Cell_Chrome;
        }
        if (GT_GeneratedItem_Renderer.isSame(ItemList.Large_Fluid_Cell_Iridium, stack)) {
            return ItemList.Large_Fluid_Cell_Iridium;
        }
        if (GT_GeneratedItem_Renderer.isSame(ItemList.Large_Fluid_Cell_Osmium, stack)) {
            return ItemList.Large_Fluid_Cell_Osmium;
        }
        if (GT_GeneratedItem_Renderer.isSame(ItemList.Large_Fluid_Cell_Neutronium, stack)) {
            return ItemList.Large_Fluid_Cell_Neutronium;
        }
        return null;
    }

    private static void renderLargeFluidCellExtraParts(IItemRenderer.ItemRenderType type, ItemList item, ItemStack stack) {
        IIcon inner = item == ItemList.Large_Fluid_Cell_Steel ? ExtraIcons.steelLargeCellInner : (item == ItemList.Large_Fluid_Cell_Aluminium ? ExtraIcons.aluminiumLargeCellInner : (item == ItemList.Large_Fluid_Cell_StainlessSteel ? ExtraIcons.stainlesssteelLargeCellInner : (item == ItemList.Large_Fluid_Cell_Titanium ? ExtraIcons.titaniumLargeCellInner : (item == ItemList.Large_Fluid_Cell_TungstenSteel ? ExtraIcons.tungstensteelLargeCellInner : (item == ItemList.Large_Fluid_Cell_Iridium ? ExtraIcons.iridiumLargeCellInner : (item == ItemList.Large_Fluid_Cell_Osmium ? ExtraIcons.osmiumLargeCellInner : (item == ItemList.Large_Fluid_Cell_Chrome ? ExtraIcons.chromiumLargeCellInner : ExtraIcons.neutroniumLargeCellInner)))))));
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110576_c);
        if (type.equals((Object)IItemRenderer.ItemRenderType.INVENTORY)) {
            GT_RenderUtil.renderItemIcon(inner, 16.0, -0.001, 0.0f, 0.0f, -1.0f);
        } else {
            ItemRenderer.func_78439_a((Tessellator)Tessellator.field_78398_a, (float)inner.func_94212_f(), (float)inner.func_94206_g(), (float)inner.func_94209_e(), (float)inner.func_94210_h(), (int)inner.func_94211_a(), (int)inner.func_94216_b(), (float)0.0625f);
        }
        FluidStack fluidStack = GT_Utility.getFluidForFilledItem(stack, true);
        if (fluidStack != null && fluidStack.getFluid() != null) {
            IIcon fluidIcon = fluidStack.getFluid().getIcon(fluidStack);
            int fluidColor = fluidStack.getFluid().getColor(fluidStack);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDepthFunc((int)514);
            GL11.glColor3ub((byte)((byte)(fluidColor >> 16)), (byte)((byte)(fluidColor >> 8)), (byte)((byte)fluidColor));
            if (type.equals((Object)IItemRenderer.ItemRenderType.INVENTORY)) {
                GT_RenderUtil.renderItemIcon(fluidIcon, 16.0, -0.001, 0.0f, 0.0f, -1.0f);
            } else {
                ItemRenderer.func_78439_a((Tessellator)Tessellator.field_78398_a, (float)fluidIcon.func_94212_f(), (float)fluidIcon.func_94206_g(), (float)fluidIcon.func_94209_e(), (float)fluidIcon.func_94210_h(), (int)fluidIcon.func_94211_a(), (int)fluidIcon.func_94216_b(), (float)0.0625f);
            }
            GL11.glColor3ub((byte)-1, (byte)-1, (byte)-1);
            GL11.glDepthFunc((int)515);
        }
    }

    private static boolean isSame(ItemList item, ItemStack stack) {
        ItemStack internal = item.getInternalStack_unsafe();
        if (GT_Utility.isStackInvalid(internal)) {
            return false;
        }
        return internal.func_77973_b() == stack.func_77973_b() && internal.func_77960_j() == stack.func_77960_j();
    }
}

