/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render.items;

import gregtech.GT_Mod;
import gregtech.api.items.GT_MetaGenerated_Item;
import gregtech.common.render.GT_RenderUtil;
import gregtech.common.render.items.GT_GeneratedMaterial_Renderer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class TranscendentMetalRenderer
extends GT_GeneratedMaterial_Renderer {
    private final int[] frameIndex = new int[]{0, 0, 0, 0, 1, 1, 2, 3, 4, 5, 7, 8, 9, 10, 12, 13, 14, 16, 17, 19, 21, 22, 24, 25, 27, 29, 30, 32, 33, 35, 36, 38, 39, 40, 42, 43, 44, 45, 46, 47, 48, 49, 50, 50, 49, 48, 47, 46, 45, 44, 43, 42, 40, 39, 38, 36, 35, 33, 32, 30, 29, 27, 25, 24, 22, 21, 19, 17, 16, 14, 13, 12, 10, 9, 8, 7, 5, 4, 3, 2, 1, 1, 0, 0, 0, 0};
    private final float[] frameRotation = new float[]{0.0f, 7.0f, 14.0f, 21.0f, 28.0f, 36.0f, 43.0f, 50.0f, 57.0f, 64.0f, 72.0f, 79.0f, 86.0f, 93.0f, 100.0f, 108.0f, 115.0f, 122.0f, 129.0f, 136.0f, 144.0f, 151.0f, 158.0f, 165.0f, 172.0f, 180.0f, 187.0f, 194.0f, 201.0f, 208.0f, 216.0f, 223.0f, 230.0f, 237.0f, 244.0f, 252.0f, 259.0f, 266.0f, 273.0f, 280.0f, 288.0f, 295.0f, 302.0f, 309.0f, 316.0f, 324.0f, 331.0f, 338.0f, 345.0f, 352.0f, 360.0f};
    private final float[] frameAlpha = new float[]{0.39215687f, 0.41568628f, 0.4392157f, 0.4627451f, 0.4862745f, 0.5137255f, 0.5372549f, 0.56078434f, 0.58431375f, 0.60784316f, 0.63529414f, 0.65882355f, 0.68235296f, 0.7058824f, 0.7294118f, 0.75686276f, 0.78039217f, 0.8039216f, 0.827451f, 0.8509804f, 0.8784314f, 0.9019608f, 0.9254902f, 0.9490196f, 0.972549f, 1.0f, 0.972549f, 0.9490196f, 0.9254902f, 0.9019608f, 0.8784314f, 0.8509804f, 0.827451f, 0.8039216f, 0.78039217f, 0.75686276f, 0.7294118f, 0.7058824f, 0.68235296f, 0.65882355f, 0.63529414f, 0.60784316f, 0.58431375f, 0.56078434f, 0.5372549f, 0.5137255f, 0.4862745f, 0.4627451f, 0.4392157f, 0.41568628f, 0.39215687f};

    private static float linearInterpolation(float[] controlPoints, int frameA, int frameB, float partial) {
        float a = controlPoints[frameA];
        float b = controlPoints[frameB];
        return a * (1.0f - partial) + b * partial;
    }

    @Override
    public void renderRegularItem(IItemRenderer.ItemRenderType type, ItemStack aStack, IIcon icon, boolean shouldModulateColor) {
        GL11.glPushMatrix();
        long animationTicks = GT_Mod.gregtechproxy.getAnimationTicks();
        int frameCurrent = this.frameIndex[(int)(animationTicks / 2L % (long)this.frameIndex.length)];
        int frameNext = this.frameIndex[(int)((animationTicks + 2L) / 2L % (long)this.frameIndex.length)];
        float partialTicks = GT_Mod.gregtechproxy.getPartialRenderTicks();
        if ((animationTicks & 1L) == 1L) {
            partialTicks = (partialTicks + 1.0f) / 2.0f;
        }
        if (type.equals((Object)IItemRenderer.ItemRenderType.INVENTORY)) {
            GL11.glTranslatef((float)8.0f, (float)8.0f, (float)0.0f);
        } else {
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.0f);
        }
        GL11.glRotatef((float)TranscendentMetalRenderer.linearInterpolation(this.frameRotation, frameCurrent, frameNext, partialTicks), (float)0.0f, (float)0.0f, (float)1.0f);
        if (type.equals((Object)IItemRenderer.ItemRenderType.INVENTORY)) {
            GL11.glTranslatef((float)-8.0f, (float)-8.0f, (float)0.0f);
        } else {
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)0.0f);
        }
        GT_MetaGenerated_Item aItem = (GT_MetaGenerated_Item)aStack.func_77973_b();
        if (shouldModulateColor) {
            short[] tModulation = aItem.getRGBa(aStack);
            GL11.glColor4f((float)((float)tModulation[0] / 255.0f), (float)((float)tModulation[1] / 255.0f), (float)((float)tModulation[2] / 255.0f), (float)TranscendentMetalRenderer.linearInterpolation(this.frameAlpha, frameCurrent, frameNext, partialTicks));
        } else {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)TranscendentMetalRenderer.linearInterpolation(this.frameAlpha, frameCurrent, frameNext, partialTicks));
        }
        if (type.equals((Object)IItemRenderer.ItemRenderType.INVENTORY)) {
            GT_RenderUtil.renderItemIcon(icon, 16.0, 0.001, 0.0f, 0.0f, -1.0f);
        } else {
            ItemRenderer.func_78439_a((Tessellator)Tessellator.field_78398_a, (float)icon.func_94212_f(), (float)icon.func_94206_g(), (float)icon.func_94209_e(), (float)icon.func_94210_h(), (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)0.0625f);
        }
        GL11.glPopMatrix();
    }
}

