/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.automation;

import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Buffer;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Utility;
import gregtech.common.gui.GT_Container_Regulator;
import gregtech.common.gui.GT_GUIContainer_Regulator;
import java.util.Collections;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class GT_MetaTileEntity_Regulator
extends GT_MetaTileEntity_Buffer {
    public int[] mTargetSlots = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
    private boolean charge = false;
    private boolean decharge = false;

    public GT_MetaTileEntity_Regulator(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 20, new String[]{"Filters up to 9 different Items", "Allows Item-specific output stack size", "Allows Item-specific output slot", "Does not consume energy to move Item"});
    }

    public GT_MetaTileEntity_Regulator(String aName, int aTier, int aInvSlotCount, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aInvSlotCount, aDescription, aTextures);
    }

    public GT_MetaTileEntity_Regulator(String aName, int aTier, int aInvSlotCount, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aInvSlotCount, aDescription, aTextures);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Regulator(this.mName, (int)this.mTier, this.mInventory.length, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public ITexture getOverlayIcon() {
        return TextureFactory.of(TextureFactory.of(Textures.BlockIcons.AUTOMATION_REGULATOR), TextureFactory.builder().addIcon(Textures.BlockIcons.AUTOMATION_REGULATOR_GLOW).glow().build());
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return aIndex < 9 || aIndex == this.rechargerSlotStartIndex();
    }

    @Override
    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_Container_Regulator(aPlayerInventory, aBaseMetaTileEntity);
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_Regulator(aPlayerInventory, aBaseMetaTileEntity);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("mTargetSlot1", this.mTargetSlots[0]);
        aNBT.func_74768_a("mTargetSlot2", this.mTargetSlots[1]);
        aNBT.func_74768_a("mTargetSlot3", this.mTargetSlots[2]);
        aNBT.func_74768_a("mTargetSlot4", this.mTargetSlots[3]);
        aNBT.func_74768_a("mTargetSlot5", this.mTargetSlots[4]);
        aNBT.func_74768_a("mTargetSlot6", this.mTargetSlots[5]);
        aNBT.func_74768_a("mTargetSlot7", this.mTargetSlots[6]);
        aNBT.func_74768_a("mTargetSlot8", this.mTargetSlots[7]);
        aNBT.func_74768_a("mTargetSlot9", this.mTargetSlots[8]);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mTargetSlots[0] = aNBT.func_74762_e("mTargetSlot1");
        this.mTargetSlots[1] = aNBT.func_74762_e("mTargetSlot2");
        this.mTargetSlots[2] = aNBT.func_74762_e("mTargetSlot3");
        this.mTargetSlots[3] = aNBT.func_74762_e("mTargetSlot4");
        this.mTargetSlots[4] = aNBT.func_74762_e("mTargetSlot5");
        this.mTargetSlots[5] = aNBT.func_74762_e("mTargetSlot6");
        this.mTargetSlots[6] = aNBT.func_74762_e("mTargetSlot7");
        this.mTargetSlots[7] = aNBT.func_74762_e("mTargetSlot8");
        this.mTargetSlots[8] = aNBT.func_74762_e("mTargetSlot9");
    }

    @Override
    public void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
    }

    @Override
    public void moveItems(IGregTechTileEntity aBaseMetaTileEntity, long aTimer) {
        for (int i = 0; i < 9; ++i) {
            int tCosts;
            if (this.mInventory[i + 9] == null || (tCosts = GT_Utility.moveOneItemStackIntoSlot(this.getBaseMetaTileEntity(), this.getBaseMetaTileEntity().getTileEntityAtSide(this.getBaseMetaTileEntity().getBackFacing()), this.getBaseMetaTileEntity().getBackFacing(), this.mTargetSlots[i], Collections.singletonList(this.mInventory[i + 9]), false, (byte)this.mInventory[i + 9].field_77994_a, (byte)this.mInventory[i + 9].field_77994_a, (byte)64, (byte)1) * 3) <= 0) continue;
            this.mSuccess = 50;
            break;
        }
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return super.allowPutStack(aBaseMetaTileEntity, aIndex, aSide, aStack) && aIndex >= 0 && aIndex <= 8 && GT_Utility.areStacksEqual(aStack, this.mInventory[aIndex + 9]);
    }

    @Override
    public int rechargerSlotStartIndex() {
        return 19;
    }

    @Override
    public int dechargerSlotStartIndex() {
        return 19;
    }

    @Override
    public int rechargerSlotCount() {
        return this.charge ? 1 : 0;
    }

    @Override
    public int dechargerSlotCount() {
        return this.decharge ? 1 : 0;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide()) {
            this.charge = aBaseMetaTileEntity.getStoredEU() / 2L > aBaseMetaTileEntity.getEUCapacity() / 3L;
            this.decharge = aBaseMetaTileEntity.getStoredEU() < aBaseMetaTileEntity.getEUCapacity() / 3L;
        }
    }
}

