/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.boilers;

import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Materials;
import gregtech.api.enums.ParticleFX;
import gregtech.api.enums.SoundResource;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicTank;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.objects.XSTR;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.WorldSpawnedEventBuilder;
import gregtech.common.GT_Pollution;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public abstract class GT_MetaTileEntity_Boiler
extends GT_MetaTileEntity_BasicTank {
    public static final byte SOUND_EVENT_LET_OFF_EXCESS_STEAM = 1;
    public int mTemperature = 20;
    public int mProcessingEnergy = 0;
    public int mLossTimer = 0;
    public FluidStack mSteam = null;
    public boolean mHadNoWater = false;
    private int mExcessWater = 0;

    public GT_MetaTileEntity_Boiler(int aID, String aName, String aNameRegional, String aDescription, ITexture ... aTextures) {
        super(aID, aName, aNameRegional, 0, 4, aDescription, aTextures);
    }

    public GT_MetaTileEntity_Boiler(int aID, String aName, String aNameRegional, String[] aDescription, ITexture ... aTextures) {
        super(aID, aName, aNameRegional, 0, 4, aDescription, aTextures);
    }

    public GT_MetaTileEntity_Boiler(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 4, aDescription, aTextures);
    }

    public GT_MetaTileEntity_Boiler(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 4, aDescription, aTextures);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] tmp = this.mTextures[aSide >= 2 ? (aSide != aFacing ? (byte)2 : (byte)(aActive ? 4 : 3)) : aSide][aColorIndex + 1];
        if (aSide != aFacing && tmp.length == 2) {
            tmp = new ITexture[]{tmp[0]};
        }
        return tmp;
    }

    @Override
    public boolean isElectric() {
        return false;
    }

    @Override
    public boolean isPneumatic() {
        return false;
    }

    @Override
    public boolean isSteampowered() {
        return false;
    }

    @Override
    public boolean isSimpleMachine() {
        return false;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return aFacing > 1;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return true;
    }

    @Override
    public int getProgresstime() {
        return this.mTemperature;
    }

    @Override
    public int maxProgresstime() {
        return 500;
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        if (aPlayer != null) {
            if (GT_Utility.areStacksEqual(aPlayer.func_71045_bC(), new ItemStack(Items.field_151131_as, 1))) {
                this.fill(Materials.Water.getFluid(1000L * (long)aPlayer.func_71045_bC().field_77994_a), true);
                if (!aPlayer.field_71075_bZ.field_75098_d) {
                    aPlayer.func_71045_bC().func_150996_a(Items.field_151133_ar);
                }
            } else {
                aBaseMetaTileEntity.openGUI(aPlayer);
            }
        }
        return true;
    }

    @Override
    public boolean doesFillContainers() {
        return true;
    }

    @Override
    public boolean doesEmptyContainers() {
        return true;
    }

    @Override
    public boolean canTankBeFilled() {
        return true;
    }

    @Override
    public boolean canTankBeEmptied() {
        return true;
    }

    @Override
    public boolean displaysItemStack() {
        return false;
    }

    @Override
    public boolean displaysStackSize() {
        return false;
    }

    @Override
    public boolean isFluidInputAllowed(FluidStack aFluid) {
        return GT_ModHandler.isWater(aFluid);
    }

    @Override
    public FluidStack getDrainableStack() {
        return this.mSteam;
    }

    @Override
    public FluidStack setDrainableStack(FluidStack aFluid) {
        this.mSteam = aFluid;
        return this.mSteam;
    }

    @Override
    public boolean isDrainableStackSeparate() {
        return true;
    }

    @Override
    public boolean allowCoverOnSide(byte aSide, GT_ItemStack aCover) {
        return GregTech_API.getCoverBehaviorNew(aCover.toStack()).isSimpleCover();
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("mLossTimer", this.mLossTimer);
        aNBT.func_74768_a("mTemperature", this.mTemperature);
        aNBT.func_74768_a("mProcessingEnergy", this.mProcessingEnergy);
        aNBT.func_74768_a("mExcessWater", this.mExcessWater);
        if (this.mSteam == null) {
            return;
        }
        try {
            aNBT.func_74782_a("mSteam", (NBTBase)this.mSteam.writeToNBT(new NBTTagCompound()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mLossTimer = aNBT.func_74762_e("mLossTimer");
        this.mTemperature = aNBT.func_74762_e("mTemperature");
        this.mProcessingEnergy = aNBT.func_74762_e("mProcessingEnergy");
        this.mExcessWater = aNBT.func_74762_e("mExcessWater");
        this.mSteam = FluidStack.loadFluidStackFromNBT((NBTTagCompound)aNBT.func_74775_l("mSteam"));
    }

    protected void produceSteam(int aAmount) {
        this.mExcessWater -= aAmount;
        if (this.mExcessWater < 0) {
            int tWaterToConsume = -this.mExcessWater / 160;
            this.mFluid.amount -= tWaterToConsume;
            this.mExcessWater += 160 * tWaterToConsume;
        }
        if (GT_ModHandler.isSteam(this.mSteam)) {
            this.mSteam.amount += aAmount;
        } else {
            this.mSteam = GT_ModHandler.getSteam(aAmount);
        }
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        this.pollute(aTick);
        if (this.isNotAllowedToWork(aBaseMetaTileEntity, aTick)) {
            return;
        }
        this.calculateCooldown();
        this.pushSteamToInventories(aBaseMetaTileEntity);
        if (this.canNotCreateSteam(aBaseMetaTileEntity, aTick)) {
            this.pollute(aTick);
            return;
        }
        this.ventSteamIfTankIsFull();
        this.updateFuelTimed(aBaseMetaTileEntity, aTick);
        this.calculateHeatUp(aBaseMetaTileEntity, aTick);
    }

    private boolean isNotAllowedToWork(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        return !aBaseMetaTileEntity.isServerSide() || aTick <= 20L;
    }

    private void pollute(long aTick) {
        if (this.mProcessingEnergy > 0 && aTick % 20L == 0L) {
            GT_Pollution.addPollution(this.getBaseMetaTileEntity(), this.getPollution());
        }
    }

    private void calculateHeatUp(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (this.mTemperature < this.getMaxTemperature() && this.mProcessingEnergy > 0 && aTick % (long)this.getHeatUpRate() == 0L) {
            this.mProcessingEnergy -= this.getEnergyConsumption();
            this.mTemperature += this.getHeatUpAmount();
        }
        aBaseMetaTileEntity.setActive(this.mProcessingEnergy > 0);
    }

    private void updateFuelTimed(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (this.mProcessingEnergy <= 0 && aBaseMetaTileEntity.isAllowedToWork()) {
            this.updateFuel(aBaseMetaTileEntity, aTick);
        }
    }

    private void ventSteamIfTankIsFull() {
        if (this.mSteam != null && this.mSteam.amount > this.getCapacity()) {
            this.sendSound((byte)1);
            this.mSteam.amount = this.getCapacity() * 3 / 4;
        }
    }

    private boolean canNotCreateSteam(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aTick % 10L != 0L) {
            return false;
        }
        if (this.mTemperature > 100) {
            if (!GT_ModHandler.isWater(this.mFluid) || this.mFluid.amount <= 0) {
                this.mHadNoWater = true;
            } else {
                if (this.mHadNoWater) {
                    GT_Log.exp.println("Boiler " + this.mName + " had no Water!");
                    this.onDangerousWaterLack(aBaseMetaTileEntity, aTick);
                    return true;
                }
                this.produceSteam(this.getProductionPerSecond() / 2);
            }
        } else {
            this.mHadNoWater = false;
        }
        return false;
    }

    protected void onDangerousWaterLack(IGregTechTileEntity tile, long ignoredTicks) {
        tile.doExplosion(2048L);
    }

    protected final void pushSteamToSide(IGregTechTileEntity aBaseMetaTileEntity, int aSide) {
        IFluidHandler tTileEntity = aBaseMetaTileEntity.getITankContainerAtSide((byte)aSide);
        if (tTileEntity == null) {
            return;
        }
        FluidStack tDrained = aBaseMetaTileEntity.drain(ForgeDirection.getOrientation((int)aSide), Math.max(1, this.mSteam.amount / 2), false);
        if (tDrained == null) {
            return;
        }
        int tFilledAmount = tTileEntity.fill(ForgeDirection.getOrientation((int)aSide).getOpposite(), tDrained, false);
        if (tFilledAmount <= 0) {
            return;
        }
        tTileEntity.fill(ForgeDirection.getOrientation((int)aSide).getOpposite(), aBaseMetaTileEntity.drain(ForgeDirection.getOrientation((int)aSide), tFilledAmount, true), true);
    }

    protected void pushSteamToInventories(IGregTechTileEntity aBaseMetaTileEntity) {
        for (int i = 1; this.mSteam != null && i < 6; ++i) {
            if (i == aBaseMetaTileEntity.getFrontFacing()) continue;
            this.pushSteamToSide(aBaseMetaTileEntity, i);
        }
    }

    private void calculateCooldown() {
        if (this.mTemperature <= 20) {
            this.mTemperature = 20;
            this.mLossTimer = 0;
        } else if (++this.mLossTimer > this.getCooldownInterval()) {
            --this.mTemperature;
            this.mLossTimer = 0;
        }
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return GT_Mod.gregtechproxy.mAllowSmallBoilerAutomation;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return GT_Mod.gregtechproxy.mAllowSmallBoilerAutomation;
    }

    @Override
    public void doSound(byte aIndex, double aX, double aY, double aZ) {
        if (aIndex == 1) {
            GT_Utility.doSoundAtClient(SoundResource.RANDOM_FIZZ, 2, 1.0f, aX, aY, aZ);
            ((WorldSpawnedEventBuilder.ParticleEventBuilder)new WorldSpawnedEventBuilder.ParticleEventBuilder().setIdentifier((Enum)ParticleFX.CLOUD)).setWorld(this.getBaseMetaTileEntity().getWorld()).setMotion(0.0, 0.0, 0.0).times(8, x -> x.setPosition(aX - 0.5 + (double)XSTR.XSTR_INSTANCE.nextFloat(), aY, aZ - 0.5 + (double)XSTR.XSTR_INSTANCE.nextFloat()).run());
        }
    }

    @Override
    public int getTankPressure() {
        return 100;
    }

    protected boolean isOutputToFront() {
        return false;
    }

    protected abstract int getPollution();

    @Override
    public int getCapacity() {
        return 16000;
    }

    protected abstract int getProductionPerSecond();

    protected abstract int getMaxTemperature();

    protected abstract int getEnergyConsumption();

    protected abstract int getCooldownInterval();

    protected int getHeatUpRate() {
        return 12;
    }

    protected int getHeatUpAmount() {
        return 1;
    }

    protected abstract void updateFuel(IGregTechTileEntity var1, long var2);
}

