/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.IStructureElementCheckOnly;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.items.GT_MetaGenerated_Tool;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_EnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Dynamo;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Muffler;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gregtech.common.items.GT_MetaGenerated_Tool_01;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;

public abstract class GT_MetaTileEntity_LargeTurbine
extends GT_MetaTileEntity_EnhancedMultiBlockBase<GT_MetaTileEntity_LargeTurbine>
implements ISurvivalConstructable {
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final ClassValue<IStructureDefinition<GT_MetaTileEntity_LargeTurbine>> STRUCTURE_DEFINITION = new ClassValue<IStructureDefinition<GT_MetaTileEntity_LargeTurbine>>(){

        @Override
        protected IStructureDefinition<GT_MetaTileEntity_LargeTurbine> computeValue(Class<?> type) {
            return StructureDefinition.builder().addShape(GT_MetaTileEntity_LargeTurbine.STRUCTURE_PIECE_MAIN, StructureUtility.transpose((String[][])new String[][]{{"     ", "xxxxx", "xxxxx", "xxxxx", "xxxxx"}, {" --- ", "xcccx", "xhhhx", "xhhhx", "xhhhx"}, {" --- ", "xc~cx", "xh-hx", "xh-hx", "xhdhx"}, {" --- ", "xcccx", "xhhhx", "xhhhx", "xhhhx"}, {"     ", "xxxxx", "xxxxx", "xxxxx", "xxxxx"}})).addElement('c', (IStructureElement)StructureUtility.lazy(t -> StructureUtility.ofBlock((Block)t.getCasingBlock(), (int)t.getCasingMeta()))).addElement('d', (IStructureElement)StructureUtility.lazy(t -> GT_HatchElement.Dynamo.newAny(t.getCasingTextureIndex(), 1))).addElement('h', (IStructureElement)StructureUtility.lazy(t -> GT_StructureUtility.buildHatchAdder(GT_MetaTileEntity_LargeTurbine.class).atLeast(GT_HatchElement.Maintenance, GT_HatchElement.InputHatch, GT_HatchElement.OutputHatch, GT_HatchElement.OutputBus, GT_HatchElement.InputBus, GT_HatchElement.Muffler).casingIndex(t.getCasingTextureIndex()).dot(2).buildAndChain(t.getCasingBlock(), t.getCasingMeta()))).addElement('x', (IStructureElement)((IStructureElementCheckOnly)(aContext, aWorld, aX, aY, aZ) -> {
                TileEntity tTile = aWorld.func_147438_o(aX, aY, aZ);
                return !(tTile instanceof IGregTechTileEntity) || !(((IGregTechTileEntity)tTile).getMetaTileEntity() instanceof GT_MetaTileEntity_LargeTurbine);
            })).build();
        }
    };
    protected int baseEff = 0;
    protected int optFlow = 0;
    protected double realOptFlow = 0.0;
    protected int storedFluid = 0;
    protected int counter = 0;
    protected boolean looseFit = false;
    protected int overflowMultiplier = 0;
    protected float[] flowMultipliers = new float[]{1.0f, 1.0f, 1.0f};

    public GT_MetaTileEntity_LargeTurbine(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_LargeTurbine(String aName) {
        super(aName);
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return this.getMaxEfficiency(aStack) > 0;
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "LargeTurbine.png");
    }

    @Override
    public IStructureDefinition<GT_MetaTileEntity_LargeTurbine> getStructureDefinition() {
        return STRUCTURE_DEFINITION.get(this.getClass());
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        return this.checkPiece(STRUCTURE_PIECE_MAIN, 2, 2, 1) && this.mMaintenanceHatches.size() == 1 && this.mMufflerHatches.isEmpty() == (this.getPollutionPerTick(null) == 0);
    }

    public abstract Block getCasingBlock();

    public abstract byte getCasingMeta();

    public abstract int getCasingTextureIndex();

    @Override
    public boolean addToMachineList(IGregTechTileEntity tTileEntity, int aBaseCasingIndex) {
        return this.addMaintenanceToMachineList(tTileEntity, this.getCasingTextureIndex()) || this.addInputToMachineList(tTileEntity, this.getCasingTextureIndex()) || this.addOutputToMachineList(tTileEntity, this.getCasingTextureIndex()) || this.addMufflerToMachineList(tTileEntity, this.getCasingTextureIndex());
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
    }

    @Override
    public boolean checkRecipe(ItemStack aStack) {
        if (!((this.counter & 7) != 0 || aStack != null && aStack.func_77973_b() instanceof GT_MetaGenerated_Tool && aStack.func_77960_j() >= 170 && aStack.func_77960_j() <= 179)) {
            this.stopMachine();
            return false;
        }
        ArrayList<FluidStack> tFluids = this.getStoredFluids();
        if (!tFluids.isEmpty()) {
            if (this.baseEff == 0 || this.optFlow == 0 || this.counter >= 512 || this.getBaseMetaTileEntity().hasWorkJustBeenEnabled() || this.getBaseMetaTileEntity().hasInventoryBeenModified()) {
                this.counter = 0;
                this.baseEff = GT_Utility.safeInt((long)((5.0f + ((GT_MetaGenerated_Tool)aStack.func_77973_b()).getToolCombatDamage(aStack)) * 1000.0f));
                this.optFlow = GT_Utility.safeInt((long)Math.max(Float.MIN_NORMAL, ((GT_MetaGenerated_Tool)aStack.func_77973_b()).getToolStats(aStack).getSpeedMultiplier() * GT_MetaGenerated_Tool.getPrimaryMaterial((ItemStack)aStack).mToolSpeed * 50.0f));
                this.overflowMultiplier = this.getOverflowMultiplier(aStack);
                this.flowMultipliers[0] = GT_MetaGenerated_Tool.getPrimaryMaterial((ItemStack)aStack).mSteamMultiplier;
                this.flowMultipliers[1] = GT_MetaGenerated_Tool.getPrimaryMaterial((ItemStack)aStack).mGasMultiplier;
                this.flowMultipliers[2] = GT_MetaGenerated_Tool.getPrimaryMaterial((ItemStack)aStack).mPlasmaMultiplier;
                if (this.optFlow <= 0 || this.baseEff <= 0) {
                    this.stopMachine();
                    return false;
                }
            } else {
                ++this.counter;
            }
        }
        int newPower = this.fluidIntoPower(tFluids, this.optFlow, this.baseEff, this.overflowMultiplier, this.flowMultipliers);
        int difference = newPower - this.mEUt;
        int maxChangeAllowed = Math.max(10, GT_Utility.safeInt((long)Math.abs(difference) / 100L));
        if (Math.abs(difference) > maxChangeAllowed) {
            int change = maxChangeAllowed * (difference > 0 ? 1 : -1);
            this.mEUt += change;
        } else {
            this.mEUt = newPower;
        }
        if (this.mEUt <= 0) {
            this.mEUt = 0;
            this.mEfficiency = 0;
            return false;
        }
        this.mMaxProgresstime = 1;
        this.mEfficiencyIncrease = 10;
        return true;
    }

    abstract int fluidIntoPower(ArrayList<FluidStack> var1, int var2, int var3, int var4, float[] var5);

    abstract float getOverflowEfficiency(int var1, int var2, int var3);

    public long getMaximumOutput() {
        long aTotal = 0L;
        for (GT_MetaTileEntity_Hatch_Dynamo aDynamo : this.mDynamoHatches) {
            if (!GT_MetaTileEntity_LargeTurbine.isValidMetaTileEntity(aDynamo)) continue;
            long aVoltage = aDynamo.maxEUOutput();
            aTotal = aDynamo.maxAmperesOut() * aVoltage;
        }
        return aTotal;
    }

    public int getOverflowMultiplier(ItemStack aStack) {
        int aOverflowMultiplier = 0;
        byte toolQualityLevel = GT_MetaGenerated_Tool.getPrimaryMaterial((ItemStack)aStack).mToolQuality;
        aOverflowMultiplier = toolQualityLevel >= 6 ? 3 : (toolQualityLevel >= 3 ? 2 : 1);
        return aOverflowMultiplier;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 1;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        if (GT_Utility.isStackInvalid(aStack)) {
            return 0;
        }
        if (aStack.func_77973_b() instanceof GT_MetaGenerated_Tool_01) {
            return 10000;
        }
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return true;
    }

    @Override
    public String[] getInfoData() {
        int mPollutionReduction = 0;
        for (GT_MetaTileEntity_Hatch_Muffler tHatch : this.mMufflerHatches) {
            if (!GT_MetaTileEntity_LargeTurbine.isValidMetaTileEntity(tHatch)) continue;
            mPollutionReduction = Math.max(tHatch.calculatePollutionReduction(100), mPollutionReduction);
        }
        String tRunning = this.mMaxProgresstime > 0 ? EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"GT5U.turbine.running.true") + EnumChatFormatting.RESET : EnumChatFormatting.RED + StatCollector.func_74838_a((String)"GT5U.turbine.running.false") + EnumChatFormatting.RESET;
        String tMaintainance = this.getIdealStatus() == this.getRepairStatus() ? EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"GT5U.turbine.maintenance.false") + EnumChatFormatting.RESET : EnumChatFormatting.RED + StatCollector.func_74838_a((String)"GT5U.turbine.maintenance.true") + EnumChatFormatting.RESET;
        int tDura = 0;
        if (this.mInventory[1] != null && this.mInventory[1].func_77973_b() instanceof GT_MetaGenerated_Tool_01) {
            tDura = GT_Utility.safeInt((long)(100.0f / (float)GT_MetaGenerated_Tool.getToolMaxDamage(this.mInventory[1]) * (float)GT_MetaGenerated_Tool.getToolDamage(this.mInventory[1]) + 1.0f));
        }
        long storedEnergy = 0L;
        long maxEnergy = 0L;
        for (GT_MetaTileEntity_Hatch_Dynamo tHatch : this.mDynamoHatches) {
            if (!GT_MetaTileEntity_LargeTurbine.isValidMetaTileEntity(tHatch)) continue;
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        String[] ret = new String[]{tRunning + ": " + EnumChatFormatting.RED + GT_Utility.formatNumbers((long)this.mEUt * (long)this.mEfficiency / 10000L) + EnumChatFormatting.RESET + " EU/t", tMaintainance, StatCollector.func_74838_a((String)"GT5U.turbine.efficiency") + ": " + EnumChatFormatting.YELLOW + (float)this.mEfficiency / 100.0f + EnumChatFormatting.RESET + "%", StatCollector.func_74838_a((String)"GT5U.multiblock.energy") + ": " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers(storedEnergy) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(maxEnergy) + EnumChatFormatting.RESET + " EU", StatCollector.func_74838_a((String)"GT5U.turbine.flow") + ": " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(GT_Utility.safeInt((long)this.realOptFlow)) + EnumChatFormatting.RESET + " L/t" + EnumChatFormatting.YELLOW + " (" + (this.looseFit ? StatCollector.func_74838_a((String)"GT5U.turbine.loose") : StatCollector.func_74838_a((String)"GT5U.turbine.tight")) + ")", StatCollector.func_74838_a((String)"GT5U.turbine.fuel") + ": " + EnumChatFormatting.GOLD + GT_Utility.formatNumbers(this.storedFluid) + EnumChatFormatting.RESET + "L", StatCollector.func_74838_a((String)"GT5U.turbine.dmg") + ": " + EnumChatFormatting.RED + tDura + EnumChatFormatting.RESET + "%", StatCollector.func_74838_a((String)"GT5U.multiblock.pollution") + ": " + EnumChatFormatting.GREEN + mPollutionReduction + EnumChatFormatting.RESET + " %"};
        if (!this.getClass().getName().contains("Steam")) {
            ret[4] = StatCollector.func_74838_a((String)"GT5U.turbine.flow") + ": " + EnumChatFormatting.YELLOW + GT_Utility.safeInt((long)this.realOptFlow) + EnumChatFormatting.RESET + " L/t";
        }
        return ret;
    }

    public boolean hasTurbine() {
        return this.getMaxEfficiency(this.mInventory[1]) > 0;
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 2, 2, 1);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 2, 2, 1, elementBudget, env, false, true);
    }
}

