/*
 * Decompiled with CFR 0.152.
 */
package gregtech.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.ItemList;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.guihook.IContainerInputHandler;
import codechicken.nei.guihook.IContainerTooltipHandler;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IRecipeHandler;
import codechicken.nei.recipe.IUsageHandler;
import codechicken.nei.recipe.RecipeCatalysts;
import codechicken.nei.recipe.RecipeInfo;
import codechicken.nei.recipe.TemplateRecipeHandler;
import gregtech.GT_Mod;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.HeatingCoilLevel;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.gui.GT_GUIContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine;
import gregtech.api.objects.ItemData;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.common.blocks.GT_Item_Machines;
import gregtech.common.power.EUPower;
import gregtech.common.power.Power;
import gregtech.common.power.UnspecifiedEUPower;
import gregtech.nei.NEIHandlerAbsoluteTooltip;
import gregtech.nei.NEI_TransferRectHost;
import gregtech.nei.RecipeMapHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.Range;
import org.lwjgl.opengl.GL11;

public class GT_NEI_DefaultHandler
extends RecipeMapHandler {
    public static final int sOffsetX = 5;
    public static final int sOffsetY = 11;
    private static final int M = 1000000;
    private static final ConcurrentMap<GT_Recipe.GT_Recipe_Map, SortedRecipeListCache> CACHE = new ConcurrentHashMap<GT_Recipe.GT_Recipe_Map, SortedRecipeListCache>();
    protected Power mPower;
    private String mRecipeName;
    private NEIHandlerAbsoluteTooltip mRecipeNameTooltip;
    private static final int RECIPE_NAME_WIDTH = 140;
    public static int cycleTicksStatic = Math.abs((int)System.currentTimeMillis());

    public GT_NEI_DefaultHandler(GT_Recipe.GT_Recipe_Map aRecipeMap) {
        super(aRecipeMap);
        if ("gt.recipe.complexfusionreactor".equals(aRecipeMap.mUnlocalizedName)) {
            this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(74, 23, 18, 18), this.getOverlayIdentifier(), new Object[0]));
        } else {
            this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(65, 13, 36, 18), this.getOverlayIdentifier(), new Object[0]));
        }
    }

    @Deprecated
    public List<GT_Recipe> getSortedRecipes() {
        ArrayList<GT_Recipe> result = new ArrayList<GT_Recipe>(this.mRecipeMap.mRecipeList);
        Collections.sort(result);
        return result;
    }

    private SortedRecipeListCache getCacheHolder() {
        return CACHE.computeIfAbsent(this.mRecipeMap, m -> new SortedRecipeListCache());
    }

    public List<CachedDefaultRecipe> getCache() {
        List<CachedDefaultRecipe> cache;
        SortedRecipeListCache cacheHolder = this.getCacheHolder();
        if (cacheHolder.getCachedRecipesVersion() != GT_Mod.gregtechproxy.getReloadCount() || (cache = cacheHolder.getCachedRecipes()) == null) {
            cache = this.mRecipeMap.mRecipeList.stream().filter(r -> !r.mHidden).sorted().map(x$0 -> new CachedDefaultRecipe((GT_Recipe)x$0)).collect(Collectors.toList());
            cacheHolder.setCachedRecipes(cache);
            cacheHolder.setCachedRecipesVersion(GT_Mod.gregtechproxy.getReloadCount());
        }
        return cache;
    }

    public TemplateRecipeHandler newInstance() {
        return new GT_NEI_DefaultHandler(this.mRecipeMap);
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getOverlayIdentifier())) {
            if (results.length > 0 && results[0] instanceof Power) {
                this.mPower = (Power)results[0];
                this.loadTieredCraftingRecipesUpTo(this.mPower.getTier());
            } else {
                this.arecipes.addAll(this.getCache());
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack aResult) {
        ItemData tPrefixMaterial = GT_OreDictUnificator.getAssociation(aResult);
        ArrayList<ItemStack> tResults = new ArrayList<ItemStack>();
        tResults.add(aResult);
        tResults.add(GT_OreDictUnificator.get(true, aResult));
        if (tPrefixMaterial != null && !tPrefixMaterial.mBlackListed && !tPrefixMaterial.mPrefix.mFamiliarPrefixes.isEmpty()) {
            for (OrePrefixes tPrefix : tPrefixMaterial.mPrefix.mFamiliarPrefixes) {
                tResults.add(GT_OreDictUnificator.get(tPrefix, tPrefixMaterial.mMaterial.mMaterial, 1L));
            }
        }
        this.addFluidStacks(aResult, tResults);
        for (CachedDefaultRecipe recipe : this.getCache()) {
            if (!tResults.stream().anyMatch(stack -> recipe.contains(recipe.mOutputs, (ItemStack)stack))) continue;
            this.arecipes.add(recipe);
        }
    }

    private void addFluidStacks(ItemStack aStack, ArrayList<ItemStack> tResults) {
        FluidStack tFluidStack;
        FluidStack tFluid = GT_Utility.getFluidForFilledItem(aStack, true);
        if (tFluid != null) {
            tFluidStack = tFluid;
            tResults.add(GT_Utility.getFluidDisplayStack(tFluid, false));
        } else {
            tFluidStack = GT_Utility.getFluidFromDisplayStack(aStack);
        }
        if (tFluidStack != null) {
            tResults.addAll(GT_Utility.getContainersFromFluid(tFluidStack));
        }
    }

    private void loadTieredCraftingRecipesUpTo(byte upperTier) {
        this.arecipes.addAll(this.getTieredRecipes(upperTier));
    }

    private List<CachedDefaultRecipe> getTieredRecipes(byte upperTier) {
        List<CachedDefaultRecipe> recipes = this.getCache();
        if (recipes.size() > 0) {
            Range<Integer> indexRange = this.getCacheHolder().getIndexRangeForTiers((byte)0, upperTier);
            recipes = recipes.subList((Integer)indexRange.getMinimum(), (Integer)indexRange.getMaximum() + 1);
        }
        return recipes;
    }

    public void loadUsageRecipes(ItemStack aInput) {
        ItemData tPrefixMaterial = GT_OreDictUnificator.getAssociation(aInput);
        ArrayList<ItemStack> tInputs = new ArrayList<ItemStack>();
        tInputs.add(aInput);
        tInputs.add(GT_OreDictUnificator.get(false, aInput));
        if (tPrefixMaterial != null && !tPrefixMaterial.mPrefix.mFamiliarPrefixes.isEmpty()) {
            for (OrePrefixes tPrefix : tPrefixMaterial.mPrefix.mFamiliarPrefixes) {
                tInputs.add(GT_OreDictUnificator.get(tPrefix, tPrefixMaterial.mMaterial.mMaterial, 1L));
            }
        }
        this.addFluidStacks(aInput, tInputs);
        for (CachedDefaultRecipe recipe : this.getCache()) {
            if (!tInputs.stream().anyMatch(stack -> recipe.contains(recipe.mInputs, (ItemStack)stack))) continue;
            this.arecipes.add(recipe);
        }
    }

    public IUsageHandler getUsageAndCatalystHandler(String inputId, Object ... ingredients) {
        if (inputId.equals("item")) {
            ItemStack candidate = (ItemStack)ingredients[0];
            GT_NEI_DefaultHandler handler = (GT_NEI_DefaultHandler)this.newInstance();
            if (RecipeCatalysts.containsCatalyst((IRecipeHandler)handler, (ItemStack)candidate)) {
                IMetaTileEntity gtTileEntity = GT_Item_Machines.getMetaTileEntity(candidate);
                if (gtTileEntity instanceof GT_MetaTileEntity_BasicMachine) {
                    Power power = ((GT_MetaTileEntity_BasicMachine)gtTileEntity).getPower();
                    handler.loadCraftingRecipes(this.getOverlayIdentifier(), power);
                } else {
                    handler.loadCraftingRecipes(this.getOverlayIdentifier(), new Object[]{null});
                }
                return handler;
            }
        }
        return this.getUsageHandler(inputId, ingredients);
    }

    public ICraftingHandler getRecipeHandler(String outputId, Object ... results) {
        GT_NEI_DefaultHandler handler = (GT_NEI_DefaultHandler)super.getRecipeHandler(outputId, results);
        if (results.length > 0 && results[0] instanceof Power) {
            handler.mPower = (Power)results[0];
        }
        return handler;
    }

    public String getOverlayIdentifier() {
        return this.mRecipeMap.mNEIName;
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)-4, (int)-8, (int)1, (int)3, (int)174, (int)78);
    }

    public void onUpdate() {
        super.onUpdate();
        if (!NEIClientUtils.shiftKey()) {
            ++cycleTicksStatic;
        }
    }

    public int recipiesPerPage() {
        return 1;
    }

    public String getRecipeName() {
        if (this.mRecipeName == null) {
            this.mRecipeName = this.computeRecipeName();
            this.updateOverrideTextColor();
        }
        return this.mRecipeName;
    }

    private String computeRecipeName() {
        String recipeName = GT_LanguageManager.getTranslation(this.mRecipeMap.mUnlocalizedName);
        if (this.mPower != null) {
            recipeName = this.addSuffixToRecipeName(recipeName, this.mPower.getTierString() + ")");
        }
        return recipeName;
    }

    private String addSuffixToRecipeName(String aRecipeName, String suffix) {
        String separator;
        String recipeName;
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int recipeNameWidth = fontRenderer.func_78256_a(aRecipeName);
        int targetWidth = 140 - fontRenderer.func_78256_a(suffix);
        if (recipeNameWidth + fontRenderer.func_78256_a(" (") <= targetWidth) {
            recipeName = aRecipeName;
            separator = " (";
        } else {
            this.setupRecipeNameTooltip(aRecipeName + " (" + suffix);
            separator = "...(";
            recipeName = this.shrinkRecipeName(aRecipeName, targetWidth - fontRenderer.func_78256_a(separator));
        }
        return recipeName + separator + suffix;
    }

    private String shrinkRecipeName(String recipeName, int targetWidth) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        while (fontRenderer.func_78256_a(recipeName = recipeName.substring(0, recipeName.length() - 2)) > targetWidth) {
        }
        return recipeName;
    }

    private void setupRecipeNameTooltip(String tooltip) {
        this.mRecipeNameTooltip = new NEIHandlerAbsoluteTooltip(tooltip, new Rectangle(13, -34, 139, 11));
    }

    public String getRecipeTabName() {
        return GT_LanguageManager.getTranslation(this.mRecipeMap.mUnlocalizedName);
    }

    public String getGuiTexture() {
        return this.mRecipeMap.mNEIGUIPath;
    }

    public List<String> handleItemTooltip(GuiRecipe<?> gui, ItemStack aStack, List<String> currentTip, int aRecipeIndex) {
        TemplateRecipeHandler.CachedRecipe tObject = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(aRecipeIndex);
        if (tObject instanceof CachedDefaultRecipe) {
            CachedDefaultRecipe tRecipe = (CachedDefaultRecipe)tObject;
            for (PositionedStack tStack : tRecipe.mOutputs) {
                if (aStack != tStack.item) continue;
                if (!(tStack instanceof FixedPositionedStack) || ((FixedPositionedStack)tStack).mChance <= 0 || ((FixedPositionedStack)tStack).mChance == 10000) break;
                currentTip.add(GT_Utility.trans("150", "Chance: ") + ((FixedPositionedStack)tStack).mChance / 100 + "." + (((FixedPositionedStack)tStack).mChance % 100 < 10 ? "0" + ((FixedPositionedStack)tStack).mChance % 100 : Integer.valueOf(((FixedPositionedStack)tStack).mChance % 100)) + "%");
                break;
            }
            for (PositionedStack tStack : tRecipe.mInputs) {
                if (aStack != tStack.item) continue;
                if (gregtech.api.enums.ItemList.Display_Fluid.isStackEqual(tStack.item, true, true) || tStack.item.field_77994_a != 0) break;
                currentTip.add(GT_Utility.trans("151", "Does not get consumed in the process"));
                break;
            }
        }
        if (this.mRecipeNameTooltip != null) {
            this.mRecipeNameTooltip.handleTooltip(currentTip, aRecipeIndex);
        }
        return currentTip;
    }

    private Power getPowerFromRecipeMap() {
        EUPower power = this.mRecipeMap.mShowVoltageAmperageInNEI ? new EUPower(1, this.mRecipeMap.mAmperage) : new UnspecifiedEUPower(1, this.mRecipeMap.mAmperage);
        return power;
    }

    public void drawExtras(int aRecipeIndex) {
        GT_Recipe recipe = ((CachedDefaultRecipe)((Object)this.arecipes.get((int)aRecipeIndex))).mRecipe;
        String[] recipeDesc = recipe.getNeiDesc();
        if (recipeDesc == null) {
            this.drawDescription(recipe);
        } else {
            this.drawOverrideDescription(recipeDesc);
        }
    }

    private void drawDescription(GT_Recipe recipe) {
        if (this.mPower == null) {
            this.mPower = this.getPowerFromRecipeMap();
        }
        this.mPower.computePowerUsageAndDuration(recipe.mEUt, recipe.mDuration);
        int lineCounter = 0;
        if (this.mPower.getEuPerTick() > 0) {
            this.drawLine(lineCounter, GT_Utility.trans("152", "Total: ") + this.mPower.getTotalPowerString());
            ++lineCounter;
            String amperage = this.mPower.getAmperageString();
            String powerUsage = this.mPower.getPowerUsageString();
            if (amperage == null || amperage.equals("unspecified") || powerUsage.contains("(OC)")) {
                Power originalPower;
                this.drawLine(lineCounter, GT_Utility.trans("153", "Usage: ") + powerUsage);
                ++lineCounter;
                if (GT_Mod.gregtechproxy.mNEIOriginalVoltage && !((originalPower = this.getPowerFromRecipeMap()) instanceof UnspecifiedEUPower)) {
                    originalPower.computePowerUsageAndDuration(recipe.mEUt, recipe.mDuration);
                    this.drawLine(lineCounter, GT_Utility.trans("228", "Original voltage: ") + originalPower.getVoltageString());
                    ++lineCounter;
                }
                if (amperage != null && !amperage.equals("unspecified") && !amperage.equals("1")) {
                    this.drawLine(lineCounter, GT_Utility.trans("155", "Amperage: ") + amperage);
                    ++lineCounter;
                }
            } else if (amperage.equals("1")) {
                this.drawLine(lineCounter, GT_Utility.trans("154", "Voltage: ") + this.mPower.getVoltageString());
                ++lineCounter;
            } else {
                this.drawLine(lineCounter, GT_Utility.trans("153", "Usage: ") + powerUsage);
                this.drawLine(++lineCounter, GT_Utility.trans("154", "Voltage: ") + this.mPower.getVoltageString());
                this.drawLine(++lineCounter, GT_Utility.trans("155", "Amperage: ") + amperage);
                ++lineCounter;
            }
        }
        if (this.mPower.getDurationTicks() > 0) {
            if (GT_Mod.gregtechproxy.mNEIRecipeSecondMode) {
                if (this.mPower.getDurationSeconds() > 1.0) {
                    this.drawLine(lineCounter, GT_Utility.trans("158", "Time: ") + this.mPower.getDurationStringSeconds());
                } else {
                    this.drawLine(lineCounter, GT_Utility.trans("158", "Time: ") + this.mPower.getDurationStringSeconds() + String.format(" (%s)", this.mPower.getDurationStringTicks()));
                }
            } else {
                this.drawLine(lineCounter, GT_Utility.trans("158", "Time: ") + this.mPower.getDurationStringTicks());
            }
            ++lineCounter;
        }
        if (this.mRecipeMap.mNEIName.equals("gt.recipe.fusionreactor") || this.mRecipeMap.mNEIName.equals("gt.recipe.complexfusionreactor")) {
            if (this.drawOptionalLine(lineCounter, this.getSpecialInfo(recipe.mSpecialValue) + " " + this.formatSpecialValueFusion(recipe.mSpecialValue, recipe.mEUt))) {
                ++lineCounter;
            }
        } else if (GT_Utility.isStringValid(this.mRecipeMap.mNEISpecialValuePre) && this.mRecipeMap.mNEISpecialValuePre.toLowerCase().contains("heat capacity")) {
            this.drawLine(lineCounter, this.getSpecialInfo(recipe.mSpecialValue));
            this.drawLine(++lineCounter, " " + this.formatSpecialValueHeatCoil(recipe.mSpecialValue));
            ++lineCounter;
        } else if (this.drawOptionalLine(lineCounter, this.getSpecialInfo(recipe.mSpecialValue))) {
            ++lineCounter;
        }
        if (GT_Mod.gregtechproxy.mNEIRecipeOwner) {
            if (recipe.owners.size() > 1) {
                this.drawLine(lineCounter, EnumChatFormatting.ITALIC + GT_Utility.trans("226", "Original Recipe by: ") + recipe.owners.get(0).getName());
                ++lineCounter;
                for (int i = 1; i < recipe.owners.size(); ++i) {
                    this.drawLine(lineCounter, EnumChatFormatting.ITALIC + GT_Utility.trans("227", "Modified by: ") + recipe.owners.get(i).getName());
                    ++lineCounter;
                }
            } else if (recipe.owners.size() > 0) {
                this.drawLine(lineCounter, EnumChatFormatting.ITALIC + GT_Utility.trans("225", "Recipe by: ") + recipe.owners.get(0).getName());
                ++lineCounter;
            }
        }
        if (GT_Mod.gregtechproxy.mNEIRecipeOwnerStackTrace && recipe.stackTraces != null && !recipe.stackTraces.isEmpty()) {
            this.drawLine(lineCounter, "stackTrace:");
            ++lineCounter;
            for (StackTraceElement stackTrace : recipe.stackTraces.get(0)) {
                this.drawLine(lineCounter, stackTrace.toString());
                ++lineCounter;
            }
        }
    }

    private void drawOverrideDescription(String[] recipeDesc) {
        for (int i = 0; i < recipeDesc.length; ++i) {
            if (recipeDesc[i] == null) continue;
            this.drawLine(i, recipeDesc[i]);
        }
    }

    protected String getSpecialInfo(int specialValue) {
        String specialInfo = null;
        if (specialValue == -100 && GT_Mod.gregtechproxy.mLowGravProcessing) {
            specialInfo = GT_Utility.trans("159", "Needs Low Gravity");
        } else if (specialValue == -200 && GT_Mod.gregtechproxy.mEnableCleanroom) {
            specialInfo = GT_Utility.trans("160", "Needs Cleanroom");
        } else if (specialValue == -201) {
            specialInfo = GT_Utility.trans("206", "Scan for Assembly Line");
        } else if (specialValue == -300 && GT_Mod.gregtechproxy.mEnableCleanroom) {
            specialInfo = GT_Utility.trans("160", "Needs Cleanroom & LowGrav");
        } else if (specialValue == -400) {
            specialInfo = GT_Utility.trans("216", "Deprecated Recipe");
        } else if (this.hasSpecialValueFormat()) {
            specialInfo = this.formatSpecialValue(specialValue);
        }
        return specialInfo;
    }

    private boolean hasSpecialValueFormat() {
        return GT_Utility.isStringValid(this.mRecipeMap.mNEISpecialValuePre) || GT_Utility.isStringValid(this.mRecipeMap.mNEISpecialValuePost);
    }

    protected String formatSpecialValue(int SpecialValue) {
        return this.mRecipeMap.mNEISpecialValuePre + GT_Utility.formatNumbers((long)SpecialValue * (long)this.mRecipeMap.mNEISpecialValueMultiplier) + this.mRecipeMap.mNEISpecialValuePost;
    }

    private String formatSpecialValueFusion(int SpecialValue, int Voltage2) {
        int tier = SpecialValue <= 160000000 ? 1 : (SpecialValue <= 320000000 ? 2 : (SpecialValue <= 640000000 ? 3 : 4));
        if ((long)Voltage2 > GT_Values.V[6]) {
            tier = (long)Voltage2 <= GT_Values.V[7] ? Math.max(tier, 2) : ((long)Voltage2 <= GT_Values.V[8] ? Math.max(tier, 3) : 4);
        }
        return "(MK " + tier + ")";
    }

    private String formatSpecialValueHeatCoil(int heat) {
        for (HeatingCoilLevel heatLevel : HeatingCoilLevel.values()) {
            if (heatLevel == HeatingCoilLevel.None || heatLevel == HeatingCoilLevel.ULV || heatLevel.getHeat() < (long)heat) continue;
            return "(" + heatLevel.getName() + ")";
        }
        return "(" + HeatingCoilLevel.MAX.getName() + "+)";
    }

    protected boolean drawOptionalLine(int lineNumber, String line, String prefix) {
        if (line != null && !"unspecified".equals(line)) {
            this.drawLine(lineNumber, prefix + line);
            return true;
        }
        return false;
    }

    protected boolean drawOptionalLine(int lineNumber, String line) {
        if (line != null && !"unspecified".equals(line)) {
            this.drawLine(lineNumber, line);
            return true;
        }
        return false;
    }

    protected void drawLine(int lineNumber, String line) {
        this.drawText(10, this.getDescriptionYOffset() + lineNumber * 10, line, -16777216);
    }

    protected int getDescriptionYOffset() {
        return 73;
    }

    @Deprecated
    public String trans(String aKey, String aEnglish) {
        return GT_Utility.trans(aKey, aEnglish);
    }

    static {
        GuiContainerManager.addInputHandler((IContainerInputHandler)new GT_RectHandler());
        GuiContainerManager.addTooltipHandler((IContainerTooltipHandler)new GT_RectHandler());
    }

    private class SortedRecipeListCache {
        private int mCachedRecipesVersion = -1;
        @Nullable
        private SoftReference<List<CachedDefaultRecipe>> mCachedRecipes;
        private Map<Byte, Range<Integer>> mTierIndexes;
        private Range<Byte> mTierRange;

        private SortedRecipeListCache() {
        }

        public int getCachedRecipesVersion() {
            return this.mCachedRecipesVersion;
        }

        public void setCachedRecipesVersion(int aCachedRecipesVersion) {
            this.mCachedRecipesVersion = aCachedRecipesVersion;
        }

        @Nullable
        public List<CachedDefaultRecipe> getCachedRecipes() {
            return this.mCachedRecipes == null ? null : this.mCachedRecipes.get();
        }

        public void setCachedRecipes(@Nonnull List<CachedDefaultRecipe> aCachedRecipes) {
            this.mCachedRecipes = new SoftReference<List<CachedDefaultRecipe>>(aCachedRecipes);
        }

        public Range<Integer> getIndexRangeForTiers(byte lowerTier, byte upperTier) {
            if (this.mTierIndexes == null) {
                this.computeTierIndexes();
            }
            return Range.between((Comparable)Integer.valueOf(this.getLowIndexForTier(lowerTier)), (Comparable)Integer.valueOf(this.getHighIndexForTier(upperTier)));
        }

        private void computeTierIndexes() {
            this.mTierIndexes = new HashMap<Byte, Range<Integer>>(GT_Values.V.length + 1, 1.0f);
            assert (this.mCachedRecipes != null);
            Iterator<CachedDefaultRecipe> iterator = Objects.requireNonNull(this.mCachedRecipes.get()).iterator();
            int index = 0;
            int minIndex = 0;
            int maxIndex = -1;
            byte previousTier = -1;
            byte lowestTier = 0;
            while (iterator.hasNext()) {
                CachedDefaultRecipe recipe = iterator.next();
                byte recipeTier = GT_Utility.getTier(recipe.mRecipe.mEUt / GT_NEI_DefaultHandler.this.mRecipeMap.mAmperage);
                if (recipeTier != previousTier) {
                    if (maxIndex != -1) {
                        this.mTierIndexes.put(previousTier, (Range<Integer>)Range.between((Comparable)Integer.valueOf(minIndex), (Comparable)Integer.valueOf(maxIndex)));
                    } else {
                        lowestTier = recipeTier;
                    }
                    minIndex = index;
                    previousTier = recipeTier;
                }
                maxIndex = index++;
                if (iterator.hasNext()) continue;
                this.mTierIndexes.put(recipeTier, (Range<Integer>)Range.between((Comparable)Integer.valueOf(minIndex), (Comparable)Integer.valueOf(maxIndex)));
                this.mTierRange = Range.between((Comparable)Byte.valueOf(lowestTier), (Comparable)Byte.valueOf(recipeTier));
            }
        }

        private int getLowIndexForTier(byte lowerTier) {
            byte lowTier = (byte)Math.max(((Byte)this.mTierRange.getMinimum()).byteValue(), lowerTier);
            while (this.mTierIndexes.get(lowTier) == null) {
                lowTier = (byte)(lowTier + 1);
            }
            return (Integer)this.mTierIndexes.get(lowTier).getMinimum();
        }

        private int getHighIndexForTier(byte upperTier) {
            byte highTier = (byte)Math.min(((Byte)this.mTierRange.getMaximum()).byteValue(), upperTier);
            while (this.mTierIndexes.get(highTier) == null) {
                highTier = (byte)(highTier - 1);
            }
            return (Integer)this.mTierIndexes.get(highTier).getMaximum();
        }
    }

    public class CachedDefaultRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public final GT_Recipe mRecipe;
        public final List<PositionedStack> mOutputs;
        public final List<PositionedStack> mInputs;

        public void drawNEIItemAndFluidGrid(ItemStack[] ItemArray, FluidStack[] FluidArray, int x_coord_origin, int y_coord_origin, int x_dir_max_items, int y_max_dir_max_items, GT_Recipe Recipe, boolean is_input) {
            if (ItemArray.length + FluidArray.length > x_dir_max_items * y_max_dir_max_items) {
                GT_Log.err.println("Recipe cannot be properly displayed in NEI due to too many items/fluids.");
            }
            int x_max = x_coord_origin + x_dir_max_items * 18;
            int x_coord = x_coord_origin;
            int y_coord = y_coord_origin;
            for (FluidStack fluid : FluidArray) {
                if (fluid == GT_Values.NF) continue;
                if (is_input) {
                    this.mInputs.add(new FixedPositionedStack((Object)GT_Utility.getFluidDisplayStack(fluid, true), x_coord, y_coord, true));
                } else {
                    this.mOutputs.add(new FixedPositionedStack((Object)GT_Utility.getFluidDisplayStack(fluid, true), x_coord, y_coord, GT_NEI_DefaultHandler.this.mRecipeMap.mNEIUnificateOutput));
                }
                if ((x_coord += 18) != x_max) continue;
                x_coord = x_coord_origin;
                y_coord += 18;
            }
            int special_counter = 0;
            for (ItemStack item : ItemArray) {
                if (item == GT_Values.NI) continue;
                if (is_input) {
                    this.mInputs.add(new FixedPositionedStack((Object)item, x_coord, y_coord, true));
                } else {
                    this.mOutputs.add(new FixedPositionedStack(item, x_coord, y_coord, Recipe.getOutputChance(special_counter), GT_NEI_DefaultHandler.this.mRecipeMap.mNEIUnificateOutput));
                    ++special_counter;
                }
                if ((x_coord += 18) != x_max) continue;
                x_coord = x_coord_origin;
                y_coord += 18;
            }
        }

        private void drawNEIItemGrid(ItemStack[] ItemArray, int x_coord_origin, int y_coord_origin, int x_dir_max_items, int y_max_dir_max_items, GT_Recipe Recipe, boolean is_input) {
            if (ItemArray.length > x_dir_max_items * y_max_dir_max_items) {
                GT_Log.err.println("Recipe cannot be properly displayed in NEI due to too many items.");
            }
            int x_max = x_coord_origin + x_dir_max_items * 18;
            int x_coord = x_coord_origin;
            int y_coord = y_coord_origin;
            int special_counter = 0;
            for (ItemStack item : ItemArray) {
                if (item == GT_Values.NI) continue;
                if (is_input) {
                    this.mInputs.add(new FixedPositionedStack((Object)item, x_coord, y_coord, true));
                } else {
                    this.mOutputs.add(new FixedPositionedStack(item, x_coord, y_coord, Recipe.getOutputChance(special_counter), GT_NEI_DefaultHandler.this.mRecipeMap.mNEIUnificateOutput));
                    ++special_counter;
                }
                if ((x_coord += 18) != x_max) continue;
                x_coord = x_coord_origin;
                y_coord += 18;
            }
        }

        public CachedDefaultRecipe(GT_Recipe aRecipe) {
            ArrayList<PositionedStack> maybeOut;
            ArrayList<PositionedStack> maybeIn;
            super((TemplateRecipeHandler)GT_NEI_DefaultHandler.this);
            this.mRecipe = aRecipe;
            try {
                maybeIn = GT_NEI_DefaultHandler.this.mRecipeMap.getInputPositionedStacks(aRecipe);
            }
            catch (NullPointerException npe) {
                maybeIn = null;
                GT_Log.err.println("CachedDefaultRecipe - Invalid InputPositionedStacks " + aRecipe);
                npe.printStackTrace(GT_Log.err);
            }
            try {
                maybeOut = GT_NEI_DefaultHandler.this.mRecipeMap.getOutputPositionedStacks(aRecipe);
            }
            catch (NullPointerException npe) {
                maybeOut = null;
                GT_Log.err.println("CachedDefaultRecipe - Invalid OutputPositionedStacks " + aRecipe);
                npe.printStackTrace(GT_Log.err);
            }
            if (maybeOut != null && maybeIn != null) {
                this.mOutputs = maybeOut;
                this.mInputs = maybeIn;
                return;
            }
            try {
                maybeIn = aRecipe.getInputPositionedStacks();
            }
            catch (NullPointerException npe) {
                maybeIn = null;
                GT_Log.err.println("CachedDefaultRecipe - Invalid InputPositionedStacks " + aRecipe);
                npe.printStackTrace(GT_Log.err);
            }
            try {
                maybeOut = aRecipe.getOutputPositionedStacks();
            }
            catch (NullPointerException npe) {
                maybeOut = null;
                GT_Log.err.println("CachedDefaultRecipe - Invalid OutputPositionedStacks " + aRecipe);
                npe.printStackTrace(GT_Log.err);
            }
            if (maybeOut != null && maybeIn != null) {
                this.mOutputs = maybeOut;
                this.mInputs = maybeIn;
                return;
            }
            this.mOutputs = new ArrayList<PositionedStack>();
            this.mInputs = new ArrayList<PositionedStack>();
            switch (GT_NEI_DefaultHandler.this.mRecipeMap.mUsualInputCount) {
                case 0: {
                    break;
                }
                case 1: {
                    this.drawNEIItemGrid(aRecipe.mInputs, 48, 14, 1, 1, aRecipe, true);
                    break;
                }
                case 2: {
                    this.drawNEIItemGrid(aRecipe.mInputs, 30, 14, 2, 1, aRecipe, true);
                    break;
                }
                case 3: {
                    this.drawNEIItemGrid(aRecipe.mInputs, 12, 14, 3, 1, aRecipe, true);
                    break;
                }
                case 4: 
                case 5: {
                    this.drawNEIItemGrid(aRecipe.mInputs, 12, 14, 3, 2, aRecipe, true);
                    break;
                }
                case 6: {
                    this.drawNEIItemGrid(aRecipe.mInputs, 12, 5, 3, 2, aRecipe, true);
                    break;
                }
                default: {
                    this.drawNEIItemGrid(aRecipe.mInputs, 12, -4, 3, 3, aRecipe, true);
                }
            }
            switch (GT_NEI_DefaultHandler.this.mRecipeMap.mUsualOutputCount) {
                case 0: {
                    break;
                }
                case 1: {
                    this.drawNEIItemGrid(aRecipe.mOutputs, 102, 14, 1, 1, aRecipe, false);
                    break;
                }
                case 2: {
                    this.drawNEIItemGrid(aRecipe.mOutputs, 102, 14, 2, 1, aRecipe, false);
                    break;
                }
                case 3: {
                    this.drawNEIItemGrid(aRecipe.mOutputs, 102, 14, 3, 1, aRecipe, false);
                    break;
                }
                case 4: {
                    this.drawNEIItemGrid(aRecipe.mOutputs, 102, 5, 2, 2, aRecipe, false);
                    break;
                }
                case 5: 
                case 6: {
                    this.drawNEIItemGrid(aRecipe.mOutputs, 102, 5, 3, 2, aRecipe, false);
                    break;
                }
                default: {
                    this.drawNEIItemGrid(aRecipe.mOutputs, 102, -4, 3, 3, aRecipe, false);
                }
            }
            if (aRecipe.mSpecialItems != null) {
                this.mInputs.add(new FixedPositionedStack(aRecipe.mSpecialItems, 120, 52));
            }
            if (aRecipe.mFluidInputs.length > 0 && aRecipe.mFluidInputs[0] != null && aRecipe.mFluidInputs[0].getFluid() != null) {
                this.mInputs.add(new FixedPositionedStack(GT_Utility.getFluidDisplayStack(aRecipe.mFluidInputs[0], true), 48, 52));
                if (aRecipe.mFluidInputs.length > 1 && aRecipe.mFluidInputs[1] != null && aRecipe.mFluidInputs[1].getFluid() != null) {
                    this.mInputs.add(new FixedPositionedStack(GT_Utility.getFluidDisplayStack(aRecipe.mFluidInputs[1], true), 30, 52));
                }
            }
            if (aRecipe.mFluidOutputs.length > 1) {
                if (aRecipe.mFluidOutputs[0] != null && aRecipe.mFluidOutputs[0].getFluid() != null) {
                    this.mOutputs.add(new FixedPositionedStack(GT_Utility.getFluidDisplayStack(aRecipe.mFluidOutputs[0], true), 120, 5));
                }
                if (aRecipe.mFluidOutputs[1] != null && aRecipe.mFluidOutputs[1].getFluid() != null) {
                    this.mOutputs.add(new FixedPositionedStack(GT_Utility.getFluidDisplayStack(aRecipe.mFluidOutputs[1], true), 138, 5));
                }
                if (aRecipe.mFluidOutputs.length > 2 && aRecipe.mFluidOutputs[2] != null && aRecipe.mFluidOutputs[2].getFluid() != null) {
                    this.mOutputs.add(new FixedPositionedStack(GT_Utility.getFluidDisplayStack(aRecipe.mFluidOutputs[2], true), 102, 23));
                }
                if (aRecipe.mFluidOutputs.length > 3 && aRecipe.mFluidOutputs[3] != null && aRecipe.mFluidOutputs[3].getFluid() != null) {
                    this.mOutputs.add(new FixedPositionedStack(GT_Utility.getFluidDisplayStack(aRecipe.mFluidOutputs[3], true), 120, 23));
                }
                if (aRecipe.mFluidOutputs.length > 4 && aRecipe.mFluidOutputs[4] != null && aRecipe.mFluidOutputs[4].getFluid() != null) {
                    this.mOutputs.add(new FixedPositionedStack(GT_Utility.getFluidDisplayStack(aRecipe.mFluidOutputs[4], true), 138, 23));
                }
            } else if (aRecipe.mFluidOutputs.length > 0 && aRecipe.mFluidOutputs[0] != null && aRecipe.mFluidOutputs[0].getFluid() != null) {
                this.mOutputs.add(new FixedPositionedStack(GT_Utility.getFluidDisplayStack(aRecipe.mFluidOutputs[0], true), 102, 52));
            }
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(cycleTicksStatic / 10, this.mInputs);
        }

        public PositionedStack getResult() {
            return null;
        }

        public List<PositionedStack> getOtherStacks() {
            return this.mOutputs;
        }
    }

    public static class FixedPositionedStack
    extends PositionedStack {
        public final int mChance;
        public boolean permutated = false;

        public FixedPositionedStack(Object object, int x, int y) {
            this(object, x, y, 0);
        }

        public FixedPositionedStack(Object object, int x, int y, boolean aUnificate) {
            this(object, x, y, 0, aUnificate);
        }

        public FixedPositionedStack(Object object, int x, int y, int aChance) {
            this(object, x, y, aChance, true);
        }

        public FixedPositionedStack(Object object, int x, int y, int aChance, boolean aUnificate) {
            super(aUnificate ? GT_OreDictUnificator.getNonUnifiedStacks(object) : object, x, y, true);
            this.mChance = aChance;
        }

        public void generatePermutations() {
            if (this.permutated) {
                return;
            }
            ArrayList<ItemStack> tDisplayStacks = new ArrayList<ItemStack>();
            for (ItemStack tStack : this.items) {
                if (!GT_Utility.isStackValid(tStack)) continue;
                if (tStack.func_77960_j() == Short.MAX_VALUE) {
                    List permutations = ItemList.itemMap.get((Object)tStack.func_77973_b());
                    if (!permutations.isEmpty()) {
                        for (ItemStack permutation : permutations) {
                            tDisplayStacks.add(GT_Utility.copyAmount(tStack.field_77994_a, permutation));
                        }
                        continue;
                    }
                    ItemStack base = new ItemStack(tStack.func_77973_b(), tStack.field_77994_a);
                    base.field_77990_d = tStack.field_77990_d;
                    tDisplayStacks.add(base);
                    continue;
                }
                tDisplayStacks.add(GT_Utility.copyOrNull(tStack));
            }
            this.items = tDisplayStacks.toArray(new ItemStack[0]);
            if (this.items.length == 0) {
                this.items = new ItemStack[]{new ItemStack((Block)Blocks.field_150480_ab)};
            }
            this.permutated = true;
            this.setPermutationToRender(0);
        }
    }

    public static class GT_RectHandler
    implements IContainerInputHandler,
    IContainerTooltipHandler {
        public boolean mouseClicked(GuiContainer gui, int mouseX, int mouseY, int button) {
            NEI_TransferRectHost host;
            if (this.canHandle(gui) && this.hostRectContainsMouse(host = (NEI_TransferRectHost)gui, this.getMousePos(gui, mouseX, mouseY))) {
                if (button == 0) {
                    return this.handleTransferRectMouseClick(host, false);
                }
                if (button == 1) {
                    return this.handleTransferRectMouseClick(host, true);
                }
            }
            return false;
        }

        private Point getMousePos(GuiContainer gui, int mouseX, int mouseY) {
            return new Point(mouseX - ((GT_GUIContainer)gui).getLeft() - RecipeInfo.getGuiOffset((GuiContainer)gui)[0], mouseY - ((GT_GUIContainer)gui).getTop() - RecipeInfo.getGuiOffset((GuiContainer)gui)[1]);
        }

        private boolean hostRectContainsMouse(NEI_TransferRectHost host, Point mousePos) {
            return host.getNeiTransferRect().contains(mousePos);
        }

        private boolean handleTransferRectMouseClick(NEI_TransferRectHost gui, boolean usage) {
            String mNEI = gui.getNeiTransferRectString();
            Object[] args = gui.getNeiTransferRectArgs();
            return usage ? GuiUsageRecipe.openRecipeGui((String)mNEI, (Object[])new Object[0]) : GuiCraftingRecipe.openRecipeGui((String)mNEI, (Object[])args);
        }

        public boolean lastKeyTyped(GuiContainer gui, char keyChar, int keyCode) {
            return false;
        }

        public boolean canHandle(GuiContainer gui) {
            return gui instanceof NEI_TransferRectHost && GT_Utility.isStringValid(((NEI_TransferRectHost)gui).getNeiTransferRectString());
        }

        public List<String> handleTooltip(GuiContainer gui, int mouseX, int mouseY, List<String> currentTip) {
            NEI_TransferRectHost host;
            if (this.canHandle(gui) && currentTip.isEmpty() && this.hostRectContainsMouse(host = (NEI_TransferRectHost)gui, this.getMousePos(gui, mouseX, mouseY))) {
                currentTip.add(host.getNeiTransferRectTooltip());
            }
            return currentTip;
        }

        public List<String> handleItemDisplayName(GuiContainer gui, ItemStack itemstack, List<String> currentTip) {
            return currentTip;
        }

        public List<String> handleItemTooltip(GuiContainer gui, ItemStack itemstack, int mouseX, int mouseY, List<String> currentTip) {
            return currentTip;
        }

        public boolean keyTyped(GuiContainer gui, char keyChar, int keyCode) {
            return false;
        }

        public void onKeyTyped(GuiContainer gui, char keyChar, int keyID) {
        }

        public void onMouseClicked(GuiContainer gui, int mouseX, int mouseY, int button) {
        }

        public void onMouseUp(GuiContainer gui, int mouseX, int mouseY, int button) {
        }

        public boolean mouseScrolled(GuiContainer gui, int mouseX, int mouseY, int scrolled) {
            return false;
        }

        public void onMouseScrolled(GuiContainer gui, int mouseX, int mouseY, int scrolled) {
        }

        public void onMouseDragged(GuiContainer gui, int mouseX, int mouseY, int button, long heldTime) {
        }
    }
}

