/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.net;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import gregtech.api.net.GT_Packet;
import gregtech.api.util.GT_Utility;
import net.minecraft.world.IBlockAccess;

public class GT_Packet_Sound
extends GT_Packet {
    private int mX;
    private int mZ;
    private short mY;
    private String mSoundName;
    private float mSoundStrength;
    private float mSoundPitch;

    public GT_Packet_Sound() {
        super(true);
    }

    public GT_Packet_Sound(String aSoundName, float aSoundStrength, float aSoundPitch, int aX, short aY, int aZ) {
        super(false);
        this.mX = aX;
        this.mY = aY;
        this.mZ = aZ;
        this.mSoundName = aSoundName;
        this.mSoundStrength = aSoundStrength;
        this.mSoundPitch = aSoundPitch;
    }

    @Override
    public byte[] encode() {
        ByteArrayDataOutput tOut = ByteStreams.newDataOutput((int)10);
        tOut.writeUTF(this.mSoundName);
        tOut.writeFloat(this.mSoundStrength);
        tOut.writeFloat(this.mSoundPitch);
        tOut.writeInt(this.mX);
        tOut.writeShort((int)this.mY);
        tOut.writeInt(this.mZ);
        return tOut.toByteArray();
    }

    @Override
    public GT_Packet decode(ByteArrayDataInput aData) {
        return new GT_Packet_Sound(aData.readUTF(), aData.readFloat(), aData.readFloat(), aData.readInt(), aData.readShort(), aData.readInt());
    }

    @Override
    public void process(IBlockAccess aWorld) {
        GT_Utility.doSoundAtClient(this.mSoundName, 1, this.mSoundStrength, this.mSoundPitch, this.mX, this.mY, this.mZ);
    }

    @Override
    public byte getPacketID() {
        return 1;
    }
}

