/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.objects;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import gregtech.GT_Mod;
import gregtech.api.enums.GT_Values;
import gregtech.api.interfaces.IChunkLoader;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.util.GT_Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class GT_ChunkManager
implements ForgeChunkManager.OrderedLoadingCallback,
ForgeChunkManager.PlayerOrderedLoadingCallback {
    private Map<TileEntity, ForgeChunkManager.Ticket> registeredTickets = new HashMap<TileEntity, ForgeChunkManager.Ticket>();
    public static GT_ChunkManager instance = new GT_ChunkManager();

    public static void init() {
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)GT_Mod.instance, (ForgeChunkManager.LoadingCallback)instance);
    }

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
    }

    public List<ForgeChunkManager.Ticket> ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world, int maxTicketCount) {
        ArrayList<ForgeChunkManager.Ticket> validTickets = new ArrayList<ForgeChunkManager.Ticket>();
        if (GT_Values.alwaysReloadChunkloaders) {
            for (ForgeChunkManager.Ticket ticket : tickets) {
                TileEntity tile;
                int x = ticket.getModData().func_74762_e("OwnerX");
                int y = ticket.getModData().func_74762_e("OwnerY");
                int z = ticket.getModData().func_74762_e("OwnerZ");
                if (y <= 0 || (tile = world.func_147438_o(x, y, z)) == null || !(tile instanceof IGregTechTileEntity) || !((IGregTechTileEntity)tile).isAllowedToWork()) continue;
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)new ChunkCoordIntPair(x >> 4, z >> 4));
                if (this.registeredTickets.containsKey(tile)) continue;
                this.registeredTickets.put(tile, ticket);
                if (((IGregTechTileEntity)tile).getMetaTileEntity() instanceof IChunkLoader) {
                    ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)((IChunkLoader)((Object)((IGregTechTileEntity)tile).getMetaTileEntity())).getActiveChunk());
                }
                validTickets.add(ticket);
            }
        }
        return validTickets;
    }

    public ListMultimap<String, ForgeChunkManager.Ticket> playerTicketsLoaded(ListMultimap<String, ForgeChunkManager.Ticket> tickets, World world) {
        return ArrayListMultimap.create();
    }

    public static boolean requestPlayerChunkLoad(TileEntity owner, ChunkCoordIntPair chunkXZ, String player) {
        if (!GT_Values.enableChunkloaders) {
            return false;
        }
        if (!GT_Values.alwaysReloadChunkloaders && chunkXZ == null) {
            return false;
        }
        if (GT_Values.debugChunkloaders && chunkXZ != null) {
            GT_Log.out.println("GT_ChunkManager: Chunk request: (" + chunkXZ.field_77276_a + ", " + chunkXZ.field_77275_b + ")");
        }
        if (GT_ChunkManager.instance.registeredTickets.containsKey(owner)) {
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)GT_ChunkManager.instance.registeredTickets.get(owner), (ChunkCoordIntPair)chunkXZ);
        } else {
            ForgeChunkManager.Ticket ticket = null;
            ticket = player != "" ? ForgeChunkManager.requestPlayerTicket((Object)GT_Mod.instance, (String)player, (World)owner.func_145831_w(), (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL) : ForgeChunkManager.requestTicket((Object)GT_Mod.instance, (World)owner.func_145831_w(), (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
            if (ticket == null) {
                if (GT_Values.debugChunkloaders) {
                    GT_Log.out.println("GT_ChunkManager: ForgeChunkManager.requestTicket failed");
                }
                return false;
            }
            if (GT_Values.debugChunkloaders) {
                GT_Log.out.println("GT_ChunkManager: ticket issued for machine at: (" + owner.field_145851_c + ", " + owner.field_145848_d + ", " + owner.field_145849_e + ")");
            }
            NBTTagCompound tag = ticket.getModData();
            tag.func_74768_a("OwnerX", owner.field_145851_c);
            tag.func_74768_a("OwnerY", owner.field_145848_d);
            tag.func_74768_a("OwnerZ", owner.field_145849_e);
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)chunkXZ);
            if (GT_Values.alwaysReloadChunkloaders) {
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)new ChunkCoordIntPair(owner.field_145851_c << 4, owner.field_145849_e << 4));
            }
            GT_ChunkManager.instance.registeredTickets.put(owner, ticket);
        }
        return true;
    }

    public static boolean requestChunkLoad(TileEntity owner, ChunkCoordIntPair chunkXZ) {
        return GT_ChunkManager.requestPlayerChunkLoad(owner, chunkXZ, "");
    }

    public static void releaseChunk(TileEntity owner, ChunkCoordIntPair chunkXZ) {
        if (!GT_Values.enableChunkloaders) {
            return;
        }
        ForgeChunkManager.Ticket ticket = GT_ChunkManager.instance.registeredTickets.get(owner);
        if (ticket != null) {
            if (GT_Values.debugChunkloaders) {
                GT_Log.out.println("GT_ChunkManager: Chunk release: (" + chunkXZ.field_77276_a + ", " + chunkXZ.field_77275_b + ")");
            }
            ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)chunkXZ);
        }
    }

    public static void releaseTicket(TileEntity owner) {
        if (!GT_Values.enableChunkloaders) {
            return;
        }
        ForgeChunkManager.Ticket ticket = GT_ChunkManager.instance.registeredTickets.get(owner);
        if (ticket != null) {
            if (GT_Values.debugChunkloaders) {
                GT_Log.out.println("GT_ChunkManager: ticket released by machine at: (" + owner.field_145851_c + ", " + owner.field_145848_d + ", " + owner.field_145849_e + ")");
                for (ChunkCoordIntPair chunk : ticket.getChunkList()) {
                    GT_Log.out.println("GT_ChunkManager: Chunk release: (" + chunk.field_77276_a + ", " + chunk.field_77275_b + ")");
                }
            }
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
            GT_ChunkManager.instance.registeredTickets.remove(owner);
        }
    }

    public static void printTickets() {
        GT_Log.out.println("GT_ChunkManager: Start forced chunks dump:");
        GT_ChunkManager.instance.registeredTickets.forEach((machine, ticket) -> {
            GT_Log.out.print("GT_ChunkManager: Chunks forced by the machine at (" + machine.field_145851_c + ", " + machine.field_145848_d + ", " + machine.field_145849_e + ")");
            if (ticket.isPlayerTicket()) {
                GT_Log.out.print(" Owner: " + ticket.getPlayerName());
            }
            GT_Log.out.print(" :");
            for (ChunkCoordIntPair c : ticket.getChunkList()) {
                GT_Log.out.print("(");
                GT_Log.out.print(c.field_77276_a);
                GT_Log.out.print(", ");
                GT_Log.out.print(c.field_77275_b);
                GT_Log.out.print("), ");
            }
        });
        GT_Log.out.println("GT_ChunkManager: End forced chunks dump:");
    }
}

