/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.objects;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import gregtech.api.objects.GT_UO_Fluid;
import java.util.Map;
import java.util.Random;
import net.minecraftforge.common.config.ConfigCategory;

public class GT_UO_Dimension {
    private BiMap<String, GT_UO_Fluid> fFluids = HashBiMap.create();
    private int maxChance;
    public String Dimension = "null";

    public GT_UO_Dimension(ConfigCategory aConfigCategory) {
        if (aConfigCategory.containsKey("Dimension")) {
            aConfigCategory.get((String)"Dimension").comment = "Dimension ID or Class Name";
            this.Dimension = aConfigCategory.get("Dimension").getString();
        }
        this.maxChance = 0;
        for (int i = 0; i < aConfigCategory.getChildren().size(); ++i) {
            GT_UO_Fluid fluid = new GT_UO_Fluid((ConfigCategory)aConfigCategory.getChildren().toArray()[i]);
            this.fFluids.put((Object)fluid.Registry, (Object)fluid);
            this.maxChance += fluid.Chance;
        }
    }

    public GT_UO_Fluid getRandomFluid(Random aRandom) {
        int random = aRandom.nextInt(1000);
        for (Map.Entry fl : this.fFluids.entrySet()) {
            int chance = ((GT_UO_Fluid)fl.getValue()).Chance * 1000 / this.maxChance;
            if (random <= chance) {
                return (GT_UO_Fluid)fl.getValue();
            }
            random -= chance;
        }
        return null;
    }
}

