/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.armor.components;

import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.GregTech_API;
import gregtech.api.util.GT_Utility;
import gregtech.common.items.armor.ArmorData;
import gregtech.common.items.armor.components.IArmorComponent;
import gregtech.common.items.armor.components.StatType;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public abstract class ArmorComponent
implements IArmorComponent {
    public ItemStack mStack;
    public String mOreDict;
    public String mConfigName;
    public static Map<String, ArmorComponent> mOreDicts = new HashMap<String, ArmorComponent>();
    public static Map<String, ArmorComponent> mStacks = new HashMap<String, ArmorComponent>();
    public Map<StatType, Float> mStat = new HashMap<StatType, Float>();
    public Map<StatType, Boolean> mBStat = new HashMap<StatType, Boolean>();

    public ArmorComponent(String aName, String aOreDict, boolean aElectric, float aWeight) {
        this.mConfigName = aName;
        if (!GregTech_API.sModularArmor.get((Object)this.mConfigName, "Enabled", true)) {
            return;
        }
        this.mOreDict = GregTech_API.sModularArmor.get((Object)this.mConfigName, "OreDict", aOreDict);
        this.mBStat.put(StatType.ELECTRIC, aElectric);
        mOreDicts.put(aOreDict, this);
        for (ItemStack tStack : OreDictionary.getOres((String)aOreDict)) {
            if (tStack == null) continue;
            mStacks.put(tStack.func_77977_a(), this);
        }
        this.mStat.put(StatType.WEIGHT, Float.valueOf((float)GregTech_API.sModularArmor.get((Object)this.mConfigName, "Weight", (double)aWeight)));
    }

    public ArmorComponent(String aName, ItemStack aStack, boolean aElectric, float aWeight) {
        this.mConfigName = aName;
        String tStackName = GregTech_API.sModularArmor.get((Object)this.mConfigName, "Stack", GameRegistry.findUniqueIdentifierFor((Item)aStack.func_77973_b()).toString() + (aStack.func_77960_j() == 0 ? "" : ":" + aStack.func_77960_j()));
        this.mStack = GameRegistry.findItemStack((String)tStackName.split(":")[0], (String)tStackName.split(":")[1], (int)1);
        if (tStackName.split(":").length > 2) {
            this.mStack.func_77964_b(Integer.parseInt(tStackName.split(":")[2]));
        }
        if (!GregTech_API.sModularArmor.get((Object)this.mConfigName, "Enabled", true)) {
            return;
        }
        this.mStack = aStack;
        this.mBStat.put(StatType.ELECTRIC, aElectric);
        mStacks.put(aStack.func_77977_a(), this);
        this.mStat.put(StatType.WEIGHT, Float.valueOf((float)GregTech_API.sModularArmor.get((Object)this.mConfigName, "Weight", (double)aWeight)));
    }

    @Override
    public boolean isArmorComponent(ItemStack aStack) {
        if (this.mStack != null && GT_Utility.areStacksEqual(this.mStack, aStack, true)) {
            return true;
        }
        if (this.mOreDict != null) {
            for (ItemStack tStack : OreDictionary.getOres((String)this.mOreDict)) {
                if (!GT_Utility.areStacksEqual(tStack, aStack, true)) continue;
                return true;
            }
        }
        return false;
    }

    public void addVal(StatType aType, ArmorData aArmorData) {
        float tArmorDef = 0.0f;
        if (aArmorData.mStat.containsKey((Object)aType)) {
            tArmorDef = aArmorData.mStat.get((Object)aType).floatValue();
            aArmorData.mStat.remove((Object)aType);
        }
        aArmorData.mStat.put(aType, Float.valueOf(tArmorDef + this.mStat.get((Object)aType).floatValue()));
    }

    @Override
    public abstract void calculateArmor(ArmorData var1);
}

