/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IDebugableBlock;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.items.GT_Generic_Block;
import gregtech.api.metatileentity.BaseMetaPipeEntity;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.api.metatileentity.BaseTileEntity;
import gregtech.api.objects.XSTR;
import gregtech.api.util.GT_BaseCrop;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_Utility;
import gregtech.common.blocks.GT_Item_Machines;
import gregtech.common.blocks.GT_Material_Machines;
import gregtech.common.render.GT_Renderer_Block;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_Block_Machines
extends GT_Generic_Block
implements IDebugableBlock,
ITileEntityProvider {
    public static ThreadLocal<IGregTechTileEntity> mTemporaryTileEntity = new ThreadLocal();

    public GT_Block_Machines() {
        super(GT_Item_Machines.class, "gt.blockmachines", new GT_Material_Machines());
        GregTech_API.registerMachineBlock((Block)this, -1);
        this.func_149711_c(1.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(field_149777_j);
        this.func_149647_a(GregTech_API.TAB_GREGTECH);
        this.field_149758_A = true;
    }

    public String getHarvestTool(int aMeta) {
        if (aMeta >= 8 && aMeta <= 11) {
            return "cutter";
        }
        return "wrench";
    }

    public int getHarvestLevel(int aMeta) {
        return aMeta % 4;
    }

    protected boolean func_149700_E() {
        return false;
    }

    public void onNeighborChange(IBlockAccess aWorld, int aX, int aY, int aZ, int aTileX, int aTileY, int aTileZ) {
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof BaseTileEntity) {
            ((BaseTileEntity)tTileEntity).onAdjacentBlockChange(aTileX, aTileY, aTileZ);
        }
    }

    public void func_149695_a(World aWorld, int aX, int aY, int aZ, Block aBlock) {
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof BaseMetaPipeEntity) {
            ((BaseMetaPipeEntity)tTileEntity).onNeighborBlockChange(aX, aY, aZ);
        }
    }

    public void func_149726_b(World aWorld, int aX, int aY, int aZ) {
        super.func_149726_b(aWorld, aX, aY, aZ);
        if (GregTech_API.isMachineBlock(this, aWorld.func_72805_g(aX, aY, aZ))) {
            GregTech_API.causeMachineUpdate(aWorld, aX, aY, aZ);
        }
    }

    public String func_149739_a() {
        return "gt.blockmachines";
    }

    public String func_149732_F() {
        return StatCollector.func_74838_a((String)(this.func_149739_a() + ".name"));
    }

    public int getFlammability(IBlockAccess aWorld, int aX, int aY, int aZ, ForgeDirection face) {
        return 0;
    }

    public int getFireSpreadSpeed(IBlockAccess aWorld, int aX, int aY, int aZ, ForgeDirection face) {
        return GregTech_API.sMachineFlammable && aWorld.func_72805_g(aX, aY, aZ) == 0 ? 100 : 0;
    }

    public int func_149645_b() {
        if (GT_Renderer_Block.INSTANCE == null) {
            return super.func_149645_b();
        }
        return GT_Renderer_Block.INSTANCE.mRenderID;
    }

    public boolean isFireSource(World aWorld, int aX, int aY, int aZ, ForgeDirection side) {
        return GregTech_API.sMachineFlammable && aWorld.func_72805_g(aX, aY, aZ) == 0;
    }

    public boolean isFlammable(IBlockAccess aWorld, int aX, int aY, int aZ, ForgeDirection face) {
        return GregTech_API.sMachineFlammable && aWorld.func_72805_g(aX, aY, aZ) == 0;
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess aWorld, int aX, int aY, int aZ) {
        return false;
    }

    public boolean canConnectRedstone(IBlockAccess var1, int var2, int var3, int var4, int var5) {
        return true;
    }

    public boolean canBeReplacedByLeaves(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return false;
    }

    public boolean isNormalCube(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return false;
    }

    public boolean hasTileEntity(int aMeta) {
        return true;
    }

    public boolean func_149740_M() {
        return true;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149744_f() {
        return true;
    }

    public boolean func_149662_c() {
        return false;
    }

    public TileEntity func_149915_a(World aWorld, int aMeta) {
        return this.createTileEntity(aWorld, aMeta);
    }

    public IIcon func_149673_e(IBlockAccess aIBlockAccess, int aX, int aY, int aZ, int aSide) {
        return Textures.BlockIcons.MACHINE_LV_SIDE.getIcon();
    }

    public IIcon func_149691_a(int aSide, int aMeta) {
        return Textures.BlockIcons.MACHINE_LV_SIDE.getIcon();
    }

    public boolean func_149696_a(World aWorld, int aX, int aY, int aZ, int aData1, int aData2) {
        super.func_149696_a(aWorld, aX, aY, aZ, aData1, aData2);
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        return tTileEntity != null ? tTileEntity.func_145842_c(aData1, aData2) : false;
    }

    public void func_149743_a(World aWorld, int aX, int aY, int aZ, AxisAlignedBB inputAABB, List outputAABB, Entity collider) {
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof IGregTechTileEntity && ((IGregTechTileEntity)tTileEntity).getMetaTileEntity() != null) {
            ((IGregTechTileEntity)tTileEntity).addCollisionBoxesToList(aWorld, aX, aY, aZ, inputAABB, outputAABB, collider);
            return;
        }
        super.func_149743_a(aWorld, aX, aY, aZ, inputAABB, outputAABB, collider);
    }

    public AxisAlignedBB func_149668_a(World aWorld, int aX, int aY, int aZ) {
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof IGregTechTileEntity && ((IGregTechTileEntity)tTileEntity).getMetaTileEntity() != null) {
            return ((IGregTechTileEntity)tTileEntity).getCollisionBoundingBoxFromPool(aWorld, aX, aY, aZ);
        }
        return super.func_149668_a(aWorld, aX, aY, aZ);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World aWorld, int aX, int aY, int aZ) {
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof IGregTechTileEntity && ((IGregTechTileEntity)tTileEntity).getMetaTileEntity() != null) {
            return ((IGregTechTileEntity)tTileEntity).getCollisionBoundingBoxFromPool(aWorld, aX, aY, aZ);
        }
        return super.func_149633_g(aWorld, aX, aY, aZ);
    }

    public void func_149719_a(IBlockAccess blockAccess, int aX, int aY, int aZ) {
        TileEntity tTileEntity = blockAccess.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof IGregTechTileEntity && ((IGregTechTileEntity)tTileEntity).getMetaTileEntity() != null) {
            AxisAlignedBB bbb = ((IGregTechTileEntity)tTileEntity).getCollisionBoundingBoxFromPool(((IGregTechTileEntity)tTileEntity).getWorld(), 0, 0, 0);
            this.field_149759_B = bbb.field_72340_a;
            this.field_149760_C = bbb.field_72338_b;
            this.field_149754_D = bbb.field_72339_c;
            this.field_149755_E = bbb.field_72336_d;
            this.field_149756_F = bbb.field_72337_e;
            this.field_149757_G = bbb.field_72334_f;
            return;
        }
        super.func_149719_a(blockAccess, aX, aY, aZ);
    }

    public void func_149683_g() {
        super.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public void func_149670_a(World aWorld, int aX, int aY, int aZ, Entity collider) {
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof IGregTechTileEntity && ((IGregTechTileEntity)tTileEntity).getMetaTileEntity() != null) {
            ((IGregTechTileEntity)tTileEntity).onEntityCollidedWithBlock(aWorld, aX, aY, aZ, collider);
            return;
        }
        super.func_149670_a(aWorld, aX, aY, aZ, collider);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister aIconRegister) {
        if (GregTech_API.sPostloadFinished) {
            GT_Log.out.println("GT_Mod: Setting up Icon Register for Blocks");
            GregTech_API.sBlockIcons = aIconRegister;
            GT_Log.out.println("GT_Mod: Registering MetaTileEntity specific Textures");
            try {
                for (IMetaTileEntity tMetaTileEntity : GregTech_API.METATILEENTITIES) {
                    if (tMetaTileEntity == null) continue;
                    tMetaTileEntity.registerIcons(aIconRegister);
                }
            }
            catch (Throwable e) {
                e.printStackTrace(GT_Log.err);
            }
            GT_Log.out.println("GT_Mod: Registering Crop specific Textures");
            try {
                for (GT_BaseCrop tCrop : GT_BaseCrop.sCropList) {
                    tCrop.registerSprites(aIconRegister);
                }
            }
            catch (Throwable e) {
                e.printStackTrace(GT_Log.err);
            }
            GT_Log.out.println("GT_Mod: Starting Block Icon Load Phase");
            GT_Mod.GT_FML_LOGGER.info("GT_Mod: Starting Block Icon Load Phase");
            try {
                for (Runnable tRunnable : GregTech_API.sGTBlockIconload) {
                    tRunnable.run();
                }
            }
            catch (Throwable e) {
                e.printStackTrace(GT_Log.err);
            }
            GT_Log.out.println("GT_Mod: Finished Block Icon Load Phase");
            GT_Mod.GT_FML_LOGGER.info("GT_Mod: Finished Block Icon Load Phase");
        }
    }

    public float func_149712_f(World aWorld, int aX, int aY, int aZ) {
        return super.func_149712_f(aWorld, aX, aY, aZ);
    }

    public float func_149737_a(EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ) {
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof BaseMetaTileEntity && ((BaseMetaTileEntity)tTileEntity).privateAccess() && !((BaseMetaTileEntity)tTileEntity).playerOwnsThis(aPlayer, true)) {
            return -1.0f;
        }
        return super.func_149737_a(aPlayer, aWorld, aX, aY, aZ);
    }

    public boolean func_149727_a(World aWorld, int aX, int aY, int aZ, EntityPlayer aPlayer, int aSide, float par1, float par2, float par3) {
        ItemStack tCurrentItem;
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity == null) {
            return false;
        }
        if (!(!aPlayer.func_70093_af() || (tCurrentItem = aPlayer.field_71071_by.func_70448_g()) == null || GT_Utility.isStackInList(tCurrentItem, GregTech_API.sScrewdriverList) || GT_Utility.isStackInList(tCurrentItem, GregTech_API.sWrenchList) || GT_Utility.isStackInList(tCurrentItem, GregTech_API.sWireCutterList) || GT_Utility.isStackInList(tCurrentItem, GregTech_API.sSolderingToolList))) {
            return false;
        }
        if (tTileEntity instanceof IGregTechTileEntity) {
            if (((IGregTechTileEntity)tTileEntity).getTimer() < 50L) {
                return false;
            }
            if (!aWorld.field_72995_K && !((IGregTechTileEntity)tTileEntity).func_70300_a(aPlayer)) {
                return true;
            }
            return ((IGregTechTileEntity)tTileEntity).onRightclick(aPlayer, (byte)aSide, par1, par2, par3);
        }
        return false;
    }

    public void func_149699_a(World aWorld, int aX, int aY, int aZ, EntityPlayer aPlayer) {
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof IGregTechTileEntity) {
            ((IGregTechTileEntity)tTileEntity).onLeftclick(aPlayer);
        }
    }

    public int func_149643_k(World aWorld, int aX, int aY, int aZ) {
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof IGregTechTileEntity) {
            return ((IGregTechTileEntity)tTileEntity).getMetaTileID();
        }
        return 0;
    }

    public void onBlockExploded(World aWorld, int aX, int aY, int aZ, Explosion aExplosion) {
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof BaseMetaTileEntity) {
            GT_Log.exp.println("Explosion at :" + aX + " | " + aY + " | " + aZ + " DIMID: " + aWorld.field_73011_w.field_76574_g + " due to near explosion!");
            ((BaseMetaTileEntity)tTileEntity).doEnergyExplosion();
        }
        super.onBlockExploded(aWorld, aX, aY, aZ, aExplosion);
    }

    public void func_149749_a(World aWorld, int aX, int aY, int aZ, Block par5, int par6) {
        GregTech_API.causeMachineUpdate(aWorld, aX, aY, aZ);
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof IGregTechTileEntity) {
            IGregTechTileEntity tGregTechTileEntity = (IGregTechTileEntity)tTileEntity;
            mTemporaryTileEntity.set(tGregTechTileEntity);
            for (int i = 0; i < tGregTechTileEntity.func_70302_i_(); ++i) {
                ItemStack tItem = tGregTechTileEntity.func_70301_a(i);
                if (tItem == null || tItem.field_77994_a <= 0 || !tGregTechTileEntity.isValidSlot(i)) continue;
                EntityItem tItemEntity = new EntityItem(aWorld, (double)((float)aX + XSTR.XSTR_INSTANCE.nextFloat() * 0.8f + 0.1f), (double)((float)aY + XSTR.XSTR_INSTANCE.nextFloat() * 0.8f + 0.1f), (double)((float)aZ + XSTR.XSTR_INSTANCE.nextFloat() * 0.8f + 0.1f), new ItemStack(tItem.func_77973_b(), tItem.field_77994_a, tItem.func_77960_j()));
                if (tItem.func_77942_o()) {
                    tItemEntity.func_92059_d().func_77982_d((NBTTagCompound)tItem.func_77978_p().func_74737_b());
                }
                tItemEntity.field_70159_w = XSTR.XSTR_INSTANCE.nextGaussian() * 0.0500000007450581;
                tItemEntity.field_70181_x = XSTR.XSTR_INSTANCE.nextGaussian() * 0.0500000007450581 + 0.2000000029802322;
                tItemEntity.field_70179_y = XSTR.XSTR_INSTANCE.nextGaussian() * 0.0500000007450581;
                aWorld.func_72838_d((Entity)tItemEntity);
                tItem.field_77994_a = 0;
                tGregTechTileEntity.func_70299_a(i, null);
            }
        }
        super.func_149749_a(aWorld, aX, aY, aZ, par5, par6);
        aWorld.func_147475_p(aX, aY, aZ);
    }

    public ArrayList<ItemStack> getDrops(World aWorld, int aX, int aY, int aZ, int aMeta, int aFortune) {
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof IGregTechTileEntity) {
            return ((IGregTechTileEntity)tTileEntity).getDrops();
        }
        return mTemporaryTileEntity.get() == null ? new ArrayList() : mTemporaryTileEntity.get().getDrops();
    }

    public boolean removedByPlayer(World aWorld, EntityPlayer aPlayer, int aX, int aY, int aZ, boolean aWillHarvest) {
        if (aWillHarvest) {
            return true;
        }
        return super.removedByPlayer(aWorld, aPlayer, aX, aY, aZ, false);
    }

    public void func_149636_a(World aWorld, EntityPlayer aPlayer, int aX, int aY, int aZ, int aMeta) {
        super.func_149636_a(aWorld, aPlayer, aX, aY, aZ, aMeta);
        aWorld.func_147468_f(aX, aY, aZ);
    }

    public int func_149736_g(World aWorld, int aX, int aY, int aZ, int aSide) {
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof IGregTechTileEntity) {
            return ((IGregTechTileEntity)tTileEntity).getComparatorValue((byte)aSide);
        }
        return 0;
    }

    public int func_149709_b(IBlockAccess aWorld, int aX, int aY, int aZ, int aSide) {
        if (aSide < 0 || aSide > 5) {
            return 0;
        }
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof IGregTechTileEntity) {
            return ((IGregTechTileEntity)tTileEntity).getOutputRedstoneSignal(GT_Utility.getOppositeSide(aSide));
        }
        return 0;
    }

    public int func_149748_c(IBlockAccess aWorld, int aX, int aY, int aZ, int aSide) {
        if (aSide < 0 || aSide > 5) {
            return 0;
        }
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof IGregTechTileEntity) {
            return ((IGregTechTileEntity)tTileEntity).getStrongOutputRedstoneSignal(GT_Utility.getOppositeSide(aSide));
        }
        return 0;
    }

    public void func_149690_a(World aWorld, int aX, int aY, int aZ, int par5, float chance, int par7) {
        if (!aWorld.field_72995_K) {
            TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
            if (tTileEntity != null && chance < 1.0f) {
                if (tTileEntity instanceof BaseMetaTileEntity && GregTech_API.sMachineNonWrenchExplosions) {
                    GT_Log.exp.println("Explosion at :" + aX + " | " + aY + " | " + aZ + " DIMID: " + aWorld.field_73011_w.field_76574_g + " due to NonWrench picking/Rain!");
                    ((BaseMetaTileEntity)tTileEntity).doEnergyExplosion();
                }
            } else {
                super.func_149690_a(aWorld, aX, aY, aZ, par5, chance, par7);
            }
        }
    }

    public boolean isSideSolid(IBlockAccess aWorld, int aX, int aY, int aZ, ForgeDirection aSide) {
        if (aWorld.func_72805_g(aX, aY, aZ) == 0) {
            return true;
        }
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity != null) {
            if (tTileEntity instanceof BaseMetaTileEntity) {
                return true;
            }
            if (tTileEntity instanceof BaseMetaPipeEntity && (((BaseMetaPipeEntity)tTileEntity).mConnections & 0xFFFFFFC0) != 0) {
                return true;
            }
            if (tTileEntity instanceof ICoverable && ((ICoverable)tTileEntity).getCoverIDAtSide((byte)aSide.ordinal()) != 0) {
                return true;
            }
        }
        return false;
    }

    public int getLightOpacity(IBlockAccess aWorld, int aX, int aY, int aZ) {
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity == null) {
            return 0;
        }
        if (tTileEntity instanceof IGregTechTileEntity) {
            return ((IGregTechTileEntity)tTileEntity).getLightOpacity();
        }
        return aWorld.func_72805_g(aX, aY, aZ) == 0 ? 255 : 0;
    }

    public int getLightValue(IBlockAccess aWorld, int aX, int aY, int aZ) {
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof BaseMetaTileEntity) {
            return ((BaseMetaTileEntity)tTileEntity).getLightValue();
        }
        return 0;
    }

    public TileEntity createTileEntity(World aWorld, int aMeta) {
        if (aMeta < 4) {
            return GregTech_API.constructBaseMetaTileEntity();
        }
        return new BaseMetaPipeEntity();
    }

    public float getExplosionResistance(Entity par1Entity, World aWorld, int aX, int aY, int aZ, double explosionX, double explosionY, double explosionZ) {
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof IGregTechTileEntity) {
            return ((IGregTechTileEntity)tTileEntity).getBlastResistance((byte)6);
        }
        return 10.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int i = 1; i < GregTech_API.METATILEENTITIES.length; ++i) {
            if (GregTech_API.METATILEENTITIES[i] == null) continue;
            par3List.add(new ItemStack(par1, 1, i));
        }
    }

    public void func_149689_a(World aWorld, int aX, int aY, int aZ, EntityLivingBase aPlayer, ItemStack aStack) {
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity == null) {
            return;
        }
        if (tTileEntity instanceof IGregTechTileEntity) {
            IGregTechTileEntity var6 = (IGregTechTileEntity)tTileEntity;
            if (aPlayer == null) {
                var6.setFrontFacing((byte)1);
            } else {
                int var7 = MathHelper.func_76128_c((double)((double)(aPlayer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
                int var8 = Math.round(aPlayer.field_70125_A);
                if (var8 >= 65 && var6.isValidFacing((byte)1)) {
                    var6.setFrontFacing((byte)1);
                } else if (var8 <= -65 && var6.isValidFacing((byte)0)) {
                    var6.setFrontFacing((byte)0);
                } else {
                    switch (var7) {
                        case 0: {
                            var6.setFrontFacing((byte)2);
                            break;
                        }
                        case 1: {
                            var6.setFrontFacing((byte)5);
                            break;
                        }
                        case 2: {
                            var6.setFrontFacing((byte)3);
                            break;
                        }
                        case 3: {
                            var6.setFrontFacing((byte)4);
                        }
                    }
                }
            }
        }
    }

    @Override
    public ArrayList<String> getDebugInfo(EntityPlayer aPlayer, int aX, int aY, int aZ, int aLogLevel) {
        TileEntity tTileEntity = aPlayer.field_70170_p.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof BaseMetaTileEntity) {
            return ((BaseMetaTileEntity)tTileEntity).getDebugInfo(aPlayer, aLogLevel);
        }
        if (tTileEntity instanceof BaseMetaPipeEntity) {
            return ((BaseMetaPipeEntity)tTileEntity).getDebugInfo(aPlayer, aLogLevel);
        }
        return null;
    }

    public boolean recolourBlock(World aWorld, int aX, int aY, int aZ, ForgeDirection aSide, int aColor) {
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof IGregTechTileEntity) {
            if (((IGregTechTileEntity)tTileEntity).getColorization() == (byte)(~aColor & 0xF)) {
                return false;
            }
            ((IGregTechTileEntity)tTileEntity).setColorization((byte)(~aColor & 0xF));
            return true;
        }
        return false;
    }
}

