/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import gregtech.api.enums.GT_Values;
import gregtech.api.gui.GT_GUICover;
import gregtech.api.gui.widgets.GT_GuiFakeItemButton;
import gregtech.api.gui.widgets.GT_GuiIcon;
import gregtech.api.gui.widgets.GT_GuiIconCheckButton;
import gregtech.api.gui.widgets.GT_GuiIntegerTextBox;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.net.GT_Packet_TileEntityCover;
import gregtech.api.util.GT_CoverBehavior;
import gregtech.api.util.GT_Utility;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.Fluid;

public class GT_Cover_ItemMeter
extends GT_CoverBehavior {
    private static final int SLOT_MASK = 0x3FFFFFF;
    private static final int CONVERTED_BIT = Integer.MIN_VALUE;
    private static final int INVERT_BIT = 0x40000000;

    @Override
    public int doCoverThings(byte aSide, byte aInputRedstone, int aCoverID, int aCoverVariable, ICoverable aTileEntity, long aTimer) {
        boolean inverted;
        if ((Integer.MIN_VALUE & aCoverVariable) == 0) {
            if (aCoverVariable == 0) {
                aCoverVariable = Integer.MIN_VALUE;
            } else if (aCoverVariable == 1) {
                aCoverVariable = -1073741824;
            } else if (aCoverVariable > 1) {
                aCoverVariable = Integer.MIN_VALUE | Math.min(aCoverVariable - 2, 0x3FFFFFF);
            }
        }
        int[] tSlots = (aCoverVariable & 0x3FFFFFF) > 0 ? new int[]{(aCoverVariable & 0x3FFFFFF) - 1} : aTileEntity.func_94128_d(aSide);
        int tMax = 0;
        int tUsed = 0;
        for (int i : tSlots) {
            if (i < 0 || i >= aTileEntity.func_70302_i_()) continue;
            tMax += 64;
            ItemStack tStack = aTileEntity.func_70301_a(i);
            if (tStack == null) continue;
            tUsed += (tStack.field_77994_a << 6) / tStack.func_77976_d();
        }
        boolean bl = inverted = (aCoverVariable & 0x40000000) == 0x40000000;
        if (tUsed == 0) {
            aTileEntity.setOutputRedstoneSignal(aSide, (byte)(inverted ? 15 : 0));
        } else if (tUsed >= tMax) {
            aTileEntity.setOutputRedstoneSignal(aSide, (byte)(inverted ? 0 : 15));
        } else {
            aTileEntity.setOutputRedstoneSignal(aSide, (byte)(inverted ? 14 - 14 * tUsed / tMax : 1 + 14 * tUsed / tMax));
        }
        return aCoverVariable;
    }

    @Override
    public int onCoverScrewdriverclick(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aPlayer.func_70093_af()) {
            if ((aCoverVariable & 0x40000000) == 0x40000000) {
                aCoverVariable &= 0xBFFFFFFF;
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("NORMAL", "Normal"));
            } else {
                aCoverVariable |= 0x40000000;
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("INVERTED", "Inverted"));
            }
            return aCoverVariable;
        }
        int slot = (aCoverVariable & 0x3FFFFFF) + 1;
        if (slot > aTileEntity.func_70302_i_() || slot > 0x3FFFFFF) {
            slot = 0;
        }
        if (slot == 0) {
            GT_Utility.sendChatToPlayer(aPlayer, this.trans("053", "Slot: ") + this.trans("ALL", "All"));
        } else {
            GT_Utility.sendChatToPlayer(aPlayer, this.trans("053", "Slot: ") + (slot - 1));
        }
        return Integer.MIN_VALUE | aCoverVariable & 0x40000000 | slot;
    }

    @Override
    public boolean letsEnergyIn(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsEnergyOut(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsFluidIn(byte aSide, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsFluidOut(byte aSide, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsIn(byte aSide, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsOut(byte aSide, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean manipulatesSidedRedstoneOutput(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public int getTickRate(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return 5;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public Object getClientGUI(byte aSide, int aCoverID, int coverData, ICoverable aTileEntity) {
        return new GUI(aSide, aCoverID, coverData, aTileEntity);
    }

    private class GUI
    extends GT_GUICover {
        private final byte side;
        private final int coverID;
        private final GT_GuiIconCheckButton button;
        private final GT_GuiIntegerTextBox intSlot;
        private final GT_GuiFakeItemButton intSlotIcon;
        private int coverVariable;
        private static final int startX = 10;
        private static final int startY = 25;
        private static final int spaceX = 18;
        private static final int spaceY = 18;
        private final int maxSlot;
        private final String ALL;
        private final String INVERTED;
        private final String NORMAL;

        public GUI(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
            super(aTileEntity, 176, 107, GT_Utility.intToStack(aCoverID));
            this.ALL = GT_Cover_ItemMeter.this.trans("ALL", "All");
            this.INVERTED = GT_Cover_ItemMeter.this.trans("INVERTED", "Inverted");
            this.NORMAL = GT_Cover_ItemMeter.this.trans("NORMAL", "Normal");
            this.side = aSide;
            this.coverID = aCoverID;
            this.coverVariable = aCoverVariable;
            this.button = new GT_GuiIconCheckButton(this, 0, 10, 25, GT_GuiIcon.REDSTONE_ON, GT_GuiIcon.REDSTONE_OFF);
            this.intSlot = new GT_GuiIntegerTextBox(this, 1, 10, 45, 41, 12);
            this.intSlot.func_146203_f(6);
            this.intSlotIcon = new GT_GuiFakeItemButton(this, 150, 43, GT_GuiIcon.SLOT_GRAY);
            this.maxSlot = this.tile instanceof TileEntity && !this.tile.isDead() ? Math.min(this.tile.func_70302_i_() - 1, 0x3FFFFFE) : -1;
            if (this.maxSlot == -1) {
                this.intSlot.func_146184_c(false);
            }
        }

        @Override
        public void drawExtras(int mouseX, int mouseY, float parTicks) {
            super.drawExtras(mouseX, mouseY, parTicks);
            if (this.isInverted()) {
                this.getFontRenderer().func_78276_b(this.INVERTED, 64, 29, -11184811);
            } else {
                this.getFontRenderer().func_78276_b(this.NORMAL, 64, 29, -11184811);
            }
            this.getFontRenderer().func_78276_b(GT_Cover_ItemMeter.this.trans("254", "Detect slot#"), 64, 47, -11184811);
        }

        @Override
        protected void onInitGui(int guiLeft, int guiTop, int gui_width, int gui_height) {
            this.update();
            if (this.intSlot.isEnabled()) {
                this.intSlot.func_146195_b(true);
            }
        }

        @Override
        public void buttonClicked(GuiButton btn) {
            this.coverVariable = this.isInverted() ? (this.coverVariable &= 0xBFFFFFFF) : (this.coverVariable |= 0x40000000);
            GT_Values.NW.sendToServer(new GT_Packet_TileEntityCover(this.side, this.coverID, this.coverVariable, this.tile));
            this.update();
        }

        private void update() {
            this.resetTextBox(this.intSlot);
            this.button.setChecked(this.isInverted());
            int slot = this.getSlot();
            if (slot < 0) {
                this.intSlotIcon.setItem(null);
                return;
            }
            if (this.tile instanceof TileEntity && !this.tile.isDead() && this.tile.func_70302_i_() >= slot) {
                ItemStack item = this.tile.func_70301_a(slot);
                this.intSlotIcon.setItem(item);
                return;
            }
            this.intSlotIcon.setItem(null);
        }

        @Override
        public void onMouseWheel(int x, int y, int delta) {
            for (GT_GuiIntegerTextBox box : this.textBoxes) {
                if (!box.func_146206_l()) continue;
                int step = Math.max(1, Math.abs(delta / 120));
                step = (GUI.func_146272_n() ? 50 : (GUI.func_146271_m() ? 5 : 1)) * (delta > 0 ? step : -step);
                int val = this.parseTextBox(box);
                if (val < 0) {
                    val = -1;
                }
                if ((val += step) < 0) {
                    val = -1;
                } else if (val > this.maxSlot) {
                    val = this.maxSlot;
                }
                box.func_146180_a(val < 0 ? this.ALL : String.valueOf(val));
                return;
            }
        }

        @Override
        public void applyTextBox(GT_GuiIntegerTextBox box) {
            int val = this.parseTextBox(box) + 1;
            if (val > 0x3FFFFFF) {
                val = 0x3FFFFFF;
            } else if (val < 0) {
                val = 0;
            }
            this.coverVariable = val | Integer.MIN_VALUE | this.coverVariable & 0x40000000;
            GT_Values.NW.sendToServer(new GT_Packet_TileEntityCover(this.side, this.coverID, this.coverVariable, this.tile));
            this.update();
        }

        @Override
        public void resetTextBox(GT_GuiIntegerTextBox box) {
            box.func_146180_a(this.getSlot() < 0 ? this.ALL : String.valueOf(this.getSlot()));
        }

        private int parseTextBox(GT_GuiIntegerTextBox box) {
            int val;
            String text = box.func_146179_b();
            if (text == null) {
                return -1;
            }
            if ((text = text.trim()).startsWith(this.ALL)) {
                text = text.substring(this.ALL.length());
            }
            if (text.isEmpty()) {
                return -1;
            }
            try {
                val = Integer.parseInt(text);
            }
            catch (NumberFormatException e) {
                return -1;
            }
            if (val < 0) {
                return -1;
            }
            if (this.maxSlot < val) {
                return this.maxSlot;
            }
            return val;
        }

        private boolean isInverted() {
            return (this.coverVariable & 0x40000000) != 0;
        }

        private int getSlot() {
            return (this.coverVariable & 0x3FFFFFF) - 1;
        }
    }
}

