/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import gregtech.api.gui.widgets.GT_GuiIcon;
import gregtech.api.gui.widgets.GT_GuiTooltip;
import gregtech.api.interfaces.IGuiScreen;
import java.awt.Rectangle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import org.lwjgl.opengl.GL11;

public class GT_GuiIconButton
extends GuiButton
implements IGuiScreen.IGuiElement {
    public static final int DEFAULT_WIDTH = 16;
    public static final int DEFAULT_HEIGHT = 16;
    protected GT_GuiIcon icon;
    private int x0;
    private int y0;
    protected IGuiScreen gui;
    private GT_GuiTooltip tooltip;

    public GT_GuiIconButton(IGuiScreen gui, int id, int x, int y, GT_GuiIcon icon) {
        super(id, x, y, 16, 16, "");
        this.gui = gui;
        this.icon = icon;
        this.x0 = x;
        this.y0 = y;
        gui.addElement(this);
    }

    @Override
    public void onInit() {
        if (this.tooltip != null) {
            this.gui.addToolTip(this.tooltip);
        }
        this.field_146128_h = this.x0 + this.gui.getGuiLeft();
        this.field_146129_i = this.y0 + this.gui.getGuiTop();
    }

    @Override
    public void draw(int mouseX, int mouseY, float parTicks) {
        this.func_146112_a(Minecraft.func_71410_x(), mouseX, mouseY);
    }

    public void func_146112_a(Minecraft mc, int mouseX, int mouseY) {
        if (this.tooltip != null) {
            this.tooltip.enabled = true;
        }
        if (this.field_146125_m) {
            this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            this.func_146119_b(mc, mouseX, mouseY);
            GL11.glPushAttrib((int)8192);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            int x = this.field_146128_h;
            int y = this.field_146129_i;
            if (this.field_146123_n) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            GT_GuiIcon.render(this.getButtonTexture(this.field_146123_n), x, y, this.field_146120_f, this.field_146121_g, 0.0, true);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.icon != null) {
                GT_GuiIcon.render(this.icon, x, y, this.field_146120_f, this.field_146121_g, 0.0, true);
            }
            GL11.glPopAttrib();
        }
    }

    public void func_146118_a(int mouseX, int mouseY) {
        this.gui.clearSelectedButton();
        if (this.func_146116_c(Minecraft.func_71410_x(), mouseX, mouseY)) {
            this.gui.buttonClicked(this);
        }
    }

    public GT_GuiIcon getButtonTexture(boolean mouseOver) {
        if (!this.field_146124_l) {
            return GT_GuiIcon.BUTTON_DISABLED;
        }
        if (this.equals(this.gui.getSelectedButton())) {
            return mouseOver ? GT_GuiIcon.BUTTON_HIGHLIGHT_DOWN : GT_GuiIcon.BUTTON_DOWN;
        }
        return mouseOver ? GT_GuiIcon.BUTTON_HIGHLIGHT : GT_GuiIcon.BUTTON_NORMAL;
    }

    public GT_GuiIcon getIcon() {
        return this.icon;
    }

    public GT_GuiIconButton setIcon(GT_GuiIcon icon) {
        this.icon = icon;
        return this;
    }

    public GT_GuiTooltip getTooltip() {
        return this.tooltip;
    }

    public GT_GuiIconButton setTooltipText(String ... text) {
        if (this.tooltip == null) {
            this.tooltip = new GT_GuiTooltip(this.getBounds(), text);
        } else {
            this.tooltip.setToolTipText(text);
        }
        return this;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x0, this.y0, this.field_146120_f, this.field_146121_g);
    }
}

