/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.items;

import gregtech.api.GregTech_API;
import gregtech.api.items.GT_Generic_Item;
import ic2.core.util.StackUtil;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;

public class GT_CoolantCell_Item
extends GT_Generic_Item {
    protected int heatStorage;

    public GT_CoolantCell_Item(String aUnlocalized, String aEnglish, int aMaxStore) {
        super(aUnlocalized, aEnglish, null);
        this.func_77625_d(1);
        this.func_77656_e(100);
        this.setNoRepair();
        this.heatStorage = aMaxStore;
        this.func_77637_a(GregTech_API.TAB_GREGTECH);
    }

    protected static int getHeatOfStack(ItemStack aStack) {
        NBTTagCompound tNBT = aStack.func_77978_p();
        if (tNBT == null) {
            tNBT = new NBTTagCompound();
            aStack.func_77982_d(tNBT);
        }
        return tNBT.func_74762_e("heat");
    }

    protected void setHeatForStack(ItemStack aStack, int aHeat) {
        NBTTagCompound tNBT = aStack.func_77978_p();
        if (tNBT == null) {
            tNBT = new NBTTagCompound();
            aStack.func_77982_d(tNBT);
        }
        tNBT.func_74768_a("heat", aHeat);
        if (this.heatStorage > 0) {
            double heatRatio = (double)aHeat / (double)this.heatStorage;
            int damage = (int)((double)aStack.func_77958_k() * heatRatio);
            if (damage >= aStack.func_77958_k()) {
                damage = aStack.func_77958_k() - 1;
            }
            aStack.func_77964_b(damage);
        }
    }

    @Override
    public void addAdditionalToolTips(List<String> aList, ItemStack aStack, EntityPlayer aPlayer) {
        EnumChatFormatting color;
        super.addAdditionalToolTips(aList, aStack, aPlayer);
        int rHeat = GT_CoolantCell_Item.getHeatOfStack(aStack) * 10 / this.heatStorage;
        switch (rHeat) {
            case 0: {
                color = EnumChatFormatting.BLUE;
                break;
            }
            case 1: 
            case 2: {
                color = EnumChatFormatting.GREEN;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                color = EnumChatFormatting.YELLOW;
                break;
            }
            case 7: 
            case 8: {
                color = EnumChatFormatting.RED;
                break;
            }
            default: {
                color = EnumChatFormatting.DARK_RED;
            }
        }
        aList.add(EnumChatFormatting.WHITE + String.format(this.transItem("000", "Stored Heat: %s"), "" + color + GT_CoolantCell_Item.getHeatOfStack(aStack)));
        switch (this.getControlTagOfStack(aStack)) {
            case 1: {
                aList.add(StatCollector.func_74838_a((String)"ic2.reactoritem.heatwarning.line1"));
                aList.add(StatCollector.func_74838_a((String)"ic2.reactoritem.heatwarning.line2"));
            }
        }
    }

    public int getControlTagOfStack(ItemStack stack) {
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData((ItemStack)stack);
        return nbtData.func_74762_e("tag");
    }

    public void setControlTagOfStack(ItemStack stack, int tag) {
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData((ItemStack)stack);
        nbtData.func_74768_a("tag", tag);
    }
}

