/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import com.google.common.collect.Iterables;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.Column;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.ConfigCategories;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.SoundResource;
import gregtech.api.gui.modularui.GT_UIInfos;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.modularui.IAddGregtechLogo;
import gregtech.api.interfaces.modularui.IAddUIWidgets;
import gregtech.api.interfaces.modularui.IBindPlayerInventoryUI;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.items.GT_MetaGenerated_Tool;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Dynamo;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Maintenance;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Muffler;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_MultiInput;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_OutputBus;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.util.GT_ExoticEnergyInputHelper;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Single_Recipe_Check;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.GT_Waila;
import gregtech.common.GT_Pollution;
import gregtech.common.items.GT_MetaGenerated_Tool_01;
import gregtech.common.tileentities.machines.multi.GT_MetaTileEntity_DrillerBase;
import gregtech.common.tileentities.machines.multi.GT_MetaTileEntity_LargeTurbine;
import java.util.ArrayList;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.SpecialChars;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.input.Keyboard;

public abstract class GT_MetaTileEntity_MultiBlockBase
extends MetaTileEntity
implements IAddGregtechLogo,
IAddUIWidgets,
IBindPlayerInventoryUI {
    public static boolean disableMaintenance;
    public boolean mMachine = false;
    public boolean mWrench = false;
    public boolean mScrewdriver = false;
    public boolean mSoftHammer = false;
    public boolean mHardHammer = false;
    public boolean mSolderingTool = false;
    public boolean mCrowbar = false;
    public boolean mRunningOnLoad = false;
    public boolean mStructureChanged = false;
    public int mPollution = 0;
    public int mProgresstime = 0;
    public int mMaxProgresstime = 0;
    public int mEUt = 0;
    public int mEfficiencyIncrease = 0;
    public int mStartUpCheck = 100;
    public int mRuntime = 0;
    public int mEfficiency = 0;
    public volatile boolean mUpdated = false;
    public int mUpdate = 0;
    public ItemStack[] mOutputItems = null;
    public FluidStack[] mOutputFluids = null;
    public String mNEI;
    public int damageFactorLow = 5;
    public float damageFactorHigh = 0.6f;
    public boolean mLockedToSingleRecipe = false;
    protected boolean inputSeparation = false;
    protected boolean voidExcess = true;
    protected boolean batchMode = false;
    protected static String INPUT_SEPARATION_NBT_KEY;
    protected static String VOID_EXCESS_NBT_KEY;
    protected static String BATCH_MODE_NBT_KEY;
    public GT_Single_Recipe_Check mSingleRecipeCheck = null;
    public ArrayList<GT_MetaTileEntity_Hatch_Input> mInputHatches = new ArrayList();
    public ArrayList<GT_MetaTileEntity_Hatch_Output> mOutputHatches = new ArrayList();
    public ArrayList<GT_MetaTileEntity_Hatch_InputBus> mInputBusses = new ArrayList();
    public ArrayList<GT_MetaTileEntity_Hatch_OutputBus> mOutputBusses = new ArrayList();
    public ArrayList<GT_MetaTileEntity_Hatch_Dynamo> mDynamoHatches = new ArrayList();
    public ArrayList<GT_MetaTileEntity_Hatch_Muffler> mMufflerHatches = new ArrayList();
    public ArrayList<GT_MetaTileEntity_Hatch_Energy> mEnergyHatches = new ArrayList();
    public ArrayList<GT_MetaTileEntity_Hatch_Maintenance> mMaintenanceHatches = new ArrayList();
    protected final List<GT_MetaTileEntity_Hatch> mExoticEnergyHatches = new ArrayList<GT_MetaTileEntity_Hatch>();
    protected static final byte INTERRUPT_SOUND_INDEX = 8;
    protected static final byte PROCESS_START_SOUND_INDEX = 1;

    public GT_MetaTileEntity_MultiBlockBase(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, 2);
        disableMaintenance = GregTech_API.sMachineFile.get((Object)ConfigCategories.machineconfig, "MultiBlockMachines.disableMaintenance", false);
        this.damageFactorLow = GregTech_API.sMachineFile.get((Object)ConfigCategories.machineconfig, "MultiBlockMachines.damageFactorLow", 5);
        this.damageFactorHigh = (float)GregTech_API.sMachineFile.get((Object)ConfigCategories.machineconfig, "MultiBlockMachines.damageFactorHigh", (double)0.6f);
        this.mNEI = "";
    }

    public GT_MetaTileEntity_MultiBlockBase(String aName) {
        super(aName, 2);
        disableMaintenance = GregTech_API.sMachineFile.get((Object)ConfigCategories.machineconfig, "MultiBlockMachines.disableMaintenance", false);
        this.damageFactorLow = GregTech_API.sMachineFile.get((Object)ConfigCategories.machineconfig, "MultiBlockMachines.damageFactorLow", 5);
        this.damageFactorHigh = (float)GregTech_API.sMachineFile.get((Object)ConfigCategories.machineconfig, "MultiBlockMachines.damageFactorHigh", (double)0.6f);
    }

    public static boolean isValidMetaTileEntity(MetaTileEntity aMetaTileEntity) {
        return aMetaTileEntity.getBaseMetaTileEntity() != null && aMetaTileEntity.getBaseMetaTileEntity().getMetaTileEntity() == aMetaTileEntity && !aMetaTileEntity.getBaseMetaTileEntity().isDead();
    }

    @Override
    public boolean isDisplaySecondaryDescription() {
        return Keyboard.isKeyDown((int)42);
    }

    @Override
    public boolean allowCoverOnSide(byte aSide, GT_ItemStack aCoverID) {
        return aSide != this.getBaseMetaTileEntity().getFrontFacing();
    }

    public boolean supportsSingleRecipeLocking() {
        return false;
    }

    @Override
    public void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (this.supportsSingleRecipeLocking()) {
            boolean bl = this.mLockedToSingleRecipe = !this.mLockedToSingleRecipe;
            if (this.mLockedToSingleRecipe) {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("223", "Single recipe locking enabled. Will lock to next recipe."));
            } else {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("220", "Single recipe locking disabled."));
                this.mSingleRecipeCheck = null;
            }
        }
    }

    @Override
    public boolean isSimpleMachine() {
        return false;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return true;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return aIndex > 0;
    }

    @Override
    public int getProgresstime() {
        return this.mProgresstime;
    }

    @Override
    public int maxProgresstime() {
        return this.mMaxProgresstime;
    }

    @Override
    public int increaseProgress(int aProgress) {
        return aProgress;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        int i;
        aNBT.func_74768_a("mEUt", this.mEUt);
        aNBT.func_74768_a("mProgresstime", this.mProgresstime);
        aNBT.func_74768_a("mMaxProgresstime", this.mMaxProgresstime);
        aNBT.func_74768_a("mEfficiencyIncrease", this.mEfficiencyIncrease);
        aNBT.func_74768_a("mEfficiency", this.mEfficiency);
        aNBT.func_74768_a("mPollution", this.mPollution);
        aNBT.func_74768_a("mRuntime", this.mRuntime);
        if (this.supportsSingleRecipeLocking()) {
            aNBT.func_74757_a("mLockedToSingleRecipe", this.mLockedToSingleRecipe);
            if (this.mLockedToSingleRecipe && this.mSingleRecipeCheck != null) {
                aNBT.func_74782_a("mSingleRecipeCheck", (NBTBase)this.mSingleRecipeCheck.writeToNBT());
            }
        }
        if (this.mOutputItems != null) {
            aNBT.func_74768_a("mOutputItemsLength", this.mOutputItems.length);
            for (i = 0; i < this.mOutputItems.length; ++i) {
                if (this.mOutputItems[i] == null) continue;
                GT_Utility.saveItem(aNBT, "mOutputItem" + i, this.mOutputItems[i]);
            }
        }
        if (this.mOutputFluids != null) {
            aNBT.func_74768_a("mOutputFluidsLength", this.mOutputFluids.length);
            for (i = 0; i < this.mOutputFluids.length; ++i) {
                if (this.mOutputFluids[i] == null) continue;
                NBTTagCompound tNBT = new NBTTagCompound();
                this.mOutputFluids[i].writeToNBT(tNBT);
                aNBT.func_74782_a("mOutputFluids" + i, (NBTBase)tNBT);
            }
        }
        aNBT.func_74757_a("mWrench", this.mWrench);
        aNBT.func_74757_a("mScrewdriver", this.mScrewdriver);
        aNBT.func_74757_a("mSoftHammer", this.mSoftHammer);
        aNBT.func_74757_a("mHardHammer", this.mHardHammer);
        aNBT.func_74757_a("mSolderingTool", this.mSolderingTool);
        aNBT.func_74757_a("mCrowbar", this.mCrowbar);
        aNBT.func_74757_a(BATCH_MODE_NBT_KEY, this.batchMode);
        aNBT.func_74757_a(INPUT_SEPARATION_NBT_KEY, this.inputSeparation);
        aNBT.func_74757_a(VOID_EXCESS_NBT_KEY, this.voidExcess);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        int aOutputFluidsLength;
        this.mEUt = aNBT.func_74762_e("mEUt");
        this.mProgresstime = aNBT.func_74762_e("mProgresstime");
        this.mMaxProgresstime = aNBT.func_74762_e("mMaxProgresstime");
        if (this.mMaxProgresstime > 0) {
            this.mRunningOnLoad = true;
        }
        this.mEfficiencyIncrease = aNBT.func_74762_e("mEfficiencyIncrease");
        this.mEfficiency = aNBT.func_74762_e("mEfficiency");
        this.mPollution = aNBT.func_74762_e("mPollution");
        this.mRuntime = aNBT.func_74762_e("mRuntime");
        if (this.supportsSingleRecipeLocking()) {
            this.mLockedToSingleRecipe = aNBT.func_74767_n("mLockedToSingleRecipe");
            if (this.mLockedToSingleRecipe && aNBT.func_150297_b("mSingleRecipeCheck", 10)) {
                GT_Single_Recipe_Check c = this.loadSingleRecipeChecker(aNBT.func_74775_l("mSingleRecipeCheck"));
                if (c != null) {
                    this.mSingleRecipeCheck = c;
                } else {
                    this.getBaseMetaTileEntity().disableWorking();
                }
            }
        }
        this.batchMode = aNBT.func_74767_n(BATCH_MODE_NBT_KEY);
        this.inputSeparation = aNBT.func_74767_n(INPUT_SEPARATION_NBT_KEY);
        this.voidExcess = aNBT.func_74767_n(VOID_EXCESS_NBT_KEY);
        int aOutputItemsLength = aNBT.func_74762_e("mOutputItemsLength");
        if (aOutputItemsLength > 0) {
            this.mOutputItems = new ItemStack[aOutputItemsLength];
            for (int i = 0; i < this.mOutputItems.length; ++i) {
                this.mOutputItems[i] = GT_Utility.loadItem(aNBT, "mOutputItem" + i);
            }
        }
        if ((aOutputFluidsLength = aNBT.func_74762_e("mOutputFluidsLength")) > 0) {
            this.mOutputFluids = new FluidStack[aOutputFluidsLength];
            for (int i = 0; i < this.mOutputFluids.length; ++i) {
                this.mOutputFluids[i] = GT_Utility.loadFluid(aNBT, "mOutputFluids" + i);
            }
        }
        this.mWrench = aNBT.func_74767_n("mWrench");
        this.mScrewdriver = aNBT.func_74767_n("mScrewdriver");
        this.mSoftHammer = aNBT.func_74767_n("mSoftHammer");
        this.mHardHammer = aNBT.func_74767_n("mHardHammer");
        this.mSolderingTool = aNBT.func_74767_n("mSolderingTool");
        this.mCrowbar = aNBT.func_74767_n("mCrowbar");
    }

    protected GT_Single_Recipe_Check loadSingleRecipeChecker(NBTTagCompound aNBT) {
        return GT_Single_Recipe_Check.tryLoad(this, aNBT);
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        GT_UIInfos.openGTTileEntityUI(aBaseMetaTileEntity, aPlayer);
        return true;
    }

    @Override
    public byte getTileEntityBaseType() {
        return 2;
    }

    public void onStructureChange() {
        this.mStructureChanged = true;
    }

    @Override
    public void onMachineBlockUpdate() {
        this.mUpdated = true;
    }

    public void clearHatches() {
        this.mInputHatches.clear();
        this.mInputBusses.clear();
        this.mOutputHatches.clear();
        this.mOutputBusses.clear();
        this.mDynamoHatches.clear();
        this.mEnergyHatches.clear();
        this.setMufflers(false);
        this.mMufflerHatches.clear();
        this.mMaintenanceHatches.clear();
    }

    public boolean checkStructure(boolean aForceReset) {
        return this.checkStructure(aForceReset, this.getBaseMetaTileEntity());
    }

    public boolean checkStructure(boolean aForceReset, IGregTechTileEntity aBaseMetaTileEntity) {
        if (!aBaseMetaTileEntity.isServerSide()) {
            return this.mMachine;
        }
        if (this.mStructureChanged || aForceReset) {
            this.clearHatches();
            this.mMachine = this.checkMachine(aBaseMetaTileEntity, this.mInventory[1]);
        }
        this.mStructureChanged = false;
        return this.mMachine;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            if (this.mEfficiency < 0) {
                this.mEfficiency = 0;
            }
            if (this.mUpdated) {
                if (this.mUpdate <= 0) {
                    this.mUpdate = 50;
                }
                this.mUpdated = false;
            }
            if (--this.mUpdate == 0 || --this.mStartUpCheck == 0) {
                this.checkStructure(true, aBaseMetaTileEntity);
            }
            if (this.mStartUpCheck < 0) {
                if (this.mMachine) {
                    this.checkMaintenance();
                    if (this.getRepairStatus() > 0) {
                        this.runMachine(aBaseMetaTileEntity, aTick);
                    } else {
                        this.stopMachine();
                    }
                } else {
                    this.stopMachine();
                }
            }
            aBaseMetaTileEntity.setErrorDisplayID(aBaseMetaTileEntity.getErrorDisplayID() & 0xFFFFFF80 | (this.mWrench ? 0 : 1) | (this.mScrewdriver ? 0 : 2) | (this.mSoftHammer ? 0 : 4) | (this.mHardHammer ? 0 : 8) | (this.mSolderingTool ? 0 : 16) | (this.mCrowbar ? 0 : 32) | (this.mMachine ? 0 : 64));
            aBaseMetaTileEntity.setActive(this.mMaxProgresstime > 0);
            boolean active = aBaseMetaTileEntity.isActive() && this.mPollution > 0;
            this.setMufflers(active);
        }
    }

    private void checkMaintenance() {
        if (disableMaintenance) {
            this.mWrench = true;
            this.mScrewdriver = true;
            this.mSoftHammer = true;
            this.mHardHammer = true;
            this.mSolderingTool = true;
            this.mCrowbar = true;
            return;
        }
        for (GT_MetaTileEntity_Hatch_Maintenance tHatch : this.mMaintenanceHatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(tHatch)) continue;
            if (!(!tHatch.mAuto || this.mWrench && this.mScrewdriver && this.mSoftHammer && this.mHardHammer && this.mSolderingTool && this.mCrowbar)) {
                tHatch.autoMaintainance();
            }
            if (tHatch.mWrench) {
                this.mWrench = true;
            }
            if (tHatch.mScrewdriver) {
                this.mScrewdriver = true;
            }
            if (tHatch.mSoftHammer) {
                this.mSoftHammer = true;
            }
            if (tHatch.mHardHammer) {
                this.mHardHammer = true;
            }
            if (tHatch.mSolderingTool) {
                this.mSolderingTool = true;
            }
            if (tHatch.mCrowbar) {
                this.mCrowbar = true;
            }
            tHatch.mWrench = false;
            tHatch.mScrewdriver = false;
            tHatch.mSoftHammer = false;
            tHatch.mHardHammer = false;
            tHatch.mSolderingTool = false;
            tHatch.mCrowbar = false;
        }
    }

    protected boolean checkRecipe() {
        this.startRecipeProcessing();
        boolean result = this.checkRecipe(this.mInventory[1]);
        if (result && this.getProcessStartSound() != null) {
            this.sendLoopStart((byte)1);
        }
        this.endRecipeProcessing();
        return result;
    }

    protected void runMachine(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (this.mMaxProgresstime > 0 && this.doRandomMaintenanceDamage()) {
            if (this.onRunningTick(this.mInventory[1])) {
                this.func_70296_d();
                if (!this.polluteEnvironment(this.getPollutionPerTick(this.mInventory[1]))) {
                    this.stopMachine();
                }
                if (this.mMaxProgresstime > 0 && ++this.mProgresstime >= this.mMaxProgresstime) {
                    if (this.mOutputItems != null) {
                        for (ItemStack tStack : this.mOutputItems) {
                            if (tStack == null) continue;
                            try {
                                GT_Mod.achievements.issueAchivementHatch(aBaseMetaTileEntity.getWorld().func_72924_a(aBaseMetaTileEntity.getOwnerName()), tStack);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            this.addOutput(tStack);
                        }
                    }
                    if (this.mOutputFluids != null) {
                        this.addFluidOutputs(this.mOutputFluids);
                    }
                    this.mEfficiency = Math.max(0, Math.min(this.mEfficiency + this.mEfficiencyIncrease, this.getMaxEfficiency(this.mInventory[1]) - (this.getIdealStatus() - this.getRepairStatus()) * 1000));
                    this.mOutputItems = null;
                    this.mProgresstime = 0;
                    this.mMaxProgresstime = 0;
                    this.mEfficiencyIncrease = 0;
                    if (aBaseMetaTileEntity.isAllowedToWork()) {
                        this.checkRecipe();
                    }
                    if (this.mOutputFluids != null && this.mOutputFluids.length > 0 && this.mOutputFluids.length > 1) {
                        try {
                            GT_Mod.achievements.issueAchievement(aBaseMetaTileEntity.getWorld().func_72924_a(aBaseMetaTileEntity.getOwnerName()), "oilplant");
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        } else if (aTick % 100L == 0L || aBaseMetaTileEntity.hasWorkJustBeenEnabled() || aBaseMetaTileEntity.hasInventoryBeenModified()) {
            if (aBaseMetaTileEntity.isAllowedToWork() && this.checkRecipe()) {
                this.func_70296_d();
            }
            if (this.mMaxProgresstime <= 0) {
                this.mEfficiency = Math.max(0, this.mEfficiency - 1000);
            }
        }
    }

    public boolean polluteEnvironment(int aPollutionLevel) {
        this.mPollution += aPollutionLevel;
        for (GT_MetaTileEntity_Hatch_Muffler tHatch : this.mMufflerHatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(tHatch)) continue;
            if (this.mPollution < 10000) break;
            if (!tHatch.polluteEnvironment(this)) continue;
            this.mPollution -= 10000;
        }
        return this.mPollution < 10000;
    }

    @Override
    public void doSound(byte aIndex, double aX, double aY, double aZ) {
        super.doSound(aIndex, aX, aY, aZ);
        switch (aIndex) {
            case 1: {
                if (this.getProcessStartSound() == null) break;
                GT_Utility.doSoundAtClient(this.getProcessStartSound(), this.getTimeBetweenProcessSounds(), 1.0f, aX, aY, aZ);
                break;
            }
            case 8: {
                GT_Utility.doSoundAtClient(SoundResource.IC2_MACHINES_INTERRUPT_ONE, 100, 1.0f, aX, aY, aZ);
            }
        }
    }

    @Override
    public void startSoundLoop(byte aIndex, double aX, double aY, double aZ) {
        super.startSoundLoop(aIndex, aX, aY, aZ);
        if (aIndex == 1 && this.getProcessStartSound() != null) {
            GT_Utility.doSoundAtClient(this.getProcessStartSound(), this.getTimeBetweenProcessSounds(), 1.0f, aX, aY, aZ);
        }
    }

    protected int getTimeBetweenProcessSounds() {
        return 100;
    }

    protected SoundResource getProcessStartSound() {
        return null;
    }

    public boolean onRunningTick(ItemStack aStack) {
        if (this.mEUt > 0) {
            this.addEnergyOutput((long)this.mEUt * (long)this.mEfficiency / 10000L);
            return true;
        }
        if (this.mEUt < 0 && !this.drainEnergyInput(this.getActualEnergyUsage())) {
            this.criticalStopMachine();
            return false;
        }
        return true;
    }

    protected long getActualEnergyUsage() {
        return (long)(-this.mEUt) * 10000L / (long)Math.max(1000, this.mEfficiency);
    }

    public abstract boolean isCorrectMachinePart(ItemStack var1);

    public abstract boolean checkRecipe(ItemStack var1);

    public abstract boolean checkMachine(IGregTechTileEntity var1, ItemStack var2);

    public abstract int getMaxEfficiency(ItemStack var1);

    public int getPollutionPerTick(ItemStack aStack) {
        return this.getPollutionPerSecond(aStack) / 20;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return 0;
    }

    public abstract int getDamageToComponent(ItemStack var1);

    public abstract boolean explodesOnComponentBreak(ItemStack var1);

    public void stopMachine() {
        this.mOutputItems = null;
        this.mEUt = 0;
        this.mEfficiency = 0;
        this.mProgresstime = 0;
        this.mMaxProgresstime = 0;
        this.mEfficiencyIncrease = 0;
        this.getBaseMetaTileEntity().disableWorking();
    }

    public void criticalStopMachine() {
        this.stopMachine();
        this.sendSound((byte)8);
        this.getBaseMetaTileEntity().setShutdownStatus(true);
    }

    public int getRepairStatus() {
        return (this.mWrench ? 1 : 0) + (this.mScrewdriver ? 1 : 0) + (this.mSoftHammer ? 1 : 0) + (this.mHardHammer ? 1 : 0) + (this.mSolderingTool ? 1 : 0) + (this.mCrowbar ? 1 : 0);
    }

    public int getIdealStatus() {
        return 6;
    }

    public int getCurrentEfficiency(ItemStack itemStack) {
        int maxEff = this.getMaxEfficiency(itemStack);
        return maxEff - (this.getIdealStatus() - this.getRepairStatus()) * maxEff / 10;
    }

    public boolean doRandomMaintenanceDamage() {
        if (!this.isCorrectMachinePart(this.mInventory[1]) || this.getRepairStatus() == 0) {
            this.stopMachine();
            return false;
        }
        if (this.mRuntime++ > 1000) {
            this.mRuntime = 0;
            if (this.getBaseMetaTileEntity().getRandomNumber(6000) == 0) {
                switch (this.getBaseMetaTileEntity().getRandomNumber(6)) {
                    case 0: {
                        this.mWrench = false;
                        break;
                    }
                    case 1: {
                        this.mScrewdriver = false;
                        break;
                    }
                    case 2: {
                        this.mSoftHammer = false;
                        break;
                    }
                    case 3: {
                        this.mHardHammer = false;
                        break;
                    }
                    case 4: {
                        this.mSolderingTool = false;
                        break;
                    }
                    case 5: {
                        this.mCrowbar = false;
                    }
                }
            }
            if (this.mInventory[1] != null && this.getBaseMetaTileEntity().getRandomNumber(2) == 0 && !this.mInventory[1].func_77977_a().startsWith("gt.blockmachines.basicmachine.") && this.mInventory[1].func_77973_b() instanceof GT_MetaGenerated_Tool_01) {
                NBTTagCompound tNBT = this.mInventory[1].func_77978_p();
                ((GT_MetaGenerated_Tool)this.mInventory[1].func_77973_b()).doDamage(this.mInventory[1], (long)this.getDamageToComponent(this.mInventory[1]) * (long)Math.min((double)(this.mEUt / this.damageFactorLow), Math.pow(this.mEUt, this.damageFactorHigh)));
                if (this.mInventory[1].field_77994_a == 0) {
                    this.mInventory[1] = null;
                }
            }
        }
        return true;
    }

    public void explodeMultiblock() {
        GT_Log.exp.println("MultiBlockExplosion at: " + this.getBaseMetaTileEntity().getXCoord() + " | " + this.getBaseMetaTileEntity().getYCoord() + " | " + this.getBaseMetaTileEntity().getZCoord() + " DIMID: " + this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g + ".");
        GT_Pollution.addPollution(this.getBaseMetaTileEntity(), GT_Mod.gregtechproxy.mPollutionOnExplosion);
        this.mInventory[1] = null;
        Iterable allHatches = Iterables.concat((Iterable[])new Iterable[]{this.mInputBusses, this.mOutputBusses, this.mInputHatches, this.mOutputHatches, this.mDynamoHatches, this.mMufflerHatches, this.mEnergyHatches, this.mMaintenanceHatches});
        for (MetaTileEntity tTileEntity : allHatches) {
            if (tTileEntity == null || tTileEntity.getBaseMetaTileEntity() == null) continue;
            tTileEntity.getBaseMetaTileEntity().doExplosion(GT_Values.V[8]);
        }
        this.getBaseMetaTileEntity().doExplosion(GT_Values.V[8]);
    }

    public boolean addEnergyOutput(long aEU) {
        if (aEU <= 0L) {
            return true;
        }
        if (this.mDynamoHatches.size() > 0) {
            return this.addEnergyOutputMultipleDynamos(aEU, true);
        }
        return false;
    }

    public boolean addEnergyOutputMultipleDynamos(long aEU, boolean aAllowMixedVoltageDynamos) {
        long aVoltage;
        int injected = 0;
        long totalOutput = 0L;
        long aFirstVoltageFound = -1L;
        boolean aFoundMixedDynamos = false;
        for (GT_MetaTileEntity_Hatch_Dynamo aDynamo : this.mDynamoHatches) {
            if (aDynamo == null) {
                return false;
            }
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(aDynamo)) continue;
            aVoltage = aDynamo.maxEUOutput();
            long aTotal = aDynamo.maxAmperesOut() * aVoltage;
            if (aFirstVoltageFound == -1L) {
                aFirstVoltageFound = aVoltage;
            } else if (aFirstVoltageFound != aVoltage) {
                aFoundMixedDynamos = true;
            }
            totalOutput += aTotal;
        }
        if (totalOutput < aEU || aFoundMixedDynamos && !aAllowMixedVoltageDynamos) {
            this.explodeMultiblock();
            return false;
        }
        for (GT_MetaTileEntity_Hatch_Dynamo aDynamo : this.mDynamoHatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(aDynamo)) continue;
            long leftToInject = aEU - (long)injected;
            aVoltage = aDynamo.maxEUOutput();
            int aAmpsToInject = (int)(leftToInject / aVoltage);
            int aRemainder = (int)(leftToInject - (long)aAmpsToInject * aVoltage);
            int ampsOnCurrentHatch = (int)Math.min(aDynamo.maxAmperesOut(), (long)aAmpsToInject);
            for (int i = 0; i < ampsOnCurrentHatch; ++i) {
                aDynamo.getBaseMetaTileEntity().increaseStoredEnergyUnits(aVoltage, false);
            }
            injected = (int)((long)injected + aVoltage * (long)ampsOnCurrentHatch);
            if (aRemainder <= 0 || (long)ampsOnCurrentHatch >= aDynamo.maxAmperesOut()) continue;
            aDynamo.getBaseMetaTileEntity().increaseStoredEnergyUnits(aRemainder, false);
            injected += aRemainder;
        }
        return injected > 0;
    }

    public long getMaxInputVoltage() {
        long rVoltage = 0L;
        for (GT_MetaTileEntity_Hatch_Energy tHatch : this.mEnergyHatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(tHatch)) continue;
            rVoltage += tHatch.getBaseMetaTileEntity().getInputVoltage();
        }
        return rVoltage;
    }

    protected void calculateOverclockedNessMultiInternal(long aEUt, int aDuration, int mAmperage, long maxInputVoltage, boolean perfectOC) {
        byte mTier = (byte)Math.max(0, GT_Utility.getTier(maxInputVoltage));
        if (mTier == 0) {
            long xMaxProgresstime = (long)aDuration << 1;
            if (xMaxProgresstime > 0x7FFFFFFEL) {
                this.mEUt = 0x7FFFFFFE;
                this.mMaxProgresstime = 0x7FFFFFFE;
            } else {
                this.mEUt = GT_Utility.safeInt(aEUt >> 2);
                this.mMaxProgresstime = (int)xMaxProgresstime;
            }
        } else {
            int ocTimeShift;
            long xEUt = aEUt;
            long tempEUt = Math.max(xEUt, GT_Values.V[1]);
            this.mMaxProgresstime = aDuration;
            int n = ocTimeShift = perfectOC ? 2 : 1;
            while (tempEUt <= GT_Values.V[mTier - 1] * (long)mAmperage) {
                tempEUt <<= 2;
                int oldTime = this.mMaxProgresstime;
                this.mMaxProgresstime >>= ocTimeShift;
                if (this.mMaxProgresstime < 1) {
                    if (oldTime == 1) break;
                    xEUt *= (long)(oldTime * (perfectOC ? 1 : 2));
                    break;
                }
                xEUt <<= 2;
            }
            if (xEUt > 0x7FFFFFFEL) {
                this.mEUt = 0x7FFFFFFE;
                this.mMaxProgresstime = 0x7FFFFFFE;
            } else {
                this.mEUt = (int)xEUt;
                if (this.mEUt == 0) {
                    this.mEUt = 1;
                }
                if (this.mMaxProgresstime == 0) {
                    this.mMaxProgresstime = 1;
                }
            }
        }
    }

    @Deprecated
    protected void calculateOverclockedNessMulti(int aEUt, int aDuration, int mAmperage, long maxInputVoltage) {
        this.calculateOverclockedNessMultiInternal(aEUt, aDuration, mAmperage, maxInputVoltage, false);
    }

    protected void calculateOverclockedNessMulti(long aEUt, int aDuration, int mAmperage, long maxInputVoltage) {
        this.calculateOverclockedNessMultiInternal(aEUt, aDuration, mAmperage, maxInputVoltage, false);
    }

    @Deprecated
    protected void calculatePerfectOverclockedNessMulti(int aEUt, int aDuration, int mAmperage, long maxInputVoltage) {
        this.calculateOverclockedNessMultiInternal(aEUt, aDuration, mAmperage, maxInputVoltage, true);
    }

    protected void calculatePerfectOverclockedNessMulti(long aEUt, int aDuration, int mAmperage, long maxInputVoltage) {
        this.calculateOverclockedNessMultiInternal(aEUt, aDuration, mAmperage, maxInputVoltage, true);
    }

    public boolean drainEnergyInput(long aEU) {
        if (aEU <= 0L) {
            return true;
        }
        for (GT_MetaTileEntity_Hatch_Energy tHatch : this.mEnergyHatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(tHatch) || !tHatch.getBaseMetaTileEntity().decreaseStoredEnergyUnits(aEU, false)) continue;
            return true;
        }
        return false;
    }

    protected static boolean dumpFluid(List<GT_MetaTileEntity_Hatch_Output> aOutputHatches, FluidStack copiedFluidStack, boolean restrictiveHatchesOnly) {
        for (GT_MetaTileEntity_Hatch_Output tHatch : aOutputHatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(tHatch) || restrictiveHatchesOnly && tHatch.mMode == 0 || !tHatch.canStoreFluid(copiedFluidStack.getFluid())) continue;
            int tAmount = tHatch.fill(copiedFluidStack, false);
            if (tAmount >= copiedFluidStack.amount) {
                boolean filled = tHatch.fill(copiedFluidStack, true) >= copiedFluidStack.amount;
                tHatch.onEmptyingContainerWhenEmpty();
                return filled;
            }
            if (tAmount <= 0) continue;
            copiedFluidStack.amount -= tHatch.fill(copiedFluidStack, true);
            tHatch.onEmptyingContainerWhenEmpty();
        }
        return false;
    }

    public boolean addOutput(FluidStack aLiquid) {
        if (aLiquid == null) {
            return false;
        }
        FluidStack copiedFluidStack = aLiquid.copy();
        if (!GT_MetaTileEntity_MultiBlockBase.dumpFluid(this.mOutputHatches, copiedFluidStack, true)) {
            GT_MetaTileEntity_MultiBlockBase.dumpFluid(this.mOutputHatches, copiedFluidStack, false);
        }
        return false;
    }

    protected void addFluidOutputs(FluidStack[] mOutputFluids2) {
        for (FluidStack outputFluidStack : mOutputFluids2) {
            this.addOutput(outputFluidStack);
        }
    }

    public boolean depleteInput(FluidStack aLiquid) {
        if (aLiquid == null) {
            return false;
        }
        for (GT_MetaTileEntity_Hatch_Input tHatch : this.mInputHatches) {
            FluidStack tLiquid;
            tHatch.mRecipeMap = this.getRecipeMap();
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(tHatch) || (tLiquid = tHatch.drain(ForgeDirection.UNKNOWN, aLiquid, false)) == null || tLiquid.amount < aLiquid.amount) continue;
            tLiquid = tHatch.drain(ForgeDirection.UNKNOWN, aLiquid, true);
            return tLiquid != null && tLiquid.amount >= aLiquid.amount;
        }
        return false;
    }

    public boolean addOutput(ItemStack aStack) {
        if (GT_Utility.isStackInvalid(aStack)) {
            return false;
        }
        aStack = GT_Utility.copyOrNull(aStack);
        for (GT_MetaTileEntity_Hatch_OutputBus tHatch : this.mOutputBusses) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(tHatch) || !tHatch.storeAll(aStack)) continue;
            return true;
        }
        boolean outputSuccess = true;
        while (outputSuccess && aStack.field_77994_a > 0) {
            outputSuccess = false;
            ItemStack single = aStack.func_77979_a(1);
            for (GT_MetaTileEntity_Hatch_Output tHatch : this.mOutputHatches) {
                if (outputSuccess || !GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(tHatch) || !tHatch.outputsItems() || !tHatch.getBaseMetaTileEntity().addStackToSlot(1, single)) continue;
                outputSuccess = true;
            }
        }
        return outputSuccess;
    }

    public boolean depleteInput(ItemStack aStack) {
        if (GT_Utility.isStackInvalid(aStack)) {
            return false;
        }
        FluidStack aLiquid = GT_Utility.getFluidForFilledItem(aStack, true);
        if (aLiquid != null) {
            return this.depleteInput(aLiquid);
        }
        for (GT_MetaTileEntity_Hatch_Input gT_MetaTileEntity_Hatch_Input : this.mInputHatches) {
            gT_MetaTileEntity_Hatch_Input.mRecipeMap = this.getRecipeMap();
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(gT_MetaTileEntity_Hatch_Input) || !GT_Utility.areStacksEqual(aStack, gT_MetaTileEntity_Hatch_Input.getBaseMetaTileEntity().func_70301_a(0)) || gT_MetaTileEntity_Hatch_Input.getBaseMetaTileEntity().func_70301_a((int)0).field_77994_a < aStack.field_77994_a) continue;
            gT_MetaTileEntity_Hatch_Input.getBaseMetaTileEntity().func_70298_a(0, aStack.field_77994_a);
            return true;
        }
        for (GT_MetaTileEntity_Hatch_InputBus gT_MetaTileEntity_Hatch_InputBus : this.mInputBusses) {
            gT_MetaTileEntity_Hatch_InputBus.mRecipeMap = this.getRecipeMap();
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(gT_MetaTileEntity_Hatch_InputBus)) continue;
            for (int i = gT_MetaTileEntity_Hatch_InputBus.getBaseMetaTileEntity().func_70302_i_() - 1; i >= 0; --i) {
                if (!GT_Utility.areStacksEqual(aStack, gT_MetaTileEntity_Hatch_InputBus.getBaseMetaTileEntity().func_70301_a(i)) || gT_MetaTileEntity_Hatch_InputBus.getBaseMetaTileEntity().func_70301_a((int)i).field_77994_a < aStack.field_77994_a) continue;
                gT_MetaTileEntity_Hatch_InputBus.getBaseMetaTileEntity().func_70298_a(i, aStack.field_77994_a);
                return true;
            }
        }
        return false;
    }

    public ArrayList<ItemStack> getStoredOutputs() {
        ArrayList<ItemStack> rList = new ArrayList<ItemStack>();
        for (GT_MetaTileEntity_Hatch_OutputBus tHatch : this.mOutputBusses) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(tHatch)) continue;
            for (int i = tHatch.getBaseMetaTileEntity().func_70302_i_() - 1; i >= 0; --i) {
                rList.add(tHatch.getBaseMetaTileEntity().func_70301_a(i));
            }
        }
        return rList;
    }

    public ArrayList<FluidStack> getStoredFluids() {
        ArrayList<FluidStack> rList = new ArrayList<FluidStack>();
        for (GT_MetaTileEntity_Hatch_Input tHatch : this.mInputHatches) {
            tHatch.mRecipeMap = this.getRecipeMap();
            if (tHatch instanceof GT_MetaTileEntity_Hatch_MultiInput) {
                if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(tHatch)) continue;
                for (FluidStack tFluid : ((GT_MetaTileEntity_Hatch_MultiInput)tHatch).getStoredFluid()) {
                    if (tFluid == null) continue;
                    rList.add(tFluid);
                }
                continue;
            }
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(tHatch) || tHatch.getFillableStack() == null) continue;
            rList.add(tHatch.getFillableStack());
        }
        return rList;
    }

    public ArrayList<ItemStack> getStoredInputs() {
        ArrayList<ItemStack> rList = new ArrayList<ItemStack>();
        for (GT_MetaTileEntity_Hatch_InputBus tHatch : this.mInputBusses) {
            tHatch.mRecipeMap = this.getRecipeMap();
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(tHatch)) continue;
            for (int i = tHatch.getBaseMetaTileEntity().func_70302_i_() - 1; i >= 0; --i) {
                if (tHatch.getBaseMetaTileEntity().func_70301_a(i) == null) continue;
                rList.add(tHatch.getBaseMetaTileEntity().func_70301_a(i));
            }
        }
        if (this.func_70301_a(1) != null && this.func_70301_a(1).func_77977_a().startsWith("gt.integrated_circuit")) {
            rList.add(this.func_70301_a(1));
        }
        return rList;
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return null;
    }

    public void updateSlots() {
        for (GT_MetaTileEntity_Hatch_Input gT_MetaTileEntity_Hatch_Input : this.mInputHatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(gT_MetaTileEntity_Hatch_Input)) continue;
            gT_MetaTileEntity_Hatch_Input.updateSlots();
        }
        for (GT_MetaTileEntity_Hatch_InputBus gT_MetaTileEntity_Hatch_InputBus : this.mInputBusses) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(gT_MetaTileEntity_Hatch_InputBus)) continue;
            gT_MetaTileEntity_Hatch_InputBus.updateSlots();
        }
    }

    protected void startRecipeProcessing() {
        for (GT_MetaTileEntity_Hatch_InputBus tHatch : this.mInputBusses) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(tHatch)) continue;
            tHatch.startRecipeProcessing();
        }
    }

    protected void endRecipeProcessing() {
        for (GT_MetaTileEntity_Hatch_InputBus tHatch : this.mInputBusses) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(tHatch)) continue;
            tHatch.endRecipeProcessing();
        }
    }

    protected static <T extends GT_MetaTileEntity_Hatch> T identifyHatch(IGregTechTileEntity aTileEntity, int aBaseCasingIndex, Class<T> clazz) {
        if (aTileEntity == null) {
            return null;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (!clazz.isInstance(aMetaTileEntity)) {
            return null;
        }
        GT_MetaTileEntity_Hatch hatch = (GT_MetaTileEntity_Hatch)clazz.cast(aMetaTileEntity);
        hatch.updateTexture(aBaseCasingIndex);
        return (T)hatch;
    }

    public boolean addToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            ((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity).mRecipeMap = this.getRecipeMap();
            return this.mInputHatches.add((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_InputBus) {
            ((GT_MetaTileEntity_Hatch_InputBus)aMetaTileEntity).mRecipeMap = this.getRecipeMap();
            return this.mInputBusses.add((GT_MetaTileEntity_Hatch_InputBus)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Output) {
            return this.mOutputHatches.add((GT_MetaTileEntity_Hatch_Output)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_OutputBus) {
            return this.mOutputBusses.add((GT_MetaTileEntity_Hatch_OutputBus)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Energy) {
            return this.mEnergyHatches.add((GT_MetaTileEntity_Hatch_Energy)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Dynamo) {
            return this.mDynamoHatches.add((GT_MetaTileEntity_Hatch_Dynamo)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Maintenance) {
            return this.mMaintenanceHatches.add((GT_MetaTileEntity_Hatch_Maintenance)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Muffler) {
            return this.mMufflerHatches.add((GT_MetaTileEntity_Hatch_Muffler)aMetaTileEntity);
        }
        return false;
    }

    public boolean addMaintenanceToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Maintenance) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mMaintenanceHatches.add((GT_MetaTileEntity_Hatch_Maintenance)aMetaTileEntity);
        }
        return false;
    }

    public boolean addEnergyInputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Energy) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mEnergyHatches.add((GT_MetaTileEntity_Hatch_Energy)aMetaTileEntity);
        }
        return false;
    }

    public boolean addExoticEnergyInputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch && GT_ExoticEnergyInputHelper.isExoticEnergyInput(aMetaTileEntity)) {
            GT_MetaTileEntity_Hatch hatch = (GT_MetaTileEntity_Hatch)aMetaTileEntity;
            hatch.updateTexture(aBaseCasingIndex);
            return this.mExoticEnergyHatches.add(hatch);
        }
        return false;
    }

    public boolean addDynamoToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Dynamo) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mDynamoHatches.add((GT_MetaTileEntity_Hatch_Dynamo)aMetaTileEntity);
        }
        return false;
    }

    public boolean addMufflerToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Muffler) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mMufflerHatches.add((GT_MetaTileEntity_Hatch_Muffler)aMetaTileEntity);
        }
        return false;
    }

    public boolean addInputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        return this.addInputBusToMachineList(aTileEntity, aBaseCasingIndex) || this.addInputHatchToMachineList(aTileEntity, aBaseCasingIndex);
    }

    public boolean addOutputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        return this.addOutputBusToMachineList(aTileEntity, aBaseCasingIndex) || this.addOutputHatchToMachineList(aTileEntity, aBaseCasingIndex);
    }

    public boolean addInputBusToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_InputBus) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            ((GT_MetaTileEntity_Hatch_InputBus)aMetaTileEntity).mRecipeMap = this.getRecipeMap();
            return this.mInputBusses.add((GT_MetaTileEntity_Hatch_InputBus)aMetaTileEntity);
        }
        return false;
    }

    public boolean addOutputBusToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_OutputBus) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mOutputBusses.add((GT_MetaTileEntity_Hatch_OutputBus)aMetaTileEntity);
        }
        return false;
    }

    public boolean addInputHatchToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            ((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity).mRecipeMap = this.getRecipeMap();
            return this.mInputHatches.add((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity);
        }
        return false;
    }

    public boolean addOutputHatchToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Output) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mOutputHatches.add((GT_MetaTileEntity_Hatch_Output)aMetaTileEntity);
        }
        return false;
    }

    @Override
    public String[] getInfoData() {
        int mPollutionReduction = 0;
        for (GT_MetaTileEntity_Hatch_Muffler tHatch : this.mMufflerHatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(tHatch)) continue;
            mPollutionReduction = Math.max(tHatch.calculatePollutionReduction(100), mPollutionReduction);
        }
        long storedEnergy = 0L;
        long maxEnergy = 0L;
        for (GT_MetaTileEntity_Hatch_Energy tHatch : this.mEnergyHatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(tHatch)) continue;
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        return new String[]{StatCollector.func_74838_a((String)"GT5U.multiblock.Progress") + ": " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers(this.mProgresstime / 20) + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(this.mMaxProgresstime / 20) + EnumChatFormatting.RESET + " s", StatCollector.func_74838_a((String)"GT5U.multiblock.energy") + ": " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers(storedEnergy) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(maxEnergy) + EnumChatFormatting.RESET + " EU", StatCollector.func_74838_a((String)"GT5U.multiblock.usage") + ": " + EnumChatFormatting.RED + GT_Utility.formatNumbers(this.getActualEnergyUsage()) + EnumChatFormatting.RESET + " EU/t", StatCollector.func_74838_a((String)"GT5U.multiblock.mei") + ": " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(this.getMaxInputVoltage()) + EnumChatFormatting.RESET + " EU/t(*2A) " + StatCollector.func_74838_a((String)"GT5U.machines.tier") + ": " + EnumChatFormatting.YELLOW + GT_Values.VN[GT_Utility.getTier(this.getMaxInputVoltage())] + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.multiblock.problems") + ": " + EnumChatFormatting.RED + (this.getIdealStatus() - this.getRepairStatus()) + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"GT5U.multiblock.efficiency") + ": " + EnumChatFormatting.YELLOW + Float.toString((float)this.mEfficiency / 100.0f) + EnumChatFormatting.RESET + " %", StatCollector.func_74838_a((String)"GT5U.multiblock.pollution") + ": " + EnumChatFormatting.GREEN + mPollutionReduction + EnumChatFormatting.RESET + " %"};
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    protected ItemStack[] getCompactedInputs() {
        ArrayList<ItemStack> tInputList = this.getStoredInputs();
        int tInputList_sS = tInputList.size();
        block0: for (int i = 0; i < tInputList_sS - 1; ++i) {
            for (int j = i + 1; j < tInputList_sS; ++j) {
                if (!GT_Utility.areStacksEqual(tInputList.get(i), tInputList.get(j))) continue;
                if (tInputList.get((int)i).field_77994_a >= tInputList.get((int)j).field_77994_a) {
                    tInputList.remove(j--);
                    tInputList_sS = tInputList.size();
                    continue;
                }
                tInputList.remove(i--);
                tInputList_sS = tInputList.size();
                continue block0;
            }
        }
        return tInputList.toArray(new ItemStack[0]);
    }

    protected FluidStack[] getCompactedFluids() {
        ArrayList<FluidStack> tFluidList = this.getStoredFluids();
        int tFluidList_sS = tFluidList.size();
        block0: for (int i = 0; i < tFluidList_sS - 1; ++i) {
            for (int j = i + 1; j < tFluidList_sS; ++j) {
                if (!GT_Utility.areFluidsEqual(tFluidList.get(i), tFluidList.get(j))) continue;
                if (tFluidList.get((int)i).amount >= tFluidList.get((int)j).amount) {
                    tFluidList.remove(j--);
                    tFluidList_sS = tFluidList.size();
                    continue;
                }
                tFluidList.remove(i--);
                tFluidList_sS = tFluidList.size();
                continue block0;
            }
        }
        return tFluidList.toArray(new FluidStack[0]);
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        NBTTagCompound tag = accessor.getNBTData();
        if (tag.func_74767_n("incompleteStructure")) {
            currentTip.add(SpecialChars.RED + "** INCOMPLETE STRUCTURE **" + SpecialChars.RESET);
        }
        currentTip.add((tag.func_74767_n("hasProblems") ? SpecialChars.RED + "** HAS PROBLEMS **" : SpecialChars.GREEN + "Running Fine") + SpecialChars.RESET + "  Efficiency: " + tag.func_74760_g("efficiency") + "%");
        boolean isActive = tag.func_74767_n("isActive");
        if (isActive) {
            long actualEnergyUsage = tag.func_74763_f("energyUsage");
            if (actualEnergyUsage > 0L) {
                currentTip.add(StatCollector.func_74837_a((String)"GT5U.waila.energy.use", (Object[])new Object[]{GT_Utility.formatNumbers(actualEnergyUsage), GT_Utility.getColoredTierNameFromVoltage(actualEnergyUsage)}));
            } else if (actualEnergyUsage < 0L) {
                currentTip.add(StatCollector.func_74837_a((String)"GT5U.waila.energy.produce", (Object[])new Object[]{GT_Utility.formatNumbers(-actualEnergyUsage), GT_Utility.getColoredTierNameFromVoltage(-actualEnergyUsage)}));
            }
        }
        currentTip.add(GT_Waila.getMachineProgressString(isActive, tag.func_74762_e("maxProgress"), tag.func_74762_e("progress")));
        super.getWailaBody(itemStack, currentTip, accessor, config);
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74757_a("hasProblems", this.getIdealStatus() - this.getRepairStatus() > 0);
        tag.func_74776_a("efficiency", (float)this.mEfficiency / 100.0f);
        tag.func_74768_a("progress", this.mProgresstime);
        tag.func_74768_a("maxProgress", this.mMaxProgresstime);
        tag.func_74757_a("incompleteStructure", (this.getBaseMetaTileEntity().getErrorDisplayID() & 0x40) != 0);
        IGregTechTileEntity tileEntity = this.getBaseMetaTileEntity();
        if (tileEntity != null) {
            tag.func_74757_a("isActive", tileEntity.isActive());
            if (tileEntity.isActive()) {
                if (this.mEUt < 0) {
                    tag.func_74772_a("energyUsage", this.getActualEnergyUsage());
                } else {
                    tag.func_74772_a("energyUsage", (long)(-this.mEUt) * (long)this.mEfficiency / 10000L);
                }
            }
        }
    }

    protected void setMufflers(boolean state) {
        for (GT_MetaTileEntity_Hatch_Muffler aMuffler : this.mMufflerHatches) {
            IGregTechTileEntity iGTTileEntity = aMuffler.getBaseMetaTileEntity();
            if (iGTTileEntity == null || iGTTileEntity.isDead()) continue;
            iGTTileEntity.setActive(state);
        }
    }

    @Override
    public void onRemoval() {
        super.onRemoval();
        this.setMufflers(false);
    }

    public List<GT_MetaTileEntity_Hatch> getExoticEnergyHatches() {
        return this.mExoticEnergyHatches;
    }

    public boolean checkExoticAndNormalEnergyHatches() {
        if (this.mExoticEnergyHatches.isEmpty() && this.mEnergyHatches.isEmpty()) {
            return false;
        }
        if (this.mExoticEnergyHatches.size() >= 1) {
            if (!this.mEnergyHatches.isEmpty()) {
                return false;
            }
            if (this.mExoticEnergyHatches.size() != 1) {
                return false;
            }
        }
        return this.mEnergyHatches.size() <= 2;
    }

    @Override
    public boolean useModularUI() {
        return true;
    }

    @Override
    public int getGUIWidth() {
        return 198;
    }

    @Override
    public int getGUIHeight() {
        return 192;
    }

    protected boolean isInputSeparationButtonEnabled() {
        return false;
    }

    protected boolean isBatchModeButtonEnabled() {
        return false;
    }

    protected boolean isVoidExcessButtonEnabled() {
        return false;
    }

    protected boolean isInputSeparationEnabled() {
        return this.inputSeparation;
    }

    protected boolean isBatchModeEnabled() {
        return this.batchMode;
    }

    protected boolean isVoidExcessEnabled() {
        return this.voidExcess;
    }

    protected boolean isRecipeLockingEnabled() {
        return this.mLockedToSingleRecipe;
    }

    @Override
    public void bindPlayerInventoryUI(ModularWindow.Builder builder, UIBuildContext buildContext) {
        builder.bindPlayerInventory(buildContext.getPlayer(), new Pos2d(7, 109), (IDrawable)this.getGUITextureSet().getItemSlot());
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        builder.widget(new DrawableWidget().setDrawable((IDrawable)GT_UITextures.PICTURE_SCREEN_BLACK).setPos(4, 4).setSize(190, 85));
        SlotWidget inventorySlot = new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 1);
        builder.widget(inventorySlot.setPos(173, 167).setBackground(new IDrawable[]{GT_UITextures.SLOT_DARK_GRAY}));
        DynamicPositionedColumn screenElements = new DynamicPositionedColumn();
        this.drawTexts(screenElements, inventorySlot);
        builder.widget((Widget)screenElements);
        ((ModularWindow.Builder)builder.widget((Widget)this.createPowerSwitchButton())).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.getBaseMetaTileEntity().isAllowedToWork(), val -> {
            if (val.booleanValue()) {
                this.getBaseMetaTileEntity().enableWorking();
            } else {
                this.getBaseMetaTileEntity().disableWorking();
            }
        }));
        ((ModularWindow.Builder)builder.widget((Widget)this.createVoidExcessButton())).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.voidExcess, val -> {
            this.voidExcess = val;
        }));
        ((ModularWindow.Builder)builder.widget((Widget)this.createInputSeparationButton())).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.inputSeparation, val -> {
            this.inputSeparation = val;
        }));
        ((ModularWindow.Builder)builder.widget((Widget)this.createBatchModeButton())).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.batchMode, val -> {
            this.batchMode = val;
        }));
        ((ModularWindow.Builder)builder.widget((Widget)this.createLockToSingleRecipeButton())).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mLockedToSingleRecipe, val -> {
            this.mLockedToSingleRecipe = val;
        }));
    }

    @Override
    public void addGregTechLogo(ModularWindow.Builder builder) {
    }

    protected void drawTexts(DynamicPositionedColumn screenElements, SlotWidget inventorySlot) {
        screenElements.setSynced(false).setSpace(0).setPos(10, 7);
        ((Column)screenElements.widget(new TextWidget(GT_Utility.trans("132", "Pipe is loose.")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> !this.mWrench))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mWrench, val -> {
            this.mWrench = val;
        }));
        ((Column)screenElements.widget(new TextWidget(GT_Utility.trans("133", "Screws are loose.")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> !this.mScrewdriver))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mScrewdriver, val -> {
            this.mScrewdriver = val;
        }));
        ((Column)screenElements.widget(new TextWidget(GT_Utility.trans("134", "Something is stuck.")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> !this.mSoftHammer))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mSoftHammer, val -> {
            this.mSoftHammer = val;
        }));
        ((Column)screenElements.widget(new TextWidget(GT_Utility.trans("135", "Platings are dented.")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> !this.mHardHammer))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mHardHammer, val -> {
            this.mHardHammer = val;
        }));
        ((Column)screenElements.widget(new TextWidget(GT_Utility.trans("136", "Circuitry burned out.")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> !this.mSolderingTool))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mSolderingTool, val -> {
            this.mSolderingTool = val;
        }));
        ((Column)screenElements.widget(new TextWidget(GT_Utility.trans("137", "That doesn't belong there.")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> !this.mCrowbar))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mCrowbar, val -> {
            this.mCrowbar = val;
        }));
        ((Column)screenElements.widget(new TextWidget(GT_Utility.trans("138", "Incomplete Structure.")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> !this.mMachine))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mMachine, val -> {
            this.mMachine = val;
        }));
        screenElements.widget(new TextWidget("Too Uncertain.").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> (this.getBaseMetaTileEntity().getErrorDisplayID() & 0x80) != 0));
        screenElements.widget(new TextWidget("Invalid Parameters.").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> (this.getBaseMetaTileEntity().getErrorDisplayID() & 0x100) != 0));
        ((Column)((Column)screenElements.widget(new TextWidget(GT_Utility.trans("139", "Hit with Soft Mallet")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.getBaseMetaTileEntity().getErrorDisplayID() == 0 && !this.getBaseMetaTileEntity().isActive()))).widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.getBaseMetaTileEntity().getErrorDisplayID(), val -> this.getBaseMetaTileEntity().setErrorDisplayID((int)val)))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.getBaseMetaTileEntity().isActive(), val -> this.getBaseMetaTileEntity().setActive((boolean)val)));
        screenElements.widget(new TextWidget(GT_Utility.trans("140", "to (re-)start the Machine")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.getBaseMetaTileEntity().getErrorDisplayID() == 0 && !this.getBaseMetaTileEntity().isActive()));
        screenElements.widget(new TextWidget(GT_Utility.trans("141", "if it doesn't start.")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.getBaseMetaTileEntity().getErrorDisplayID() == 0 && !this.getBaseMetaTileEntity().isActive()));
        screenElements.widget(new TextWidget(GT_Utility.trans("142", "Running perfectly.")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.getBaseMetaTileEntity().getErrorDisplayID() == 0 && this.getBaseMetaTileEntity().isActive()));
        screenElements.widget(new TextWidget(GT_Utility.trans("143", "Missing Mining Pipe")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> {
            if (this.getBaseMetaTileEntity().getErrorDisplayID() == 0 && this instanceof GT_MetaTileEntity_DrillerBase) {
                ItemStack tItem = inventorySlot.getMcSlot().func_75211_c();
                return tItem == null || !GT_Utility.areStacksEqual(tItem, GT_ModHandler.getIC2Item("miningPipe", 1L));
            }
            return false;
        }));
        screenElements.widget(new TextWidget(GT_Utility.trans("144", "Missing Turbine Rotor")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> {
            if (this.getBaseMetaTileEntity().getErrorDisplayID() == 0 && this instanceof GT_MetaTileEntity_LargeTurbine) {
                ItemStack tItem = inventorySlot.getMcSlot().func_75211_c();
                return tItem == null || tItem.func_77973_b() != GT_MetaGenerated_Tool_01.INSTANCE || tItem.func_77960_j() < 170 || tItem.func_77960_j() > 177;
            }
            return false;
        }));
    }

    protected ButtonWidget createPowerSwitchButton() {
        Widget button = new ButtonWidget().setOnClick((clickData, widget) -> {
            if (this.getBaseMetaTileEntity().isAllowedToWork()) {
                this.getBaseMetaTileEntity().disableWorking();
            } else {
                this.getBaseMetaTileEntity().enableWorking();
            }
        }).setPlayClickSound(true).setBackground(() -> {
            ArrayList<UITexture> ret = new ArrayList<UITexture>();
            ret.add(GT_UITextures.BUTTON_STANDARD);
            if (this.getBaseMetaTileEntity().isAllowedToWork()) {
                ret.add(GT_UITextures.OVERLAY_BUTTON_POWER_SWITCH_ON);
            } else {
                ret.add(GT_UITextures.OVERLAY_BUTTON_POWER_SWITCH_OFF);
            }
            return ret.toArray(new IDrawable[0]);
        }).setPos(174, 148).setSize(16, 16);
        button.addTooltip(StatCollector.func_74838_a((String)"GT5U.gui.button.power_switch")).setTooltipShowUpDelay(5);
        return (ButtonWidget)button;
    }

    protected ButtonWidget createVoidExcessButton() {
        Widget button = new ButtonWidget().setOnClick((clickData, widget) -> {
            if (this.isVoidExcessButtonEnabled()) {
                this.voidExcess = !this.voidExcess;
            }
        }).setPlayClickSound(true).setBackground(() -> {
            ArrayList<UITexture> ret = new ArrayList<UITexture>();
            ret.add(GT_UITextures.BUTTON_STANDARD);
            if (this.isVoidExcessButtonEnabled()) {
                if (this.isVoidExcessEnabled()) {
                    ret.add(GT_UITextures.OVERLAY_BUTTON_VOID_EXCESS_ON);
                } else {
                    ret.add(GT_UITextures.OVERLAY_BUTTON_VOID_EXCESS_OFF);
                }
            } else if (this.isVoidExcessEnabled()) {
                ret.add(GT_UITextures.OVERLAY_BUTTON_VOID_EXCESS_ON_DISABLED);
            } else {
                ret.add(GT_UITextures.OVERLAY_BUTTON_VOID_EXCESS_OFF_DISABLED);
            }
            return ret.toArray(new IDrawable[0]);
        }).setPos(8, 91).setSize(16, 16);
        button.addTooltip(StatCollector.func_74838_a((String)"GT5U.gui.button.void_excess")).setTooltipShowUpDelay(5);
        return (ButtonWidget)button;
    }

    protected ButtonWidget createInputSeparationButton() {
        Widget button = new ButtonWidget().setOnClick((clickData, widget) -> {
            if (this.isInputSeparationButtonEnabled()) {
                this.inputSeparation = !this.inputSeparation;
            }
        }).setPlayClickSound(true).setBackground(() -> {
            ArrayList<UITexture> ret = new ArrayList<UITexture>();
            ret.add(GT_UITextures.BUTTON_STANDARD);
            if (this.isInputSeparationButtonEnabled()) {
                if (this.isInputSeparationEnabled()) {
                    ret.add(GT_UITextures.OVERLAY_BUTTON_INPUT_SEPARATION_ON);
                } else {
                    ret.add(GT_UITextures.OVERLAY_BUTTON_INPUT_SEPARATION_OFF);
                }
            } else if (this.isInputSeparationEnabled()) {
                ret.add(GT_UITextures.OVERLAY_BUTTON_INPUT_SEPARATION_ON_DISABLED);
            } else {
                ret.add(GT_UITextures.OVERLAY_BUTTON_INPUT_SEPARATION_OFF_DISABLED);
            }
            return ret.toArray(new IDrawable[0]);
        }).setPos(26, 91).setSize(16, 16);
        button.addTooltip(StatCollector.func_74838_a((String)"GT5U.gui.button.input_separation")).setTooltipShowUpDelay(5);
        return (ButtonWidget)button;
    }

    protected ButtonWidget createBatchModeButton() {
        Widget button = new ButtonWidget().setOnClick((clickData, widget) -> {
            if (this.isBatchModeButtonEnabled()) {
                this.batchMode = !this.batchMode;
            }
        }).setPlayClickSound(true).setBackground(() -> {
            ArrayList<UITexture> ret = new ArrayList<UITexture>();
            ret.add(GT_UITextures.BUTTON_STANDARD);
            if (this.isBatchModeButtonEnabled()) {
                if (this.isBatchModeEnabled()) {
                    ret.add(GT_UITextures.OVERLAY_BUTTON_BATCH_MODE_ON);
                } else {
                    ret.add(GT_UITextures.OVERLAY_BUTTON_BATCH_MODE_OFF);
                }
            } else if (this.isBatchModeEnabled()) {
                ret.add(GT_UITextures.OVERLAY_BUTTON_BATCH_MODE_ON_DISABLED);
            } else {
                ret.add(GT_UITextures.OVERLAY_BUTTON_BATCH_MODE_OFF_DISABLED);
            }
            return ret.toArray(new IDrawable[0]);
        }).setPos(44, 91).setSize(16, 16);
        button.addTooltip(StatCollector.func_74838_a((String)"GT5U.gui.button.batch_mode")).setTooltipShowUpDelay(5);
        return (ButtonWidget)button;
    }

    protected ButtonWidget createLockToSingleRecipeButton() {
        Widget button = new ButtonWidget().setOnClick((clickData, widget) -> {
            if (this.supportsSingleRecipeLocking()) {
                this.mLockedToSingleRecipe = !this.mLockedToSingleRecipe;
            }
        }).setPlayClickSound(true).setBackground(() -> {
            ArrayList<UITexture> ret = new ArrayList<UITexture>();
            ret.add(GT_UITextures.BUTTON_STANDARD);
            if (this.supportsSingleRecipeLocking()) {
                if (this.isRecipeLockingEnabled()) {
                    ret.add(GT_UITextures.OVERLAY_BUTTON_RECIPE_LOCKED);
                } else {
                    ret.add(GT_UITextures.OVERLAY_BUTTON_RECIPE_UNLOCKED);
                }
            } else if (this.isRecipeLockingEnabled()) {
                ret.add(GT_UITextures.OVERLAY_BUTTON_RECIPE_LOCKED_DISABLED);
            } else {
                ret.add(GT_UITextures.OVERLAY_BUTTON_RECIPE_UNLOCKED_DISABLED);
            }
            return ret.toArray(new IDrawable[0]);
        }).setPos(62, 91).setSize(16, 16);
        button.addTooltip(StatCollector.func_74838_a((String)"GT5U.gui.button.lock_recipe")).setTooltipShowUpDelay(5);
        return (ButtonWidget)button;
    }

    static {
        INPUT_SEPARATION_NBT_KEY = "inputSeparation";
        VOID_EXCESS_NBT_KEY = "voidExcess";
        BATCH_MODE_NBT_KEY = "batchMode";
    }
}

