/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.multitileentity.multiblock.casing;

import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.widget.textfield.TextFieldWidget;
import gregtech.api.multitileentity.interfaces.IMultiBlockController;
import gregtech.api.multitileentity.multiblock.casing.AdvancedCasing;
import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;

public class InventoryUpgrade
extends AdvancedCasing {
    public UUID mInventoryID;
    public static final int INPUT = 0;
    public static final int OUTPUT = 1;
    public static final int BOTH = 2;
    private String mInventoryName = "inventory";
    private int mInventorySize;
    private int mType = 2;

    @Override
    public String func_145825_b() {
        return this.mInventoryName;
    }

    public void setInventoryName(String aInventoryName) {
        this.mInventoryName = aInventoryName;
    }

    @Override
    protected void customWork(IMultiBlockController aTarget) {
        int tInvSize = this.mInventorySize;
        if (this.mType == 2) {
            tInvSize /= 2;
        }
        aTarget.registerInventory(this.mInventoryName, this.mInventoryID.toString(), tInvSize, this.mType);
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.multiblock.inventory";
    }

    @Override
    public void readMultiTileNBT(NBTTagCompound aNBT) {
        super.readMultiTileNBT(aNBT);
        this.mInventoryID = aNBT.func_74764_b("gt.invuuid.upg") ? UUID.fromString(aNBT.func_74779_i("gt.invuuid.upg")) : UUID.randomUUID();
        this.mInventorySize = aNBT.func_74762_e("gt.invsize.upg");
        this.mInventoryName = aNBT.func_74779_i("gt.invname.upg");
    }

    @Override
    public void writeMultiTileNBT(NBTTagCompound aNBT) {
        super.writeMultiTileNBT(aNBT);
        aNBT.func_74778_a("gt.invuuid.upg", this.mInventoryID.toString());
        aNBT.func_74778_a("gt.invname.upg", this.mInventoryName);
    }

    @Override
    protected void onBaseTEDestroyed() {
        super.onBaseTEDestroyed();
        this.unregisterInventories();
    }

    private void unregisterInventories() {
        IMultiBlockController controller = this.getTarget(false);
        if (controller != null) {
            controller.unregisterInventory(this.mInventoryName, this.mInventoryID.toString(), this.mType);
        }
    }

    @Override
    public boolean hasGui(byte aSide) {
        return true;
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        builder.widget(new TextFieldWidget().setGetter(() -> this.mInventoryName).setSetter(val -> {
            this.mInventoryName = val;
            IMultiBlockController controller = this.getTarget(false);
            if (controller != null) {
                controller.changeInventoryName(this.mInventoryName, this.mInventoryID.toString(), this.mType);
            }
        }).setSize(100, 25).setPos(50, 30));
    }
}

