/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.util.GT_Utility;

public class GT_OverclockCalculator {
    private long mAmps = 1L;
    private long mEUt = 0L;
    private long mRecipeEUt = 0L;
    private long mRecipeAmps = 1L;
    private float mEUtDiscount = 1.0f;
    private float mSpeedBoost = 1.0f;
    private float mHeatDiscountAmount = 0.95f;
    private int mEUtIncreasePerOC = 2;
    private int mDurationDecreasePerOC = 1;
    private int mDuration = 0;
    private int mParallel = 1;
    private int mRecipeHeat = 0;
    private int mMultiHeat = 0;
    private int mHeatPerfectOC = 2;
    private boolean mHeatOC;
    private boolean mOneTickDiscount;
    private boolean calculated;
    private boolean mHeatDiscount;
    private static final int HEAT_DISCOUNT_THRESHOLD = 900;
    private static final int HEAT_PERFECT_OVERCLOCK_THRESHOLD = 1800;

    public GT_OverclockCalculator setRecipeEUt(long aRecipeEUt) {
        this.mRecipeEUt = aRecipeEUt;
        return this;
    }

    public GT_OverclockCalculator setEUt(long aEUt) {
        this.mEUt = aEUt;
        return this;
    }

    public GT_OverclockCalculator setDuration(int aDuration) {
        this.mDuration = aDuration;
        return this;
    }

    public GT_OverclockCalculator setAmperage(long aAmps) {
        this.mAmps = aAmps;
        return this;
    }

    public GT_OverclockCalculator setRecipeAmperage(long aRecipeAmps) {
        this.mRecipeAmps = aRecipeAmps;
        return this;
    }

    public GT_OverclockCalculator enablePerfectOC() {
        this.mDurationDecreasePerOC = 2;
        return this;
    }

    public GT_OverclockCalculator enableHeatOC() {
        this.mHeatOC = true;
        return this;
    }

    public GT_OverclockCalculator enableHeatDiscount() {
        this.mHeatDiscount = true;
        return this;
    }

    public GT_OverclockCalculator setRecipeHeat(int aRecipeHeat) {
        this.mRecipeHeat = aRecipeHeat;
        return this;
    }

    public GT_OverclockCalculator setMultiHeat(int aMultiHeat) {
        this.mMultiHeat = aMultiHeat;
        return this;
    }

    public GT_OverclockCalculator setEUtDiscount(float aEUtDiscount) {
        this.mEUtDiscount = aEUtDiscount;
        return this;
    }

    public GT_OverclockCalculator setSpeedBoost(float aSpeedBoost) {
        this.mSpeedBoost = aSpeedBoost;
        return this;
    }

    public GT_OverclockCalculator setParallel(int aParallel) {
        this.mParallel = aParallel;
        return this;
    }

    public GT_OverclockCalculator setHeatDiscount(float aHeatDiscount) {
        this.mHeatDiscountAmount = aHeatDiscount;
        return this;
    }

    public GT_OverclockCalculator setHeatPerfectOC(int aHeatPerfectOC) {
        this.mHeatPerfectOC = aHeatPerfectOC;
        return this;
    }

    public GT_OverclockCalculator setEUtIncreasePerOC(int aEUtIncreasePerOC) {
        this.mEUtIncreasePerOC = aEUtIncreasePerOC;
        return this;
    }

    public GT_OverclockCalculator setDurationDecreasePerOC(int aDurationDecreasePerOC) {
        this.mDurationDecreasePerOC = aDurationDecreasePerOC;
        return this;
    }

    public GT_OverclockCalculator enableOneTickDiscount() {
        this.mOneTickDiscount = true;
        return this;
    }

    public GT_OverclockCalculator calculate() {
        this.calculateOverclock();
        this.calculated = true;
        return this;
    }

    private void calculateOverclock() {
        byte tRecipeTier;
        if (this.mRecipeEUt > this.mEUt || this.mRecipeHeat > this.mMultiHeat) {
            this.mRecipeEUt = Long.MAX_VALUE;
            this.mDuration = Integer.MAX_VALUE;
            return;
        }
        int heatDiscounts = (this.mMultiHeat - this.mRecipeHeat) / 900;
        this.mDuration = (int)Math.ceil((float)this.mDuration * this.mSpeedBoost);
        if (this.mHeatOC) {
            while (this.mRecipeHeat + 1800 <= this.mMultiHeat && this.mRecipeEUt * (long)this.mParallel * this.mRecipeAmps << 2 < this.mEUt * this.mAmps && this.mDuration >= 1) {
                this.mRecipeEUt <<= this.mEUtIncreasePerOC;
                this.mDuration >>= this.mHeatPerfectOC;
                this.mRecipeHeat += 1800;
            }
        }
        if ((tRecipeTier = GT_Utility.getTier(this.mRecipeEUt)) == 0) {
            byte tTier = GT_Utility.getTier(this.mEUt);
            int tTierDifference = tTier - 1;
            for (long tNextConsumption = (long)Math.ceil((float)(this.mRecipeEUt * (long)this.mParallel * this.mRecipeAmps) * this.mEUtDiscount) << this.mEUtIncreasePerOC; tTierDifference > 0 && tNextConsumption < this.mEUt * this.mAmps; tNextConsumption <<= this.mEUtIncreasePerOC, --tTierDifference) {
                this.mRecipeEUt <<= this.mEUtIncreasePerOC;
                this.mDuration >>= this.mDurationDecreasePerOC;
            }
        } else {
            for (long tNextConsumption = (long)Math.ceil((float)(this.mRecipeEUt * (long)this.mParallel * this.mRecipeAmps) * this.mEUtDiscount) << this.mEUtIncreasePerOC; tNextConsumption < this.mEUt * this.mAmps && this.mDuration > 1; tNextConsumption <<= this.mEUtIncreasePerOC) {
                this.mRecipeEUt <<= this.mEUtIncreasePerOC;
                this.mDuration >>= this.mDurationDecreasePerOC;
            }
        }
        if (this.mDuration < 1) {
            this.mDuration = 1;
        }
        if (this.mHeatDiscount) {
            this.mRecipeEUt = (long)Math.ceil((double)this.mRecipeEUt * Math.pow(this.mHeatDiscountAmount, heatDiscounts));
        }
        if (this.mOneTickDiscount) {
            int voltageDifference = GT_Utility.getTier(this.mEUt) - GT_Utility.getTier(this.mRecipeEUt);
            this.mRecipeEUt >>= voltageDifference * this.mDurationDecreasePerOC;
            if (this.mRecipeEUt < 1L) {
                this.mRecipeEUt = 1L;
            }
        }
        this.mRecipeEUt = (long)Math.ceil((float)(this.mRecipeEUt * (long)this.mParallel * this.mRecipeAmps) * this.mEUtDiscount);
    }

    public long getConsumption() {
        if (!this.calculated) {
            this.calculate();
        }
        return this.mRecipeEUt;
    }

    public int getDuration() {
        if (!this.calculated) {
            this.calculate();
        }
        return this.mDuration;
    }
}

