/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.redstone;

import com.google.common.io.ByteArrayDataInput;
import com.gtnewhorizons.modularui.api.math.MathExpression;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.gui.modularui.GT_CoverUIBuildContext;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.ISerializableObject;
import gregtech.common.covers.GT_Cover_LiquidMeter;
import gregtech.common.covers.redstone.GT_Cover_AdvancedRedstoneTransmitterBase;
import gregtech.common.gui.modularui.widget.CoverDataControllerWidget;
import gregtech.common.gui.modularui.widget.CoverDataFollower_TextFieldWidget;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class GT_Cover_WirelessFluidDetector
extends GT_Cover_AdvancedRedstoneTransmitterBase<FluidTransmitterData> {
    public GT_Cover_WirelessFluidDetector(ITexture coverTexture) {
        super(FluidTransmitterData.class, coverTexture);
    }

    @Override
    public FluidTransmitterData createDataObject() {
        return new FluidTransmitterData();
    }

    @Override
    public FluidTransmitterData createDataObject(int aLegacyData) {
        return this.createDataObject();
    }

    @Override
    public FluidTransmitterData doCoverThingsImpl(byte aSide, byte aInputRedstone, int aCoverID, FluidTransmitterData aCoverVariable, ICoverable aTileEntity, long aTimer) {
        byte signal = GT_Cover_LiquidMeter.computeSignalBasedOnFluid(aTileEntity, aCoverVariable.invert, aCoverVariable.threshold);
        long hash = GT_Cover_WirelessFluidDetector.hashCoverCoords(aTileEntity, aSide);
        GT_Cover_WirelessFluidDetector.setSignalAt(aCoverVariable.getUuid(), aCoverVariable.getFrequency(), hash, signal);
        return aCoverVariable;
    }

    @Override
    public boolean letsRedstoneGoOutImpl(byte aSide, int aCoverID, FluidTransmitterData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean manipulatesSidedRedstoneOutputImpl(byte aSide, int aCoverID, FluidTransmitterData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public ModularWindow createWindow(GT_CoverUIBuildContext buildContext) {
        return new WirelessFluidDetectorUIFactory(buildContext).createWindow();
    }

    private class WirelessFluidDetectorUIFactory
    extends GT_Cover_AdvancedRedstoneTransmitterBase.AdvancedRedstoneTransmitterBaseUIFactory {
        public WirelessFluidDetectorUIFactory(GT_CoverUIBuildContext buildContext) {
            super(GT_Cover_WirelessFluidDetector.this, buildContext);
        }

        @Override
        protected int getFrequencyRow() {
            return 1;
        }

        @Override
        protected int getButtonRow() {
            return 2;
        }

        @Override
        protected void addUIWidgets(ModularWindow.Builder builder) {
            super.addUIWidgets(builder);
            builder.widget(new TextWidget(GT_Utility.trans("222", "Fluid threshold")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(100, 29));
        }

        protected void addUIForDataController(CoverDataControllerWidget<FluidTransmitterData> controller) {
            super.addUIForDataController(controller);
            controller.addFollower((Widget)new CoverDataFollower_TextFieldWidget(), coverData -> String.valueOf(((FluidTransmitterData)coverData).threshold), (coverData, state) -> {
                ((FluidTransmitterData)coverData).threshold = (int)MathExpression.parseMathExpression((String)state);
                return coverData;
            }, widget -> widget.setOnScrollNumbers().setNumbers(0, Integer.MAX_VALUE).setPos(1, 2).setSize(86, 12));
        }
    }

    public static class FluidTransmitterData
    extends GT_Cover_AdvancedRedstoneTransmitterBase.TransmitterData {
        private int threshold;

        public FluidTransmitterData(int frequency, UUID uuid, boolean invert, int threshold) {
            super(frequency, uuid, invert);
            this.threshold = threshold;
        }

        public FluidTransmitterData() {
            this.threshold = 0;
        }

        @Override
        @Nonnull
        public ISerializableObject copy() {
            return new FluidTransmitterData(this.frequency, this.uuid, this.invert, this.threshold);
        }

        @Override
        @Nonnull
        public NBTBase saveDataToNBT() {
            NBTTagCompound tag = (NBTTagCompound)super.saveDataToNBT();
            tag.func_74768_a("threshold", this.threshold);
            return tag;
        }

        @Override
        public void writeToByteBuf(ByteBuf aBuf) {
            super.writeToByteBuf(aBuf);
            aBuf.writeInt(this.threshold);
        }

        @Override
        public void loadDataFromNBT(NBTBase aNBT) {
            super.loadDataFromNBT(aNBT);
            NBTTagCompound tag = (NBTTagCompound)aNBT;
            this.threshold = tag.func_74762_e("threshold");
        }

        @Override
        @Nonnull
        public ISerializableObject readFromPacket(ByteArrayDataInput aBuf, EntityPlayerMP aPlayer) {
            super.readFromPacket(aBuf, aPlayer);
            this.threshold = aBuf.readInt();
            return this;
        }
    }
}

