/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.automation;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.internal.wrapper.BaseSlot;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.SlotGroup;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.modularui.IAddUIWidgets;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Buffer;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Utility;
import java.util.Collections;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class GT_MetaTileEntity_Regulator
extends GT_MetaTileEntity_Buffer
implements IAddUIWidgets {
    public int[] mTargetSlots = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
    private boolean charge = false;
    private boolean decharge = false;

    public GT_MetaTileEntity_Regulator(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 20, new String[]{"Filters up to 9 different Items", "Allows Item-specific output stack size", "Allows Item-specific output slot", "Does not consume energy to move Item"});
    }

    public GT_MetaTileEntity_Regulator(String aName, int aTier, int aInvSlotCount, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aInvSlotCount, aDescription, aTextures);
    }

    public GT_MetaTileEntity_Regulator(String aName, int aTier, int aInvSlotCount, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aInvSlotCount, aDescription, aTextures);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Regulator(this.mName, (int)this.mTier, this.mInventory.length, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public ITexture getOverlayIcon() {
        return TextureFactory.of(TextureFactory.of(Textures.BlockIcons.AUTOMATION_REGULATOR), TextureFactory.builder().addIcon(Textures.BlockIcons.AUTOMATION_REGULATOR_GLOW).glow().build());
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return aIndex < 9 || aIndex == this.rechargerSlotStartIndex();
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("mTargetSlot1", this.mTargetSlots[0]);
        aNBT.func_74768_a("mTargetSlot2", this.mTargetSlots[1]);
        aNBT.func_74768_a("mTargetSlot3", this.mTargetSlots[2]);
        aNBT.func_74768_a("mTargetSlot4", this.mTargetSlots[3]);
        aNBT.func_74768_a("mTargetSlot5", this.mTargetSlots[4]);
        aNBT.func_74768_a("mTargetSlot6", this.mTargetSlots[5]);
        aNBT.func_74768_a("mTargetSlot7", this.mTargetSlots[6]);
        aNBT.func_74768_a("mTargetSlot8", this.mTargetSlots[7]);
        aNBT.func_74768_a("mTargetSlot9", this.mTargetSlots[8]);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mTargetSlots[0] = aNBT.func_74762_e("mTargetSlot1");
        this.mTargetSlots[1] = aNBT.func_74762_e("mTargetSlot2");
        this.mTargetSlots[2] = aNBT.func_74762_e("mTargetSlot3");
        this.mTargetSlots[3] = aNBT.func_74762_e("mTargetSlot4");
        this.mTargetSlots[4] = aNBT.func_74762_e("mTargetSlot5");
        this.mTargetSlots[5] = aNBT.func_74762_e("mTargetSlot6");
        this.mTargetSlots[6] = aNBT.func_74762_e("mTargetSlot7");
        this.mTargetSlots[7] = aNBT.func_74762_e("mTargetSlot8");
        this.mTargetSlots[8] = aNBT.func_74762_e("mTargetSlot9");
    }

    @Override
    public void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
    }

    @Override
    public void moveItems(IGregTechTileEntity aBaseMetaTileEntity, long aTimer) {
        for (int i = 0; i < 9; ++i) {
            int tCosts;
            if (this.mInventory[i + 9] == null || (tCosts = GT_Utility.moveOneItemStackIntoSlot(this.getBaseMetaTileEntity(), this.getBaseMetaTileEntity().getTileEntityAtSide(this.getBaseMetaTileEntity().getBackFacing()), this.getBaseMetaTileEntity().getBackFacing(), this.mTargetSlots[i], Collections.singletonList(this.mInventory[i + 9]), false, (byte)this.mInventory[i + 9].field_77994_a, (byte)this.mInventory[i + 9].field_77994_a, (byte)64, (byte)1) * 3) <= 0) continue;
            this.mSuccess = 50;
            break;
        }
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return super.allowPutStack(aBaseMetaTileEntity, aIndex, aSide, aStack) && aIndex >= 0 && aIndex <= 8 && GT_Utility.areStacksEqual(aStack, this.mInventory[aIndex + 9]);
    }

    @Override
    public int rechargerSlotStartIndex() {
        return 19;
    }

    @Override
    public int dechargerSlotStartIndex() {
        return 19;
    }

    @Override
    public int rechargerSlotCount() {
        return this.charge ? 1 : 0;
    }

    @Override
    public int dechargerSlotCount() {
        return this.decharge ? 1 : 0;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide()) {
            this.charge = aBaseMetaTileEntity.getStoredEU() / 2L > aBaseMetaTileEntity.getEUCapacity() / 3L;
            this.decharge = aBaseMetaTileEntity.getStoredEU() < aBaseMetaTileEntity.getEUCapacity() / 3L;
        }
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        this.addEmitEnergyButton(builder);
        builder.widget((Widget)this.createChargerSlot(43, 62));
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new DrawableWidget().setDrawable((IDrawable)GT_UITextures.PICTURE_ARROW_22_RED.apply(84, true)).setPos(65, 60).setSize(84, 22))).widget(SlotGroup.ofItemHandler((IItemHandlerModifiable)this.inventoryHandler, (int)3).startFromSlot(0).endAtSlot(8).build().setPos(7, 5))).widget(new DrawableWidget().setDrawable((IDrawable)GT_UITextures.PICTURE_SLOTS_HOLO_3BY3).setPos(62, 5).setSize(54, 54))).widget(SlotGroup.ofItemHandler((IItemHandlerModifiable)this.inventoryHandler, (int)3).phantom(true).startFromSlot(9).endAtSlot(17).applyForWidget(widget -> widget.setControlsAmount(true).setBackground(new IDrawable[]{GT_UITextures.TRANSPARENT})).build().setPos(62, 5))).widget(new DrawableWidget().setDrawable((IDrawable)GT_UITextures.PICTURE_SLOTS_HOLO_3BY3).setPos(117, 5).setSize(54, 54));
        int xBase = 117;
        int yBase = 5;
        for (int i = 0; i < this.mTargetSlots.length; ++i) {
            final int index = i;
            int xPos = xBase + i % 3 * 18;
            int yPos = yBase + i / 3 * 18;
            ((ModularWindow.Builder)builder.widget(new SlotWidget(BaseSlot.empty()){

                protected void phantomClick(Widget.ClickData clickData, ItemStack cursorStack) {
                    GT_MetaTileEntity_Regulator.this.mTargetSlots[index] = Math.min(99, Math.max(0, GT_MetaTileEntity_Regulator.this.mTargetSlots[index] + (clickData.mouseButton == 0 ? -1 : 1) * (clickData.shift ? 16 : 1)));
                }
            }.setBackground(new IDrawable[]{GT_UITextures.TRANSPARENT}).setPos(xPos, yPos))).widget(TextWidget.dynamicString(() -> String.valueOf(this.mTargetSlots[index])).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(xPos + 2 + (i % 3 == 0 ? 1 : 0), yPos + 3 + (i / 3 == 0 ? 1 : 0)));
        }
    }
}

