/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.automation;

import com.google.common.collect.ImmutableList;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_SpecialFilter;
import gregtech.api.objects.ItemData;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;

public class GT_MetaTileEntity_TypeFilter
extends GT_MetaTileEntity_SpecialFilter {
    public int mRotationIndex = 0;
    public OrePrefixes mPrefix = OrePrefixes.ore;
    public static ImmutableList<OrePrefixes> OREBLOCK_PREFIXES = ImmutableList.of((Object)((Object)OrePrefixes.oreBlackgranite), (Object)((Object)OrePrefixes.oreDense), (Object)((Object)OrePrefixes.oreEnd), (Object)((Object)OrePrefixes.oreEndstone), (Object)((Object)OrePrefixes.oreNether), (Object)((Object)OrePrefixes.oreNetherrack), (Object)((Object)OrePrefixes.oreNormal), (Object)((Object)OrePrefixes.orePoor), (Object)((Object)OrePrefixes.oreRedgranite), (Object)((Object)OrePrefixes.oreRich), (Object)((Object)OrePrefixes.oreSmall), (Object)((Object)OrePrefixes.oreBasalt), (Object[])new OrePrefixes[]{OrePrefixes.oreMarble});

    public GT_MetaTileEntity_TypeFilter(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, new String[]{"Filters 1 Item Type", "Use Screwdriver to regulate output stack size", "Does not consume energy to move Item"});
    }

    public GT_MetaTileEntity_TypeFilter(String aName, int aTier, int aInvSlotCount, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aInvSlotCount, aDescription, aTextures);
    }

    public GT_MetaTileEntity_TypeFilter(String aName, int aTier, int aInvSlotCount, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aInvSlotCount, aDescription, aTextures);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_TypeFilter(this.mName, (int)this.mTier, this.mInventory.length, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public ITexture getOverlayIcon() {
        return TextureFactory.of(TextureFactory.of(Textures.BlockIcons.AUTOMATION_TYPEFILTER), TextureFactory.builder().addIcon(Textures.BlockIcons.AUTOMATION_TYPEFILTER_GLOW).glow().build());
    }

    @Override
    public void clickTypeIcon(boolean aRightClick, ItemStack aHandStack) {
        if (this.getBaseMetaTileEntity().isServerSide()) {
            ItemData data = GT_OreDictUnificator.getAssociation(aHandStack);
            if (data != null && data.hasValidPrefixData()) {
                this.mPrefix = data.mPrefix;
                this.mRotationIndex = -1;
                return;
            }
            for (int i = 0; i < OrePrefixes.values().length; ++i) {
                if (this.mPrefix != OrePrefixes.values()[i]) continue;
                this.mPrefix = null;
                while (this.mPrefix == null) {
                    if (aRightClick) {
                        do {
                            if (--i >= 0) continue;
                            i = OrePrefixes.values().length - 1;
                        } while (OrePrefixes.values()[i].mPrefixedItems.isEmpty());
                    } else {
                        do {
                            if (++i < OrePrefixes.values().length) continue;
                            i = 0;
                        } while (OrePrefixes.values()[i].mPrefixedItems.isEmpty());
                    }
                    if (!OrePrefixes.values()[i].mPrefixedItems.isEmpty() && OrePrefixes.values()[i].mPrefixInto == OrePrefixes.values()[i]) {
                        this.mPrefix = OrePrefixes.values()[i];
                    }
                    this.mPrefix = OrePrefixes.values()[i];
                }
            }
            this.mRotationIndex = -1;
        }
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPreTick(aBaseMetaTileEntity, aTick);
        if (!this.getBaseMetaTileEntity().isServerSide() || aTick % 8L != 0L && this.mRotationIndex != -1) {
            return;
        }
        if (this.mPrefix.mPrefixedItems.isEmpty()) {
            this.mInventory[9] = null;
            return;
        }
        Object[] objectArray = new Object[1];
        this.mRotationIndex = (this.mRotationIndex + 1) % this.mPrefix.mPrefixedItems.size();
        objectArray[0] = this.mPrefix.mPrefixedItems.get(this.mRotationIndex);
        this.mInventory[9] = GT_Utility.copyAmount(1L, objectArray);
        if (this.mInventory[9] == null) {
            return;
        }
        if (this.mInventory[9].func_77960_j() == Short.MAX_VALUE) {
            this.mInventory[9].func_77964_b(0);
        }
        this.mInventory[9].func_151001_c(this.mPrefix.toString());
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74778_a("mPrefix", this.mPrefix.toString());
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mPrefix = OrePrefixes.getPrefix(aNBT.func_74779_i("mPrefix"), this.mPrefix);
    }

    @Override
    protected boolean isStackAllowed(ItemStack aStack) {
        ItemData data;
        if (this.mPrefix == OrePrefixes.ore && (data = GT_OreDictUnificator.getItemData(aStack)) != null && data.mPrefix != null && OREBLOCK_PREFIXES.contains((Object)data.mPrefix)) {
            return true;
        }
        return this.mPrefix.contains(aStack);
    }

    @Override
    protected List<String> getItemExtraTooltip() {
        return Arrays.asList(EnumChatFormatting.DARK_GRAY + StatCollector.func_74838_a((String)"GT5U.type_filter.representation_slot.tooltip.0"), EnumChatFormatting.DARK_GRAY + StatCollector.func_74838_a((String)"GT5U.type_filter.representation_slot.tooltip.1"));
    }
}

